/* ============================================================
 * File  : standard_list.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "standard_list.h"

standard_list::standard_list(QWidget *parent)
    : QListWidget(parent)
{
        this->setAttribute(Qt::WA_TranslucentBackground, true);
	setSelectionMode(QAbstractItemView::SingleSelection);
	action_delete = new QAction(tr("Supprimer la selection"), this);
	action_delete->setIcon ( QIcon(":/Interface/Interface/trash.png") );
	connect(action_delete, SIGNAL(triggered()), this, SLOT(delete_select()));
}

void standard_list::delete_select()
{
	QList<QListWidgetItem *> selectitem = this->selectedItems();
	int wl_int_002 = this->selectedItems().size();
	for (int wl_int_001 = 0; wl_int_001 < wl_int_002; wl_int_001++) 
	{
		this->removeItemWidget(selectitem.at(wl_int_001));
		emit delete_row(QListWidget::row(selectitem.at(wl_int_001)));
		this->takeItem(QListWidget::row(selectitem.at(wl_int_001)));
	}
}

void standard_list::contextMenuEvent(QContextMenuEvent *event)
{
	if (currentItem() == NULL) 
	{
		return;
	}
	else
	{
		QMenu menu(this);
		menu.addAction(action_delete);
		menu.exec(event->globalPos());
	}
}

