/* ============================================================
 * File  : property.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "property.h"

property::property ( QWidget * parent )
    : QFrame(parent)
{
    dragPosition = QPoint(0,0);
    myfont.setBold(true);

    wg_color_1 = QApplication::palette().color(QPalette::Normal, QPalette::Text);
    wg_color_2 = QApplication::palette().color(QPalette::Normal, QPalette::Light);
    wg_color_3 = QApplication::palette().color(QPalette::Normal, QPalette::Window);
}

void property::mouseMoveEvent(QMouseEvent *event)
{
    if (!(event->buttons() & Qt::LeftButton) ) return;
    if ( dragPosition == QPoint(0,0) )
    {
        return;
    }
    else
    {
        move(event->globalPos() - dragPosition);
    }
}

void property::mousePressEvent ( QMouseEvent * event ) 
{
    dragPosition = event->globalPos() - frameGeometry().topLeft();
    this->raise();
}

void property::mouseReleaseEvent ( QMouseEvent * ) 
{
    dragPosition = QPoint(0,0);
}

void property::paintEvent(QPaintEvent *)
{
    QPainter p;
    p.begin(this);
    p.setRenderHint(QPainter::Antialiasing,true);
    p.setPen(wg_color_2);

    p.setBrush(wg_color_3);
    p.drawRoundedRect(1, 1, this->width()-2, this->height()-2,6,6,Qt::AbsoluteSize);

    if ( this->statusTip() != "" )
    {
            p.setFont(myfont);
            p.setPen(wg_color_1);
            p.drawText(QRect(5,4,this->width()-10,20), Qt::AlignCenter,this->statusTip());
    }
    p.end();
}

