/* ============================================================
 * File  : tetrahedron.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include <QDropEvent>
#include "panelmedia.h"
#include "media.h"

panelmedia::panelmedia ( QWidget * parent )
    : QFrame(parent)
{
        myparent = parent;
        this->setAcceptDrops(true);
        this->setAttribute(Qt::WA_TranslucentBackground, true);

        is_open = 0;

        action_load = new QAction(tr("Ajouter des medias"), this);
        action_load->setIcon ( QIcon(":/Interface/Interface/open.png") );

        connect(action_load, SIGNAL(triggered()), this, SLOT(f_load_media()));
}

void panelmedia::wheelEvent(QWheelEvent *event)
{
        emit wheel_scroll();

        if ( event->delta() > 0 )
        {
            if ( this->height()-((this->geometry().y()-(event->delta()/10))*-1) >= dvdysize )
            {
                this->setGeometry(0,this->geometry().y()-(event->delta()/10),this->width(),this->height());
            }
        }
        else
        {
            if ( this->geometry().y()-(event->delta()/10) <= 0 )
            {
                this->setGeometry(0,this->geometry().y()-(event->delta()/10),this->width(),this->height());
            }
            else
            {
                this->setGeometry(0,0,this->width(),this->height());
            }
        }
}

void panelmedia::f_load_media()
{
	emit load_media();
}

void panelmedia::contextMenuEvent(QContextMenuEvent *event)
{
    if ( is_open == 0 )
    {
        QMenu menu(this);
        menu.addAction(action_load);
        menu.exec(event->globalPos());
    }
}

void panelmedia::dragEnterEvent(QDragEnterEvent *event)
{
	event->acceptProposedAction();
}

// **********************************
// *** AJOUTER LE MEDIA AU PROJET ***
// **********************************
void panelmedia::dropEvent(QDropEvent *event)
{
	drop_x = event->pos().x();
	drop_y = event->pos().y();

	if ( event->mimeData()->hasUrls() == true )
	{
            QList<QUrl> myurl = event->mimeData()->urls();
            wl_pathname = myurl[0].toString(QUrl::None);
            if ( wl_pathname.mid(0,4) != "$MED" )
            {
                emit drop_to_panel();
            }
	}
}

Qt::DropActions panelmedia::supportedDropActions () const
{
	// returns what actions are supported when dropping
	return Qt::CopyAction | Qt::MoveAction;
}
