/* ============================================================
 * File  : menu_pencil.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "menu_pencil.h"

menu_pencil::menu_pencil ( QWidget * parent )
    : QFrame(parent)
{
        setMouseTracking(true);
	draw_user.load(":/Interface/Interface/reload.png");
	draw_user = draw_user.scaled(401,291);
	draw_user.fill(0);
        draw_user = draw_user.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );
        fond_draw = draw_user.convertToFormat ( QImage::Format_ARGB32_Premultiplied, Qt::AutoColor );
        dragPosition = QPoint(0,0);
	brush_width = 10;
        pencil_color.setRgb(255,255,255);
        pencil_color_2.setRgb(255,255,255);
        opacity = 255;
        opacity_2 = 255;
	tool = 0;
	is_in = 0;
        is_draw_ct = 0;
        is_bt = 0;
        is_round = 1;
}

void menu_pencil::mouseMoveEvent(QMouseEvent *event)
{
	mouse_x = event->x();
	mouse_y = event->y();
	if ((event->buttons() & Qt::LeftButton) )
	{
                QPen brush_pen;
                brush_pen.setColor(pencil_color);
                brush_pen.setWidth(brush_width);

                if ( is_round == 1 )
                {
                    brush_pen.setJoinStyle(Qt::RoundJoin);
                    brush_pen.setCapStyle(Qt::RoundCap);
                }
                else
                {
                    brush_pen.setJoinStyle(Qt::MiterJoin);
                    brush_pen.setCapStyle(Qt::SquareCap);
                }

		QPainter p;
		p.begin(&draw_user);
		p.setBackgroundMode(Qt::TransparentMode);
		p.setRenderHint(QPainter::Antialiasing,true);

                p.setPen(brush_pen);

                if ( tool == 0 )
		{
                        p.setPen(brush_pen);
                        p.drawLine(old_mouse_x,old_mouse_y,mouse_x,mouse_y);
		}
		else
		{
			if ( tool == 1 )
			{
				QPainter::CompositionMode mode = (QPainter::CompositionMode)3;
				p.setCompositionMode ( mode );
				brush_pen.setColor(QColor(0,0,0,0));
				p.setPen(brush_pen);
				p.drawLine(old_mouse_x,old_mouse_y,mouse_x,mouse_y);
			}
                }
		p.end();

		old_mouse_x = event->x();
		old_mouse_y = event->y();
	}

	this->repaint();
}

void menu_pencil::mousePressEvent ( QMouseEvent * event )
{
	old_mouse_x = event->x();
	old_mouse_y = event->y();

	draw_ct_x = event->x();
	draw_ct_y = event->y();
	is_draw_ct = 1;
	is_modification = 1;

        if ((event->buttons() & Qt::LeftButton) )
	{
		QPen brush_pen;
                brush_pen.setColor(pencil_color);
		brush_pen.setWidth(brush_width);
                if ( is_round == 1 )
                {
                    brush_pen.setJoinStyle(Qt::RoundJoin);
                    brush_pen.setCapStyle(Qt::RoundCap);
                }
                else
                {
                    brush_pen.setJoinStyle(Qt::MiterJoin);
                    brush_pen.setCapStyle(Qt::SquareCap);
                }

		QPainter p;
		p.begin(&draw_user);
		p.setBackgroundMode(Qt::TransparentMode);
		p.setRenderHint(QPainter::Antialiasing,true);

		if ( tool == 0 )
		{
			p.setPen(brush_pen);
			p.drawPoint(old_mouse_x,old_mouse_y);
		}
		else
		{
			if ( tool == 1 )
			{
				QPainter::CompositionMode mode = (QPainter::CompositionMode)3;
				p.setCompositionMode ( mode );
				brush_pen.setColor(QColor(0,0,0,0));
				p.setPen(brush_pen);
				p.drawPoint(old_mouse_x,old_mouse_y);
			}
		}
		p.end();
        }

	this->repaint();
}

void menu_pencil::mouseReleaseEvent ( QMouseEvent * )
{
        is_draw_ct = 0;
	if ( tool == 2 )
	{
		QPen brush_pen;
                brush_pen.setColor(pencil_color);
		brush_pen.setWidth(brush_width);
                if ( is_round == 1 )
                {
                    brush_pen.setJoinStyle(Qt::RoundJoin);
                    brush_pen.setCapStyle(Qt::RoundCap);
                }
                else
                {
                    brush_pen.setJoinStyle(Qt::MiterJoin);
                    brush_pen.setCapStyle(Qt::SquareCap);
                }

		QPainter p;
		p.begin(&draw_user);
		p.setPen(brush_pen);
                p.setBrush(pencil_color_2);
		p.setBackgroundMode(Qt::TransparentMode);
		p.setRenderHint(QPainter::Antialiasing,true);
		p.drawRect(draw_ct_x,draw_ct_y,mouse_x-draw_ct_x,mouse_y-draw_ct_y);
		p.end();

		this->repaint();
		return;
	}
	if ( tool == 3 )
	{
		QPen brush_pen;
                brush_pen.setColor(pencil_color);
		brush_pen.setWidth(brush_width);
                if ( is_round == 1 )
                {
                    brush_pen.setJoinStyle(Qt::RoundJoin);
                    brush_pen.setCapStyle(Qt::RoundCap);
                }
                else
                {
                    brush_pen.setJoinStyle(Qt::MiterJoin);
                    brush_pen.setCapStyle(Qt::SquareCap);
                }

		QPainter p;
		p.begin(&draw_user);
		p.setPen(brush_pen);
                p.setBrush(pencil_color_2);
		p.setBackgroundMode(Qt::TransparentMode);
		p.setRenderHint(QPainter::Antialiasing,true);
		p.drawEllipse(draw_ct_x,draw_ct_y,mouse_x-draw_ct_x,mouse_y-draw_ct_y);
		p.end();

		this->repaint();
		return;
	}
        if ( tool == 4 )
        {
                QPen brush_pen;
                brush_pen.setColor(pencil_color);
                brush_pen.setWidth(brush_width);
                if ( is_round == 1 )
                {
                    brush_pen.setJoinStyle(Qt::RoundJoin);
                    brush_pen.setCapStyle(Qt::RoundCap);
                }
                else
                {
                    brush_pen.setJoinStyle(Qt::MiterJoin);
                    brush_pen.setCapStyle(Qt::SquareCap);
                }

                QPainter p;
                p.begin(&draw_user);
                p.setPen(brush_pen);
                p.setBrush(pencil_color_2);
                p.setBackgroundMode(Qt::TransparentMode);
                p.setRenderHint(QPainter::Antialiasing,true);
                p.drawLine(draw_ct_x,draw_ct_y,mouse_x,mouse_y);
                p.end();

                this->repaint();
                return;
        }
        if ( tool == 5 )
        {
                QPainter p;
                p.begin(&draw_user);
                p.setBackgroundMode(Qt::TransparentMode);
                p.setRenderHint(QPainter::Antialiasing,true);
                p.drawPixmap(mouse_x,mouse_y,-1,-1,pixy);
                p.end();

                this->repaint();
                return;
        }
}

void menu_pencil::enterEvent(QEvent *)
{
	is_in = 1;
        //this->repaint();
}

void menu_pencil::leaveEvent(QEvent *)
{
	is_in = 0;
        this->repaint();
}

void menu_pencil::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
        p.drawImage(QRect(0,0,-1,-1),fond_draw);
	p.drawImage(QRect(0,0,-1,-1),draw_user);

	p.setRenderHint(QPainter::Antialiasing,true);
	QPen brush_pen;
        brush_pen.setColor(pencil_color.rgb());
        if ( is_round == 1 )
        {
            brush_pen.setJoinStyle(Qt::RoundJoin);
            brush_pen.setCapStyle(Qt::RoundCap);
        }
        else
        {
            brush_pen.setJoinStyle(Qt::MiterJoin);
            brush_pen.setCapStyle(Qt::SquareCap);
        }

	p.setBrush(QColor(0,0,0,0));
	if ( tool < 2 && is_in == 1 )
	{
		brush_pen.setWidth(1);
		p.setPen(brush_pen);
                p.setBrush(pencil_color_2);
		p.drawEllipse(mouse_x-(brush_width/2),mouse_y-(brush_width/2),brush_width,brush_width);
		//p.drawPoint(mouse_x,mouse_y);
	}
	else
	{
		if ( is_draw_ct == 1 && tool == 2 )
		{
			brush_pen.setWidth(brush_width);
			p.setPen(brush_pen);
                        p.setBrush(pencil_color_2);
			p.drawRect(draw_ct_x,draw_ct_y,mouse_x-draw_ct_x,mouse_y-draw_ct_y);
		}
		else
		{
			if ( is_draw_ct == 1 && tool == 3 )
			{
				brush_pen.setWidth(brush_width);
				p.setPen(brush_pen);
                                p.setBrush(pencil_color_2);
				p.drawEllipse(draw_ct_x,draw_ct_y,mouse_x-draw_ct_x,mouse_y-draw_ct_y);
			}
                        else
                        {
                                if ( is_draw_ct == 1 && tool == 4 )
                                {
                                        brush_pen.setWidth(brush_width);
                                        p.setPen(brush_pen);
                                        p.setBrush(pencil_color_2);
                                        p.drawLine(draw_ct_x,draw_ct_y,mouse_x,mouse_y);
                                }
                                else
                                {
                                    if ( tool == 5 )
                                    {
                                        p.drawPixmap(mouse_x,mouse_y,-1,-1,pixy);
                                    }
                                }
                        }
		}
        }

        if ( is_bt == 1 )
        {
            p.drawImage(QRect(0,0,-1,-1),bt_draw);
        }
	p.end();
}

