#ifndef menu_editor_H
#define menu_editor_H
#include <QLabel>

class menu_editor : public QLabel
{
	Q_OBJECT
	public:
		menu_editor(QWidget * parent);

		int is_copy;
		int has_sound;
		int has_intro;
		int xevent;
		int yevent;
                int drop_x;
                int drop_y;

                QString wg_str_001;

		QAction *action_customize;
		QAction *action_addone;
		QAction *action_addmul;
                QAction *action_pencil;
                QAction *action_addone_txt;
		QAction *action_intro_load;
		QAction *action_intro_cancel;
		QAction *action_paste;
		QAction *action_zik_load;
		QAction *action_zik_cancel;
		QAction *action_intro_calc;
		QAction *action_color_overlays;
                QAction *action_menu_pro;
	public:
	private:
	signals:
		void customize_background();
		void addone();
                void addone_txt();
		void addmul();
		void loadintro();
		void cancelintro();
		void loadzik();
                void menu_pencil();
		void cancelzik();
		void paste_menu();
		void intro_calc();
		void color_overlays();
                void drop_to_editor();
                void menu_openpro();
	public slots:
		void customize();
		void f_addone();
		void f_addmul();
                void f_addone_txt();
		void f_load_intro();
		void f_cancel_intro();
		void f_load_zik();
		void f_cancel_zik();
		void f_paste();
		void f_calc();
		void f_coverl();
                void f_pencil();
                void f_openpro();
	protected:
		void contextMenuEvent(QContextMenuEvent *);
                void dropEvent(QDropEvent *);
                void dragEnterEvent(QDragEnterEvent *);
                Qt::DropActions supportedDropActions () const;
};
#endif
