#ifndef menu_H
#define menu_H
#include <QLabel>
#include <QProcess>
#include <QGraphicsOpacityEffect>

class menu : public QLabel
{
	Q_OBJECT
	public:
		menu(QWidget * parent);
	public:
		int menu_x;
		int menu_y;
                float rotation;
                float rotation2;
                float tetatemp;
		int shear_value_x;
		int shear_value_y;
                int menu_width;
                int menu_height;
		int tool;
		int img_x_size;
		int img_y_size;
		int is_select;
		int pos_cx;
		int pos_cy;
		int radius0;
		int radius1;
		int islabel;
		int shadow;
		int shadow_angle;
		int shadow_opacity;
		int isgrab;
		int isovermask;
		int anim_thumb;
		int zindex;
		int shift_press;
		int taborder;
		int is_ruler;
		int alpha_menu;
		int iscontours;
                int font_size;
                int is_magnetic;

		QString quoi_faire;
		QString quoi_overlay;
                QString wg_str_001;

		bool isbold;
		bool isitalic;
		bool isunderline;
		int isalign;

		float teta0;
		float teta1;

		QPoint oldpos;
		QPoint centerpos;

		double PI;
		double angleradian;
		QPoint p0;
		QPoint p1;

		QString back_image;
		QString quoilire;
		QString quoilirechapitre;
		QString pos_thumb;
		QString path_mask;
		QString path_over_mask;
		QString color_mask_over;
		QString shadow_color;
		QString audio_track;

		QPixmap mask;
		QPixmap over_mask;
		QPixmap draw_image;
		QPixmap original;
		QPixmap original_mask;

		QAction *action_supprimer;
		QAction *action_customize;
		QAction *action_charger_image;
		QAction *action_charger_image_video;
		QAction *action_envoi_premier;
		QAction *action_envoi_dernier;
		QAction *action_copy;
		QAction *action_goto;
		QAction *action_tobt;
		QAction *action_halign;
		QAction *action_valign;
		QAction *action_talign;
		QAction *action_quoifaire;
		QAction *action_editoverlay;
		QAction *action_adjust;

		QProcess proc_ffmpeg_m;

                QGraphicsOpacityEffect *myeffect;

	private:
		QPoint dragPosition;
	signals:
		void delete_menu(menu*);
		void select_menu(menu*);
		void release_menu(menu*);
		void affiche_navi(menu*);
		void cache_navi(menu*);
		void change_position(menu*);
		void customize_menu(menu*);
		void go_lower(menu*);
		void go_front(menu*);
		void call_charge_image();
		void call_charge_image_video();
		void copy_menu(menu*);
		void goto_menu(menu*);
                //void has_scale(menu*);
		void halign(menu*);
		void valign(menu*);
		void talign(menu*);
		void quoifaire(menu*);
		void editoverlay(menu*);
		void tobt(menu*);
		void adjust(menu*);
                void drop_to_a_menu(menu*);
                void rsc_txt(int);

	public slots:
		void set_opacity(int);
		void charge_image(QString);
		void reload_charge_image(QString);
		void charge_mask(QString);
		void supprimer();
		void customize();
		void charge_image_call();
		void charge_image_video_call();
		void f_front();
		void f_back();
		void f_copy();
		void f_goto();
		void f_halign();
		void f_valign();
		void f_talign();
		void f_quoifaire();
		void f_editoverlay();
		void f_tobt();
		void change_cursor();
		void f_adjust();

                void f_static_show();

		// *** FONCTIONS TRIGO ***
		float getTeta(QPoint,int);
                float getDist(QPoint,QPoint);
	protected:
		void paintEvent(QPaintEvent *);
		void enterEvent(QEvent *);
		void leaveEvent(QEvent *);
		void contextMenuEvent(QContextMenuEvent *);
		void mouseMoveEvent(QMouseEvent *);
		void mousePressEvent(QMouseEvent *);
		void mouseReleaseEvent(QMouseEvent *);
		void wheelEvent(QWheelEvent *);
                void dragEnterEvent(QDragEnterEvent *);
                void dropEvent(QDropEvent *);

                virtual void showEvent ( QShowEvent *)
                {
                        emit f_static_show();
                }

};
#endif
