/* ============================================================
 * File  : media.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "media.h"

media::media ( QWidget * parent , panelmedia *hdtmp )
    : QLabel(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        //this->setMouseTracking(true);
	this->setScaledContents(true);
	// *** Initialisations ***
	hdlpar = hdtmp;
	nbre_chapitres = 0;
	is_select = 0;
	is_lock = 0;
	isdvd = 0;
	oldisdvd = 0;
	already_encode = 0;
	wl_sub_path = "";
	wl_video_sync = "0";
	isdvdintro = 0;
        issca = 0;

	saturation = 0;
	hue = 0;
	contraste = 0;
	lumiere = 0;

        sub_size = 5;
        sub_pos = 90;

	int wl_int_001 = 0;

	while ( wl_int_001 < 8 )
	{
		table_soundtrack[wl_int_001] = "";
		wl_int_001++;
	}

	// *** AJOUT DES FONCTIONS MEDIAS ***
	action_delete = new QAction(tr("Supprimer le media"), this);
	action_delete->setIcon ( QIcon(":/Interface/Interface/trash.png") );
	action_chapitrer = new QAction(tr("Chapitrer le media"), this);
	action_chapitrer->setIcon ( QIcon(":/Interface/Interface/chapitrage.png") );
	action_thumb = new QAction(tr("Miniature du media"), this);
        action_thumb->setIcon ( QIcon(":/Interface/Interface/media.png") );
	action_reencode = new QAction(tr("Changer le bitrate du media"), this);
	action_reencode->setIcon ( QIcon(":/Interface/Interface/edit.png") );
	action_force_reencode = new QAction(tr("Forcer le reencodage du media"), this);
	action_force_reencode->setIcon ( QIcon(":/Interface/Interface/execute.png") );
        action_force_nreencode = new QAction(tr("Empecher le reencodage du media"), this);
        action_force_nreencode->setIcon ( QIcon(":/Interface/Interface/select.png") );
        action_bb = new QAction(tr("Ajustement de l'image"), this);
        action_bb->setIcon ( QIcon(":/Interface/Interface/scalemedia.png") );

	action_sub_load = new QAction(tr("Charger un fichier sous titre"), this);
	action_sub_load->setIcon ( QIcon(":/Interface/Interface/finder.png") );
	action_sub_cancel = new QAction(tr("Supprimer le fichier sous titre"), this);
	action_sub_cancel->setIcon ( QIcon(":/Interface/Interface/trash.png") );

	action_soundtrack = new QAction(tr("Bandes son"), this);
	action_soundtrack->setIcon ( QIcon(":/Interface/Interface/sound.png") );

	action_reglages = new QAction(tr("Effets sur la video"), this);
        action_reglages->setIcon ( QIcon(":/Interface/Interface/customize.png") );

	action_introdvd = new QAction(tr("Definir comme video d'introduction du DVD"), this);
	action_introdvd->setIcon ( QIcon(":/Interface/Interface/introdvd.png") );
	action_introdvd_cancel = new QAction(tr("Ne pas definir comme video d'introduction du DVD"), this);
	action_introdvd_cancel->setIcon ( QIcon(":/Interface/Interface/cancel1.png") );

	connect(action_delete, SIGNAL(triggered()), this, SLOT(del_media()));
	connect(action_chapitrer, SIGNAL(triggered()), this, SLOT(cha_media()));
	connect(action_thumb, SIGNAL(triggered()), this, SLOT(thu_media()));
	connect(action_reencode, SIGNAL(triggered()), this, SLOT(ren_media()));
	connect(action_force_reencode, SIGNAL(triggered()), this, SLOT(force_ren_media()));
        connect(action_force_nreencode, SIGNAL(triggered()), this, SLOT(force_nren_media()));

	connect(action_sub_load, SIGNAL(triggered()), this, SLOT(f_load_sub()));
	connect(action_sub_cancel, SIGNAL(triggered()), this, SLOT(f_cancel_sub()));

	connect(action_soundtrack, SIGNAL(triggered()), this, SLOT(f_soundtrack()));

        connect(action_bb, SIGNAL(triggered()), this, SLOT(f_sca_media()));

	connect(action_reglages, SIGNAL(triggered()), this, SLOT(f_effets()));
	connect(action_introdvd, SIGNAL(triggered()), this, SLOT(f_introdvd()));
	connect(action_introdvd_cancel, SIGNAL(triggered()), this, SLOT(f_introdvd()));
}

void media::f_sca_media()
{
        emit sca_media(this);
}

void media::f_introdvd()
{
	if ( isdvdintro == 0 )
	{
		isdvdintro = 1;
		this->repaint();
		emit introdvd(this);
	}
	else
	{
		isdvdintro = 0;
		this->repaint();
		//emit introdvd(this);
	}
}

void media::f_effets()
{
	emit effets(this);
}

void media::f_soundtrack()
{
	emit soundtrack(this);
}

// *******************
// *** SOUS TITRES ***
// *******************

void media::f_load_sub()
{
	wl_sub_path = QFileDialog::getOpenFileName(
        	this,
        	tr("Sous titres"),
        	"",
        	"(*.SRT *.srt)");
	if ( wl_sub_path.isNull() )
	{
		wl_sub_path = "";
	}
	else
	{
		oldisdvd = isdvd;
		already_encode = 0;
		//isdvd = 0;
		this->repaint();
	}
}

void media::f_cancel_sub()
{
	isdvd = oldisdvd;
	wl_sub_path = "";
	this->repaint();
}

// ********************************
// *** MENU CONTEXTUEL DU MEDIA ***
// ********************************

void media::contextMenuEvent(QContextMenuEvent *event)
{
        if ( is_lock == 0 )
        {
                action_delete->setEnabled(true);
                action_chapitrer->setEnabled(true);
                action_thumb->setEnabled(true);
                action_soundtrack->setEnabled(true);
        }
        else
        {
                action_delete->setDisabled(true);
                action_chapitrer->setDisabled(true);
                action_thumb->setDisabled(true);
                action_soundtrack->setDisabled(true);
        }

        /*if ( isdvd == 0 )
        {
                action_force_reencode->setDisabled(true);
        }
        else
        {
                action_force_reencode->setEnabled(true);
        }

        if ( issca == 0 )
        {
                action_bb->setDisabled(true);
        }
        else
        {
                action_bb->setEnabled(true);
        }*/

        QMenu menu(this);
        menu.addAction(action_delete);
        menu.addAction(action_chapitrer);
        menu.addAction(action_reglages);
        menu.addSeparator();
        menu.addAction(action_thumb);
        if ( isdvdintro == 0 )
        {
                menu.addAction(action_introdvd);
        }
        else
        {
                menu.addAction(action_introdvd_cancel);
        }
        menu.addSeparator();
        menu.addAction(action_reencode);
        if ( isdvd == 1 )
        {
            menu.addAction(action_force_reencode);
        }
        else
        {
            menu.addAction(action_force_nreencode);
        }
        if ( issca > 0 )
        {
            menu.addAction(action_bb);
        }

        menu.addSeparator();
        QMenu *menusub = menu.addMenu(QIcon(":/Interface/Interface/subtitle.png"),tr("Sous titres"));

        if ( wl_sub_path == "" )
        {
                action_sub_load->setEnabled(true);
                action_sub_cancel->setDisabled(true);
        }
        else
        {
                action_sub_load->setDisabled(true);
                action_sub_cancel->setEnabled(true);
        }

        menusub->addAction(action_sub_load);
        menusub->addAction(action_sub_cancel);
        menu.addSeparator();
        menu.addAction(action_soundtrack);

        menu.exec(event->globalPos());
}

void media::force_ren_media()
{
	isdvd = 0;
}

void media::force_nren_media()
{
    QMessageBox msgBox;
    msgBox.setText(tr("Avertissement"));
    msgBox.setInformativeText(tr("Etes vous sur de vouloir utiliser ce media sans le reencoder ? Ceci peut empecher votre projet d'etre correctement genere."));
    msgBox.setStandardButtons(QMessageBox::No | QMessageBox::Yes);
    msgBox.setDefaultButton(QMessageBox::Yes);
    int ret = msgBox.exec();
    switch (ret) {
            case QMessageBox::No:
                    return;
                    break;
    }
    isdvd = 1;
    already_encode = 2;
}

void media::ren_media()
{
	emit encode_media(this);
}

void media::del_media()
{
	emit delete_media(this);
        //this->close();
}

void media::cha_media()
{
	emit chapitre_media(this);
}

void media::thu_media()
{
	emit thumbnail_media(this);
}

// *************************************
// *** GESTION DES EVENEMENTS SOURIS ***
// *************************************

void media::mouseMoveEvent(QMouseEvent *event )
{
        if (!(event->buttons() & Qt::LeftButton)) return;

        /*QIcon iconedrag = currentItem()->icon();
        currentselect = iconedrag.pixmap ( 128, 128, QIcon::Normal ,  QIcon::On);
        currentselectindex = this->selectedIndexes().at(0).row();*/
        //
        QMimeData *mimedata = new QMimeData;
        QList<QUrl> lsturl;
        QUrl myurl;
        myurl.setPath("$MED" + pathname_media);
        lsturl.insert ( 0, myurl );
        mimedata->setUrls(lsturl);
        QDrag *drag = new QDrag(this);
        drag->setMimeData(mimedata);
        drag->setPixmap(image);
        drag->exec(Qt::MoveAction);
}

void media::mousePressEvent ( QMouseEvent * event ) 
{
        emit select_media(this,1);
        if ((event->buttons() & Qt::LeftButton)) emit cache_info(this);
}

void media::mouseReleaseEvent ( QMouseEvent * )
{
        emit affiche_info(this);
}

void media::enterEvent ( QEvent * )
{
        emit affiche_info(this);
}

void media::leaveEvent ( QEvent * ) 
{
	emit cache_info(this);
}

// ***********************
// *** DESSIN DU MEDIA ***
// ***********************

void media::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);

	p.setRenderHint(QPainter::Antialiasing,true);
	//p.setPen(QColor(255,255,255,255));

	/*QLinearGradient Gradient(0.0, 0.0,0.0,this->height());
	Gradient.setColorAt(0.5, QColor(255,255,255,150));
	Gradient.setColorAt(1.0, QColor(255,255,255,170));
	p.setBrush(Gradient);

	p.drawRoundedRect(1, 1, this->width()-2, this->height()-2,10,10,Qt::AbsoluteSize);*/

	p.drawPixmap ( 0,0,image );
	if ( is_select == 1 )
	{
		p.drawPixmap(3,3,QPixmap(":/Interface/Interface/select.png"));
	}
	if ( is_lock == 1 )
	{
		p.drawPixmap(3,this->height()-40,QPixmap(":/Interface/Interface/locked.png"));
	}
	if ( wl_sub_path != "" )
	{
		p.drawPixmap(40,this->height()-40,QPixmap(":/Interface/Interface/subtitle2.png"));
	}
	if ( isdvdintro == 1 )
	{
		p.drawPixmap(77,this->height()-40,QPixmap(":/Interface/Interface/introdvd.png"));
	}
	p.end();
}
