#ifndef MAINFRM_H
#define MAINFRM_H

#include <QDialog>
#include <QProcess>
//#include <QScrollArea>
#include <QGraphicsOpacityEffect>
//#include <QScreen>
#include "ui_mainfrm.h"
#include "menu.h"
#include "menu_th.h"
#include "media.h"
#include "thani.h"
#include "thblend.h"
#include "thimg.h"
#include "thptra.h"
#include "thptradia.h"
#include "thsave.h"
#include "pictureflow.h"
#include "flag.h"
#include "myfileopen.h"
#include "widgets/colorpickerwidget.h"
#include "back_syno.h"
#include "item_menu.h"
#include "item_media.h"
#include "toolbar_bt4.h"
#include "tetrahedron.h"
#include "slide_timeline.h"
#include "diapos_th.h"
#include "lst_diapos.h"
#include "audio_editor.h"
#include "frame_th_trans.h"

class mainfrm : public QMainWindow, public Ui::mainfrm
{
	Q_OBJECT
	public:
		mainfrm(QWidget *parent = 0);

                // *** PARTIE DIAPORAMA ***
                Tetrahedron *pntmygl;
                int nbre_diapos;
                int end_renderer;
                diapos_th *hdl_current_diapo;
                diapos_th *table_hdl_diapo[400];

                QString table_lumas[11][22];
                frame_th_trans *table_trluma[11][22];
                int trans_page_count[11];

                QImage wg_tout_services;

                int num_current_diapo;
                float pos_playing;
                int isrendering;
                int cpt_trt_trans;
                int sx_tr_diapo;
                int sy_tr_diapo;
                int wg_jpg_qual;

                int nombre_themes_3d;
                int nombre_transitions;

                int wl_wait;
                int dvdauthor_version;

                int remember_status;
                int nbre_audio_track;
                float thread_trans_render_sequence;
                QString wg_fps;

                QImage wg_img_smile_effect;
                QImage wg_myimg_render;

                QGraphicsOpacityEffect *myeffect_global;
                QGraphicsOpacityEffect *myeffect_global_sb_medias;

                float crop_ratio_x;
                float crop_ratio_y;
                float wg_fps_int;

                float wl_avtrans;
                float wl_aptrans;
                float wlincr;

                audio_editor *hdl_audio;

		// *** VARIABLES D'INTERFACE ***
		QString name_application;
		QString path_background;
		QString path_img_menu;
		QString path_save;
		QString path_capture;
		QString path_language;
		QString dvd_standard;
		QString dvd_format;
		QString wg_str_int_001;
		QString wg_str_int_002;
		QString wg_str_int_003;
		QString wg_str_int_004;
		QString wg_str_int_005;
		QString wg_str_int_006;
		QString logstring;
		QString path_always_save;
		QString global_audio;

		int dvdxsize;
		int dvdysize;
		int wl_vmax;
		int must_update;
		int dvd_total_size;
		int dvd_actual_size;
		int current_tool;
		int iserror;
		int special_delete;
		int current_loop;
		int loop_length;
		int is_new_create;
		int nbre_threads;
		int dvdzone;
		int isnotify;
		int draw_contours;
                int isdragging;

		QString current_menu_background;
		int scale_current_menu_background;
                QString current_pencil_draw;
		QString current_menu_audio;
		QString current_menu_intro;
		QString current_intro_zik;

		PictureFlow *hdlpf;
                toolbar_bt4 *table_hdl_medbrow[40];
                toolbar_bt4 *table_hdl_medbrow_smile[40];
                int lengthbar;
                int lengthbar_smile;

		// *** VARIABLES CHEMINS ***
		QString path_media_import;
                QString path_media_import_smile;
		QString path_project;

		// *** VARIABLES MEDIAS ***
		int nbre_medias;
		int current_media;
		media *table_hdl_medias[60];
		media *hdl_current_media;
		menu *hdl_current_menu;
		menu_th *hdl_current_menuth;
		menu_th *table_hdl_menuth[30];
                menu_th *tmp_hdl_menu_th;
                videowrapper *hdl_medext;

		// *** VARIABLES MENUS BOUTONS ***
		int nbre_menus;
		int nbre_menus_wo_label;
		menu *table_hdl_menus[20];
		flag *table_hdl_flags[20];

		int nbre_menuth;
                QString table_menus[30][20][27];
                QString copy_table_menus[27];

                QString table_menus_property[30][10];

		// *** VARIABLES TEMPORAIRES GLOBALES ***
		QString wg_string_001;
		QString wg_string_002;
		QString wg_string_003;
		QString wg_string_004;
		QString wg_string_005;
		QString wg_string_006;

		int wg_int_001;
		int wg_int_002;
		int wg_int_003;
		int wg_int_004;
		int wg_int_005;
		int wg_int_006;
		int wg_int_007;
		int wg_int_008;
		int step_render;
		int ismultiplex;
                int whereopenfrom;

		int position_dispatch;
		int position_media_dispatch;

		int nbre_vignettes;

		float wg_float_001;

		QPixmap wg_pix_001;
		QPixmap wg_pix_002;
		QPixmap wg_pix_003;

                QMovie *hdlmov;

		QByteArray Process_Data;

		QTime mysynctime;

		// *** MPLAYER ***
                bool player_isplaying;
		float player_position;
		int oldseek;

		// *** WHEELS ***
		ColorPickerWidget *pntwheel1;
		ColorPickerWidget *pntwheel2;
		ColorPickerWidget *pntwheel3;
		ColorPickerWidget *pntwheel4;
		ColorPickerWidget *pntwheel5;
                ColorPickerWidget *pntwheel6;
                ColorPickerWidget *pntwheel7;
                ColorPickerWidget *pntwheel8;
                ColorPickerWidget *pntwheel9;
                ColorPickerWidget *pntwheel10;
                ColorPickerWidget *pntwheel11;
                ColorPickerWidget *pntwheel12;

                int wheel_red;
                int wheel_green;
                int wheel_blue;

		myfileopen *pntfiled;

                thsave *thread_save;

	public slots:
		// *** FONCTIONS PROJETS ***
		void f_valide_new_projet();
                void f_valide_new_projet_slideshow();
		bool f_create_env();
		void f_find_place();
		void f_open_from_start();
		void f_open_ext(QString);

                void f_start_2();
                void f_start_6();
                void f_start_7();

                void f_resize_project();

                // *** FONCTIONS DIAPORAMA ***
                void f_open_file_smile();
                void f_change_directory_smile(QString);
                void f_move_directory_smile();
                void f_chgdir_smile(toolbar_bt4 *);
                void f_close_navigator_smile();
                void f_close_import_navigator_smile();

                void f_flakes_act(int);
                void f_mark_pos();
                void f_deplace_keyframe();
                void f_display_mark_on_timeline(int);
                void f_display_position_timeline(int);
                void f_hide_preview();
                void f_update_diapoth();
                void f_load_theme_3d();
                void f_move_start();

                void f_action_diapauto_fi();
                void f_load_diapo_fi_step_2( const QStringList );

                void f_add_diapo();
                void f_select_diapos_th(diapos_th*);
                void f_delete_diaposth(diapos_th*);
                void f_theme_diaposth(diapos_th*);
                void f_dupliquer_diaposth(diapos_th*);

                void f_change_length_diapo(int);
                void f_change_length_translide(int);
                void f_change_length_diapo_from_tetra(int);
                void f_load_back();

                void f_color_back_slide();
                void f_play_diapo();
                void f_play_diapo_boucle();

                void f_mark_visible(int);

                void f_render_smile();
                void f_render_smile_2();
                void f_end_smile_encode();
                void f_bt_cancel_slideshow();
                void f_end_break_renderer();

                void f_rwd_diapo();
                void f_fwd_diapo();

                void f_thm_smile();
                void f_pro_smile();

                void f_scroll_timeline_smile(int);
                void f_select_them_smile();

                void f_slider_opa_slide(int);
                void f_slider_blur_slide(int);

                void f_saveas_smile();
                void f_save_smile();
                void f_openfs_smile(QString);

                void f_scale_project();

                void f_godrop_diapo();

                void f_update_coo();

                void f_lst_trans_smile_changed(int);

                void f_update_trans_render();
                void f_actionDiaporama_automatique();
                void f_actionDiaporama_automatique_1();
                void f_actionDiaporama_automatique_2();
                void f_cancel_actionDiaporama_automatique();

                void f_action_ef_image(int);

                void f_dial_smile_light(int);
                void f_dial_smile_contraste(int);
                void f_load_diapo(int);

                void f_slider_slide_color(int);
                void f_slider_slide_chsize(int);

                void f_effect_run(int, int);

                void f_switch_coo_diapo();

                void f_valid_coord_diapo();

                void f_px_changed(QString);
                void f_py_changed(QString);
                void f_pz_changed(QString);

                void f_rx_changed(QString);
                void f_ry_changed(QString);
                void f_rz_changed(QString);

                void f_action_talea();

                void f_s_delete_position(int);

                void f_add_diapo_signal();
                void f_update_diapo_signal();
                void f_chk_calq(QListWidgetItem*);

                void f_s_delete_diapo(int);
                void f_delete_image_fc(int);
                void f_renum_clq();
                void f_action_replace(int);
                void f_action_dupliquer(int);
                void f_select_clq(QListWidgetItem*);

                void f_s_edit_image();
                void f_s_cancel_image();
                void f_s_valide_image();

                void f_bt_close_param_render();
                void f_bt_start_param_render();
                void f_bt_open_folder_render();
                void f_combo_fmt_smile(int);

                void f_s_add_sound();
                void f_s_add_sound_step_2(QString);
                void f_s_adj_sound();
                void f_s_del_sound();
                void f_s_del_sound_from_audiotrack();
                void f_recalc_length_audio();
                void f_color_fog();

                void f_s_d_f_custo_mask();

                void f_s_slide_lst(int);

                void f_enter_diath(diapos_th*);
                void f_leave_diath(diapos_th*);

                void f_s_action_adjtime(int);
                void f_color_txt_slide();

                void f_tool_change(int);
                void f_open_trans_smile();
                void f_changed_tab_smile_trans(int);
                void f_close_prev_trans_smile();
                void f_close_prev_trans_smile_none();
                void f_select_trans_smile(frame_th_trans*);

                void f_tool_ef_image();
                void f_cancel_smeff();
                void f_reinit_smeff();
                void f_valide_smeff();

                void f_aff_msk_eff();

                void f_smeff_1();
                void f_smeff_2();
                void f_smeff_3();
                void f_smeff_4();
                void f_smeff_5();
                void f_smeff_6();
                void f_smeff_7();
                void f_smeff_8();
                void f_smeff_9();
                void f_smeff_10();

                void f_showhide_grid();
                void f_showhide_smeff();

                void f_actionDiaporama_automatique_find();

		// *** OPENFILEDIALOG ***
		void f_open_ipreview(QString);
		void f_close_ipreview( const QStringList );
		void f_cancel_ipreview();

                // *** MENU DU BAS ***
                void f_showhide_lstmenu();
                void f_switch_lstmenu();
                void f_switch_lstmenu_2();
                void f_showhide_lstmedias();
                void f_showhide_lstthemes();
                void f_showhide_lstproperty();

		// *** TOOLBAR ***
                void f_openclose_toolbar();
                void f_openclose_toolbar_end();

                void displayRegle( bool state );
                void displayCoord( bool state );
                void displayZone( bool state );
                void displayContours( bool state );
		void f_showhide_regle();
		void f_showhide_coor();
		void f_showhide_safe();
                void f_view_zone();
		void f_view_tabulation();
		void f_screengrab_menu();

                void f_view_tabinfos();
                void f_tabinfos_step_2();

		// *** ARBORESCENCE ***
		void f_view_arborescence();
		void f_item_move(item_menu*);
		void f_item_select(item_menu*);
		void f_edit_menu_tree(item_menu*);
		void f_add_link(item_menu*,int);
		void f_add_link_media(item_menu*,QString);
		void f_itemmedia_move(item_media*);
		void f_affiche_info_mediaarbo(item_media*);
		void f_hide_info_mediaarbo(item_media*);
		void f_itemmedia_ren(media*);
                void f_switch_lstmenu_close();

		// *** OBJETS ***
		void f_select_object();
                void f_select_object_from_drop();

		// *** LABEL ***
		void f_ajoute_label();

		// *** ZONES ***
		void f_aff_zone_0();
		void f_aff_zone_1();
		void f_aff_zone_2();
		void f_aff_zone_3();
		void f_aff_zone_4();
		void f_aff_zone_5();
		void f_aff_zone_6();
		void f_valide_zone();

		// *** BIBLIOTHEQUE DE MEDIAS ***
		void f_lecture_console_extract();

		void f_change_directory(QString);
                void f_chgdir(toolbar_bt4 *);
		void f_move_directory();
		void f_generation_vignette(int, QProcess::ExitStatus);
		void f_ident_media(int, QProcess::ExitStatus);
		void f_drop_to_panel();
		void f_drop_dble();

		void f_open_import_bibmedia();
		void f_close_import_bibmedia();

		void f_delete_media(media*);
		void f_encode_media(media*);
		void f_chapitre_media(media*);
		void f_select_media(media*, int);
		void f_affiche_info(media*);
		void f_thumbnail_media(media*);
		void f_cache_info(media*);
		void f_introdvd(media*);
                void f_scamedia(media*);

                void f_scamedia_1();
                void f_scamedia_2();

		void f_generation_thu(int, QProcess::ExitStatus);

		void f_next_thumb();
		void f_prev_thumb();
		void f_valid_thumb();

		void f_close_reencode();
		void f_bitarte_change(int);

		void f_select_quoifaire_after(menu*);
		void f_add_quoifaire_media();
		void f_close_quoifaire_media();
		void f_delete_quoifaire_media(int);

		void f_affiche_language(media*);
		void f_close_language();
		void f_search_language();
		void f_delete_language(int);
		void f_display_language();

		void f_effets_media(media*);

                void f_wheel_scroll();
                void f_scroll_medias(int);

		// *** DVDNAV ***
		void f_dvdnav_1();
		void f_dvdnav_2();
		void f_dvdnav_3();
		void f_dvdnav_4();
		void f_dvdnav_5();
		void f_dvdnav_6();
		void f_dvdnav_7();
		void f_dvdnav_8();
		void f_dvdnav_9();
                void f_close_dvdnav();

		// *** GESTION DES MENUS MEDIAS ***
                void f_drop_to_editor();
                void f_ajoute_menu();
                void f_ajoute_menu_txt();
                void f_ajoute_menu_from_menubar();
		void f_ajoute_menu_new(int,int,int,int);
		void f_dispatch_menu();
		void f_put_txt_on_bt();
                void f_rsc_txt(int);
		void f_shadowtext_angle(int);
		void f_shadowtext_opacity(int);
                void f_fonttext_size(int);
		void f_put_anim();
		void f_valide_color_txt();
		void f_valide_color_txt_shadow();
		void f_fmtfont_txt_on_bt_1();
		void f_fmtfont_txt_on_bt_2();
		void f_fmtfont_txt_on_bt_3();
                void f_fmtfont_txt_on_bt_4();
		void f_fmtfont_txt_on_bt_5();
		void f_fmtfont_txt_on_bt_6();
                void f_showhide_txtadv();
                void f_showhide_txtadv_end();
		void f_font_txt_on_bt(QFont);
		void f_import_mask();
		void f_dispatch_1();
		void f_dispatch_2();
		void f_dispatch_3();
		void f_dispatch_4();
		void f_dispatch_5();
		void f_combo_typehelp_changed(int);
		void f_combo_typehelpchapter_changed(int);
		void f_dispatch_declare();

		void f_delete_menu(menu*);
		void f_select_menu(menu*);
		void f_release_menu(menu*);
		void f_customize_menu(menu*);
		void f_menu_lower(menu*);
		void f_menu_front(menu*);
		void f_copy_menu(menu*);
		void f_goto_menu(menu*);
		void f_halign_menu(menu*);
		void f_valign_menu(menu*);
		void f_talign_menu(menu*);
                void f_drop_to_a_menu(menu*);
                void f_tobt(menu*);
		void f_paste_menu();
		void f_select_mask();
		void f_valide_customize();
                void f_cancel_customize();
		void f_refresh_customize();
		void f_custo_red(int);
		void f_custo_green(int);
		void f_custo_blue(int);
		void f_custo_opacity(int);

		void f_menu_zoom();
		void f_menu_rotate();
		void f_menu_grab();
		void f_menu_shear();

		void f_menu_opacity(int);

		void f_select_background();
		void f_select_sound();
		void f_cancel_sound();
		void f_select_intro();
		void f_cancel_intro();
		void f_valide_scale_background_2();
		void f_valide_scale_background_1();
		void f_image_menu();
		void f_image_menu_video();
		void f_quoilire_changed(int);
		void f_quoilire_menu_changed(int);
		void f_quoilire_chapitre_changed(int);
		void f_quoilire_audio_changed(int);
		void f_add_menu();
		void f_select_menuth(menu_th*);
                void f_select_menuth_step_2();
		void f_delete_menuth(menu_th*);
                void f_dupliquer_menuth(menu_th*);
		void f_previous_menu();
		void f_next_menu();
		void f_overlay_menu();
		void f_preview_overlay();
		void f_valide_overlay();
		void f_edit_overlay(menu*);
		void f_close_editoverlay();
                void f_close_editoverlay_cancel();
		void f_designer_brush_width(int);
		void f_tool_designer_1();
		void f_tool_designer_2();
		void f_tool_designer_3();
		void f_tool_designer_4();
		void f_tool_designer_5();
                void f_tool_designer_6();

		void f_copy_bt_2();
		void f_paste_bt_2();

		void f_color_overlays();
                void f_close_pencil_menu();
                void f_cancel_pencil_menu();
                void f_tool_pencil_1();
                void f_tool_pencil_2();
                void f_tool_pencil_3();
                void f_tool_pencil_4();
                void f_tool_pencil_5();
                void f_tool_pencil_6();
                void f_tool_pencil_7();
                void f_pencil_brush_width(int);
                void f_valide_color_pencil();
                void f_valide_color_pencil_2();
                void f_pencil_brush_opacity(int);
                void f_pencil_check_bt(int);
                void f_pencil_check_bt_2(int);
                void f_pencil_brush_opacity_2(int);

                void f_menu_pencil();

		void f_view_contours();

                void f_adjust_th(menu*);
                void f_affhide_anim();
                void f_select_item_object(QListWidgetItem *);
                void f_import_obj();

                void f_reload_thumb(int);
                void f_color_fd_menu();
                void f_chkradial(int);

		// *** THEMES ***
		void f_add_theme();
                void f_add_theme_2();
		void f_cancel_add_theme();
		void f_select_them();
		void f_add_theme_categorie();
                void f_licence(QString);
                void f_close_licence();
                void f_pack(QString,QString);

		// *** PREFERENCES ***
		void f_open_preferences();
		void f_close_preferences();

		// *** MPLAYER ***
		void player_open_video(QString);
		void player_play_video();
		void player_read_stdout();
		void player_add_chapter();
		void player_current_percent();
		void player_avance();
		void player_recule();
		void player_go_chapter(QString);
		void player_auto_chapter();
		void player_auto_chapter_thumb();
		void player_close();
		void player_mute();
		void player_capture();
		void player_start_seek();
		void player_stop_seek();
                void player_move_seek(int);
		void player_bri(int);
		void player_con(int);
		void player_sat(int);
                void player_sub_pos(int);
                void player_sub_siz(int);
		void f_init_effects();
		void f_close_effects();

		// *** MPLAYER THUMBNAIL ***
		void player_thu_open_video(QString);
		void player_thu_valide();
                void player_thu_cancel();
                void player_thu_move_seek(int);

		// *** RENDERING ***
		void f_go_render_dvd();
		void f_gene_dvdauthorxml();
		void render_end(int, QProcess::ExitStatus);
		void render_stdout();
		void f_gene_mencoder();
		void f_make_menus();
		void f_encoding_end();
		void f_close_endencoding();
		void f_view_result();
		void f_create_iso();
		void f_read_ffmpeg();

		// *** FONCTIONS CLES ***
		void f_affiche_info_pos(menu *hdlm);
		void f_lockbar();
		void f_delete_widgetonmenu();
		void f_save_widgetonmenu();
		void f_update_thumb_menu();
		void f_create_menu_movie();
		void f_calcul_jauge(long);
		void f_run_ani();
                void f_run_bld();
		void f_generation_scale();
                void f_update_blend();
                void f_end_blend();

		// *** GESTION PROJET ***
		void f_new_1();
		void f_save_1();
		void f_save_2();
		void f_open_1();
		void f_open_2();
		void f_init_proj();
		void f_create_new_menu();
		void projectend(int, QProcess::ExitStatus);

		// *** GRAVAGE ***
		void f_open_burn();
		void f_open_burn_2();
		void f_cancel_burn();
		void f_go_burn();
		void f_read_outidv();
		void f_idvd_end(int, QProcess::ExitStatus);

		// *** DIVERS ***
		void f_apropos_open();
		void f_apropos_close();
		void f_scroll_timeline(int);
		void thvi_end(int, QProcess::ExitStatus);
		void f_menu_navi_on(menu*);
		void f_menu_navi_off(menu*);

		void f_advanced_open();
		void f_advanced_close();
		void f_put_loop(int);

		void f_read_outiso();
		void f_giso_end(int, QProcess::ExitStatus);
                void f_triangle_copier(ColorPickerWidget*);
                void f_triangle_coller(ColorPickerWidget*);

                void f_arbo_new_menu();

                //void f_refreshit();

                void f_view_magnetic();

		// *** INTRO CALCULEES ***
		void f_intro_calc();
		void f_valide_intro_calc();
		void f_cancel_intro_calc();
		void f_update_trans();
		void f_restart_proc_trans();
		void f_change_transition(QListWidgetItem*);
                void f_dial_trans_length(int);
		void f_find_intro_zik();

		// *** BLUR ***
		QImage blur_shadow(QImage);

		// *** EVENTS EXTERIEURS ***
		void extevent();

	private slots:
		// *** GESTION DE LA FENETRE ***
		void f_close();
		void keyPressEvent( QKeyEvent * );
		void keyReleaseEvent( QKeyEvent * );

	private:
		QProcess process_extract_img;
		QProcess process_import_background;
		QProcess process_one_shot;
		QProcess process_ident_media;
		QProcess process_extract_thu;

		QProcess mplayerProcess;
		QProcess renderProcess;
		QProcess projectProcess;
		QProcess nullProcess;
		QProcess thviProcess;
		QProcess isoProcess;
		QProcess idvProcess;
		QProcess proc_ffmpeg;

		thani *thread_ani;
                thblend *thread_blend;
		thimg *thread_img;
                thptra *thread_trans;


	signals:
	protected:
		virtual void closeEvent(QCloseEvent *e)
		{
			emit f_close();
			QMainWindow::closeEvent(e);
		}
};
#endif
