/* ============================================================
 * File  : language.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "mainfrm.h"

void mainfrm::f_affiche_language(media *hdlmedia)
{
	list_language->clear();
	list_language_2->clear();

	int wl_int_001 = 0;
	int wl_int_002 = 0;

	while ( hdlmedia->table_soundtrack[wl_int_001] != "" && wl_int_001 < 8 )
	{
		wl_int_002 = hdlmedia->table_soundtrack[wl_int_001].lastIndexOf( '/' );

		QListWidgetItem *item = new QListWidgetItem(list_language);
		item->setIcon(QIcon(":/Interface/Interface/sound.png"));
		item->setText(hdlmedia->table_soundtrack[wl_int_001].mid(wl_int_002+1,hdlmedia->table_soundtrack[wl_int_001].length()-(wl_int_002+1)));

		QListWidgetItem *item2 = new QListWidgetItem(list_language_2);
		item2->setText(hdlmedia->table_soundtrack[wl_int_001]);

		wl_int_001++;
	}

	hdl_current_media = hdlmedia;

	frame_language->show();
	frame_language->raise();
}

void mainfrm::f_close_language()
{
	int wl_int_001;

	for (wl_int_001 = 0; wl_int_001 < 8; wl_int_001++)
	{
		hdl_current_media->table_soundtrack[wl_int_001] = "";
	}

	// *** SAUVEGARDE DES BANDES AUDIO ***
	if ( list_language->count() > 0 )
	{
		hdl_current_media->isdvd = 0;
		list_language_2->selectAll();
		QList<QListWidgetItem*> lst_snd = list_language_2->selectedItems();
		wl_int_001 = 0;
		while ( wl_int_001 < lst_snd.size() )
		{
			hdl_current_media->table_soundtrack[wl_int_001] = lst_snd.at(wl_int_001)->text();
			wl_int_001++;
		}
		hdl_current_media->already_encode = 0;
	}
	frame_language->hide();
}

void mainfrm::f_search_language()
{
	if ( list_language->count() < 8 )
	{
		QString wmylan = QFileDialog::getOpenFileName(this, tr("Fichier audio"), path_language, "(*.mp2 *.MP2 *.mp3 *.MP3 *.wav *.WAV *.ogg *.OGG)");
	       	if ( wmylan.isNull() )
	       	{
			return;
	       	}
		else
		{
	   		int wl_int_001 = wmylan.lastIndexOf( '/' );
	    		if ( wl_int_001 != -1 )
	    		{
				path_language = wmylan.mid(0,wl_int_001);
	    		}

			QListWidgetItem *item = new QListWidgetItem(list_language);
			item->setIcon(QIcon(":/Interface/Interface/sound.png"));
			item->setText(wmylan.mid(wl_int_001+1,wmylan.length()-(wl_int_001+1)));

			QListWidgetItem *item2 = new QListWidgetItem(list_language_2);
			item2->setText(wmylan);
		}
	}
	else
	{
		QMessageBox::information(this, name_application, tr("Desole le nombre maximum de bandes son est de 8"));
	}
}

void mainfrm::f_delete_language(int row)
{
	list_language_2->takeItem(row);
}

void mainfrm::f_display_language()
{
	combo_select_langue->clear();

	if ( combo_quoilire_media->currentText() != wg_str_int_002 )
	{	
		// *** RECHERCHE DU MEDIA ***
		int wl_int_001=0;
		int wl_int_002=0;
		int wl_int_003=0;

		while ( wl_int_003 < nbre_medias && wl_int_002 == 0 )
		{
			if ( table_hdl_medias[wl_int_003]->pathname_media == combo_quoilire_media->currentText() )
			{
				wl_int_002 = 1;
			}
			else
			{
				wl_int_003++;
			}
		}

		combo_select_langue->insertItem(0,wg_str_int_006);

		while ( table_hdl_medias[wl_int_003]->table_soundtrack[wl_int_001] != "" && wl_int_001 < 8 )
		{
			combo_select_langue->insertItem(wl_int_001+1,table_hdl_medias[wl_int_003]->table_soundtrack[wl_int_001]);
			combo_select_langue->setItemIcon(wl_int_001+1, QIcon(":/Interface/Interface/sound.png"));

			wl_int_001++;
		}

		if ( wl_int_001 > 0 )
		{
			combo_select_langue->setEnabled(true);
		}
		else
		{
			combo_select_langue->setDisabled(true);
		}
	}
	else
	{
		combo_select_langue->setDisabled(true);
	}
}

