/* ============================================================
 * File  : item_menu.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "item_menu.h"

item_menu::item_menu ( QWidget * parent )
    : QLabel(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        //this->setMouseTracking(true);
	this->setScaledContents(true);
        num_menu = 0;
	wg_str_001 = tr("Menu principal");

        myfont.setPixelSize ( 11 );
        myfont.setBold(false);

        QPalette mypal = QApplication::palette();
        wg_color_1 = mypal.color(QPalette::Normal, QPalette::Light);
        wg_color_2 = mypal.color(QPalette::Normal, QPalette::Shadow);
        wg_color_2.setAlpha(200);

	// *** AJOUT DES FONCTIONS MEDIAS ***
	action_editmenu = new QAction(tr("Editer le menu"), this);
	action_editmenu->setIcon ( QIcon(":/Interface/Interface/edit_menu.png") );
	connect(action_editmenu, SIGNAL(triggered()), this, SLOT(f_edit()));
}

void item_menu::f_edit()
{
	emit edit_menu_tree(this);
}

// ********************************
// *** MENU CONTEXTUEL DU MEDIA ***
// ********************************

void item_menu::contextMenuEvent(QContextMenuEvent *event)
{
	QMenu menu(this);
	//menu.addAction(action_addlien);
	//menu.addSeparator();
	QMenu *menusub = menu.addMenu(QIcon(":/Interface/Interface/new.png"),tr("Lien vers un menu"));

	int wl_int_001 = 0;
	while (wl_int_001 <= nbre_menus)
	{
		QAction *hdlact[wl_int_001];
		if ( wl_int_001 == 0 )
		{
			hdlact[wl_int_001] = new QAction(wg_str_001, this);
		}
		else
		{
			hdlact[wl_int_001] = new QAction(tr("Menu") + " " + QString::number(wl_int_001), this);
		}
		hdlact[wl_int_001]->setIcon ( QIcon(":/Interface/Interface/quoifaire.png") );
		connect(hdlact[wl_int_001], SIGNAL(triggered()), this, SLOT(f_link()));
                if ( wl_int_001 != num_menu )
		{
			menusub->addAction(hdlact[wl_int_001]);
		}
		wl_int_001++;
	}

	QMenu *menusubm = menu.addMenu(QIcon(":/Interface/Interface/new.png"),tr("Lien vers un media"));
	wl_int_001 = 0;
	while (wl_int_001 < nbre_medias)
	{
		QAction *hdlact[wl_int_001];
		hdlact[wl_int_001] = new QAction(table_medias[wl_int_001], this);
		hdlact[wl_int_001]->setIcon ( QIcon(":/Interface/Interface/media1.png") );
		connect(hdlact[wl_int_001], SIGNAL(triggered()), this, SLOT(f_link_media()));
		menusubm->addAction(hdlact[wl_int_001]);
		wl_int_001++;
	}

	menu.addSeparator();
	menu.addAction(action_editmenu);
	menu.exec(event->globalPos());
}

void item_menu::f_link()
{
	QAction *myact = (QAction *)sender();

	if ( myact->text() == wg_str_001 )
	{
		emit add_link(this,0);
	}
	else
	{
		QString wl_str_001 = myact->text();
		int wl_int_001 = wl_str_001.lastIndexOf( " " );
		if ( wl_int_001 > -1 )
		{
			emit add_link(this,wl_str_001.mid(wl_int_001+1,wl_str_001.length()-(wl_int_001+1)).toInt());
		}
		else
		{
			qDebug() << "ERROR LINKING MESS : " << wl_str_001;
		}
	}
}

void item_menu::f_link_media()
{
	QAction *myact = (QAction *)sender();

	QString wl_str_001 = myact->text();
	emit add_link_media(this,wl_str_001);
}

// *************************************
// *** GESTION DES EVENEMENTS SOURIS ***
// *************************************

void item_menu::mouseMoveEvent(QMouseEvent *event)
{
	if (!(event->buttons() & Qt::LeftButton)) return;
	move(event->globalPos().x() - dragPosition.x(),event->globalPos().y() - dragPosition.y());
	emit item_move(this);
}

void item_menu::mousePressEvent ( QMouseEvent * event ) 
{
	dragPosition = event->globalPos() - frameGeometry().topLeft();
	emit item_select(this);
}

void item_menu::mouseReleaseEvent ( QMouseEvent * )
{
}

// ************************
// *** DESSIN DU WIDGET ***
// ************************

void item_menu::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
	p.setBrush(QColor(0,0,0));
	//p.drawRect(0,0,this->width(),this->height());
	p.drawPixmap(QRect(9,9,88,88),fond);
	p.drawPixmap(0,0,QPixmap(":/Interface/Interface/case_menu.png"));

        p.setBrush(wg_color_2);
        p.setPen(Qt::NoPen);
        p.drawRect(9,78,this->width()-18,16);
        p.setFont(myfont);
        p.setPen(wg_color_1);

        if ( num_menu == 0 )
        {
            p.drawText(QRect(9,79,this->width()-18,16),wg_str_001);
        }
        else
        {
            p.drawText(QRect(9,79,this->width()-18,16),"Menu " + QString::number(num_menu));
        }
	p.end();
}
