/* ============================================================
 * File  : item_media.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "item_media.h"

item_media::item_media ( QWidget * parent )
    : QLabel(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        //this->setMouseTracking(true);
	this->setScaledContents(true);
	action_reencode = new QAction(tr("Changer le bitrate du media"), this);
	action_reencode->setIcon ( QIcon(":/Interface/Interface/edit.png") );
	connect(action_reencode, SIGNAL(triggered()), this, SLOT(ren_media()));
}

// ********************************
// *** MENU CONTEXTUEL DU MEDIA ***
// ********************************

void item_media::contextMenuEvent(QContextMenuEvent *event)
{
	QMenu menu(this);
	menu.addAction(action_reencode);
	//menu.addSeparator();
	menu.exec(event->globalPos());
}

void item_media::ren_media()
{
	emit sg_ren_media(hdlmedia);
}

// *************************************
// *** GESTION DES EVENEMENTS SOURIS ***
// *************************************

void item_media::mouseMoveEvent(QMouseEvent *event)
{
	if (!(event->buttons() & Qt::LeftButton)) return;
	move(event->globalPos().x() - dragPosition.x(),event->globalPos().y() - dragPosition.y());
	emit item_move(this);
}

void item_media::mousePressEvent ( QMouseEvent * event ) 
{
	dragPosition = event->globalPos() - frameGeometry().topLeft();
}

void item_media::mouseReleaseEvent ( QMouseEvent * )
{
}

void item_media::enterEvent ( QEvent * ) 
{
	emit affiche_info(this);
}

void item_media::leaveEvent ( QEvent * ) 
{
	emit hide_info(this);
}

// ************************
// *** DESSIN DU WIDGET ***
// ************************

void item_media::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
	p.setBrush(QColor(0,0,0));
	//p.drawRect(0,0,this->width(),this->height());
	p.drawPixmap(QRect(9,9,88,88),fond);
	//p.drawPixmap(0,0,QPixmap(":/Interface/Interface/case_menu.png"));
	p.end();
}
