/* ============================================================
 * File  : frame_th_trans.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "frame_th_trans.h"
frame_th_trans::frame_th_trans ( QWidget * parent )
    : QFrame(parent)
{
    this->setAttribute(Qt::WA_DeleteOnClose);

    srcImage.load(":/Interface/Interface/A.png");
    srcImage2.load(":/Interface/Interface/B.png");
    srcImage3.load(":/Interface/Interface/B.png");
    dstImage.load(":/Interface/Interface/A.png");
    sequence = 0;
    type_trans = 0;
    is_display = 0;

    myfont.setPixelSize ( 8 );
    myfont.setBold(false);

    QPalette mypal = QApplication::palette();
    wg_color_1 = mypal.color(QPalette::Normal, QPalette::Highlight);

    myeffect = new QGraphicsColorizeEffect();
    myeffect->setStrength(0);
    myeffect->setColor(wg_color_1);
    this->setAttribute(Qt::WA_TranslucentBackground, true);
    this->setGraphicsEffect(myeffect);

    mysynctime.start();
}

void frame_th_trans::enterEvent(QEvent *)
{
        QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "strength");
        animation->setDuration(250);
        animation->setStartValue(myeffect->strength());
        animation->setEndValue(0.6);
        animation->start();
}

void frame_th_trans::leaveEvent(QEvent *)
{
        QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "strength");
        animation->setDuration(250);
        animation->setStartValue(myeffect->strength());
        animation->setEndValue(0.0);
        animation->start();
}

void frame_th_trans::mousePressEvent ( QMouseEvent * event )
{
    emit(select_trans(this));
}

void frame_th_trans::render_prev()
{
    if ( type_trans == 0 ) // *** Transitions par luma ***
    {
            lumavalue = (float)((float)255/(float)100)*(float)sequence;

            if ( lumavalue >= 0 )
            {
                    mycolor.setRed(lumavalue);
                    mycolor.setGreen(lumavalue);
                    mycolor.setBlue(lumavalue);
            }
            else
            {
                    mycolor.setRed(0);
                    mycolor.setGreen(0);
                    mycolor.setBlue(0);
            }

            if ( mycolor.red() <= 215 )
            {
                mycolor2.setRed(mycolor.red()+40);
                mycolor2.setGreen(mycolor.red()+40);
                mycolor2.setBlue(mycolor.red()+40);
            }
            else
            {
                mycolor2.setRed(255);
                mycolor2.setGreen(255);
                mycolor2.setBlue(255);
            }

            QRgb *ltrt1 = reinterpret_cast<QRgb *>(srcImage.scanLine(0));
            QRgb *ltrt2 = reinterpret_cast<QRgb *>(srcImage2.scanLine(0));

            for (y = 0; y < srcImage.height(); y++)
            {
                    ltrt1 = reinterpret_cast<QRgb *>(srcImage.scanLine(y));
                    ltrt2 = reinterpret_cast<QRgb *>(srcImage2.scanLine(y));

                    for (x = 0; x < srcImage.width(); x++)
                    {
                            srcPixel = ltrt1[x];
                            srcPixel2 = ltrt2[x];
                            srcPixel3 = srcImage3.pixel(x, y);

                            tmpcolor1 = srcPixel;
                            tmpcolor2 = srcPixel2;
                            tmpcolor3 = srcPixel3;

                            if ( tmpcolor3.value() > mycolor.value() )
                            {
                                    if ( tmpcolor3.value() <= mycolor2.value() )
                                    {
                                            valuefade = 255-(float)((float)(tmpcolor3.value()-mycolor.value())*255)/(float)(mycolor2.value()-mycolor.value()); //(float)255+(((float)tmpcolor3.value()/(float)2.5)-((float)mycolor2.value()/(float)2.5))*(float)20;

                                            tmpcolor3.setRed(tmpcolor1.red() * (1-(float)((float)valuefade/(float)255)) + tmpcolor2.red() * (float)((float)valuefade/(float)255));
                                            tmpcolor3.setGreen(tmpcolor1.green() * (1-(float)((float)valuefade/(float)255)) + tmpcolor2.green() * (float)((float)valuefade/(float)255));
                                            tmpcolor3.setBlue(tmpcolor1.blue() * (1-(float)((float)valuefade/(float)255)) + tmpcolor2.blue() * (float)((float)valuefade/(float)255));
                                            dstPixel = tmpcolor3.rgb();
                                            dstImage.setPixel(x, y, dstPixel);
                                    }
                                    else
                                    {
                                            dstImage.setPixel(x, y, srcPixel);
                                    }
                            }
                            else
                            {
                                    dstImage.setPixel(x, y, srcPixel2);
                            }
                    }
            }
    }
    else
    {
            // *** Fondu enchaine ***

            QRgb *ltrt1 = reinterpret_cast<QRgb *>(srcImage.scanLine(0));
            QRgb *ltrt2 = reinterpret_cast<QRgb *>(srcImage2.scanLine(0));

            for (y = 0; y < srcImage.height(); y++)
            {
                    ltrt1 = reinterpret_cast<QRgb *>(srcImage.scanLine(y));
                    ltrt2 = reinterpret_cast<QRgb *>(srcImage2.scanLine(y));

                    for (x = 0; x < srcImage.width(); x++)
                    {
                            srcPixel = ltrt1[x];
                            srcPixel2 = ltrt2[x];
                            tmpcolor1 = srcPixel;
                            tmpcolor2 = srcPixel2;
                            tmpcolor3.setRed(tmpcolor1.red() * (1-(float)((float)sequence/(float)100)) + tmpcolor2.red() * (float)((float)sequence/(float)100));
                            tmpcolor3.setGreen(tmpcolor1.green() * (1-(float)((float)sequence/(float)100)) + tmpcolor2.green() * (float)((float)sequence/(float)100));
                            tmpcolor3.setBlue(tmpcolor1.blue() * (1-(float)((float)sequence/(float)100)) + tmpcolor2.blue() * (float)((float)sequence/(float)100));
                            dstPixel = tmpcolor3.rgb();
                            dstImage.setPixel(x, y, dstPixel);
                    }
            }
    }

    sequence += 2;
    if ( sequence > 100 )
    {
        sequence = 0;
    }

    if ( is_display == 1 )
    {
        this->repaint();
        wl_wait = mysynctime.elapsed();
        if ( wl_wait < 40 )
        {
                QTimer::singleShot(40-wl_wait, this, SLOT(render_prev()));
        }
        else
        {
                QTimer::singleShot(1, this, SLOT(render_prev()));
        }
        mysynctime.restart();
    }
}


// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void frame_th_trans::paintEvent(QPaintEvent *)
{
        QPainter p;
        p.begin(this);
        p.setRenderHint(QPainter::Antialiasing,true);
        p.drawImage(QRect(0,0,-1,-1),dstImage);
        p.setPen(Qt::NoPen);
        p.setBrush(QColor(0,0,0,180));
        p.drawRect(0,82,128,18);
        p.setPen(QColor(255,255,255));
        p.setFont(myfont);
        p.drawText(QRect(0,82,this->width(),18), Qt::AlignCenter,trans_name);

        p.end();
}

