/* ============================================================
 * File  : frame_info_small.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "frame_info_small.h"

frame_info_small::frame_info_small ( QWidget * parent )
    : QFrame(parent)
{
        this->setAttribute(Qt::WA_DeleteOnClose);
        //this->setMouseTracking(true);
        position = "";

        myfont.setPixelSize(18);
        typeoffr = 0;
        sens = 0;

        myeffect = new QGraphicsOpacityEffect();
        myeffect->setOpacity(0.0);
        this->setAttribute(Qt::WA_TranslucentBackground, true);
        this->setGraphicsEffect(myeffect);
}

void frame_info_small::letvisible()
{
    this->show();

    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
    if ( typeoffr == 0 )
    {
        animation->setDuration(500);
    }
    else
    {
        animation->setDuration(250);
    }
    animation->setStartValue(qreal(myeffect->opacity()));
    animation->setEndValue(qreal(0.9));
    animation->start();
}

void frame_info_small::lethidden()
{
    QPropertyAnimation *animation = new QPropertyAnimation(myeffect, "opacity");
    connect(animation,SIGNAL(finished()),this,SLOT(f_end()));
    if ( typeoffr == 0 )
    {
        animation->setDuration(500);
    }
    else
    {
        animation->setDuration(250);
    }
    animation->setStartValue(myeffect->opacity());
    animation->setEndValue(0.0);
    animation->start();
}

void frame_info_small::f_end()
{
    this->hide();
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void frame_info_small::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
	p.setPen(Qt::NoPen);
        p.setFont(myfont);
        p.setRenderHint(QPainter::Antialiasing,true);
        p.setBrush(QColor(40,40,40));

        if ( sens == 0 )
        {
            p.drawRoundedRect(3, 0, this->width()-3, this->height(),2,2,Qt::AbsoluteSize);
            QPointF points[3] = {
                    QPointF(3.0, 10.0),
                    QPointF(3.0, 14.0),
                    QPointF(0.0, 12.0)
            };
            p.drawPolygon(points, 3);
            p.setPen(QColor(255,255,255));
        }
        else
        {
            p.drawRoundedRect(0, 0, this->width()-3, this->height(),2,2,Qt::AbsoluteSize);
            QPointF points[3] = {
                    QPointF(this->width()-3, 10.0),
                    QPointF(this->width()-3, 14.0),
                    QPointF(this->width(), 12.0)
            };
            p.drawPolygon(points, 3);
            p.setPen(QColor(255,255,255));
        }

        if ( typeoffr == 0 )
        {
            p.drawText(QRect(3,0,this->width()-3,this->height()), Qt::AlignCenter, position);
        }
        else
        {
            myfont.setPixelSize(12);
            p.setFont(myfont);
            p.drawText(QRect(32,0,this->width()-34,this->height()), Qt::AlignCenter, position);
            p.drawPixmap(5,4,-1,-1,trans);
        }
	p.end();
}

