/* ============================================================
 * File  : frame_bk.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "frame_bk.h"

frame_bk::frame_bk ( QWidget * parent )
    : QFrame(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        this->setMouseTracking(true);

        wg_color_1 = QApplication::palette().color(QPalette::Window);
}

// ********************************
// *** DESSIN DU FOND DU WIDGET ***
// ********************************

void frame_bk::paintEvent(QPaintEvent *)
{
        QPainter p;
	p.begin(this);
	p.setPen(Qt::NoPen);
	p.setRenderHint(QPainter::Antialiasing,true);

        QLinearGradient Gradient1(0.0,0.0,0.0,this->height()+20);
        Gradient1.setColorAt(0.2, wg_color_1);
        Gradient1.setColorAt(1.0, wg_color_1.darker(120));
        p.setBrush(Gradient1);

        p.drawRect(0, 0, this->width(), this->height());
        p.end();
}

