/* ============================================================
 * File  : diapos_th.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "diapos_th.h"

diapos_th::diapos_th ( QWidget * parent )
    : QLabel(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
    //is_first = 0;

        action_supprimer = new QAction(tr("Supprimer la diapositive"), this);
        action_supprimer->setIcon ( QIcon(":/Interface/Interface/trash.png") );
        action_dupliquer = new QAction(tr("Dupliquer la diapositive"), this);
        action_dupliquer->setIcon ( QIcon(":/Interface/Interface/paste.png") );
        action_theme = new QAction(tr("Définir l'animation comme nouveau thème"), this);
        action_theme->setIcon ( QIcon(":/Interface/Interface/heart.png") );

        connect(action_supprimer, SIGNAL(triggered()), this, SLOT(supprimer()));
        connect(action_dupliquer, SIGNAL(triggered()), this, SLOT(dupliquer()));
        connect(action_theme, SIGNAL(triggered()), this, SLOT(theme()));

        /*QPalette mypal = QApplication::palette();
        QColor wg_color_1 = mypal.color(QPalette::Normal, QPalette::Highlight);

        myeffect = new QGraphicsColorizeEffect();
        myeffect->setStrength(0);
        myeffect->setColor(wg_color_1);
        this->setAttribute(Qt::WA_TranslucentBackground, true);
        this->setGraphicsEffect(myeffect);*/
}

void diapos_th::dupliquer()
{
        emit dupliquer_diapoth(this);
}

void diapos_th::supprimer()
{
        emit delete_diapoth(this);
        //this->close();
}

void diapos_th::theme()
{
        emit theme_diapoth(this);
}

void diapos_th::mouseMoveEvent ( QMouseEvent * event )
{
    if (!(event->buttons() & Qt::LeftButton)) return;
    //
    emit leave_diath(this);

    QMimeData *mimedata = new QMimeData;
    mimedata->setText("$$DRAGINTO$$$");
    QDrag *drag = new QDrag(this);
    drag->setMimeData(mimedata);
    drag->setPixmap(QPixmap::fromImage(draw_image.scaledToWidth(52,Qt::FastTransformation)));

    drag->exec(Qt::MoveAction);
}

void diapos_th::mousePressEvent ( QMouseEvent * event )
{

    if (!(event->buttons() & Qt::LeftButton)) return;

    if ( is_edit == 0 )
    {
        emit select_diapoth(this);
    }
}

void diapos_th::enterEvent(QEvent *)
{
    emit enter_diath(this);
}

void diapos_th::leaveEvent(QEvent *)
{
    emit leave_diath(this);
}

void diapos_th::contextMenuEvent(QContextMenuEvent *event)
{
    if ( is_edit == 1 )
    {
            //if ( is_first == 1 )
            /*{
                    action_supprimer->setDisabled(true);
            }
            else
            {
                    action_supprimer->setEnabled(true);
            }*/

            QMenu menu(this);
            menu.addAction(action_supprimer);
            menu.addSeparator();
            menu.addAction(action_dupliquer);
            menu.addSeparator();
            menu.addAction(action_theme);
            menu.exec(event->globalPos());
    }
}

void diapos_th::paintEvent(QPaintEvent *)
{
    QPainter p;
    p.begin(this);
    p.drawImage ( QRect(4,4,42,42),draw_image.scaled(38,38) );
    if ( is_edit == 1 )
    {
            p.drawPixmap(0,0,QPixmap(":/Interface/Interface/case_diapo_select.png"));
    }
    else
    {
            p.drawPixmap(0,0,QPixmap(":/Interface/Interface/case_diapo.png"));
    }
    p.end();
}

Qt::DropActions diapos_th::supportedDropActions () const
{
        // returns what actions are supported when dropping
        return Qt::CopyAction | Qt::MoveAction;
}
