/* ============================================================
 * File  : diaporama.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 *
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <QtGui>
#include "mainfrm.h"
#include "userSettings.h"

// *****************************************
// *** GESTION FICHIERS MODULE DIAPORAMA ***
// *****************************************

void mainfrm::f_open_file_smile()
{
    frame_directory_smile->setGeometry(0,0,this->width(),this->height());
    media_media_smile->setGeometry(20,60,this->width()-40,this->height()-120);
    frame_support_path_smile->setGeometry(20,10,this->width()-40,frame_support_path_smile->height());
    bt_close_navigator_smile->setGeometry(this->width()-(bt_close_navigator_smile->width()+20), this->height() - 57, bt_close_navigator_smile->width(),bt_close_navigator_smile->height());
    bt_import_navigator_smile->setGeometry(bt_close_navigator_smile->geometry().x()-(bt_import_navigator_smile->width()+10),bt_close_navigator_smile->geometry().y(),bt_import_navigator_smile->width(),bt_import_navigator_smile->height());
    pb_load_img_smile->setGeometry(20,this->height(),pb_load_img_smile->width(),pb_load_img_smile->height());
    frame_directory_smile->show();
    frame_directory_smile->raise();

    media_media_smile->clearSelection();

    if ( pntmygl->src_open_file == 0 )
    {
        media_media_smile->setSelectionMode(QAbstractItemView::ExtendedSelection);
    }
    else
    {
        media_media_smile->setSelectionMode(QAbstractItemView::SingleSelection);
    }

    /*QPropertyAnimation *animation = new QPropertyAnimation(frame_directory_smile, "geometry");
    animation->setDuration(800);
    animation->setStartValue(QRect(frame_directory_smile->geometry().x(),frame_directory_smile->geometry().y(),frame_directory_smile->width(),frame_directory_smile->height()));
    animation->setEndValue(QRect(0,0,frame_directory_smile->width(),frame_directory_smile->height()));
    animation->start();*/
}

void mainfrm::f_close_navigator_smile()
{
    frame_directory_smile->hide();
    frame_directory_smile->lower();
}

void mainfrm::f_close_import_navigator_smile()
{
    if ( media_media_smile->selectedItems().count() < 1 )
    {
        return;
    }

    QStringList wl_export;
    int i = 0;

    while ( i < media_media_smile->selectedItems().count() )
    {
        wl_export.append(path_media_import_smile + "/" + media_media_smile->selectedItems().at(i)->text());
        i += 1;
    }
    frame_directory_smile->hide();
    frame_directory_smile->lower();

    if ( pntmygl->src_open_file == 2 )
    {
        pntmygl->f_load_background(wl_export);
        return;
    }
    else
    {
        pntmygl->f_load_image_step_2(wl_export);
        return;
    }
}

void mainfrm::f_change_directory_smile(QString directory)
{
        // **************************************
        // *** TRAITEMENT REPERTOIRE EN COURS ***
        // **************************************
        QDir tmpdir(directory);
        QStringList filters;
        filters << "*.jpg" << "*.JPG" << "*.jpeg" << "*.JPEG" << "*.png" << "*.PNG" << "*.gif" << "*.GIF" << "*.avi" << "*.AVI" << "*.MPG" << "*.mpg" << "*.MPEG" << "*.mpeg" << "*.mp4" << "*.MP4";

        tmpdir.setNameFilters(filters);
        tmpdir.setSorting(QDir::Name | QDir::IgnoreCase);

        QFileInfo infostr;
        QString wlfile;
        wg_int_004 = 0;
        nbre_vignettes = 0;

        QImage wl_img_texture;
        QPixmap wl_pix_texture;
        QPixmap wl_msk(":/Interface/Interface/mask_image.png");

        media_media_smile->clear();
        media_media_smile->current_path = directory;

        pb_load_img_smile->setMaximum(tmpdir.entryList().count());
        pb_load_img_smile->setValue(0);

        foreach (wlfile, tmpdir.entryList(QDir::AllDirs | QDir::Files, QDir::DirsFirst | QDir::IgnoreCase))
        {
                if ( wlfile == "." || ( wlfile == ".." && directory == "/" ) )
                {
                }
                else
                {
                        infostr.setFile(directory + "/" + wlfile);
                        if ( infostr.isFile() == false )
                        {
                            QListWidgetItem *item = new QListWidgetItem(media_media_smile);
                            item->setIcon(QIcon(":/Interface/Interface/folder_theme.png"));
                            item->setStatusTip(wlfile);
                            item->setText(wlfile);
                            wg_int_004++;
                        }
                        else
                        {
                            if ( wlfile.right(4) == ".avi" || wlfile.right(4) == ".AVI" || wlfile.right(4) == ".mpg" || wlfile.right(4) == ".MPG" || wlfile.right(5) == ".MPEG" || wlfile.right(5) == ".mpeg" || wlfile.right(4) == ".mp4" || wlfile.right(4) == ".MP4" )
                            {
                                QFile wmyficext;
                                QTextStream outext(&wmyficext);

                                wmyficext.setFileName(path_project + ".extthum.sh");
                                wmyficext.open( QIODevice::WriteOnly );
                                outext << "ffmpegthumbnailer -i \"" + directory + "/" + wlfile + "\" -t 15 -s 128 -q 10 -o \"" + path_project + ".th.jpg\"" << endl;
                                outext << "rm -f " + path_project + ".extthum.sh" << endl;
                                outext << "exit" << endl;
                                wmyficext.close();

                                QString programf = "bash";
                                QStringList argumentsf;
                                argumentsf << path_project + ".extthum.sh";

                                proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
                                proc_ffmpeg.start(programf,argumentsf);

                                proc_ffmpeg.waitForFinished(-1);

                                QImageReader image_reader(path_project + ".th.jpg");
                                image_reader.setScaledSize(QSize(128, 128));
                                wl_img_texture = image_reader.read();

                                QListWidgetItem *item = new QListWidgetItem(media_media_smile);

                                wl_pix_texture = QPixmap::fromImage(wl_img_texture,Qt::AutoColor);
                                wl_pix_texture.setMask(wl_msk.mask());

                                QPainter p;
                                p.begin(&wl_pix_texture);
                                p.drawPixmap(0,0,-1,-1,QPixmap(":/Interface/Interface/mask_image_2.png"));
                                p.end();

                                item->setIcon(wl_pix_texture);
                                item->setStatusTip("$$OTHER");
                                item->setText(wlfile);
                            }
                            else
                            {
                                QImageReader image_reader(directory + "/" + wlfile);
                                image_reader.setScaledSize(QSize(128, 128));
                                wl_img_texture = image_reader.read();

                                QListWidgetItem *item = new QListWidgetItem(media_media_smile);

                                wl_pix_texture = QPixmap::fromImage(wl_img_texture,Qt::AutoColor);
                                wl_pix_texture.setMask(wl_msk.mask());

                                QPainter p;
                                p.begin(&wl_pix_texture);
                                p.drawPixmap(0,0,-1,-1,QPixmap(":/Interface/Interface/mask_image_2.png"));
                                p.end();

                                item->setIcon(wl_pix_texture);
                                item->setStatusTip("$$OTHER");
                                item->setText(wlfile);
                             }
                        }
                        pb_load_img_smile->setValue(pb_load_img_smile->value()+1);
                        qApp->processEvents();
                }
        }

        QPropertyAnimation *animation = new QPropertyAnimation(pb_load_img_smile, "geometry");
        animation->setDuration(800);
        animation->setStartValue(QRect(pb_load_img_smile->geometry().x(),pb_load_img_smile->geometry().y(),pb_load_img_smile->width(),pb_load_img_smile->height()));
        animation->setEndValue(QRect(pb_load_img_smile->geometry().x(),this->height(),pb_load_img_smile->width(),pb_load_img_smile->height()));
        animation->start();
}

void mainfrm::f_move_directory_smile()
{
        // ***************************************
        // *** DEPLACEMENT DANS L'ARBORESCENCE ***
        // ***************************************
        QPropertyAnimation *animation = new QPropertyAnimation(pb_load_img_smile, "geometry");
        animation->setDuration(400);
        animation->setStartValue(QRect(pb_load_img_smile->geometry().x(),pb_load_img_smile->geometry().y(),pb_load_img_smile->width(),pb_load_img_smile->height()));
        animation->setEndValue(QRect(pb_load_img_smile->geometry().x(),bt_close_navigator_smile->geometry().y()+4,pb_load_img_smile->width(),pb_load_img_smile->height()));
        animation->start();

        QList<QListWidgetItem *> selectdir = media_media_smile->selectedItems();
        QListWidgetItem *dirtxt = new QListWidgetItem;
        dirtxt = selectdir.at(0);
        int wl_larg_txt = 0;

        if ( dirtxt->statusTip() == "$$VIDF" )
        {
                return;
        }
        if ( dirtxt->statusTip().mid(0,2) != ".." )
        {
                path_media_import_smile = path_media_import_smile + "/" + dirtxt->statusTip();

                QStringList wl_explode = path_media_import_smile.split("/",QString::SkipEmptyParts);

                toolbar_bt4 *newpt = new toolbar_bt4(frame_support_path_smile);
                connect(newpt, SIGNAL(chgdir(toolbar_bt4*)),this, SLOT(f_chgdir_smile(toolbar_bt4*)));
                table_hdl_medbrow_smile[wl_explode.count()-1] = newpt;

                QFontMetrics fm(newpt->myfont);
                wl_larg_txt = fm.width(dirtxt->statusTip());

                newpt->setGeometry(lengthbar_smile+3,33,wl_larg_txt+15,26);
                lengthbar_smile = lengthbar_smile + newpt->width()+3;

                newpt->setText(dirtxt->statusTip());
                newpt->show();
                newpt->f_show();
        }
        else
        {
                if ( path_media_import_smile.count('/', Qt::CaseSensitive) > 1 )
                {
                        path_media_import_smile = path_media_import_smile.section('/', 0, path_media_import_smile.count('/', Qt::CaseSensitive)-1, QString::SectionDefault);

                        QStringList wl_explode = path_media_import_smile.split("/",QString::SkipEmptyParts);
                        lengthbar_smile = lengthbar_smile - table_hdl_medbrow_smile[wl_explode.count()]->width()-3;
                        table_hdl_medbrow_smile[wl_explode.count()]->f_delete(0);
                }
                else
                {
                        table_hdl_medbrow_smile[0]->f_delete(0);
                        lengthbar_smile = 24;
                        path_media_import_smile = "/";
                }
        }

        f_change_directory_smile(path_media_import_smile);
}

void mainfrm::f_chgdir_smile(toolbar_bt4 *hdlbt)
{
    QPropertyAnimation *animation = new QPropertyAnimation(pb_load_img_smile, "geometry");
    animation->setDuration(400);
    animation->setStartValue(QRect(pb_load_img_smile->geometry().x(),pb_load_img_smile->geometry().y(),pb_load_img_smile->width(),pb_load_img_smile->height()));
    animation->setEndValue(QRect(pb_load_img_smile->geometry().x(),bt_close_navigator_smile->geometry().y()+4,pb_load_img_smile->width(),pb_load_img_smile->height()));
    animation->start();

    QString wl_path = "/";
    int wl_int_001 = 0;

    if ( hdlbt->text() != "/" )
    {
        while ( table_hdl_medbrow_smile[wl_int_001] != hdlbt && wl_int_001 < 40 )
        {
            wl_path = wl_path + table_hdl_medbrow_smile[wl_int_001]->text() + "/";
            wl_int_001++;
        }
        wl_path = wl_path + table_hdl_medbrow_smile[wl_int_001]->text() + "/";
        wl_int_001++;
    }

    int maxdel = frame_support_path_smile->children().count()-1;

    while ( wl_int_001 < maxdel )
    {
        lengthbar_smile = lengthbar_smile - table_hdl_medbrow_smile[wl_int_001]->width()-3;
        table_hdl_medbrow_smile[wl_int_001]->f_delete(100*wl_int_001);
        wl_int_001++;
    }

    path_media_import_smile = wl_path;
    f_change_directory_smile(path_media_import_smile);
}

// *****************
// *** DIAPORAMA ***
// *****************

void mainfrm::f_valide_new_projet_slideshow()
{
    if ( line_path_projet->text() != "" )
    {
            f_scale_project();

            // *** CREATION DE LA PREMIERE DIAPOSITIVE ***
            nbre_diapos = 1;
            QImage wl_pix1(50,50,QImage::Format_ARGB32_Premultiplied);
            QPainter p;
            p.begin(&wl_pix1);
            p.setBrush(QColor(0,0,0));
            p.drawRect(0,0,50,50);
            p.end();

            table_hdl_diapo[0] = new diapos_th(timeline_diapo);
            table_hdl_diapo[0]->setGeometry( 0, 0, 50, 50 );
            table_hdl_diapo[0]->draw_image = wl_pix1;
            table_hdl_diapo[0]->is_edit = 1;
            //table_hdl_diapo[0]->is_first = 1;
            table_hdl_diapo[0]->show();

            num_current_diapo = 0;
            hdl_current_diapo = table_hdl_diapo[0];

            connect(table_hdl_diapo[0], SIGNAL(select_diapoth(diapos_th*) ),this, SLOT(f_select_diapos_th(diapos_th*)));
            connect(table_hdl_diapo[0], SIGNAL(delete_diapoth(diapos_th*) ),this, SLOT(f_delete_diaposth(diapos_th*)));
            connect(table_hdl_diapo[0], SIGNAL(theme_diapoth(diapos_th*) ),this, SLOT(f_theme_diaposth(diapos_th*)));
            connect(table_hdl_diapo[0], SIGNAL(dupliquer_diapoth(diapos_th*) ),this, SLOT(f_dupliquer_diaposth(diapos_th*)));
            connect(table_hdl_diapo[0], SIGNAL(enter_diath(diapos_th*) ),this, SLOT(f_enter_diath(diapos_th*)));
            connect(table_hdl_diapo[0], SIGNAL(leave_diath(diapos_th*) ),this, SLOT(f_leave_diath(diapos_th*)));

            pntmygl->length_diapo = screen_timeline->length_diapo;
            frame_smile->raise();

            actionAfficher_cacher_les_coordonn_es->setChecked( userSettings::getDisplayOption( userSettings::DISPLAY_COORD ) );
            displayCoord( userSettings::getDisplayOption( userSettings::DISPLAY_COORD ) );
    }
    else
    {
            QMessageBox::information(this, name_application, tr("Vous devez choisir un dossier pour les fichiers de travail"));
    }
}

void mainfrm::f_scale_project()
{
    if ( line_path_projet->text() != "" )
    {
            // *** DEMARRAGE D'UN NOUVEAU PROJET ***
            if ( combo_format_dvd->currentIndex() == 0 )
            {
                    dvdxsize = 720;
                    dvdysize = 576;
                    dvd_standard = "pal";
                    dvd_format = "4/3";
                    wg_fps = "25";
                    wg_fps_int = 25;
            }
            else
            {
                    if ( combo_format_dvd->currentIndex() == 1 )
                    {
                            dvdxsize = 1024;
                            dvdysize = 576;
                            dvd_standard = "pal";
                            dvd_format = "16/9";
                            wg_fps = "25";
                            wg_fps_int = 25;
                    }
                    else
                    {
                            if ( combo_format_dvd->currentIndex() == 2 )
                            {
                                    dvdxsize = 720;
                                    dvdysize = 480;
                                    dvd_standard = "ntsc";
                                    dvd_format = "4/3";
                                    wg_fps = "30000/1001";
                                    wg_fps_int = 29.97;
                            }
                            else
                            {
                                    dvdxsize = 1024;
                                    dvdysize = 480;
                                    dvd_standard = "ntsc";
                                    dvd_format = "16/9";
                                    wg_fps = "30000/1001";
                                    wg_fps_int = 29.97;
                            }
                    }
            }

            if ( whereopenfrom == 0 )
            {
                /*QGLFormat f = QGLFormat::defaultFormat();
                f.setSampleBuffers(true);
                QGLFormat::setDefaultFormat(f);*/

                frame_editor->hide();

                pntmygl = new Tetrahedron(hdl_fr3d, cb_dr->checkState(), cb_aa->checkState());
                pntmygl->resize(dvdxsize,dvdysize);
                pntmygl->wg_fps_int = wg_fps_int;

                sx_tr_diapo = dvdxsize;
                sy_tr_diapo = dvdysize;

                connect(pntmygl, SIGNAL(dia_select(int)),this, SLOT(f_display_mark_on_timeline(int)));
                connect(pntmygl, SIGNAL(dia_of_preview(QString)),this, SLOT(f_open_ipreview(QString)));
                connect(pntmygl, SIGNAL(hide_preview()),this, SLOT(f_hide_preview()));
                connect(pntmygl, SIGNAL(update_preview()),this, SLOT(f_update_diapoth()));
                connect(pntmygl, SIGNAL(move_start()),this, SLOT(f_move_start()));
                connect(pntmygl, SIGNAL(load_back()),this, SLOT(f_load_back()));
                connect(pntmygl, SIGNAL(update_coo()),this, SLOT(f_update_coo()));
                connect(pntmygl, SIGNAL(change_length(int)),this, SLOT(f_change_length_diapo_from_tetra(int)));
                connect(pntmygl, SIGNAL(add_diapo()),this, SLOT(f_add_diapo_signal()));
                connect(pntmygl, SIGNAL(update_diapo()),this, SLOT(f_update_diapo_signal()));
                connect(pntmygl, SIGNAL(s_delete_diapo(int)),this, SLOT(f_s_delete_diapo(int)));
                connect(pntmygl, SIGNAL(s_edit_image()),this, SLOT(f_s_edit_image()));

                connect(pntmygl, SIGNAL(file_smile()),this, SLOT(f_open_file_smile()));

                connect(pntmygl, SIGNAL(tool_ef_image()),this, SLOT(f_tool_ef_image()));

                connect(bt_smile_img_bck, SIGNAL(clicked()), pntmygl, SLOT(f_load_background_1()));
                connect(actionReinitialiser_les_coordonn_es, SIGNAL(triggered()),pntmygl, SLOT(f_init_image()));

                connect(pntmygl, SIGNAL(s_d_f_custo_mask()),this, SLOT(f_s_d_f_custo_mask()));

                connect(screen_timeline, SIGNAL(follow(int)),pntmygl, SLOT(f_follow_timeline(int)));
                connect(screen_timeline, SIGNAL(update_coo()),this, SLOT(f_update_coo()));

                connect(sl_esp_ana, SIGNAL(valueChanged(int)),pntmygl, SLOT(f_sl_esp_ana(int)));
                connect(check_anaglyph,SIGNAL(stateChanged(int)),pntmygl,SLOT(f_check_anaglyph(int)));
                connect(check_motion_blur,SIGNAL(stateChanged(int)),pntmygl,SLOT(f_check_motion_blur(int)));
                connect(check_fog,SIGNAL(stateChanged(int)),pntmygl,SLOT(f_check_fog(int)));

                connect(combo_od, SIGNAL(currentIndexChanged(int)),pntmygl, SLOT(f_combo_od_changed(int)));
                connect(combo_og, SIGNAL(currentIndexChanged(int)),pntmygl, SLOT(f_combo_og_changed(int)));

                connect(check_reflet,SIGNAL(stateChanged(int)),pntmygl,SLOT(f_put_reflect(int)));

                connect(sl_sca_diapo, SIGNAL(valueChanged(int)),pntmygl, SLOT(f_sl_sca_diapo(int)));

                connect(linxtxtslide, SIGNAL(textChanged(QString)), pntmygl, SLOT(f_txt_changed(QString)));
                connect(font_slidetxt,SIGNAL(currentFontChanged(QFont)),pntmygl,SLOT(f_font_slidetxt(QFont)));

                connect(frame_th_ani_smile, SIGNAL(itemDoubleClicked ( QListWidgetItem* )),pntmygl, SLOT(f_load_object(QListWidgetItem*)));
                connect(frame_th_ani_smile, SIGNAL(itemClicked ( QListWidgetItem * )),this, SLOT(f_select_item_object(QListWidgetItem *)));
                connect(frame_th_ani_smile, SIGNAL(affhide_anim ()),this, SLOT(f_affhide_anim()));

                connect(bt_bold_txtslide,SIGNAL(clicked()),pntmygl,SLOT(f_bt_bold_txtslide()));
                connect(bt_italic_txtslide,SIGNAL(clicked()),pntmygl,SLOT(f_bt_italic_txtslide()));
                connect(bt_underline_txtslide,SIGNAL(clicked()),pntmygl,SLOT(f_bt_underline_txtslide()));

                connect(pbgz,SIGNAL(clicked()),pntmygl,SLOT(f_change_tool_grab_fi()));
                connect(pbrx,SIGNAL(clicked()),pntmygl,SLOT(f_change_tool_rotate_x_fi()));
                connect(pbry,SIGNAL(clicked()),pntmygl,SLOT(f_change_tool_rotate_y_fi()));
                connect(pbrz,SIGNAL(clicked()),pntmygl,SLOT(f_change_tool_rotate_z_fi()));

                connect(chk_flakes,SIGNAL(stateChanged(int)),pntmygl,SLOT(f_flakes_changed(int)));
                connect(chk_flakes_2,SIGNAL(stateChanged(int)),pntmygl,SLOT(f_flakes_mcolor(int)));
                connect(sl_part_nombre,SIGNAL(valueChanged(int)),pntmygl,SLOT(f_flakes_nbre_changed(int)));
                connect(sl_part_size,SIGNAL(valueChanged(int)),pntmygl,SLOT(f_flakes_size_changed(int)));
                connect(combo_tflakes,SIGNAL(currentIndexChanged(int)),pntmygl,SLOT(f_flakes_type_changed(int)));
                connect(sl_part_prof,SIGNAL(valueChanged(int)),pntmygl,SLOT(f_flakes_prof_changed(int)));
                connect(sl_part_speed,SIGNAL(valueChanged(int)),pntmygl,SLOT(f_flakes_speed_changed(int)));
                connect(pntmygl, SIGNAL(flakes_act(int)),this, SLOT(f_flakes_act(int)));

                connect(pntmygl, SIGNAL(tool_change(int)),this, SLOT(f_tool_change(int)));

                connect(pntmygl, SIGNAL(effect_render()), this, SLOT(f_aff_msk_eff()));
            }
            else
            {
                pntmygl->wg_fps_int = wg_fps_int;
            }

            if ( combo_vmemory->currentIndex() == 0 )
            {
                    pntmygl->sm_mxw = 1024;
            }
            else
            {
                if ( combo_vmemory->currentIndex() == 1 )
                {
                    pntmygl->sm_mxw = 2048;
                }
                else
                {
                    pntmygl->sm_mxw = 4096;
                }
            }
            qDebug() << "TEXTURE_SIZE=" << pntmygl->sm_mxw;

            /*if ( pntmygl->format().sampleBuffers() == true )
            {
                pntmygl->is_sample_layer = 1;

                if ( cb_aa->checkState() == 2 )
                {
                    bt_switch_quality->setChecked(true);
                }
            }
            else
            {
                if ( cb_aa->isChecked() == true )
                {
                    pntmygl->setFormat(QGLFormat(QGL::NoSampleBuffers));
                }
                pntmygl->is_sample_layer = 0;
            }*/

            path_project = line_path_projet->text();
            path_always_save = "";
            player_isplaying = false;

            // *** INITIALISATIONS ***
            f_change_directory_smile(path_media_import_smile);
            pntmygl->f_init_tabtex();
            lst_calques->clear();
            screen_timeline->f_init_pos();
            pntmygl->nombre_diapos = 0;
            timeline_diapo->max_diapo = 1;
            timeline_diapo->tab_duration[0] = spin_length_diapo->value();
            isrendering = 0;
            pntmygl->isrendering = 0;
            scroll_timeline_smile->setMaximum(0);
            scroll_timeline_smile->setValue(0);
            nbre_audio_track = 0;
            timeline_diapo->nbre_audio_track = nbre_audio_track;
            myeffect_global->setOpacity(0.0);

            // *** RESIZE DE LA FENETRE ***
            frame_new_proj->hide();
            frame_top_tool->hide();
            smenuBar->show();

            this->setWindowTitle(tr("2ManDVD - Creation de diaporamas"));
            this->setMinimumSize(dvdxsize+frame_pro->width(),dvdysize+180);
            this->setMaximumSize(dvdxsize+frame_pro->width(),dvdysize+180);
            this->setGeometry((QApplication::desktop()->screenGeometry(0).width()-(dvdxsize+frame_pro->width()))/2,(QApplication::desktop()->screenGeometry(0).height()-(dvdysize+180))/2,dvdxsize+frame_pro->width(),dvdysize+180);

            frame_render_smile->hide();
            frame_load_diapo->hide();

            smenuBar->setEnabled(true);
            menuEdition->setEnabled(true);
            actionCopier_le_bouton->setDisabled(true);
            actionColler_le_bouton->setDisabled(true);
            actionCapturer_une_image_du_menu->setEnabled(true);
            actionPreferences->setEnabled(true);
            actionReinitialiser_les_coordonn_es->setEnabled(true);

            actionAfficher_cacher_les_coordonn_es->setEnabled(true);
            actionAfficher_cacher_les_r_gles->setDisabled(true);
            actionAfficher_cacher_les_zones_de_s_curit->setDisabled(true);
            actionAfficher_cacher_les_contours->setDisabled(true);
            actionArborescence_du_projet->setDisabled(true);

            menuInsertion->setEnabled(true);
            actionAjouter_un_bouton->setDisabled(true);
            actionAjouter_plusieurs_boutons->setDisabled(true);
            actionAjouter_une_zone_de_texte->setDisabled(true);
            actionDiaporama_automatique->setEnabled(true);
            actionAjouter_une_diapositive->setEnabled(true);
            actionAfficher_cacher_grille_de_placement->setEnabled(true);
            menuMenu->setDisabled(true);
            menuMenu->hide();
            menuG_n_ration->setEnabled(true);
            actionG_n_rer_le_DVD->setEnabled(true);
            actionGraver_le_DVD->setDisabled(true);
            actionGenerer_l_image_ISO_du_DVD->setDisabled(true);
            actionRevoir_la_derniere_generation->setDisabled(true);
            actionZone_du_DVD->setDisabled(true);
            menuA_propos->setEnabled(true);

            actionOuvrir->setEnabled(true);
            actionEnregistrer->setEnabled(true);
            actionEnregistrer_2->setDisabled(true);

            dial_smile_light->setDisabled(true);
            dial_smile_contrast->setDisabled(true);
            slider_opa_slide->setDisabled(true);
            slider_blur_img->setDisabled(true);
            check_reflet->setDisabled(true);
            sl_sca_diapo->setDisabled(true);

            slider_slide_red->setDisabled(true);
            slider_slide_green->setDisabled(true);
            slider_slide_blue->setDisabled(true);

            slider_size_x_scale->setDisabled(true);
            slider_size_y_scale->setDisabled(true);
            slider_size_x_scale_2->setDisabled(true);
            slider_size_y_scale_2->setDisabled(true);

            frame_th_msk_smile->setDisabled(true);

            linxtxtslide->setDisabled(true);
            wheel_txt_col_slide->setDisabled(true);

            combo_tflakes->setDisabled(true);

            frame_smile->setGeometry(0,0,this->width(),this->height());
            frame_smile->show();
            frame_smile->raise();
            hdl_fr3d->setGeometry(0,0,dvdxsize,dvdysize);
            frame_msk_ed3d->setGeometry(0,0,dvdxsize,dvdysize);
            frame_msk_ed3d->hide();
            frame_holy->hide();
            frame_holy_param->hide();
            frame_holy->setGeometry((this->width()-frame_holy->width())/2,(this->height()-frame_holy->height())/2,frame_holy->width(),frame_holy->height());
            frame_holy_param->setGeometry((this->width()-frame_holy_param->width())/2,(this->height()-frame_holy_param->height())/2,frame_holy_param->width(),frame_holy_param->height());

            frame_bottom_slide->setGeometry(0,this->height()-180,this->width(),50);
            screen_timeline->setGeometry((pntmygl->width()-700)/2,5,700,40);
            frame_toolslide->setGeometry(dvdxsize,0,this->width()-dvdxsize,this->height()-170);

            frame_tools_3d->setGeometry(frame_toolslide->geometry().x()+((frame_toolslide->width()-frame_tools_3d->width())/2),0,frame_tools_3d->width(),frame_tools_3d->height());

            frame_topbt_smile->setGeometry((frame_toolslide->width()-frame_topbt_smile->width())/2,frame_toolslide->height()-(frame_topbt_smile->height()+10),frame_topbt_smile->width(),frame_topbt_smile->height());

            tab_smile->setGeometry(10,10,frame_toolslide->width()-20,frame_topbt_smile->geometry().y()-20);
            frame_pro_smile->setGeometry(0,0,frame_toolslide->width(),frame_topbt_smile->geometry().y());

            frame_choose_encode->setGeometry((this->width()-frame_choose_encode->width())/2,(this->height()-frame_choose_encode->height())/2,frame_choose_encode->width(),frame_choose_encode->height());

            wheel_back_slide->setGeometry((frame_pro_smile->width()-wheel_back_slide->width())/2,wheel_back_slide->geometry().y(),wheel_back_slide->width(),wheel_back_slide->height());
            label_56->setGeometry(10,label_56->geometry().y(),frame_pro_smile->width()-20,label_56->height());

            sl_esp_ana->setGeometry(sl_esp_ana->geometry().x(),sl_esp_ana->geometry().y(),tb_diapositive->width()-(10+sl_esp_ana->geometry().x()),sl_esp_ana->height());
            combo_od->setGeometry(combo_od->geometry().x(),combo_od->geometry().y(),tb_diapositive->width()-(10+sl_esp_ana->geometry().x()),sl_esp_ana->height());
            combo_og->setGeometry(combo_og->geometry().x(),combo_og->geometry().y(),tb_diapositive->width()-(10+sl_esp_ana->geometry().x()),sl_esp_ana->height());

            slider_opa_slide->setGeometry(10,slider_opa_slide->geometry().y(),tb_diapositive->width()-20,slider_opa_slide->height());
            slider_blur_img->setGeometry(10,slider_blur_img->geometry().y(),tb_diapositive->width()-20,slider_blur_img->height());
            sl_sca_diapo->setGeometry(10,sl_sca_diapo->geometry().y(),tb_diapositive->width()-20,sl_sca_diapo->height());

            frame_coorsmile->setGeometry(0,frame_bottom_slide->geometry().y(),dvdxsize,0);
            frame_center_coord->setGeometry((frame_coorsmile->width()-frame_center_coord->width())/2,0,frame_center_coord->width(),frame_center_coord->height());

            tb_diapositive->setGeometry(10,10,frame_pro_smile->width()-20,330);
            frame_calques->setGeometry(0,tb_diapositive->height()+15,frame_pro_smile->width(),frame_pro_smile->height()-340);
            lst_calques->setGeometry(10,34,frame_calques->width()-20,frame_calques->height()-39);

            frame_thm_smile->setGeometry(0,frame_toolslide->height(),frame_toolslide->width(),frame_topbt_smile->geometry().y());
            frame_th_msk_smile->setGeometry(10,10,tab_smile->width()-20,tab_smile->height()-50);

            bt_smile_img_bck->setGeometry((frame_pro_smile->width()-bt_smile_img_bck->width())/2,bt_smile_img_bck->geometry().y(),bt_smile_img_bck->width(),bt_smile_img_bck->height());

            frame_support_th3d->setGeometry(10,10,tab_smile->width()-20,tab_smile->height()-50);
            frame_th_ani_smile->setGeometry(10,10,tab_smile->width()-20,tab_smile->height()-50);
            frame_lcd_position->setGeometry(screen_timeline->geometry().x()+screen_timeline->width()+5,(frame_bottom_slide->height()-frame_lcd_position->height())/2,frame_lcd_position->width(),frame_lcd_position->height());
            frame_preview_image->setGeometry(this->width()-(frame_preview_image->width()+15),this->height()-(frame_preview_image->height()+15),frame_preview_image->width(),frame_preview_image->height());
            frame_support_timeline_diapo->setGeometry(0,this->height()-130,this->width(),130);
            frame_support_timeline->setGeometry(40,0,this->width()-40,85);
            scroll_timeline_smile->setGeometry(40,90,this->width()-42,16);
            scroll_timeline_smile->raise();

            timeline_diapo->setGeometry(0,0,this->width()-20,85);

            frame_preferences->setGeometry((this->width()-frame_preferences->width())/2,(this->height()-frame_preferences->height())/2,frame_preferences->width(),frame_preferences->height());
            tabprodia->setGeometry(0,0,page->width(),page->height());
            tabeffects->setGeometry(0,0,tabprodia->width(),tabprodia->height());

            frame_bottom_slide->raise();
            frame_lcd_position->raise();

            mask_interface->setGeometry(0,0,this->width(),this->height());
            mask_interface->hide();
            frame_apropos->setGeometry((this->width()-frame_apropos->width())/2,(this->height()-frame_apropos->height())/2,frame_apropos->width(),frame_apropos->height());
            frame_load_diapo->setGeometry((this->width()-frame_load_diapo->width())/2,(this->height()-frame_load_diapo->height())/2,frame_load_diapo->width(),frame_load_diapo->height());

            actionAfficher_cacher_les_coordonn_es->setChecked( userSettings::getDisplayOption( userSettings::DISPLAY_COORD ) );
            displayCoord( userSettings::getDisplayOption( userSettings::DISPLAY_COORD ) );
            whereopenfrom = 0;
        }

    QGraphicsOpacityEffect *myeffect = new QGraphicsOpacityEffect();
    myeffect->setOpacity(1.0);
    mask_interface->setAttribute(Qt::WA_TranslucentBackground, true);
    mask_interface->setGraphicsEffect(myeffect);
}

void mainfrm::f_tool_ef_image()
{
    QPixmap wl_pix_002(this->width(),this->height());
    wl_pix_002.fill(QColor(0,0,0,220));
    mask_interface->setPixmap(wl_pix_002);
    label_overmask->setPixmap(wl_pix_002);
    smenuBar->setDisabled(true);
    label_overmask->hide();
    label_loading->hide();

    QPixmap wl_pix_001ori(pntmygl->tab_diapo[pntmygl->num_select][0]);

    QStringList cropd = pntmygl->tab_diapo[pntmygl->num_select][7].split("/",QString::KeepEmptyParts);
    QPixmap wl_pix_001 = wl_pix_001ori.copy(cropd.at(0).toFloat(),cropd.at(1).toFloat(),cropd.at(2).toFloat()-cropd.at(0).toFloat(),cropd.at(3).toFloat()-cropd.at(1).toFloat());

    int wl_width;
    int wl_height;

    if ( wl_pix_001.width() > wl_pix_001.height() )
    {
        wl_pix_001 = wl_pix_001.scaledToWidth(this->width()-100,Qt::FastTransformation);
        wl_width = wl_pix_001.width();
        wl_height = wl_pix_001.height();
    }
    else
    {
        wl_pix_001 = wl_pix_001.scaledToHeight(this->height()-100,Qt::FastTransformation);
        wl_width = wl_pix_001.width();
        wl_height = wl_pix_001.height();
    }
    preview_smile_effect->wl_pix_ori = wl_pix_001;
    preview_smile_effect->wl_pix_mod = wl_pix_001;

    wl_pix_001.save( path_project + "/._mo.png","PNG");
    wl_pix_001 = wl_pix_001.scaled(128,128);
    wl_pix_001.save( path_project + "/._t1.png","PNG");

    pntmygl->src_effect = 0;

    pntmygl->wg_src_effects = path_project + "/._t1.png";
    pntmygl->wg_dst_effects = path_project + "/._t2.png";

    pntmygl->effect_polaroid();
    bt_eff_1->wl_img_1.load(path_project + "/._t2.png");

    pntmygl->effect_sepia();
    bt_eff_2->wl_img_1.load(path_project + "/._t2.png");

    pntmygl->effect_paint();
    bt_eff_3->wl_img_1.load(path_project + "/._t2.png");

    pntmygl->effect_auto_gamma();
    bt_eff_4->wl_img_1.load(path_project + "/._t2.png");

    pntmygl->effect_negate();
    bt_eff_5->wl_img_1.load(path_project + "/._t2.png");

    pntmygl->effect_multi_polaroid();
    bt_eff_6->wl_img_1.load(path_project + "/._t2.png");

    pntmygl->effect_charcoal();
    bt_eff_7->wl_img_1.load(path_project + "/._t2.png");

    pntmygl->effect_posterize();
    bt_eff_8->wl_img_1.load(path_project + "/._t2.png");

    pntmygl->effect_auto_level();
    bt_eff_9->wl_img_1.load(path_project + "/._t2.png");

    pntmygl->effect_radial_blur();
    bt_eff_10->wl_img_1.load(path_project + "/._t2.png");

    pntmygl->src_effect = 1;

    mask_interface->show();
    mask_interface->raise();

    frame_smile_effect->setGeometry(0,0,this->width(),this->height());
    label_overmask->setGeometry(0,0,this->width(),this->height());
    frame_bottom_smile_effect->setGeometry(0,frame_smile_effect->height()-(frame_bottom_smile_effect->height()+smenuBar->height()),this->width(),frame_bottom_smile_effect->height());

    bt_valide_smeff->setGeometry(frame_bottom_smile_effect->width()-160,bt_valide_smeff->geometry().y(),bt_valide_smeff->width(),bt_valide_smeff->height());
    bt_cancel_smeff->setGeometry(frame_bottom_smile_effect->width()-320,bt_valide_smeff->geometry().y(),bt_valide_smeff->width(),bt_valide_smeff->height());
    label_loading->setGeometry((this->width()-label_loading->width())/2,(this->height()-label_loading->height())/2,label_loading->width(),label_loading->height());
    frame_lst_effects->setGeometry(0,this->height(),this->width(),frame_lst_effects->height());

    preview_smile_effect->setGeometry((this->width()-wl_width)/2,((this->height()-(wl_height+frame_bottom_smile_effect->height()))/2)-10,wl_width, wl_height);
    preview_smile_effect->as_effect = 0;

    frame_smile_effect->show();
    frame_smile_effect->raise();

    pntmygl->wg_src_effects = path_project + "/._mo.png";
    pntmygl->wg_dst_effects = path_project + "/._mo.png";

    qApp->processEvents();

    /*QPropertyAnimation *animation = new QPropertyAnimation(frame_lst_effects, "geometry");
    animation->setDuration(1000);
    animation->setStartValue(QRect(frame_lst_effects->geometry().x(),frame_lst_effects->geometry().y(),frame_lst_effects->width(),frame_lst_effects->height()));
    animation->setEndValue(QRect(frame_lst_effects->geometry().x(),0,this->width(),this->height()));
    animation->setEasingCurve(QEasingCurve::InOutCubic);
    animation->start();*/
}

void mainfrm::f_cancel_smeff()
{
    mask_interface->hide();
    frame_smile_effect->hide();
    smenuBar->setEnabled(true);
}

void mainfrm::f_reinit_smeff()
{
    QPixmap wl_pix_001(pntmygl->tab_diapo[pntmygl->num_select][0]);

    //int wl_width;
    //int wl_height;

    if ( wl_pix_001.width() > wl_pix_001.height() )
    {
        wl_pix_001 = wl_pix_001.scaledToWidth(this->width()-80,Qt::FastTransformation);
        /*wl_width = wl_pix_001.width();
        wl_height = wl_pix_001.height();*/
    }
    else
    {
        wl_pix_001 = wl_pix_001.scaledToWidth(this->width()-100,Qt::FastTransformation);
        /*wl_width = wl_pix_001.width();
        wl_height = wl_pix_001.height();*/
    }
    preview_smile_effect->wl_pix_ori = wl_pix_001;
    preview_smile_effect->wl_pix_mod = wl_pix_001;
    preview_smile_effect->as_effect = 0;

    wl_pix_001.save( path_project + "/._mo.png","PNG");
    preview_smile_effect->repaint();
}

void mainfrm::f_valide_smeff()
{
    QString wmyimg = QFileDialog::getSaveFileName(this, tr("Sauvegarder l'image"), path_save, tr("Image (*.png)"));
    if ( wmyimg.isNull() )
    {
        return;
    }
    else
    {
        wg_int_001 = wmyimg.lastIndexOf( '/' );
        if ( wg_int_001 != -1 )
        {
                path_save = wmyimg.mid(0,wg_int_001);
        }

        QPixmap wl_pix_001( path_project + "/._mo.png");
        wl_pix_001.save(wmyimg,"PNG");

        pntmygl->tab_diapo[pntmygl->num_select][0] = wmyimg;
        pntmygl->f_reload_img(pntmygl->num_select);

        mask_interface->hide();
        frame_smile_effect->hide();
        smenuBar->setEnabled(true);
    }
}

void mainfrm::f_aff_msk_eff()
{
    //preview_smile_effect->setPixmap(QPixmap(path_project + "/._mo.png"));
    preview_smile_effect->wl_pix_mod = QPixmap(path_project + "/._mo.png").scaled(preview_smile_effect->wl_pix_mod.width(),preview_smile_effect->wl_pix_mod.height());
    preview_smile_effect->repaint();

    label_overmask->hide();
    label_loading->hide();

    QPropertyAnimation *animation = new QPropertyAnimation(frame_lst_effects, "geometry");
    animation->setDuration(200);
    animation->setStartValue(QRect(frame_lst_effects->geometry().x(),frame_lst_effects->geometry().y(),frame_lst_effects->width(),frame_lst_effects->height()));
    animation->setEndValue(QRect(frame_lst_effects->geometry().x(),frame_lst_effects->geometry().y()+(frame_lst_effects->height()+frame_bottom_smile_effect->height()),frame_lst_effects->width(),frame_lst_effects->height()));
    animation->setEasingCurve(QEasingCurve::InOutCubic);
    animation->start();
}

void mainfrm::f_showhide_smeff()
{
    if ( frame_lst_effects->geometry().y() < frame_bottom_smile_effect->geometry().y() )
    {
        QPropertyAnimation *animation = new QPropertyAnimation(frame_lst_effects, "geometry");
        animation->setDuration(1000);
        animation->setStartValue(QRect(frame_lst_effects->geometry().x(),frame_lst_effects->geometry().y(),frame_lst_effects->width(),frame_lst_effects->height()));
        animation->setEndValue(QRect(frame_lst_effects->geometry().x(),this->height(),frame_lst_effects->width(),frame_lst_effects->height()));
        animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();
    }
    else
    {
        QPropertyAnimation *animation = new QPropertyAnimation(frame_lst_effects, "geometry");
        animation->setDuration(1000);
        animation->setStartValue(QRect(frame_lst_effects->geometry().x(),frame_lst_effects->geometry().y(),frame_lst_effects->width(),frame_lst_effects->height()));
        animation->setEndValue(QRect(frame_lst_effects->geometry().x(),frame_bottom_smile_effect->geometry().y()-frame_lst_effects->height(),frame_lst_effects->width(),frame_lst_effects->height()));
        animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();
    }
}

void mainfrm::f_smeff_1()
{
    QMovie *wl_mov = new QMovie(":/Interface/Interface/loading.gif");

    label_loading->setMovie(wl_mov);
    wl_mov->start();

    label_overmask->show();
    label_overmask->raise();
    label_loading->show();
    label_loading->raise();
    preview_smile_effect->as_effect = 1;

    this->repaint();
    qApp->processEvents();

    QTimer::singleShot(25, pntmygl, SLOT(effect_polaroid()));
}

void mainfrm::f_smeff_2()
{
    QMovie *wl_mov = new QMovie(":/Interface/Interface/loading.gif");

    label_loading->setMovie(wl_mov);
    wl_mov->start();

    label_overmask->show();
    label_overmask->raise();
    label_loading->show();
    label_loading->raise();
    preview_smile_effect->as_effect = 1;

    this->repaint();
    qApp->processEvents();

    QTimer::singleShot(25, pntmygl, SLOT(effect_sepia()));
}

void mainfrm::f_smeff_3()
{
    QMovie *wl_mov = new QMovie(":/Interface/Interface/loading.gif");

    label_loading->setMovie(wl_mov);
    wl_mov->start();

    label_overmask->show();
    label_overmask->raise();
    label_loading->show();
    label_loading->raise();
    preview_smile_effect->as_effect = 1;

    this->repaint();
    qApp->processEvents();

    QTimer::singleShot(25, pntmygl, SLOT(effect_paint()));
}

void mainfrm::f_smeff_4()
{
    QMovie *wl_mov = new QMovie(":/Interface/Interface/loading.gif");

    label_loading->setMovie(wl_mov);
    wl_mov->start();

    label_overmask->show();
    label_overmask->raise();
    label_loading->show();
    label_loading->raise();
    preview_smile_effect->as_effect = 1;

    this->repaint();
    qApp->processEvents();

    QTimer::singleShot(25, pntmygl, SLOT(effect_auto_gamma()));
}

void mainfrm::f_smeff_5()
{
    QMovie *wl_mov = new QMovie(":/Interface/Interface/loading.gif");

    label_loading->setMovie(wl_mov);
    wl_mov->start();

    label_overmask->show();
    label_overmask->raise();
    label_loading->show();
    label_loading->raise();
    preview_smile_effect->as_effect = 1;

    this->repaint();
    qApp->processEvents();

    QTimer::singleShot(25, pntmygl, SLOT(effect_negate()));
}

void mainfrm::f_smeff_6()
{
    QMovie *wl_mov = new QMovie(":/Interface/Interface/loading.gif");

    label_loading->setMovie(wl_mov);
    wl_mov->start();

    label_overmask->show();
    label_overmask->raise();
    label_loading->show();
    label_loading->raise();
    preview_smile_effect->as_effect = 1;

    this->repaint();
    qApp->processEvents();

    QTimer::singleShot(25, pntmygl, SLOT(effect_multi_polaroid()));
}

void mainfrm::f_smeff_7()
{
    QMovie *wl_mov = new QMovie(":/Interface/Interface/loading.gif");

    label_loading->setMovie(wl_mov);
    wl_mov->start();

    label_overmask->show();
    label_overmask->raise();
    label_loading->show();
    label_loading->raise();
    preview_smile_effect->as_effect = 1;

    this->repaint();
    qApp->processEvents();

    QTimer::singleShot(25, pntmygl, SLOT(effect_charcoal()));
}

void mainfrm::f_smeff_8()
{
    QMovie *wl_mov = new QMovie(":/Interface/Interface/loading.gif");

    label_loading->setMovie(wl_mov);
    wl_mov->start();

    label_overmask->show();
    label_overmask->raise();
    label_loading->show();
    label_loading->raise();
    preview_smile_effect->as_effect = 1;

    this->repaint();
    qApp->processEvents();

    QTimer::singleShot(25, pntmygl, SLOT(effect_posterize()));
}

void mainfrm::f_smeff_9()
{
    QMovie *wl_mov = new QMovie(":/Interface/Interface/loading.gif");

    label_loading->setMovie(wl_mov);
    wl_mov->start();

    label_overmask->show();
    label_overmask->raise();
    label_loading->show();
    label_loading->raise();
    preview_smile_effect->as_effect = 1;

    this->repaint();
    qApp->processEvents();

    QTimer::singleShot(25, pntmygl, SLOT(effect_auto_level()));
}

void mainfrm::f_smeff_10()
{
    QMovie *wl_mov = new QMovie(":/Interface/Interface/loading.gif");

    label_loading->setMovie(wl_mov);
    wl_mov->start();

    label_overmask->show();
    label_overmask->raise();
    label_loading->show();
    label_loading->raise();
    preview_smile_effect->as_effect = 1;

    this->repaint();
    qApp->processEvents();

    QTimer::singleShot(25, pntmygl, SLOT(effect_radial_blur()));
}

void mainfrm::f_open_trans_smile()
{
    int wl_int_001 = 1;
    int wl_int_002 = 0;
    int wl_int_003 = 10;
    int wl_int_004 = 10;

    QImage wl_img_a;
    QImage wl_img_b;
    int is_a = 0;
    int is_b = 0;

    if ( wl_img_a.load(pntmygl->tab_diapo[1][0]) == true )
    {
        is_a = 1;
        wl_img_a = wl_img_a.scaled(100,100);
    }

    if ( num_current_diapo > 0 )
    {
        QStringList wl_explode = pntmygl->tab_save_diapo[num_current_diapo-1][1].split("$",QString::KeepEmptyParts);

        if ( wl_img_b.load(wl_explode.at(0)) == true )
        {
            is_b = 1;
            wl_img_b = wl_img_b.scaled(100,100);
        }
    }

    while ( table_lumas[wl_int_001][0] != "" )
    {
        wl_int_002 = 0;
        wl_int_003 = 10;
        wl_int_004 = 10;
        while ( table_lumas[wl_int_001][wl_int_002] != "" )
        {
            if ( wl_int_001 == 1 )
            {
                table_trluma[wl_int_001][wl_int_002] = new frame_th_trans(frame_support_prev_sm_1);
                connect(table_trluma[wl_int_001][wl_int_002], SIGNAL(select_trans(frame_th_trans*) ),this, SLOT(f_select_trans_smile(frame_th_trans*)));
                table_trluma[wl_int_001][wl_int_002]->is_display = 1;
                if ( wl_int_003 > frame_support_prev_sm_1->width()-110 )
                {
                    wl_int_003 = 10;
                    wl_int_004 = wl_int_004 + 110;
                }
            }
            else
            {
                if ( wl_int_001 == 2 )
                {
                    table_trluma[wl_int_001][wl_int_002] = new frame_th_trans(frame_support_prev_sm_2);
                    connect(table_trluma[wl_int_001][wl_int_002], SIGNAL(select_trans(frame_th_trans*) ),this, SLOT(f_select_trans_smile(frame_th_trans*)));
                    table_trluma[wl_int_001][wl_int_002]->is_display = 0;

                    if ( wl_int_003 > frame_support_prev_sm_2->width()-110 )
                    {
                        wl_int_003 = 10;
                        wl_int_004 = wl_int_004 + 110;
                    }
                }
                else
                {
                    if ( wl_int_001 == 3 )
                    {
                        table_trluma[wl_int_001][wl_int_002] = new frame_th_trans(frame_support_prev_sm_3);
                        connect(table_trluma[wl_int_001][wl_int_002], SIGNAL(select_trans(frame_th_trans*) ),this, SLOT(f_select_trans_smile(frame_th_trans*)));
                        table_trluma[wl_int_001][wl_int_002]->is_display = 0;
                        if ( wl_int_003 > frame_support_prev_sm_3->width()-110 )
                        {
                            wl_int_003 = 10;
                            wl_int_004 = wl_int_004 + 110;
                        }
                    }
                    else
                    {
                        if ( wl_int_001 == 4 )
                        {
                            table_trluma[wl_int_001][wl_int_002] = new frame_th_trans(frame_support_prev_sm_4);
                            connect(table_trluma[wl_int_001][wl_int_002], SIGNAL(select_trans(frame_th_trans*) ),this, SLOT(f_select_trans_smile(frame_th_trans*)));
                            table_trluma[wl_int_001][wl_int_002]->is_display = 0;
                            if ( wl_int_003 > frame_support_prev_sm_4->width()-110 )
                            {
                                wl_int_003 = 10;
                                wl_int_004 = wl_int_004 + 110;
                            }
                        }
                        else
                        {
                            if ( wl_int_001 == 5 )
                            {
                                table_trluma[wl_int_001][wl_int_002] = new frame_th_trans(frame_support_prev_sm_5);
                                connect(table_trluma[wl_int_001][wl_int_002], SIGNAL(select_trans(frame_th_trans*) ),this, SLOT(f_select_trans_smile(frame_th_trans*)));
                                table_trluma[wl_int_001][wl_int_002]->is_display = 0;
                                if ( wl_int_003 > frame_support_prev_sm_5->width()-110 )
                                {
                                    wl_int_003 = 10;
                                    wl_int_004 = wl_int_004 + 110;
                                }
                            }
                            else
                            {
                                if ( wl_int_001 == 6 )
                                {
                                    table_trluma[wl_int_001][wl_int_002] = new frame_th_trans(frame_support_prev_sm_6);
                                    connect(table_trluma[wl_int_001][wl_int_002], SIGNAL(select_trans(frame_th_trans*) ),this, SLOT(f_select_trans_smile(frame_th_trans*)));
                                    table_trluma[wl_int_001][wl_int_002]->is_display = 0;
                                    if ( wl_int_003 > frame_support_prev_sm_6->width()-110 )
                                    {
                                        wl_int_003 = 10;
                                        wl_int_004 = wl_int_004 + 110;
                                    }
                                }
                                else
                                {
                                    if ( wl_int_001 == 7 )
                                    {
                                        table_trluma[wl_int_001][wl_int_002] = new frame_th_trans(frame_support_prev_sm_7);
                                        connect(table_trluma[wl_int_001][wl_int_002], SIGNAL(select_trans(frame_th_trans*) ),this, SLOT(f_select_trans_smile(frame_th_trans*)));
                                        table_trluma[wl_int_001][wl_int_002]->is_display = 0;
                                        if ( wl_int_003 > frame_support_prev_sm_7->width()-110 )
                                        {
                                            wl_int_003 = 10;
                                            wl_int_004 = wl_int_004 + 110;
                                        }
                                    }
                                    else
                                    {
                                        if ( wl_int_001 == 8 )
                                        {
                                            table_trluma[wl_int_001][wl_int_002] = new frame_th_trans(frame_support_prev_sm_8);
                                            connect(table_trluma[wl_int_001][wl_int_002], SIGNAL(select_trans(frame_th_trans*) ),this, SLOT(f_select_trans_smile(frame_th_trans*)));
                                            table_trluma[wl_int_001][wl_int_002]->is_display = 0;
                                            if ( wl_int_003 > frame_support_prev_sm_8->width()-110 )
                                            {
                                                wl_int_003 = 10;
                                                wl_int_004 = wl_int_004 + 110;
                                            }
                                        }
                                        else
                                        {
                                            if ( wl_int_001 == 9 )
                                            {
                                                table_trluma[wl_int_001][wl_int_002] = new frame_th_trans(frame_support_prev_sm_9);
                                                connect(table_trluma[wl_int_001][wl_int_002], SIGNAL(select_trans(frame_th_trans*) ),this, SLOT(f_select_trans_smile(frame_th_trans*)));
                                                table_trluma[wl_int_001][wl_int_002]->is_display = 0;
                                                if ( wl_int_003 > frame_support_prev_sm_9->width()-110 )
                                                {
                                                    wl_int_003 = 10;
                                                    wl_int_004 = wl_int_004 + 110;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            table_trluma[wl_int_001][wl_int_002]->setGeometry(wl_int_003,wl_int_004,100,100);

            if ( table_lumas[wl_int_001][wl_int_002] != "crossfade" )
            {
                table_trluma[wl_int_001][wl_int_002]->srcImage3.load(QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Luma/" + table_lumas[wl_int_001][wl_int_002] + ".png");
                table_trluma[wl_int_001][wl_int_002]->srcImage3 = table_trluma[wl_int_001][wl_int_002]->srcImage3.scaled(100,100);
            }
            else
            {
                table_trluma[wl_int_001][wl_int_002]->type_trans = 1;
            }

            if ( is_a == 1 )
            {
                table_trluma[wl_int_001][wl_int_002]->srcImage2 = wl_img_a;
            }

            if ( is_b == 1 )
            {
                table_trluma[wl_int_001][wl_int_002]->srcImage = wl_img_b;
            }

            table_trluma[wl_int_001][wl_int_002]->trans_name = table_lumas[wl_int_001][wl_int_002];
            table_trluma[wl_int_001][wl_int_002]->show();
            table_trluma[wl_int_001][wl_int_002]->render_prev();

            wl_int_003 = wl_int_003 + 110;

            wl_int_002++;
        }

        wl_int_001++;
    }

    tabWidget_transsmile->setCurrentIndex(0);

    QPixmap wl_pix_002(this->width(),this->height());
    wl_pix_002.fill(QColor(0,0,0,240));
    mask_interface->setPixmap(wl_pix_002);

    smenuBar->setDisabled(true);

    mask_interface->show();
    mask_interface->raise();

    frame_trans_smile_prev->setGeometry((this->width()-frame_trans_smile_prev->width())/2,(this->height()-frame_trans_smile_prev->height())/2,frame_trans_smile_prev->width(),frame_trans_smile_prev->height());
    frame_trans_smile_prev->show();
    frame_trans_smile_prev->raise();
    wg_int_001 = 0;
}

void mainfrm::f_select_trans_smile(frame_th_trans* hdlt)
{
    lst_trans_smile->setCurrentIndex(lst_trans_smile->findText(hdlt->trans_name,Qt::MatchExactly | Qt::MatchCaseSensitive));
    int wl_int_001 = 1;
    int wl_int_002 = 0;
    while ( wl_int_001 < 10 )
    {
        wl_int_002=0;
        while ( wl_int_002 < trans_page_count[wl_int_001] )
        {
            delete table_trluma[wl_int_001][wl_int_002];
            wl_int_002++;
        }
        wl_int_001++;
    }
    frame_trans_smile_prev->hide();
    mask_interface->hide();
    smenuBar->setEnabled(true);
}

void mainfrm::f_changed_tab_smile_trans(int newidx)
{
    int wl_int_002 = 0;

    while ( wl_int_002 < trans_page_count[wg_int_001+1] )
    {
        table_trluma[wg_int_001+1][wl_int_002]->is_display = 0;
        wl_int_002++;
    }
    wl_int_002 = 0;

    while ( wl_int_002 < trans_page_count[newidx+1] )
    {
        table_trluma[newidx+1][wl_int_002]->is_display = 1;
        table_trluma[newidx+1][wl_int_002]->render_prev();

        wl_int_002++;
    }
    wg_int_001 = newidx;
}

void mainfrm::f_close_prev_trans_smile()
{
    int wl_int_001 = 1;
    int wl_int_002 = 0;
    while ( wl_int_001 < 4  )
    {
        wl_int_002=0;
        while ( wl_int_002 < trans_page_count[wl_int_001] )
        {
            delete table_trluma[wl_int_001][wl_int_002];
            wl_int_002++;
        }
        wl_int_001++;
    }
    frame_trans_smile_prev->hide();
    mask_interface->hide();
    smenuBar->setEnabled(true);
}

void mainfrm::f_close_prev_trans_smile_none()
{
    int wl_int_001 = 1;
    int wl_int_002 = 0;
    while ( wl_int_001 < 4  )
    {
        wl_int_002=0;
        while ( wl_int_002 < trans_page_count[wl_int_001] )
        {
            delete table_trluma[wl_int_001][wl_int_002];
            wl_int_002++;
        }
        wl_int_001++;
    }

    lst_trans_smile->setCurrentIndex(0);

    frame_trans_smile_prev->hide();
    mask_interface->hide();
    smenuBar->setEnabled(true);
}

void mainfrm::f_flakes_act(int value)
{
    if ( value < 2 )
    {
        combo_tflakes->setDisabled(true);
    }
    else
    {
        combo_tflakes->setEnabled(true);
    }
}

void mainfrm::f_s_d_f_custo_mask()
{
    QPixmap wl_pix_001(preview_customize->width(),preview_customize->height());
    wg_pix_002.load(":/Interface/Interface/back_transparent.png");
    wg_pix_002 = wg_pix_002.scaled(preview_customize->width(),preview_customize->height());

    QStringList wl_explode = pntmygl->tab_diapo[pntmygl->num_select][3].split("%*",QString::KeepEmptyParts);

    if ( wg_pix_001.load(QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wl_explode.at(0) + ".png") == true )
    {
        wg_pix_003 = wg_pix_001.scaledToHeight(preview_customize->height(), Qt::SmoothTransformation);

        must_update = 0;
        slider_custo_red->setValue(wl_explode.at(1).toInt());
        slider_custo_green->setValue(wl_explode.at(2).toInt());
        slider_custo_blue->setValue(wl_explode.at(3).toInt());
        slider_custo_opacity->setValue(wl_explode.at(4).toInt());
        must_update = 1;

        thread_img->rouge = slider_custo_red->value();
        thread_img->vert = slider_custo_green->value();
        thread_img->bleu = slider_custo_blue->value();
        thread_img->opacity = slider_custo_opacity->value();

        thread_img->wlimg = wg_pix_003.toImage().convertToFormat(QImage::Format_ARGB32, Qt::AutoColor);
        thread_img->run();
        
        QPainter p;
        p.begin(&wl_pix_001);
        p.drawPixmap(0,0,-1,-1,wg_pix_002);
        p.drawPixmap((wl_pix_001.width()-wg_pix_003.width())/2,(wl_pix_001.height()-wg_pix_003.height())/2,-1,-1,QPixmap::fromImage(thread_img->wlimg));
        p.end();

        preview_customize->setPixmap(wl_pix_001);

        QPixmap wl_pix_002(this->width(),this->height());
        wl_pix_002.fill(QColor(0,0,0,240));
        mask_interface->setPixmap(wl_pix_002);

        smenuBar->setDisabled(true);

        mask_interface->show();
        mask_interface->raise();

        frame_customize->setGeometry((this->width()-frame_customize->width())/2,(this->height()-frame_customize->height())/2,frame_customize->width(),frame_customize->height());
        frame_customize->show();
        frame_customize->raise();
    }
    else
    {
        QMessageBox::information(this, name_application, tr("Ce mask ne peut comporte pas d'elements customisables"));
    }
}

void mainfrm::f_update_coo()
{
    must_update = 0;
    slider_opa_slide->setValue(pntmygl->tab_coo[pntmygl->num_select][9]);
    slider_blur_img->setValue(pntmygl->tab_coo[pntmygl->num_select][10]);
    slider_slide_red->setValue(pntmygl->tab_coo[pntmygl->num_select][12]);
    slider_slide_green->setValue(pntmygl->tab_coo[pntmygl->num_select][13]);
    slider_slide_blue->setValue(pntmygl->tab_coo[pntmygl->num_select][14]);
    slider_size_x_scale->setValue(pntmygl->tab_coo[pntmygl->num_select][3]);
    slider_size_y_scale->setValue(pntmygl->tab_coo[pntmygl->num_select][4]);
    slider_size_x_scale_2->setValue(pntmygl->tab_coo[pntmygl->num_select][15]);
    slider_size_y_scale_2->setValue(pntmygl->tab_coo[pntmygl->num_select][16]);

    txt_px->setText(QString::number(pntmygl->tab_coo[pntmygl->num_select][0]).setNum( QString::number(pntmygl->tab_coo[pntmygl->num_select][0]).toDouble(), 'f', 3 ));
    txt_py->setText(QString::number(pntmygl->tab_coo[pntmygl->num_select][1]).setNum( QString::number(pntmygl->tab_coo[pntmygl->num_select][1]).toDouble(), 'f', 3 ));
    txt_pz->setText(QString::number(pntmygl->tab_coo[pntmygl->num_select][2]).setNum( QString::number(pntmygl->tab_coo[pntmygl->num_select][2]).toDouble(), 'f', 3 ));

    txt_rx->setText(QString::number(pntmygl->tab_coo[pntmygl->num_select][5]).setNum( QString::number(pntmygl->tab_coo[pntmygl->num_select][5]).toDouble(), 'f', 3 ));
    txt_ry->setText(QString::number(pntmygl->tab_coo[pntmygl->num_select][6]).setNum( QString::number(pntmygl->tab_coo[pntmygl->num_select][6]).toDouble(), 'f', 3 ));
    txt_rz->setText(QString::number(pntmygl->tab_coo[pntmygl->num_select][7]).setNum( QString::number(pntmygl->tab_coo[pntmygl->num_select][7]).toDouble(), 'f', 3 ));

    must_update = 1;
}

void mainfrm::f_hide_preview()
{
    frame_preview_image->hide();
}

void mainfrm::f_mark_pos()
{
    pntmygl->f_mark_pos(screen_timeline->pos_x,110,slider_opa_slide->value(),slider_blur_img->value(),slider_slide_red->value(),slider_slide_green->value(),slider_slide_blue->value(),slider_size_x_scale->value(),slider_size_y_scale->value(),slider_size_x_scale_2->value(),slider_size_y_scale_2->value());
}

void mainfrm::f_deplace_keyframe()
{
    if ( pntmygl->num_select > 0 )
    {
        int j = 0;
        int ok = 0;
        QStringList wl_exp;
        QStringList wl_exp_2;

        while ( j < 20 && pntmygl->tab_coo_timeline[pntmygl->num_select][j] != "" && ok == 0 ) // *** RECHERCHE COORD POINT DEPART ***
        {
            wl_exp = pntmygl->tab_coo_timeline[pntmygl->num_select][j].split(":",QString::SkipEmptyParts);
            if ( wl_exp.at(0).toInt() == screen_timeline->save_point )
            {
                ok = 1;
            }
            else
            {
                j++;
            }
        }

        QString wl_save = pntmygl->tab_coo_timeline[pntmygl->num_select][j];
        int i = j;

        while ( pntmygl->tab_coo_timeline[pntmygl->num_select][j] != "" && j < 20 ) // *** ON DEPLACE LES COORD D'APRES ***
        {
            pntmygl->tab_coo_timeline[pntmygl->num_select][j] = pntmygl->tab_coo_timeline[pntmygl->num_select][j+1];
            j++;
        }

        j = 0;
        ok = 0;

        while ( j < 20 && pntmygl->tab_coo_timeline[pntmygl->num_select][j] != "" && ok == 0 )
        {
            wl_exp_2 = pntmygl->tab_coo_timeline[pntmygl->num_select][j].split(":",QString::SkipEmptyParts);

            if ( wl_exp_2.at(0).toInt() >= screen_timeline->new_position ) //screen_timeline->save_point )
            {
                ok = 1;
            }
            else
            {
                j++;
            }
        }

        if ( wl_exp_2.at(0).toInt() > screen_timeline->new_position )
        {
            wl_exp = wl_save.split(":",QString::SkipEmptyParts);

            QString wl_save_to = QString::number(screen_timeline->new_position) + ":" + wl_exp.at(1) + ":" + wl_exp.at(2) + ":" + wl_exp.at(3) + ":" + wl_exp.at(4) + ":" + wl_exp.at(5) + ":" + wl_exp.at(6) + ":" + wl_exp.at(7) + ":" + wl_exp.at(8) + ":" + wl_exp.at(9) + ":" + wl_exp.at(10) + ":" + wl_exp.at(11) + ":" + wl_exp.at(12) + ":" + wl_exp.at(13) + ":" + wl_exp.at(14) + ":" + wl_exp.at(15) + ":" + wl_exp.at(16);

            if ( wl_exp_2.at(0).toInt() == screen_timeline->save_point )
            {
                pntmygl->tab_coo_timeline[pntmygl->num_select][j] = wl_save_to;
            }
            else
            {
                i = j;

                while ( pntmygl->tab_coo_timeline[pntmygl->num_select][j] != "" && j < 20 )
                {
                    j++;
                }

                while ( j > i )
                {
                    pntmygl->tab_coo_timeline[pntmygl->num_select][j] = pntmygl->tab_coo_timeline[pntmygl->num_select][j-1];
                    j--;
                }
                pntmygl->tab_coo_timeline[pntmygl->num_select][i] = wl_save_to;
            }
        }
        else
        {
            wl_exp = wl_save.split(":",QString::SkipEmptyParts);

            QString wl_save_to = QString::number(screen_timeline->new_position) + ":" + wl_exp.at(1) + ":" + wl_exp.at(2) + ":" + wl_exp.at(3) + ":" + wl_exp.at(4) + ":" + wl_exp.at(5) + ":" + wl_exp.at(6) + ":" + wl_exp.at(7) + ":" + wl_exp.at(8) + ":" + wl_exp.at(9) + ":" + wl_exp.at(10) + ":" + wl_exp.at(11) + ":" + wl_exp.at(12) + ":" + wl_exp.at(13) + ":" + wl_exp.at(14) + ":" + wl_exp.at(15) + ":" + wl_exp.at(16);

            pntmygl->tab_coo_timeline[pntmygl->num_select][j] = wl_save_to;
        }
        f_display_mark_on_timeline(pntmygl->num_select);
     }

     pntmygl->f_follow_timeline(screen_timeline->new_position);
}

void mainfrm::f_display_mark_on_timeline(int num_select)
{
    // *** CHARGEMENT DES POSITIONS MARQUEES DANS LA TIMELINE ***
    screen_timeline->f_init_pos();
    pntmygl->must_update = 0;

    if ( num_select > 0 )
    {
        if ( pntmygl->tab_diapo[num_select][0].mid(0,1) == "?" && pntmygl->tab_diapo[num_select][0].mid(0,2) != "?9" )
        {
            screen_timeline->is_object = 1;
        }
        else
        {
            screen_timeline->is_object = 0;
        }

        int wl_int_001 = 0;
        QStringList wl_explode;

        while ( wl_int_001 < 20 )
        {
            wl_explode = pntmygl->tab_coo_timeline[num_select][wl_int_001].split(":",QString::KeepEmptyParts);

            if ( wl_explode.count() > 2 )
            {
                screen_timeline->tab_mark[wl_int_001][0] = wl_explode.at(0);
                screen_timeline->tab_mark[wl_int_001][1] = wl_explode.at(7);
                screen_timeline->tab_mark[wl_int_001][2] = wl_explode.at(8);
                screen_timeline->tab_mark[wl_int_001][3] = wl_explode.at(9);
            }
            else
            {
                screen_timeline->tab_mark[wl_int_001][0] = "";
                screen_timeline->tab_mark[wl_int_001][1] = "1";
                screen_timeline->tab_mark[wl_int_001][2] = "0";
                screen_timeline->tab_mark[wl_int_001][3] = "0";
            }
            wl_int_001++;
        }
        screen_timeline->num_select = num_select;
        sl_sca_diapo->setValue((float)pntmygl->tab_diapo[num_select][5].toFloat()*(float)100);
        must_update = 0;
        slider_opa_slide->setValue(pntmygl->tab_coo[num_select][9]);
        slider_blur_img->setValue(pntmygl->tab_coo[num_select][10]);
        must_update = 1;

        if ( pntmygl->tab_diapo[num_select][6] == "0" )
        {
            check_reflet->setChecked(false);
        }
        else
        {
            check_reflet->setChecked(true);
        }
        if ( pntmygl->tab_diapo[num_select][0].mid(0,1) == "?" && pntmygl->tab_diapo[num_select][0].mid(0,2) != "?9" )
        {
            dial_smile_light->setDisabled(true);
            dial_smile_contrast->setDisabled(true);
            slider_opa_slide->setDisabled(true);
            slider_blur_img->setDisabled(true);
            check_reflet->setDisabled(true);
            sl_sca_diapo->setEnabled(true);
            frame_th_msk_smile->setDisabled(true);

            slider_slide_red->setDisabled(true);
            slider_slide_green->setDisabled(true);
            slider_slide_blue->setDisabled(true);

            slider_size_x_scale->setDisabled(true);
            slider_size_y_scale->setDisabled(true);
            slider_size_x_scale_2->setDisabled(true);
            slider_size_y_scale_2->setDisabled(true);

            linxtxtslide->setDisabled(true);
            wheel_txt_col_slide->setDisabled(true);
        }
        else
        {
            if ( pntmygl->tab_diapo[num_select][0] == "NULL" )
            {
                dial_smile_light->setDisabled(true);
                dial_smile_contrast->setDisabled(true);
                slider_blur_img->setDisabled(true);
                slider_opa_slide->setDisabled(true);
                check_reflet->setEnabled(true);
                sl_sca_diapo->setEnabled(true);
                frame_th_msk_smile->setEnabled(true);

                slider_slide_red->setDisabled(true);
                slider_slide_green->setDisabled(true);
                slider_slide_blue->setDisabled(true);
                slider_size_x_scale->setDisabled(true);
                slider_size_y_scale->setDisabled(true);
                slider_size_x_scale_2->setDisabled(true);
                slider_size_y_scale_2->setDisabled(true);

            }
            else
            {
                dial_smile_light->setEnabled(true);
                dial_smile_contrast->setEnabled(true);
                slider_opa_slide->setEnabled(true);
                slider_blur_img->setEnabled(true);
                check_reflet->setEnabled(true);
                sl_sca_diapo->setEnabled(true);
                frame_th_msk_smile->setEnabled(true);

                slider_slide_red->setEnabled(true);
                slider_slide_green->setEnabled(true);
                slider_slide_blue->setEnabled(true);
                slider_size_x_scale->setEnabled(true);
                slider_size_y_scale->setEnabled(true);
                slider_size_x_scale_2->setEnabled(true);
                slider_size_y_scale_2->setEnabled(true);

            }

            if ( pntmygl->tab_diapo[num_select][0].mid(0,2) == "?9" )
            {
                linxtxtslide->setEnabled(true);
                wheel_txt_col_slide->setEnabled(true);
                bt_bold_txtslide->setEnabled(true);
                bt_italic_txtslide->setEnabled(true);
                bt_underline_txtslide->setEnabled(true);

                QStringList wl_explode = pntmygl->tab_diapo[num_select][0].split("!;!",QString::KeepEmptyParts);

                pntmygl->must_update = 0;


                linxtxtslide->setText(wl_explode.at(0).mid(2,wl_explode.at(0).length()-2));


                if ( wl_explode.at(3).mid(0,1) == "1" )
                {
                    bt_bold_txtslide->setChecked(true);
                }
                else
                {
                    bt_bold_txtslide->setChecked(false);
                }

                if ( wl_explode.at(3).mid(1,1) == "1" )
                {
                    bt_italic_txtslide->setChecked(true);
                }
                else
                {
                    bt_italic_txtslide->setChecked(false);
                }

                if ( wl_explode.at(3).mid(2,1) == "1" )
                {
                    bt_underline_txtslide->setChecked(true);
                }
                else
                {
                    bt_underline_txtslide->setChecked(false);
                }

                QStringList wl_explode2 = wl_explode.at(1).split("*^*",QString::KeepEmptyParts);

                pntwheel10->setColor(wl_explode2.at(0).toInt(),wl_explode2.at(1).toInt(),wl_explode2.at(2).toInt());
                pntmygl->must_update = 1;
            }
            else
            {
                linxtxtslide->setDisabled(true);
                wheel_txt_col_slide->setDisabled(true);

                bt_bold_txtslide->setDisabled(true);
                bt_italic_txtslide->setDisabled(true);
                bt_underline_txtslide->setDisabled(true);

                linxtxtslide->setText("");
                pntmygl->must_update = 0;
            }
        }
        //pntmygl->f_follow_timeline(screen_timeline->pos_x); // *** TODO VERIFIER SUPPRESSION ***

        lst_calques->setCurrentRow(num_select-1);
        screen_timeline->repaint();

        QStringList wl_ext1 = pntmygl->tab_diapo[num_select][4].split(":",QString::SkipEmptyParts);
        must_update = 0;
        dial_smile_light->setValue(wl_ext1.at(0).toInt());
        dial_smile_contrast->setValue(wl_ext1.at(1).toInt());
        must_update = 1;
    }
    else
    {
        screen_timeline->num_select = 0;
        dial_smile_light->setDisabled(true);
        dial_smile_contrast->setDisabled(true);
        slider_opa_slide->setDisabled(true);
        slider_blur_img->setDisabled(true);
        check_reflet->setDisabled(true);
        sl_sca_diapo->setDisabled(true);
        screen_timeline->repaint();
        lst_calques->clearSelection();
        slider_slide_red->setDisabled(true);
        slider_slide_green->setDisabled(true);
        slider_slide_blue->setDisabled(true);
        slider_size_x_scale->setDisabled(true);
        slider_size_y_scale->setDisabled(true);
        slider_size_x_scale_2->setDisabled(true);
        slider_size_y_scale_2->setDisabled(true);
    }
}

void mainfrm::f_display_position_timeline(int position)
{
    QTime wl_time(0,0,0,0);
    wl_time = wl_time.addMSecs(((float)(position-10)*((float)screen_timeline->length_diapo))/(float)(screen_timeline->width()-20)*1000);
    frame_lcd_position->position = wl_time.toString("ss.zzz");
    frame_lcd_position->repaint();
}

void mainfrm::f_slider_opa_slide(int value)
{
    if ( must_update == 1 && pntmygl->num_select > 0 )
    {
        pntmygl->tab_coo[screen_timeline->num_select][9] = value;
        pntmygl->updateGL();
    }
}

void mainfrm::f_slider_blur_slide(int value)
{
    if ( must_update == 1 && pntmygl->num_select > 0 )
    {
        pntmygl->tab_coo[screen_timeline->num_select][10] = value;
        pntmygl->tab_old_blur[screen_timeline->num_select] = value;
        pntmygl->f_reload_img(screen_timeline->num_select);
        pntmygl->updateGL();
    }
}

void mainfrm::f_add_diapo()
{
    if ( nbre_diapos+1 >= 400 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de diapositive 400 atteint"));
        return;
    }

    pntmygl->f_save_diapo(num_current_diapo);
    screen_timeline->num_select = 0;

    lst_calques->clear();

    // *** NETTOYAGE DE L'ACCUM BUFFER ***
    pntmygl->f_netbuf();
    pntmygl->f_net_video();

    if ( pntmygl->back_color.right(4) == ".avi" || pntmygl->back_color.right(4) == ".AVI" || pntmygl->back_color.right(4) == ".mpg" || pntmygl->back_color.right(4) == ".MPG" || pntmygl->back_color.right(5) == ".MPEG" || pntmygl->back_color.right(5) == ".mpeg" || pntmygl->back_color.right(4) == ".mp4" || pntmygl->back_color.right(4) == ".MP4" )
    {
        pntmygl->wg_tabvid[20]->delete_videowrapper();
        delete pntmygl->wg_tabvid[20];
        pntmygl->wg_tabvid[20] = 0;
    }

    QImage wl_pix1(50,50,QImage::Format_ARGB32_Premultiplied);
    QPainter p;
    p.begin(&wl_pix1);
    p.setBrush(QColor(0,0,0));
    p.drawRect(0,0,50,50);
    p.end();

    hdl_current_diapo->is_edit = 0;
    hdl_current_diapo->repaint();

    pntmygl->must_update = 0;

    linxtxtslide->setText("");
    bt_bold_txtslide->setChecked(false);
    bt_italic_txtslide->setChecked(false);
    bt_underline_txtslide->setChecked(false);

    linxtxtslide->setDisabled(true);
    bt_bold_txtslide->setDisabled(true);
    bt_italic_txtslide->setDisabled(true);
    bt_underline_txtslide->setDisabled(true);

    pntmygl->must_update = 1;

    diapos_th *newdiapo = new diapos_th(timeline_diapo);

    connect(newdiapo, SIGNAL(select_diapoth(diapos_th*) ),this, SLOT(f_select_diapos_th(diapos_th*)));
    connect(newdiapo, SIGNAL(delete_diapoth(diapos_th*) ),this, SLOT(f_delete_diaposth(diapos_th*)));
    connect(newdiapo, SIGNAL(theme_diapoth(diapos_th*) ),this, SLOT(f_theme_diaposth(diapos_th*)));
    connect(newdiapo, SIGNAL(dupliquer_diapoth(diapos_th*) ),this, SLOT(f_dupliquer_diaposth(diapos_th*)));
    connect(newdiapo, SIGNAL(enter_diath(diapos_th*) ),this, SLOT(f_enter_diath(diapos_th*)));
    connect(newdiapo, SIGNAL(leave_diath(diapos_th*) ),this, SLOT(f_leave_diath(diapos_th*)));

    if ( num_current_diapo+1 >= nbre_diapos )
    {
        table_hdl_diapo[nbre_diapos] = newdiapo;
        newdiapo->setGeometry( nbre_diapos * 60, 0, 50, 50 );
        num_current_diapo = nbre_diapos;
    }
    else
    {
        int wl_i1 = num_current_diapo;
        while ( wl_i1 < nbre_diapos )
        {
            if ( wl_i1 < nbre_diapos-1 )
            {
                QPropertyAnimation *animation2 = new QPropertyAnimation(table_hdl_diapo[wl_i1], "geometry");
                animation2->setDuration(300);
                animation2->setStartValue(QRect(table_hdl_diapo[wl_i1]->geometry().x(),table_hdl_diapo[wl_i1]->geometry().y(),table_hdl_diapo[wl_i1]->width(),table_hdl_diapo[wl_i1]->height()));
                animation2->setEndValue(QRect(table_hdl_diapo[wl_i1+1]->geometry().x(),table_hdl_diapo[wl_i1+1]->geometry().y(),table_hdl_diapo[wl_i1]->width(),table_hdl_diapo[wl_i1]->height()));
                animation2->setEasingCurve(QEasingCurve::InOutCubic);
                animation2->start();
            }
            else
            {
                QPropertyAnimation *animation2 = new QPropertyAnimation(table_hdl_diapo[wl_i1], "geometry");
                animation2->setDuration(300);
                animation2->setStartValue(QRect(table_hdl_diapo[wl_i1]->geometry().x(),table_hdl_diapo[wl_i1]->geometry().y(),table_hdl_diapo[wl_i1]->width(),table_hdl_diapo[wl_i1]->height()));
                animation2->setEndValue(QRect(table_hdl_diapo[wl_i1]->geometry().x()+60,table_hdl_diapo[wl_i1]->geometry().y(),table_hdl_diapo[wl_i1]->width(),table_hdl_diapo[wl_i1]->height()));
                animation2->setEasingCurve(QEasingCurve::InOutCubic);
                animation2->start();
            }

            wl_i1++;
        }

        // *** PERMUTATION DES HANDLES ***
        int wl_int_001 = nbre_diapos;
        int wl_int_002;

        while ( wl_int_001 >= num_current_diapo )
        {
            table_hdl_diapo[wl_int_001+1] = table_hdl_diapo[wl_int_001];
            wl_int_002 = 0;
            while ( wl_int_002 < 45 )
            {
                pntmygl->tab_save_diapo[wl_int_001+1][wl_int_002] = pntmygl->tab_save_diapo[wl_int_001][wl_int_002];
                wl_int_002++;
            }
            wl_int_001--;
        }
        table_hdl_diapo[num_current_diapo] = newdiapo;
        newdiapo->setGeometry( num_current_diapo * 60, 0, 50, 50 );
    }
    newdiapo->draw_image = wl_pix1;
    newdiapo->is_edit = 1;
    newdiapo->show();

    int wl_int_001 = 0;
    while ( wl_int_001 < 20 )
    {
        screen_timeline->tab_mark[wl_int_001][0] = "";
        screen_timeline->tab_mark[wl_int_001][1] = "";
        screen_timeline->tab_mark[wl_int_001][2] = "";
        wl_int_001++;
    }
    screen_timeline->repaint();

    hdl_current_diapo = newdiapo;

    timeline_diapo->tab_duration[nbre_diapos] = spin_length_diapo->value();
    pntmygl->back_color = "0:0:0";
    pntmygl->is_mblur = 0;
    pntmygl->is_fog = 0;
    pntmygl->wg_nb_cube = 0;
    pntmygl->is_flakes = 0;
    chk_flakes->setChecked(false);

    check_motion_blur->setChecked(false);
    check_fog->setChecked(false);

    nbre_diapos++;
    timeline_diapo->max_diapo = nbre_diapos;
    timeline_diapo->num_current_diapo = num_current_diapo;
    timeline_diapo->repaint();

    if ( (nbre_diapos*70) > timeline_diapo->width() )
    {
        timeline_diapo->setGeometry(timeline_diapo->geometry().x(),0,nbre_diapos*70,timeline_diapo->height());
        scroll_timeline_smile->setMaximum(timeline_diapo->width()-frame_support_timeline->width());

        if ( myeffect_global->opacity() < 1.0 )
        {
            QPropertyAnimation *animation = new QPropertyAnimation(myeffect_global, "opacity");
            animation->setDuration(1000);
            animation->setStartValue(qreal(myeffect_global->opacity()));
            animation->setEndValue(qreal(1.0));
            animation->start();
        }
    }

    must_update = 0;
    pntmygl->str_trans = "";
    lst_trans_smile->setCurrentIndex(0);
    must_update = 1;

    pntmygl->nombre_diapos = 0;
    pntmygl->f_init_tabcoo();
    pntmygl->f_init_tabtex();

    pntmygl->num_select = 0;
    pntmygl->updateGL();

    f_recalc_length_audio();
    dial_smile_light->setDisabled(true);
    dial_smile_contrast->setDisabled(true);
    slider_blur_img->setDisabled(true);
    slider_opa_slide->setDisabled(true);

    slider_slide_red->setDisabled(true);
    slider_slide_green->setDisabled(true);
    slider_slide_blue->setDisabled(true);
    slider_size_x_scale->setDisabled(true);
    slider_size_y_scale->setDisabled(true);
    slider_size_x_scale_2->setDisabled(true);
    slider_size_y_scale_2->setDisabled(true);
}

void mainfrm::f_scroll_timeline_smile(int value)
{
    timeline_diapo->setGeometry(0-value,0,timeline_diapo->width(),timeline_diapo->height());
    timeline_diapo->repaint();
    if ( nbre_audio_track > 0 )
    {
        hdl_audio->repaint();
    }
}

void mainfrm::f_update_diapoth()
{
    /*if ( pntmygl->nombre_diapos == 0 || pntmygl->tab_diapo[1][0] == "NULL" )
    {
        hdl_current_diapo->draw_image = pntmygl->grabFrameBuffer( false ).scaled(106,106);
    }
    else
    {*/
        hdl_current_diapo->draw_image = pntmygl->grabFrameBuffer( false ).scaled(106,106);

        /*wg_tout_services.load(pntmygl->tab_diapo[1][0]);
        wg_tout_services = wg_tout_services.scaled(106,106,Qt::IgnoreAspectRatio,Qt::FastTransformation);*/

        //QPainter p;
        //p.begin(&hdl_current_diapo->draw_image);
        //p.drawImage(0,0, wg_tout_services, 0, 0, -1, -1 );
        //p.end();
    //}
    hdl_current_diapo->repaint();
}

void mainfrm::f_theme_diaposth(diapos_th*)
{
    if ( pntmygl->nombre_diapos == 0 )
    {
        QMessageBox::information(this, name_application, tr("Il n est pas possible de creer un theme avec une diapositive vide"));
        return;
    }
    bool ok;
    QString text = QInputDialog::getText(this, tr("Nommage du theme"),
                                              tr("Nom du theme :"), QLineEdit::Normal,
                                              "" , &ok);
    QStringList wl_explode;

    if (ok && !text.isEmpty())
    {
        QFile modelefile( QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/3d/ani3d.dat" );

        if (modelefile.open(QFile::ReadWrite))
        {
            QTextStream out(&modelefile);
            modelefile.readAll();
            out << text << endl;
            out << combo_format_dvd->currentIndex() << endl;
            out << pntmygl->length_diapo << endl;
            out << pntmygl->is_mblur << endl;

            int wl_int_001 = 1;
            int wl_int_002 = 0;
            QString wl_tmpstr_001 = "";

            while ( wl_int_001 < pntmygl->nombre_diapos+1 )
            {
                wl_int_002 = 0;
                wg_string_005 = "000";

                wl_explode = pntmygl->tab_diapo[wl_int_001][4].split(":",QString::KeepEmptyParts);

                wg_string_005.replace( 3 - wl_explode.at(1).length(), wl_explode.at(1).length(), wl_explode.at(1));

                wl_tmpstr_001 = wg_string_005 + ":" + pntmygl->tab_diapo[wl_int_001][6] +  ":" + pntmygl->tab_diapo[wl_int_001][5] + ":";

                while ( pntmygl->tab_coo_timeline[wl_int_001][wl_int_002] != "" && wl_int_002 < 20 )
                {
                    if ( wl_int_002 == 0 )
                    {
                        wl_tmpstr_001 = wl_tmpstr_001 + pntmygl->tab_coo_timeline[wl_int_001][wl_int_002] + ":" + pntmygl->tab_diapo[wl_int_001][3].replace(QString("_"), QString("underscore")) + "$";
                    }
                    else
                    {
                        wl_tmpstr_001 = wl_tmpstr_001 + pntmygl->tab_coo_timeline[wl_int_001][wl_int_002] + "$";
                    }

                    wl_int_002++;
                }
                out << wl_tmpstr_001 << endl;
                wl_int_001++;
            }

            out << "------" << endl;
            modelefile.close();
        }

        // *** RELOAD MODELES 3D ***
        //modelefile.setFileName(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/3d/ani3d.dat" );
        QByteArray newData;
        int wl_pos_cpt = 0;
        int wl_pos_cpt_2 = 0;
        nombre_themes_3d = 0;
        QString wl_name = "";
        QString wl_coord = "";

        if (modelefile.open(QFile::ReadOnly))
        {
            frame_support_th3d->clear();
            while ( modelefile.atEnd() == false )
            {
                newData = modelefile.readLine(0);
                wg_string_001 = QString::fromLocal8Bit(newData);
                wg_string_001 = wg_string_001.simplified();
                wg_string_001 = wg_string_001.mid(0, newData.count() - 1);

                if ( wl_pos_cpt == 0 )
                {
                    wl_name = wg_string_001;
                    wl_pos_cpt++;
                }
                else
                {
                    if ( wg_string_001.mid(0,3) == "---" )
                    {
                        QListWidgetItem *item = new QListWidgetItem(frame_support_th3d);
                        item->setIcon(QIcon(":/Interface/Interface/theme.png"));
                        item->setStatusTip(wl_coord);
                        item->setText(wl_name);

                        wl_pos_cpt_2++;
                        wl_pos_cpt = 0;
                        wl_coord = "";
                        nombre_themes_3d++;
                    }
                    else
                    {
                        if ( wl_coord == "" )
                        {
                            wl_coord = wg_string_001;
                        }
                        else
                        {
                            wl_coord = wl_coord + "_" + wg_string_001;
                        }
                    }
                }
            }

            frame_support_th3d->sortItems(Qt::AscendingOrder);
        }

        modelefile.close();

    }
}

void mainfrm::f_delete_diaposth(diapos_th* hdld)
{
    if ( nbre_diapos > 1 )
    {

        int wl_int_001 = 0;
        while ( table_hdl_diapo[wl_int_001] != hdld )
        {
            wl_int_001++;
        }

        int wl_int_002 = wl_int_001;
        int wl_int_003 = 0;

        if ( pntmygl->back_color.right(4) == ".avi" || pntmygl->back_color.right(4) == ".AVI" || pntmygl->back_color.right(4) == ".mpg" || pntmygl->back_color.right(4) == ".MPG" || pntmygl->back_color.right(5) == ".MPEG" || pntmygl->back_color.right(5) == ".mpeg" || pntmygl->back_color.right(4) == ".mp4" || pntmygl->back_color.right(4) == ".MP4" )
        {
            pntmygl->wg_tabvid[20]->delete_videowrapper();
            delete pntmygl->wg_tabvid[20];
            pntmygl->wg_tabvid[20] = 0;
        }

        pntmygl->f_net_video();

        while ( wl_int_002 < nbre_diapos-1 )
        {
            table_hdl_diapo[wl_int_002] = table_hdl_diapo[wl_int_002+1];
            wl_int_003 = 0;

            while ( wl_int_003 < 45 )
            {
                pntmygl->tab_save_diapo[wl_int_002][wl_int_003] = pntmygl->tab_save_diapo[wl_int_002+1][wl_int_003];
                wl_int_003++;
            }

            QPropertyAnimation *animation = new QPropertyAnimation(table_hdl_diapo[wl_int_002+1], "geometry");
            animation->setDuration(500+(50*wl_int_002));
            animation->setStartValue(QRect(table_hdl_diapo[wl_int_002+1]->geometry().x(),table_hdl_diapo[wl_int_002+1]->geometry().y(),table_hdl_diapo[wl_int_002+1]->width(),table_hdl_diapo[wl_int_002+1]->height()));
            animation->setEndValue(QRect(table_hdl_diapo[wl_int_002+1]->geometry().x()-60,table_hdl_diapo[wl_int_002+1]->geometry().y(),table_hdl_diapo[wl_int_002+1]->width(),table_hdl_diapo[wl_int_002+1]->height()));
            animation->setEasingCurve(QEasingCurve::InOutCubic);
            animation->start();

            wl_int_002++;
        }

        timeline_diapo->tab_duration[nbre_diapos] = 0;
        nbre_diapos--;
        timeline_diapo->max_diapo = nbre_diapos;
        timeline_diapo->repaint();

        if ( (nbre_diapos*70) > timeline_diapo->width() )
        {
            timeline_diapo->setGeometry(timeline_diapo->geometry().x(),0,nbre_diapos*70,timeline_diapo->height());
            scroll_timeline_smile->setMaximum(timeline_diapo->width()-frame_support_timeline->width());

            if ( myeffect_global->opacity() < 1.0 )
            {
                QPropertyAnimation *animation_2 = new QPropertyAnimation(myeffect_global, "opacity");
                animation_2->setDuration(1000);
                animation_2->setStartValue(qreal(myeffect_global->opacity()));
                animation_2->setEndValue(qreal(0.0));
                animation_2->start();
            }
        }
        else
        {
            if ( nbre_diapos*70 <= frame_support_timeline->width() && myeffect_global->opacity() > 0 )
            {
                timeline_diapo->setGeometry(timeline_diapo->geometry().x(),0,frame_support_timeline->width(),timeline_diapo->height());
                scroll_timeline_smile->setMaximum(frame_support_timeline->width());
                scroll_timeline_smile->setValue(0);

                QPropertyAnimation *animation_2 = new QPropertyAnimation(myeffect_global, "opacity");
                animation_2->setDuration(1000);
                animation_2->setStartValue(qreal(myeffect_global->opacity()));
                animation_2->setEndValue(qreal(0.0));
                animation_2->start();
            }
        }

        if ( num_current_diapo < nbre_diapos )
        {
            f_load_diapo(num_current_diapo);
            table_hdl_diapo[num_current_diapo]->is_edit = 1;
            hdl_current_diapo = table_hdl_diapo[num_current_diapo];
            spin_length_diapo->setValue(pntmygl->length_diapo);
            pntmygl->f_follow_timeline(10);
        }
        else
        {
            f_load_diapo(nbre_diapos-1);
            table_hdl_diapo[nbre_diapos-1]->is_edit = 1;
            hdl_current_diapo = table_hdl_diapo[nbre_diapos-1];
            num_current_diapo = nbre_diapos-1;
            spin_length_diapo->setValue(pntmygl->length_diapo);
            pntmygl->f_follow_timeline(10);
        }

        /*if ( wl_int_002 < nbre_diapos )
        {
            num_current_diapo = wl_int_002;
            f_load_diapo(wl_int_002);
            table_hdl_diapo[wl_int_002]->is_edit = 1;
            hdl_current_diapo = table_hdl_diapo[wl_int_002];
            spin_length_diapo->setValue(pntmygl->length_diapo);
            pntmygl->f_follow_timeline(10);
        }
        else
        {
            num_current_diapo = wl_int_002-1;
            f_load_diapo(wl_int_002-1);
            table_hdl_diapo[wl_int_002-1]->is_edit = 1;
            hdl_current_diapo = table_hdl_diapo[wl_int_002-1];
            spin_length_diapo->setValue(pntmygl->length_diapo);
            pntmygl->f_follow_timeline(10);
        }*/
        f_recalc_length_audio();
        hdld->close();
    }
    else
    {
        QMessageBox::information(this, name_application, tr("Imposible de supprimer la diapositive. Il n'en reste qu'une."));
    }
}

void mainfrm::f_mark_visible(int value)
{
    pntmygl->f_mark_vis(screen_timeline->pos_x,value);
    pntmygl->f_follow_timeline(screen_timeline->pos_x);
}

void mainfrm::f_s_action_adjtime(int timedi)
{
    pntmygl->f_save_diapo(num_current_diapo);

    int wl_int1 = 0;
    int wl_int2 = 0;

    while ( wl_int1 < nbre_diapos )
    {
        wl_int2 = 0;

        while ( wl_int2 < 20 && pntmygl->tab_save_diapo[wl_int1][wl_int2] != "$#$" )
        {
            wl_int2++;
        }

        if ( pntmygl->tab_save_diapo[wl_int1][wl_int2] == "$#$" )
        {
            pntmygl->tab_save_diapo[wl_int1][wl_int2+1] = QString::number(timedi);
            timeline_diapo->tab_duration[wl_int1] = timedi;
        }

        wl_int1++;
    }

    timeline_diapo->repaint();
}

void mainfrm::f_select_diapos_th(diapos_th* hdlm)
{
    pntmygl->f_save_diapo(num_current_diapo);
    // *** NETTOYAGE DE L'ACCUM BUFFER ***
    //pntmygl->f_netbuf();

    hdl_current_diapo->is_edit = 0;
    hdl_current_diapo->repaint();
    hdl_current_diapo = hdlm;
    hdl_current_diapo->is_edit = 1;
    hdl_current_diapo->repaint();

    int wl_int_001 = 0;
    while ( table_hdl_diapo[wl_int_001] != hdlm )
    {
        wl_int_001++;
    }
    num_current_diapo = wl_int_001;
    f_load_diapo(wl_int_001);
    spin_length_diapo->setValue(pntmygl->length_diapo);

    timeline_diapo->num_current_diapo = wl_int_001;

    if ( wl_int_001 == 0 )
    {
        if ( timeline_diapo->tab_duration[wl_int_001]/2 < 8 )
        {
            spintrandur->setMaximum(timeline_diapo->tab_duration[wl_int_001]/2);
        }
        else
        {
            spintrandur->setMaximum(8);
        }
    }
    else
    {
        if ( timeline_diapo->tab_duration[wl_int_001] > timeline_diapo->tab_duration[wl_int_001-1] )
        {
            if ( timeline_diapo->tab_duration[wl_int_001-1]/2 < 8 )
            {
                spintrandur->setMaximum(timeline_diapo->tab_duration[wl_int_001-1]/2);
            }
            else
            {
                spintrandur->setMaximum(8);
            }
        }
        else
        {
            if ( timeline_diapo->tab_duration[wl_int_001]/2 < 8 )
            {
                spintrandur->setMaximum(timeline_diapo->tab_duration[wl_int_001]/2);
            }
            else
            {
                spintrandur->setMaximum(8);
            }
        }
    }

    must_update = 0;
    if ( pntmygl->str_trans != "" && pntmygl->str_trans != wg_str_int_004 )
    {
        lst_trans_smile->setCurrentIndex(lst_trans_smile->findText(pntmygl->str_trans,Qt::MatchExactly | Qt::MatchCaseSensitive));
    }
    else
    {
        lst_trans_smile->setCurrentIndex(0);
    }

    if ( pntmygl->is_mblur == 0 )
    {
        check_motion_blur->setChecked(false);
    }
    else
    {
        check_motion_blur->setChecked(true);
    }

    if ( pntmygl->is_fog == 0 )
    {
        check_fog->setChecked(false);
    }
    else
    {
        check_fog->setChecked(true);
    }

    must_update = 1;

    screen_timeline->num_select = 0;
    screen_timeline->pos_x = 10;
    screen_timeline->repaint();

    pntmygl->num_select = 0;
    //pntmygl->updateGL();

    pntmygl->f_follow_timeline(10);
}

void mainfrm::f_load_theme_3d()
{
    //pntmygl->f_init_tabcoo();

    QList<QListWidgetItem *> selectthe = frame_support_th3d->selectedItems();
    QListWidgetItem *thetxt = new QListWidgetItem;
    thetxt = selectthe.at(0);

    pntmygl->f_load_theme(thetxt->statusTip(),thetxt->text());

    if ( pntmygl->is_mblur == 0 )
    {
        check_motion_blur->setChecked(false);
    }
    else
    {
        check_motion_blur->setChecked(true);
    }
}

void mainfrm::f_move_start()
{
    screen_timeline->num_select = 0;
    screen_timeline->pos_x = 10;
    screen_timeline->repaint();
    pntmygl->f_follow_timeline(10);
}

void mainfrm::f_tool_change(int tool)
{
    if ( tool == 0 )
    {
        pbgz->setChecked(true);
        pbrx->setChecked(false);
        pbry->setChecked(false);
        pbrz->setChecked(false);
        return;
    }

    if ( tool == 1 )
    {
        pbgz->setChecked(false);
        pbrx->setChecked(true);
        pbry->setChecked(false);
        pbrz->setChecked(false);
        return;
    }

    if ( tool == 2 )
    {
        pbgz->setChecked(false);
        pbrx->setChecked(false);
        pbry->setChecked(true);
        pbrz->setChecked(false);
        return;
    }

    if ( tool == 3 )
    {
        pbgz->setChecked(false);
        pbrx->setChecked(false);
        pbry->setChecked(false);
        pbrz->setChecked(true);
        return;
    }

    if ( tool == 4 )
    {
        pbgz->setChecked(false);
        pbrx->setChecked(false);
        pbry->setChecked(false);
        pbrz->setChecked(false);
        return;
    }
}

void mainfrm::f_change_length_diapo(int ldia)
{
    if ( must_update == 1 )
    {
        screen_timeline->length_diapo = ldia;
        pntmygl->length_diapo = ldia;
        timeline_diapo->tab_duration[num_current_diapo] = ldia;
        screen_timeline->repaint();

        if ( num_current_diapo == 0 )
        {
            if ( timeline_diapo->tab_duration[num_current_diapo]/2 < 8 )
            {
                spintrandur->setMaximum(timeline_diapo->tab_duration[num_current_diapo]/2);
            }
            else
            {
                spintrandur->setMaximum(8);
            }
        }
        else
        {
            if ( timeline_diapo->tab_duration[num_current_diapo] > timeline_diapo->tab_duration[num_current_diapo-1] )
            {
                if ( timeline_diapo->tab_duration[num_current_diapo-1]/2 < 8 )
                {
                    spintrandur->setMaximum(timeline_diapo->tab_duration[num_current_diapo-1]/2);
                }
                else
                {
                    spintrandur->setMaximum(8);
                }
            }
            else
            {
                if ( timeline_diapo->tab_duration[num_current_diapo]/2 < 8 )
                {
                    spintrandur->setMaximum(timeline_diapo->tab_duration[num_current_diapo]/2);
                }
                else
                {
                    spintrandur->setMaximum(8);
                }
            }
        }
        if ( lst_trans_smile->currentIndex() > 0 )
        {
            timeline_diapo->tab_transition[num_current_diapo] = spintrandur->value();
        }
        else
        {
            timeline_diapo->tab_transition[num_current_diapo] = 0;
        }
        timeline_diapo->repaint();
    }
}

void mainfrm::f_change_length_translide(int ldia)
{
    if ( must_update == 1 )
    {
        pntmygl->lgt_trans = ldia;
        if ( lst_trans_smile->currentIndex() > 0 )
        {
            timeline_diapo->tab_transition[num_current_diapo] = ldia;
        }
        else
        {
            timeline_diapo->tab_transition[num_current_diapo] = 0;
        }
        timeline_diapo->repaint();
    }
}

void mainfrm::f_change_length_diapo_from_tetra(int ldia)
{
    screen_timeline->length_diapo = ldia;
    pntmygl->length_diapo = ldia;
    screen_timeline->repaint();
    timeline_diapo->tab_duration[num_current_diapo] = ldia;
    timeline_diapo->repaint();
    must_update = 0;
    spin_length_diapo->setValue(ldia);
    must_update = 1;
}

void mainfrm::f_color_back_slide()
{
    if ( must_update == 1 )
    {
        QImage wl_puis_001(1024,1024,QImage::Format_ARGB32_Premultiplied);
        QPainter p;

        p.begin(&wl_puis_001);
        p.setBrush(QColor(pntwheel8->red,pntwheel8->green,pntwheel8->blue));
        p.drawRect(0,0,1024,1024);
        p.end();

        pntmygl->wg_fd_tx = 1.0;
        pntmygl->wg_fd_ty = 1.0;

        QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

        glDeleteTextures (1,&pntmygl->texture_diapo[41]);
        glGenTextures (1,&pntmygl->texture_diapo[41]);
        glBindTexture (GL_TEXTURE_2D, pntmygl->texture_diapo[41]);

        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

        pntmygl->isback = 1;

        pntmygl->back_color = QString::number(pntwheel8->red) + ":" + QString::number(pntwheel8->green) + ":" + QString::number(pntwheel8->blue);
        pntmygl->updateGL();
    }
}

void mainfrm::f_load_back()
{
    if ( pntmygl->back_color.mid(0,1) != "/" )
    {
        if ( pntmygl->back_color == "0:0:0" )
        {
            pntmygl->isback = 0;
            //pntmygl->updateGL();
        }
        else
        {
            QStringList wl_explode = pntmygl->back_color.split(":", QString::SkipEmptyParts);
            pntwheel8->red = wl_explode.at(0).toInt();
            pntwheel8->green = wl_explode.at(1).toInt();
            pntwheel8->blue = wl_explode.at(2).toInt();

            QImage wl_puis_001(1024,1024,QImage::Format_ARGB32_Premultiplied);
            QPainter p;

            p.begin(&wl_puis_001);
            p.setBrush(QColor(pntwheel8->red,pntwheel8->green,pntwheel8->blue));
            p.drawRect(0,0,1024,1024);
            p.end();

            pntmygl->wg_fd_tx = 1.0;
            pntmygl->wg_fd_ty = 1.0;

            QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

            glDeleteTextures (1,&pntmygl->texture_diapo[41]);
            glGenTextures (1,&pntmygl->texture_diapo[41]);
            glBindTexture (GL_TEXTURE_2D, pntmygl->texture_diapo[41]);

            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

            glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                          0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

            pntmygl->isback = 1;
            pntmygl->back_color = QString::number(pntwheel8->red) + ":" + QString::number(pntwheel8->green) + ":" + QString::number(pntwheel8->blue);
            //pntmygl->updateGL();
        }
    }
    else
    {
        //QString wl_myfic = pntmygl->back_color;
        QImage wl_img_texture;

        QImageReader image_reader(pntmygl->back_color);
        int image_width = image_reader.size().width();
        int image_height = image_reader.size().height();
        int isok = image_width;

        if (image_width > image_height) {
                  image_height = static_cast<double>(pntmygl->sm_mxw) / image_width * image_height;
                  image_width = pntmygl->sm_mxw;
                } else if (image_width < image_height) {
                  image_width = static_cast<double>(pntmygl->sm_mxw) / image_height * image_width;
                  image_height = pntmygl->sm_mxw;
                } else {
                  image_width = pntmygl->sm_mxw;
                  image_height = pntmygl->sm_mxw;
                }
                image_reader.setScaledSize(QSize(image_width, image_height));
                wl_img_texture = image_reader.read();

        //if ( wl_img_texture.load(wl_myfic) == true )
        if ( isok > 0 )
        {

        //if ( wl_img_texture.load(pntmygl->back_color) == true )
        //{
            /*if ( wl_img_texture.width() > wl_img_texture.height() )
            {
                wl_img_texture = wl_img_texture.scaledToWidth(1024,Qt::SmoothTransformation);
            }
            else
            {
                wl_img_texture = wl_img_texture.scaledToHeight(1024,Qt::SmoothTransformation);
            }*/

            QImage wl_puis_001(pntmygl->sm_mxw,pntmygl->sm_mxw,QImage::Format_ARGB32_Premultiplied);
            wl_puis_001 = wl_img_texture.copy ( 0, 0, pntmygl->sm_mxw, pntmygl->sm_mxw);

            pntmygl->wg_fd_tx = (float)wl_img_texture.width()/(float)pntmygl->sm_mxw;
            pntmygl->wg_fd_ty = (float)wl_img_texture.height()/(float)pntmygl->sm_mxw;

            QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

            glDeleteTextures (1,&pntmygl->texture_diapo[41]);
            glGenTextures (1,&pntmygl->texture_diapo[41]);
            glBindTexture (GL_TEXTURE_2D, pntmygl->texture_diapo[41]);

            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

            glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                          0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

            pntmygl->isback = 1;
            //pntmygl->back_color = wl_myfic;
            //pntmygl->updateGL();
        }
        else
        {
            // *** CHARGEMENT ARRIERE PLAN VIDEO ***
            if ( pntmygl->back_color.right(4) == ".avi" || pntmygl->back_color.right(4) == ".AVI" || pntmygl->back_color.right(4) == ".mpg" || pntmygl->back_color.right(4) == ".MPG" || pntmygl->back_color.right(5) == ".MPEG" || pntmygl->back_color.right(5) == ".mpeg" || pntmygl->back_color.right(4) == ".mp4" || pntmygl->back_color.right(4) == ".MP4" )
            {
                videowrapper *hdlw = new videowrapper();
                pntmygl->wg_tabvid[20] = hdlw;

                int result = hdlw->load_video(pntmygl->back_color);
                if ( result == 0 )
                {
                    wl_img_texture = hdlw->read_frame(0);
                    QImage wl_puis_001(pntmygl->sm_mxw,pntmygl->sm_mxw,QImage::Format_ARGB32_Premultiplied);

                    if ( wl_img_texture.width() > wl_img_texture.height() )
                    {
                        wl_img_texture = wl_img_texture.scaledToWidth(pntmygl->sm_mxw,Qt::SmoothTransformation);
                    }
                    else
                    {
                        wl_img_texture = wl_img_texture.scaledToHeight(pntmygl->sm_mxw,Qt::SmoothTransformation);
                    }

                    wl_puis_001 = wl_img_texture.copy ( 0, 0, pntmygl->sm_mxw, pntmygl->sm_mxw); //sm_mxw, sm_mxw);

                    pntmygl->wg_fd_tx = (float)wl_img_texture.width()/(float)pntmygl->sm_mxw;
                    pntmygl->wg_fd_ty = (float)wl_img_texture.height()/(float)pntmygl->sm_mxw;

                    QImage f = QGLWidget::convertToGLFormat( wl_puis_001 );

                    glDeleteTextures (1,&pntmygl->texture_diapo[41]);
                    glGenTextures (1,&pntmygl->texture_diapo[41]);
                    glBindTexture (GL_TEXTURE_2D, pntmygl->texture_diapo[41]);

                    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                    glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                                  0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());

                    pntmygl->isback = 1;
                    //pntmygl->back_color = wl_myfic;
               }
            }
        }
    }
}

void mainfrm::f_play_diapo()
{
    isrendering = 0;
    pntmygl->f_netbuf();
    if ( player_isplaying == false )
    {
        pntmygl->isrendering = 1;
        pntmygl->f_save_diapo(num_current_diapo);
        frame_toolslide->setDisabled(true);
        screen_timeline->setDisabled(true);
        smenuBar->setDisabled(true);
        pntmygl->num_select = 0;
        screen_timeline->num_select = 0;
        screen_timeline->repaint();
        frame_support_timeline_diapo->setDisabled(true);
        player_isplaying = true;
        pntmygl->f_follow_timeline(10);
        pos_playing = 10;
        cpt_trt_trans = 0;

        // *** CHARGEMENT DIAPO NOIRE ***

        QPixmap wl_tmp_001(sx_tr_diapo,sy_tr_diapo);
        wl_tmp_001.fill(QColor(0,0,0));
        while ( isrendering < 251 )
        {
            pntmygl->table_preview_transition[isrendering] = wl_tmp_001.toImage();
            isrendering++;
        }

        frame_msk_ed3d->setPixmap(wl_tmp_001);
        frame_msk_ed3d->show();
        frame_msk_ed3d->raise();

        isrendering = 0;
        thread_trans_render_sequence = 0;
        mysynctime.restart();
        f_play_diapo_boucle();
    }
    else
    {
        pntmygl->isrendering = 0;
        player_isplaying = false;
        frame_toolslide->setEnabled(true);
        frame_bottom_slide->setEnabled(true);
        frame_support_timeline_diapo->setEnabled(true);
        screen_timeline->setEnabled(true);
        smenuBar->setEnabled(true);
        frame_msk_ed3d->hide();
        frame_msk_ed3d->lower();
    }
}

void mainfrm::f_fwd_diapo()
{
    if ( screen_timeline->num_select > 0 )
    {
        int wl_int_001 = 0;
        int wl_int_002 = 9999;

        while ( screen_timeline->tab_mark[wl_int_001][0] != "" )
        {
            if ( screen_timeline->tab_mark[wl_int_001][0].toInt() > screen_timeline->pos_x )
            {
                if ( screen_timeline->tab_mark[wl_int_001][0].toInt() < wl_int_002 )
                {
                    wl_int_002 = screen_timeline->tab_mark[wl_int_001][0].toInt();
                }
            }
            wl_int_001++;
        }

        if ( wl_int_002 < 9999 )
        {
            pntmygl->f_follow_timeline(wl_int_002);
            screen_timeline->pos_x = wl_int_002;
            screen_timeline->repaint();
        }
    }
}

void mainfrm::f_rwd_diapo()
{
    if ( screen_timeline->num_select > 0 )
    {
        int wl_int_001 = 0;
        int wl_int_002 = 0;

        while ( screen_timeline->tab_mark[wl_int_001][0] != "" )
        {
            if ( screen_timeline->tab_mark[wl_int_001][0].toInt() < screen_timeline->pos_x )
            {
                if ( screen_timeline->tab_mark[wl_int_001][0].toInt() > wl_int_002 )
                {
                    wl_int_002 = screen_timeline->tab_mark[wl_int_001][0].toInt();
                }
            }
            wl_int_001++;
        }

        if ( wl_int_002 > 0 )
        {
            pntmygl->f_follow_timeline(wl_int_002);
            screen_timeline->pos_x = wl_int_002;
            screen_timeline->repaint();
        }
    }
}

void mainfrm::f_play_diapo_boucle()
{
    if ( end_renderer == 1 && isrendering == 1 )
    {
        f_end_break_renderer();
        return;
    }

    wlincr = (float)((float)(screen_timeline->width()-20)/(float)(wg_fps_int*pntmygl->length_diapo));

    if ( qRound(pos_playing + wlincr) == qRound(pos_playing) )
    {
        pos_playing = pos_playing + wlincr + 1;
    }
    else
    {
        pos_playing = pos_playing + wlincr;
    }

    wl_avtrans = (float)((pntmygl->lgt_trans_old*25)+3)*wlincr;
    wl_aptrans = (float)((pntmygl->lgt_trans*25)+2)*wlincr;

    if ( pos_playing >= screen_timeline->width()-10 )
    {
        num_current_diapo++;
        progress_render_smile_2->setValue(num_current_diapo);

        pos_playing = 10;

        if ( num_current_diapo < nbre_diapos )
        {
            f_load_diapo(num_current_diapo);

            progress_render_smile->setValue(0);
            progress_render_smile->setMaximum(pntmygl->length_diapo*25);

            label_61->setText(tr("Progression diapositive :") + " "  + QString::number(num_current_diapo+1));
            spin_length_diapo->setValue(pntmygl->length_diapo);

            cpt_trt_trans = 0;
            thread_trans_render_sequence = 0;
        }
        else
        {
            if ( isrendering == 0 )
            {
                num_current_diapo = 0;
                f_load_diapo(num_current_diapo);
                spin_length_diapo->setValue(pntmygl->length_diapo);
                cpt_trt_trans = 0;
                thread_trans_render_sequence = 0;

                // *** CHARGEMENT DIAPO NOIRE ***
                while ( isrendering < 250 )
                {
                    pntmygl->table_preview_transition[isrendering] = pntmygl->table_preview_transition[250];
                    isrendering++;
                }

                isrendering = 0;
            }
            else
            {
                f_render_smile_2();
                return;
            }
        }
    }

    pntmygl->f_follow_timeline(qRound(pos_playing));
    screen_timeline->pos_x = pos_playing;
    screen_timeline->repaint();

    if ( isrendering == 1 )
    {
        progress_render_smile->setValue(progress_render_smile->value()+1);

        wg_myimg_render = pntmygl->grabFrameBuffer ( false );

        if ( pos_playing < screen_timeline->width()-wl_avtrans )
        {
            if ( pos_playing > wl_aptrans )
            {
                if ( cpt_trt_trans > 0 )
                {
                    cpt_trt_trans = 0;
                }

                wg_string_005 = "0000000000";
                wg_string_005.replace( 10 - QString::number(wg_int_001).length(), QString::number(wg_int_001).length(), QString::number(wg_int_001));

                thread_save->wait();

                thread_save->wg_path_save = path_project + "/RDR/" + wg_string_005 + ".jpg";
                thread_save->wg_save_image = wg_myimg_render;
                thread_save->run();

                wg_myimg_render.save( path_project + "/RDR/" + wg_string_005 + ".jpg" ,"JPEG", wg_jpg_qual );
                wg_int_001++;
            }
            else
            {
                if ( pntmygl->str_trans == "" || pntmygl->str_trans == wg_str_int_004 )
                {
                    if ( cpt_trt_trans > 0 )
                    {
                        cpt_trt_trans = 0;
                    }

                    wg_string_005 = "0000000000";
                    wg_string_005.replace( 10 - QString::number(wg_int_001).length(), QString::number(wg_int_001).length(), QString::number(wg_int_001));

                    thread_save->wait();

                    thread_save->wg_path_save = path_project + "/RDR/" + wg_string_005 + ".jpg";
                    thread_save->wg_save_image = wg_myimg_render;
                    thread_save->run();

                    wg_myimg_render.save( path_project + "/RDR/" + wg_string_005 + ".jpg" ,"JPEG", wg_jpg_qual );
                    wg_int_001++;
                }
                else
                {
                    f_update_trans_render();
                    cpt_trt_trans++;
                    qApp->processEvents();
                    f_play_diapo_boucle();
                    return;
                }
            }
        }
        else
        {
            if ( pntmygl->str_trans == "" || pntmygl->str_trans == wg_str_int_004 )
            {
                if ( cpt_trt_trans > 0 )
                {
                    cpt_trt_trans = 0;
                }

                wg_string_005 = "0000000000";
                wg_string_005.replace( 10 - QString::number(wg_int_001).length(), QString::number(wg_int_001).length(), QString::number(wg_int_001));

                thread_save->wait();

                thread_save->wg_path_save = path_project + "/RDR/" + wg_string_005 + ".jpg";
                thread_save->wg_save_image = wg_myimg_render;
                thread_save->run();

                wg_myimg_render.save( path_project + "/RDR/" + wg_string_005 + ".jpg" ,"JPEG", wg_jpg_qual );
                wg_int_001++;

            }
            else
            {
                pntmygl->table_preview_transition[cpt_trt_trans] = wg_myimg_render;
                cpt_trt_trans++;
            }
        }
        //QTimer::singleShot(2, this, SLOT(f_play_diapo_boucle()));
        f_play_diapo_boucle();
        qApp->processEvents();
        return;
    }
    else
    {
        if ( pos_playing < screen_timeline->width()-wl_avtrans )
        {
            if ( pos_playing > wl_aptrans )
            {
                if ( cpt_trt_trans > 0 )
                {
                    cpt_trt_trans = 0;
                }
                frame_msk_ed3d->setPixmap(QPixmap::fromImage( pntmygl->grabFrameBuffer ( false )));
            }
            else
            {               
                if ( pntmygl->str_trans == "" || pntmygl->str_trans == wg_str_int_004 )
                {
                    if ( cpt_trt_trans > 0 )
                    {
                        cpt_trt_trans = 0;
                    }
                    frame_msk_ed3d->setPixmap(QPixmap::fromImage( pntmygl->grabFrameBuffer ( false )));
                }
                else
                {
                    wg_myimg_render = pntmygl->grabFrameBuffer ( false );
                    f_update_trans_render();
                    cpt_trt_trans++;
                }
            }
        }
        else
        {
            if ( pntmygl->str_trans == "" || pntmygl->str_trans == wg_str_int_004 )
            {
                if ( cpt_trt_trans > 0 )
                {
                    cpt_trt_trans = 0;
                }
                frame_msk_ed3d->setPixmap(QPixmap::fromImage( pntmygl->grabFrameBuffer ( false )));
            }
            else
            {
                pntmygl->table_preview_transition[cpt_trt_trans] = pntmygl->grabFrameBuffer ( false );
                cpt_trt_trans++;
                qApp->processEvents();
                f_play_diapo_boucle();
                return;
            }
        }
    }

    if ( player_isplaying == true )
    {
        wl_wait = mysynctime.elapsed();
        if ( wl_wait < 40 )
        {
            mysynctime.restart();
            QTimer::singleShot(40-wl_wait, this, SLOT(f_play_diapo_boucle()));
        }
        else
        {
            mysynctime.restart();
            qApp->processEvents();
            f_play_diapo_boucle();
        }
    }
}

void mainfrm::f_update_trans_render()
{   
    QImage dstImage(dvdxsize,dvdysize,QImage::Format_ARGB32);

    thptradia *thread_trans_render = new thptradia();
    thread_trans_render->dstImage = &dstImage;

    thptradia *thread_trans_render_2 = new thptradia();
    thread_trans_render_2->dstImage = &dstImage;

    if ( pntmygl->str_trans != "crossfade" )
    {
            thread_trans_render->invert = "1";

            thread_trans_render->srcImage2 = pntmygl->table_preview_transition[cpt_trt_trans];
            thread_trans_render->srcImage = wg_myimg_render; //pntmygl->grabFrameBuffer ( false );
            thread_trans_render->srcImage3.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/" + pntmygl->str_trans + ".png");
            thread_trans_render->srcImage3 = thread_trans_render->srcImage3.scaled(sx_tr_diapo, sy_tr_diapo, Qt::IgnoreAspectRatio, Qt::FastTransformation);
            thread_trans_render->type_trans = 0;

            thread_trans_render_2->invert = "1";
            thread_trans_render_2->srcImage2 = pntmygl->table_preview_transition[cpt_trt_trans];
            thread_trans_render_2->srcImage = wg_myimg_render;
            thread_trans_render_2->srcImage3 = thread_trans_render->srcImage3;
            thread_trans_render_2->type_trans = 0;
    }
    else
    {
            thread_trans_render->srcImage = pntmygl->table_preview_transition[cpt_trt_trans];
            thread_trans_render->srcImage2 = wg_myimg_render; //pntmygl->grabFrameBuffer ( false );
            thread_trans_render->type_trans = 1;

            thread_trans_render_2->srcImage2 = wg_myimg_render;
            thread_trans_render_2->srcImage = pntmygl->table_preview_transition[cpt_trt_trans];
            thread_trans_render_2->type_trans = 1;
    }

    if ( thread_trans_render_sequence > 100 )
    {
        thread_trans_render_sequence = 100;
    }

    thread_trans_render->minx = 0;
    thread_trans_render->maxx = thread_trans_render->srcImage2.width();
    thread_trans_render->miny = 0;
    thread_trans_render->maxy = thread_trans_render->srcImage2.height()/2;

    thread_trans_render->sequence = thread_trans_render_sequence;

    thread_trans_render_2->minx = 0;
    thread_trans_render_2->maxx = thread_trans_render->maxx;
    thread_trans_render_2->maxy = thread_trans_render_2->srcImage2.height();
    thread_trans_render_2->miny = thread_trans_render_2->maxy/2;

    thread_trans_render_2->sequence = thread_trans_render_sequence;

    thread_trans_render->start();
    thread_trans_render_2->start();
    thread_trans_render->wait();
    thread_trans_render_2->wait();

    if ( isrendering == 0 )
    {
        frame_msk_ed3d->setPixmap(QPixmap::fromImage(dstImage,Qt::AutoColor));
    }
    else
    {
        wg_string_005 = "0000000000";
        wg_string_005.replace( 10 - QString::number(wg_int_001).length(), QString::number(wg_int_001).length(), QString::number(wg_int_001));

        dstImage.save( path_project + "/RDR/" + wg_string_005 + ".jpg" ,"JPEG", wg_jpg_qual );
        wg_int_001++;
    }

    if ( pntmygl->str_trans != "crossfade" )
    {
        thread_trans_render_sequence = (float)( (pow(cpt_trt_trans,(1.0/1.4))*100.0) /  ( pow(pntmygl->lgt_trans,(1.0/1.4)) * pow(25,(1.0/1.4)) ) );
    }
    else
    {
        thread_trans_render_sequence = (float)( (pow(cpt_trt_trans,3)*100.0) /  ( pow(pntmygl->lgt_trans,3) * pow(25,3) ) );
    }

    if ( pos_playing + wlincr >= screen_timeline->width()-wl_avtrans )
    {
        cpt_trt_trans = 0;
    }

    delete thread_trans_render;
    delete thread_trans_render_2;
}

void mainfrm::f_render_smile()
{
    QPixmap wl_pix_001(this->width(),this->height());
    wl_pix_001.fill(QColor(0,0,0,240));
    mask_interface->setPixmap(wl_pix_001);

    smenuBar->setDisabled(true);
    //path_render_smile->setText(QSettings().value("last/render", "").toString());

    mask_interface->show();
    mask_interface->raise();

    frame_choose_encode->show();
    frame_choose_encode->raise();

    end_renderer = 0;
    pntmygl->f_save_diapo(num_current_diapo);
}

void mainfrm::f_render_smile_2()
{
    progress_render_smile->setValue(progress_render_smile->maximum());
    progress_render_smile_3->setMaximum(100);
    f_end_smile_encode();
}

void mainfrm::f_bt_cancel_slideshow()
{
    end_renderer = 1;
}

void mainfrm::f_end_break_renderer()
{
    QFile wmyficext;
    QTextStream outext(&wmyficext);

    wmyficext.setFileName(path_project + "/RDR/stop.sh");
    wmyficext.open( QIODevice::WriteOnly );
    outext << "cd " + path_project + "/RDR/" << endl;
    outext << "rm -f *.jpg" << endl;
    outext << "rm -f stop.sh" << endl;
    outext << "exit" << endl;
    wmyficext.close();
    QString programf = "bash";
    QStringList argumentsf;
    argumentsf << path_project + "/RDR/stop.sh";

    proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
    proc_ffmpeg.start(programf,argumentsf);

    proc_ffmpeg.waitForFinished(-1);

    pos_playing = 10;

    pntmygl->f_follow_timeline(qRound(pos_playing));
    screen_timeline->pos_x = pos_playing;
    screen_timeline->num_select = 0;
    screen_timeline->repaint();

    player_isplaying = false;
    pntmygl->f_netbuf();

    wg_int_001 = 0;
    cpt_trt_trans = 0;
    isrendering = 0;
    pntmygl->isrendering = 0;

    frame_choose_encode->hide();

    frame_toolslide->setEnabled(true);
    frame_bottom_slide->setEnabled(true);
    frame_support_timeline_diapo->setEnabled(true);
    smenuBar->setEnabled(true);

    screen_timeline->num_select = 0;
    pntmygl->num_select = 0;

    frame_render_smile->hide();
    smenuBar->setEnabled(true);
    player_isplaying = false;
    mask_interface->hide();
    pntmygl->f_netbuf();

    frame_msk_ed3d->hide();

    frame_choose_encode->hide();

    end_renderer = 0;
    pntmygl->isrendering = 0;
    //num_current_diapo--;
}

void mainfrm::f_end_smile_encode()
{
    // *** GENERATION DE LA VIDEO ***

    if ( frame_path_smile->isEnabled() == true )
    {
        QFile wmyficext;
        QTextStream outext(&wmyficext);

        wmyficext.setFileName(path_project + "/RDR/gene.sh");
        wmyficext.open( QIODevice::WriteOnly );
        outext << "cd " + path_project + "/RDR/" << endl;
        outext << "sox -n -t wav -c 2 silent.wav trim 0 " + QString::number(timeline_diapo->wg_cumul) << endl;

        if ( nbre_audio_track > 0 )
        {
            // *** CALCUL TEMPS POUR BANDE AUDIO ***

            int wl_int_001 = 0;
            int wl_cumul_before = 0;
            int wl_cumul_after = 0;

            int wl_durfin = 0;
            int wl_durfou = 0;
            int wl_lgtfou = 0;

            while ( wl_int_001 < nbre_diapos )
            {
                if ( wl_int_001 < hdl_audio->position )
                {
                    wl_cumul_before = wl_cumul_before + (timeline_diapo->tab_duration[wl_int_001]-timeline_diapo->tab_transition[wl_int_001]);
                }
                else
                {
                    if ( wl_int_001 == hdl_audio->position )
                    {
                        wl_durfin = timeline_diapo->tab_duration[wl_int_001];
                    }
                    wl_cumul_after = wl_cumul_after + (timeline_diapo->tab_duration[wl_int_001]-timeline_diapo->tab_transition[wl_int_001]);
                    if ( wl_cumul_after >= hdl_audio->length_media || wl_int_001 == nbre_diapos-1 )
                    {
                        wl_durfou = (timeline_diapo->tab_duration[wl_int_001]-timeline_diapo->tab_transition[wl_int_001]);
                        wl_lgtfou = wl_cumul_after-(timeline_diapo->tab_duration[wl_int_001]-timeline_diapo->tab_transition[wl_int_001]);
                    }
                }
                wl_int_001++;
            }

            QString wl_str_fade = "";

            if ( hdl_audio->is_fade_in == 1 && hdl_audio->is_fade_out == 1 )
            {
                wl_str_fade = "fade t " + QString::number(2) + " " + QString::number(wl_lgtfou) + " " + QString::number(2);
            }
            else
            {
                if ( hdl_audio->is_fade_in == 1 && hdl_audio->is_fade_out == 0 )
                {
                    wl_str_fade = "fade t " + QString::number(2);
                }
                else
                {
                    if ( hdl_audio->is_fade_in == 0 && hdl_audio->is_fade_out == 1 )
                    {
                        wl_str_fade = "fade t 0 " + QString::number(wl_lgtfou) + " " + QString::number(2);
                    }
                }
            }

            outext << "ffmpeg -y -i '" + hdl_audio->title_audio + "' trscode.wav" << endl;
            outext << "sox silent.wav -t wav -c 2 -r 44100 debut.wav trim 0:0:0.0 " << QString::number(wl_cumul_before) << endl;
            outext << "sox trscode.wav -t wav -c 2 -r 44100 temp.wav trim 0:0:0.0 " << QString::number(wl_cumul_after) << " " << wl_str_fade << endl;
            outext << "rm -f silent.wav" << endl;
            outext << "sox -S debut.wav temp.wav silent.wav" << endl;
        }

        outext << "ffmpeg -i silent.wav -y -acodec ac3 -ab 128k silent.mp2" << endl;

        if ( combo_fmt_smile->currentIndex() < 6 )
        {
            if ( dvd_format == "4/3" )
            {
                outext << "mencoder \"mf://*.jpg\" -noskip -mf w=" + QString::number(dvdxsize) + ":h=" + QString::number(dvdysize) + ":fps=" + wg_fps + ":type=jpg -o \"" + wg_str_int_001 + "\" -oac lavc -ovc lavc -vf harddup -of mpeg -mpegopts format=dvd:tsaf:vbitrate=9700:muxrate=7500 -srate 48000 -af lavcresample=48000 -lavcopts vcodec=mpeg2video:aspect=4/3:vrc_buf_size=1835:vrc_maxrate=9800:threads=" + QString::number(nbre_threads) + ":vbitrate=9800:keyint=12:vstrict=0:acodec=ac3:abitrate=128 -cache 8192 -audiofile silent.mp2 | perl " + (QString)DEF_FAKE + "/fake.pl" << endl;
            }
            else
            {
                outext << "mencoder \"mf://*.jpg\" -noskip -mf w=" + QString::number(dvdxsize) + ":h=" + QString::number(dvdysize) + ":fps=" + wg_fps + ":type=jpg -o \"" + wg_str_int_001 + "\" -oac lavc -ovc lavc -vf harddup -of mpeg -mpegopts format=dvd:tsaf:vbitrate=9700:muxrate=7500 -srate 48000 -af lavcresample=48000 -lavcopts vcodec=mpeg2video:aspect=16/9:vrc_buf_size=1835:vrc_maxrate=9800:threads=" + QString::number(nbre_threads) + ":vbitrate=9800:keyint=12:vstrict=0:acodec=ac3:abitrate=128 -cache 8192 -audiofile silent.mp2 | perl " + (QString)DEF_FAKE + "/fake.pl" << endl;
            }
        }
        else
        {
            if ( combo_fmt_smile->currentIndex() == 6 )
            {
                if ( dvd_format == "4/3" )
                {
                    outext << "mencoder \"mf://*.jpg\" -noskip -mf w=" + QString::number(dvdxsize) + ":h=" + QString::number(dvdysize) + ":fps=" + wg_fps + ":type=jpg -o \"" + wg_str_int_001 + "\" -ovc lavc -lavcopts vcodec=msmpeg4v2:vbitrate=800:aspect=4/3 -oac mp3lame -lameopts cbr:br=128 -audiofile silent.mp2 | perl " + (QString)DEF_FAKE + "/fake.pl" << endl;
                }
                else
                {
                    outext << "mencoder \"mf://*.jpg\" -noskip -mf w=" + QString::number(dvdxsize) + ":h=" + QString::number(dvdysize) + ":fps=" + wg_fps + ":type=jpg -o \"" + wg_str_int_001 + "\" -ovc lavc -lavcopts vcodec=msmpeg4v2:vbitrate=800:aspect=16/9 -oac mp3lame -lameopts cbr:br=128 -audiofile silent.mp2 | perl " + (QString)DEF_FAKE + "/fake.pl" << endl;
                }
            }
            else
            {
                int sizy = 1920 / ((float)dvdxsize / (float)dvdysize);

                int cropy = (sizy-1080)/2;

                outext << "mencoder \"mf://*.jpg\" -noskip -mf fps=" + wg_fps + ":type=jpg -o \"" + wg_str_int_001 + "\" -oac mp3lame -ovc lavc -lavcopts vcodec=mpeg4:threads=" + QString::number(nbre_threads) + ":vbitrate=2160000:mbd=2:keyint=132:v4mv:vqmin=3:vlelim=-4:vcelim=7:lumi_mask=0.07:dark_mask=0.10:naq:vqcomp=0.7:vqblur=0.2:mpeg_quant:aspect=16/9 -vf scale=1920:" + QString::number(sizy) + ",crop=1920:1080:0:" + QString::number(cropy) + " -audiofile silent.mp2 | perl " + (QString)DEF_FAKE + "/fake.pl" << endl;
            }
        }
        outext << "rm -f *.wav" << endl;
        outext << "rm -f silent.mp2" << endl;
        outext << "exit" << endl;
        wmyficext.close();
        wg_string_003 = "";
        QString programf = "bash";
        QStringList argumentsf;
        argumentsf << path_project + "/RDR/gene.sh";

        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start(programf,argumentsf);

        proc_ffmpeg.waitForFinished(-1);
    }

    progress_render_smile_3->setValue(100);
    frame_toolslide->setEnabled(true);
    frame_bottom_slide->setEnabled(true);
    frame_support_timeline_diapo->setEnabled(true);

    if ( wg_string_003.lastIndexOf( "FATAL:" ) >= 0 )
    {
        /*if ( isnotify == 1 )
        {
                QString programf = "notify-send";
                QStringList argumentsf;
                argumentsf << "-i" << QDir::homePath() + "/.2ManDVD_Library/"  + "/Interface/emblem2.png";
                argumentsf << "2ManDVD";
                argumentsf << tr("La generation du diaporama a echouee");
                proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
                proc_ffmpeg.start(programf,argumentsf);
        }
        else
        {
            QString programf = "kdialog";
            QStringList argumentsf;
            argumentsf << "--passivepopup";
            argumentsf << tr("La generation du diaporama a echouee");
            argumentsf << "--title";
            argumentsf << "'2ManDVD'";

            proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
            proc_ffmpeg.start(programf,argumentsf);
        }*/

        QMessageBox::information(this, name_application, tr("La generation du diaporama a echouee"));
    }
    else
    {
        /*if ( isnotify == 1 )
        {
                QString programf = "notify-send";
                QStringList argumentsf;
                argumentsf << "-i" << QDir::homePath() + "/.2ManDVD_Library/"  + "/Interface/emblem2.png";
                argumentsf << "2ManDVD";
                argumentsf << tr("La generation du diaporama est terminee avec succes");
                proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
                proc_ffmpeg.start(programf,argumentsf);
        }
        else
        {
            QString programf = "kdialog";
            QStringList argumentsf;
            argumentsf << "--passivepopup";
            argumentsf << tr("La generation du diaporama est terminee avec succes");
            argumentsf << "--title";
            argumentsf << "'2ManDVD'";

            proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
            proc_ffmpeg.start(programf,argumentsf);
        }*/

        //QMessageBox::information(this, name_application, tr("La generation du diaporama s est achevee avec succes"));


        if ( frame_path_smile->isEnabled() == true )
        {
            QMessageBox msgBox;
            msgBox.setText(name_application);
            msgBox.setInformativeText(tr("La generation du diaporama s est achevee avec succes. Voulez vous le visualiser avec xine ?"));
            msgBox.setStandardButtons(QMessageBox::No | QMessageBox::Yes);
            msgBox.setDefaultButton(QMessageBox::Yes);
            int ret = msgBox.exec();
            switch (ret) {
                    case QMessageBox::Yes:
                        QStringList args;
                        args << wg_str_int_001;
                        nullProcess.start("xine", args);
                        if(!nullProcess.waitForStarted(3000))
                        {
                                QMessageBox::information(this, name_application, tr("Impossible de demarrer xine. Est t il installe correctement dans /usr/bin ?"));
                        }
            }
        }
        else
        {
            QMessageBox::information(this, name_application, tr("La generation du diaporama s est achevee avec succes. Vos fichiers sont dans : ") + path_project + "/RDR/");
        }
    }
    frame_render_smile->hide();
    smenuBar->setEnabled(true);
    player_isplaying = false;
    mask_interface->hide();
    pntmygl->f_netbuf();
    pntmygl->isrendering = 0;

    frame_choose_encode->hide();

    num_current_diapo--;
}

void mainfrm::f_pro_smile()
{
    frame_pro_smile->raise();
    frame_topbt_smile->raise();
    if ( frame_pro_smile->geometry().y() >= frame_toolslide->height() )
    {
        QPropertyAnimation *animation = new QPropertyAnimation(frame_pro_smile, "geometry");
        animation->setDuration(900);
        animation->setStartValue(QRect(0,frame_pro_smile->geometry().y(),frame_pro_smile->width(),frame_pro_smile->height()));
        animation->setEndValue(QRect(0,0,frame_pro_smile->width(),frame_pro_smile->height()));
        animation->setEasingCurve(QEasingCurve::InOutQuart);
        animation->start();

        QPropertyAnimation *animation2 = new QPropertyAnimation(frame_thm_smile, "geometry");
        animation2->setDuration(700);
        animation2->setStartValue(QRect(0,frame_thm_smile->geometry().y(),frame_thm_smile->width(),frame_thm_smile->height()));
        animation2->setEndValue(QRect(0,frame_toolslide->height(),frame_thm_smile->width(),frame_thm_smile->height()));
        animation2->setEasingCurve(QEasingCurve::InOutQuart);
        animation2->start();
    }
}

void mainfrm::f_thm_smile()
{
    frame_thm_smile->raise();
    frame_topbt_smile->raise();
    if ( frame_thm_smile->geometry().y() >= frame_toolslide->height() )
    {
        QPropertyAnimation *animation = new QPropertyAnimation(frame_thm_smile, "geometry");
        animation->setDuration(900);
        animation->setStartValue(QRect(0,frame_thm_smile->geometry().y(),frame_thm_smile->width(),frame_thm_smile->height()));
        animation->setEndValue(QRect(0,0,frame_thm_smile->width(),frame_thm_smile->height()));
        animation->setEasingCurve(QEasingCurve::InOutQuart);
        animation->start();

        QPropertyAnimation *animation2 = new QPropertyAnimation(frame_pro_smile, "geometry");
        animation2->setDuration(700);
        animation2->setStartValue(QRect(0,frame_pro_smile->geometry().y(),frame_pro_smile->width(),frame_pro_smile->height()));
        animation2->setEndValue(QRect(0,frame_toolslide->height(),frame_pro_smile->width(),frame_pro_smile->height()));
        animation2->setEasingCurve(QEasingCurve::InOutQuart);
        animation2->start();
    }
}

void mainfrm::f_select_them_smile()
{
    if ( screen_timeline->num_select > 0 )
    {
        QList<QListWidgetItem *> selectthe = frame_th_msk_smile->selectedItems();
        QListWidgetItem *thetxt = new QListWidgetItem;
        thetxt = selectthe.at(0);

        if ( thetxt->text() != wg_str_int_004 )
        {
            pntmygl->f_load_mask(thetxt->text(),screen_timeline->num_select);
        }
        else
        {
            pntmygl->f_load_mask("",screen_timeline->num_select);
        }
    }
}

void mainfrm::f_valid_coord_diapo()
{
    pntmygl->f_mark_pos(screen_timeline->pos_x,110,slider_opa_slide->value(),slider_blur_img->value(),slider_slide_red->value(),slider_slide_green->value(),slider_slide_blue->value(),slider_size_x_scale->value(),slider_size_y_scale->value(),slider_size_x_scale_2->value(),slider_size_y_scale_2->value());
}

void mainfrm::f_px_changed(QString px)
{
    if ( pntmygl->num_select > 0 && must_update == 1 )
    {
        pntmygl->tab_coo[pntmygl->num_select][0] = px.toFloat();
        pntmygl->updateGL();
    }
}

void mainfrm::f_py_changed(QString py)
{
    if ( pntmygl->num_select > 0 && must_update == 1 )
    {
        pntmygl->tab_coo[pntmygl->num_select][1] = py.toFloat();
        pntmygl->updateGL();
    }
}

void mainfrm::f_pz_changed(QString pz)
{
    if ( pntmygl->num_select > 0 && must_update == 1 )
    {
        pntmygl->tab_coo[pntmygl->num_select][2] = pz.toFloat();
        pntmygl->updateGL();
    }
}

void mainfrm::f_rx_changed(QString rx)
{
    if ( pntmygl->num_select > 0 && must_update == 1 )
    {
        pntmygl->tab_coo[pntmygl->num_select][5] = rx.toFloat();
        pntmygl->updateGL();
    }
}

void mainfrm::f_ry_changed(QString ry)
{
    if ( pntmygl->num_select > 0 && must_update == 1 )
    {
        pntmygl->tab_coo[pntmygl->num_select][6] = ry.toFloat();
        pntmygl->updateGL();
    }
}

void mainfrm::f_rz_changed(QString rz)
{
    if ( pntmygl->num_select > 0 && must_update == 1 )
    {
        pntmygl->tab_coo[pntmygl->num_select][7] = rz.toFloat();
        pntmygl->updateGL();
    }
}

void mainfrm::f_action_talea()
{
    pntmygl->f_save_diapo(num_current_diapo);

    int wl_int_001 = 0;
    int wl_int_002 = 0;
    int wl_random_value;
    while ( wl_int_001 < nbre_diapos )
    {
        wl_random_value = rand()%(nombre_transitions);
        if ( wl_random_value < 1 )
        {
            wl_random_value = 1;
        }

        wl_int_002 = 0;

        while ( pntmygl->tab_save_diapo[wl_int_001][wl_int_002] != "$#$" )
        {
            wl_int_002++;
        }

        pntmygl->tab_save_diapo[wl_int_001][wl_int_002+3] = lst_trans_smile->itemText(wl_random_value) + "}1";

        if ( wl_int_001 == num_current_diapo )
        {
            must_update = 0;
            pntmygl->str_trans = lst_trans_smile->itemText(wl_random_value);
            pntmygl->lgt_trans = 1;
            lst_trans_smile->setCurrentIndex(lst_trans_smile->findText(pntmygl->str_trans,Qt::MatchExactly | Qt::MatchCaseSensitive));
            must_update = 1;
        }

        wl_int_001++;
    }
    f_select_diapos_th(table_hdl_diapo[num_current_diapo]);
}

void mainfrm::f_godrop_diapo()
{
    pntmygl->f_save_diapo(num_current_diapo); // *** TODO A VERIFIER ***

    int pos_drag = 0;
    pos_drag = timeline_diapo->drop_x/60;

    if ( pos_drag == num_current_diapo )
    {
        return;
    }

    if ( pos_drag > nbre_diapos-1 )
    {
        pos_drag = nbre_diapos-1;
    }

    int wl_int_001 = pos_drag;
    int wl_int_002 = 0;

    if ( pos_drag < num_current_diapo)
    {
        while ( wl_int_001 < num_current_diapo )
        {
            QPropertyAnimation *animation2 = new QPropertyAnimation(table_hdl_diapo[wl_int_001], "geometry");
            animation2->setDuration(300);
            animation2->setStartValue(QRect(table_hdl_diapo[wl_int_001]->geometry().x(),table_hdl_diapo[wl_int_001]->geometry().y(),table_hdl_diapo[wl_int_001]->width(),table_hdl_diapo[wl_int_001]->height()));
            animation2->setEndValue(QRect(table_hdl_diapo[wl_int_001+1]->geometry().x(),table_hdl_diapo[wl_int_001+1]->geometry().y(),table_hdl_diapo[wl_int_001]->width(),table_hdl_diapo[wl_int_001]->height()));
            animation2->setEasingCurve(QEasingCurve::InOutCubic);
            animation2->start();
            wl_int_001++;
        }
    }
    else
    {
        wl_int_001 = num_current_diapo+1;
        while ( wl_int_001 <= pos_drag )
        {
            QPropertyAnimation *animation2 = new QPropertyAnimation(table_hdl_diapo[wl_int_001], "geometry");
            animation2->setDuration(300);
            animation2->setStartValue(QRect(table_hdl_diapo[wl_int_001]->geometry().x(),table_hdl_diapo[wl_int_001]->geometry().y(),table_hdl_diapo[wl_int_001]->width(),table_hdl_diapo[wl_int_001]->height()));
            animation2->setEndValue(QRect(table_hdl_diapo[wl_int_001-1]->geometry().x(),table_hdl_diapo[wl_int_001-1]->geometry().y(),table_hdl_diapo[wl_int_001]->width(),table_hdl_diapo[wl_int_001]->height()));
            animation2->setEasingCurve(QEasingCurve::InOutCubic);
            animation2->start();
            wl_int_001++;
        }
    }

    QPropertyAnimation *animation = new QPropertyAnimation(table_hdl_diapo[num_current_diapo], "geometry");
    animation->setDuration(800);
    animation->setStartValue(QRect(table_hdl_diapo[num_current_diapo]->geometry().x(),table_hdl_diapo[num_current_diapo]->geometry().y(),table_hdl_diapo[num_current_diapo]->width(),table_hdl_diapo[num_current_diapo]->height()));
    animation->setEndValue(QRect(table_hdl_diapo[pos_drag]->geometry().x(),table_hdl_diapo[pos_drag]->geometry().y(),table_hdl_diapo[pos_drag]->width(),table_hdl_diapo[pos_drag]->height()));
    animation->setEasingCurve(QEasingCurve::InOutCubic);
    animation->start();

    // *** PERMUTATION DES HANDLES ***
    diapos_th *hdltmp;

    QString save_diapo_tmp[45];

    if ( pos_drag < num_current_diapo)
    {
        wl_int_001 = num_current_diapo;
        hdltmp = table_hdl_diapo[num_current_diapo];

        wl_int_002 = 0;
        while ( wl_int_002 < 45 )
        {
            save_diapo_tmp[wl_int_002] = pntmygl->tab_save_diapo[num_current_diapo][wl_int_002];
            wl_int_002++;
        }

        while ( wl_int_001 > pos_drag )
        {
            table_hdl_diapo[wl_int_001] = table_hdl_diapo[wl_int_001-1];
            wl_int_002 = 0;
            while ( wl_int_002 < 45 )
            {
                pntmygl->tab_save_diapo[wl_int_001][wl_int_002] = pntmygl->tab_save_diapo[wl_int_001-1][wl_int_002];
                wl_int_002++;
            }

            timeline_diapo->tab_transition[wl_int_001] = timeline_diapo->tab_transition[wl_int_001-1];
            timeline_diapo->tab_duration[wl_int_001] = timeline_diapo->tab_duration[wl_int_001-1];

            wl_int_001--;
        }
        table_hdl_diapo[pos_drag] = hdltmp;

        wl_int_002 = 0;
        while ( wl_int_002 < 45 )
        {
            pntmygl->tab_save_diapo[pos_drag][wl_int_002] = save_diapo_tmp[wl_int_002];
            wl_int_002++;
        }
        timeline_diapo->tab_duration[pos_drag] = spin_length_diapo->value();
        if ( lst_trans_smile->currentIndex() > 0 )
        {
            timeline_diapo->tab_transition[pos_drag] = spintrandur->value();
        }
        else
        {
            timeline_diapo->tab_transition[pos_drag] = 0;
        }
        timeline_diapo->repaint();
    }
    else
    {
        wl_int_001 = num_current_diapo;
        hdltmp = table_hdl_diapo[num_current_diapo];

        wl_int_002 = 0;
        while ( wl_int_002 < 45 )
        {
            save_diapo_tmp[wl_int_002] = pntmygl->tab_save_diapo[num_current_diapo][wl_int_002];
            wl_int_002++;
        }

        while ( wl_int_001 < pos_drag )
        {
            table_hdl_diapo[wl_int_001] = table_hdl_diapo[wl_int_001+1];
            wl_int_002 = 0;
            while ( wl_int_002 < 45 )
            {
                pntmygl->tab_save_diapo[wl_int_001][wl_int_002] = pntmygl->tab_save_diapo[wl_int_001+1][wl_int_002];
                wl_int_002++;
            }
            timeline_diapo->tab_transition[wl_int_001] = timeline_diapo->tab_transition[wl_int_001+1];
            timeline_diapo->tab_duration[wl_int_001] = timeline_diapo->tab_duration[wl_int_001+1];
            wl_int_001++;
        }
        table_hdl_diapo[pos_drag] = hdltmp;

        wl_int_002 = 0;
        while ( wl_int_002 < 45 )
        {
            pntmygl->tab_save_diapo[pos_drag][wl_int_002] = save_diapo_tmp[wl_int_002];
            wl_int_002++;
        }
        timeline_diapo->tab_duration[pos_drag] = spin_length_diapo->value();
        if ( lst_trans_smile->currentIndex() > 0 )
        {
            timeline_diapo->tab_transition[pos_drag] = spintrandur->value();
        }
        else
        {
            timeline_diapo->tab_transition[pos_drag] = 0;
        }
        timeline_diapo->repaint();
    }
    num_current_diapo = pos_drag;
}

void mainfrm::f_lst_trans_smile_changed(int)
{
    if ( must_update == 1 )
    {
        pntmygl->str_trans = lst_trans_smile->currentText();

        if ( lst_trans_smile->currentIndex() > 0 )
        {
            timeline_diapo->tab_transition[num_current_diapo] = spintrandur->value();
        }
        else
        {
            timeline_diapo->tab_transition[num_current_diapo] = 0;
        }
        timeline_diapo->repaint();
    }
}

void mainfrm::f_dupliquer_diaposth(diapos_th*)
{
    if ( nbre_diapos+1 >= 400 )
    {
        QMessageBox::information(this, name_application, tr("Nombre maximum de diapositive 400 atteint"));
        return;
    }

    pntmygl->f_save_diapo(num_current_diapo);

    diapos_th *newdiapo = new diapos_th(timeline_diapo);

    table_hdl_diapo[nbre_diapos] = newdiapo;

    connect(newdiapo, SIGNAL(select_diapoth(diapos_th*) ),this, SLOT(f_select_diapos_th(diapos_th*)));
    connect(newdiapo, SIGNAL(delete_diapoth(diapos_th*) ),this, SLOT(f_delete_diaposth(diapos_th*)));
    connect(newdiapo, SIGNAL(theme_diapoth(diapos_th*) ),this, SLOT(f_theme_diaposth(diapos_th*)));
    connect(newdiapo, SIGNAL(dupliquer_diapoth(diapos_th*) ),this, SLOT(f_dupliquer_diaposth(diapos_th*)));
    connect(newdiapo, SIGNAL(enter_diath(diapos_th*) ),this, SLOT(f_enter_diath(diapos_th*)));
    connect(newdiapo, SIGNAL(leave_diath(diapos_th*) ),this, SLOT(f_leave_diath(diapos_th*)));

    if ( num_current_diapo+1 >= nbre_diapos )
    {
        newdiapo->setGeometry( nbre_diapos * 60, 0, 50, 50 );

        int wl_int_001 = 0;

        while ( wl_int_001 < 45 )
        {
            pntmygl->tab_save_diapo[nbre_diapos][wl_int_001] = pntmygl->tab_save_diapo[num_current_diapo][wl_int_001];
            wl_int_001++;
        }

        table_hdl_diapo[nbre_diapos] = newdiapo;
        newdiapo->draw_image = table_hdl_diapo[num_current_diapo]->draw_image;
        newdiapo->is_edit = 0;
        newdiapo->show();
    }
    else
    {
        int wl_i1 = num_current_diapo;
        while ( wl_i1 < nbre_diapos )
        {
            if ( wl_i1 < nbre_diapos-1 )
            {
                QPropertyAnimation *animation2 = new QPropertyAnimation(table_hdl_diapo[wl_i1], "geometry");
                animation2->setDuration(300);
                animation2->setStartValue(QRect(table_hdl_diapo[wl_i1]->geometry().x(),table_hdl_diapo[wl_i1]->geometry().y(),table_hdl_diapo[wl_i1]->width(),table_hdl_diapo[wl_i1]->height()));
                animation2->setEndValue(QRect(table_hdl_diapo[wl_i1+1]->geometry().x(),table_hdl_diapo[wl_i1+1]->geometry().y(),table_hdl_diapo[wl_i1]->width(),table_hdl_diapo[wl_i1]->height()));
                animation2->setEasingCurve(QEasingCurve::InOutCubic);
                animation2->start();
            }
            else
            {
                QPropertyAnimation *animation2 = new QPropertyAnimation(table_hdl_diapo[wl_i1], "geometry");
                animation2->setDuration(300);
                animation2->setStartValue(QRect(table_hdl_diapo[wl_i1]->geometry().x(),table_hdl_diapo[wl_i1]->geometry().y(),table_hdl_diapo[wl_i1]->width(),table_hdl_diapo[wl_i1]->height()));
                animation2->setEndValue(QRect(table_hdl_diapo[wl_i1]->geometry().x()+60,table_hdl_diapo[wl_i1]->geometry().y(),table_hdl_diapo[wl_i1]->width(),table_hdl_diapo[wl_i1]->height()));
                animation2->setEasingCurve(QEasingCurve::InOutCubic);
                animation2->start();
            }

            wl_i1++;
        }

        int wl_int_001 = nbre_diapos;
        int wl_int_002;

        while ( wl_int_001 >= num_current_diapo )
        {
            table_hdl_diapo[wl_int_001+1] = table_hdl_diapo[wl_int_001];
            wl_int_002 = 0;
            while ( wl_int_002 < 45 )
            {
                pntmygl->tab_save_diapo[wl_int_001+1][wl_int_002] = pntmygl->tab_save_diapo[wl_int_001][wl_int_002];
                wl_int_002++;
            }
            wl_int_001--;
        }
        table_hdl_diapo[num_current_diapo] = newdiapo;
        newdiapo->draw_image = table_hdl_diapo[num_current_diapo+1]->draw_image;
        newdiapo->is_edit = 0;
        newdiapo->show();

        wl_int_001 = 0;
        while ( wl_int_001 < 45 )
        {
            pntmygl->tab_save_diapo[num_current_diapo][wl_int_001] = pntmygl->tab_save_diapo[num_current_diapo+1][wl_int_001];
            wl_int_001++;
        }

        newdiapo->setGeometry( num_current_diapo * 60, 0, 50, 50 );
    }

    timeline_diapo->repaint();

    nbre_diapos++;
}

void mainfrm::f_actionDiaporama_automatique()
{
    QString mydir = QFileDialog::getExistingDirectory( this, tr("Choisissez le dossier contenant vos images"), pntmygl->wg_path_images, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
    if ( mydir != "" )
    {
        pntmygl->wg_path_images = mydir;
        QPixmap wl_pix_002(this->width(),this->height());
        wl_pix_002.fill(QColor(0,0,0,240));
        mask_interface->setPixmap(wl_pix_002);

        smenuBar->setDisabled(true);

        mask_interface->show();
        mask_interface->raise();

        pathfildiapauto->setText(mydir);

        frame_holy_param->show();
        frame_holy_param->raise();
        wg_string_001 = mydir;
    }
}

void mainfrm::f_actionDiaporama_automatique_find()
{
    if ( frame_smile->isVisible() == true )
    {
        QString mydir = QFileDialog::getExistingDirectory( this, tr("Choisissez le dossier contenant vos images"), pntmygl->wg_path_images, QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
        if ( mydir != "" )
        {
            pathfildiapauto->setText(mydir);
            wg_string_001 = mydir;
        }
    }
    else
    {
        QString mydir = QFileDialog::getExistingDirectory( this, tr("Choisissez le dossier contenant vos images"), "~", QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
        if ( mydir != "" )
        {
            pathfildiapauto->setText(mydir);
            wg_string_001 = mydir;
        }
    }
}

void mainfrm::f_actionDiaporama_automatique_1()
{
    if ( pathfildiapauto->text() == "" )
    {
        QMessageBox::information(this, name_application, tr("Vous devez choisir un dossier contenant les images à importer"));
        return;
    }

    if ( frame_smile->isVisible() == true )
    {
        frame_holy_param->hide();

        pb_holy->setValue(0);
        frame_holy->show();
        frame_holy->raise();

        qApp->processEvents();
        f_actionDiaporama_automatique_2();
    }
    else
    {
        frame_holy_param->hide();

        f_valide_new_projet_slideshow();

        pb_holy->setValue(0);
        frame_holy->show();
        frame_holy->raise();

        qApp->processEvents();

        f_actionDiaporama_automatique_2();
        f_delete_diaposth(table_hdl_diapo[0]);
    }
}

void mainfrm::f_cancel_actionDiaporama_automatique()
{
    if ( frame_smile->isVisible() == true )
    {
        frame_holy_param->hide();
        smenuBar->setEnabled(true);

        mask_interface->hide();
    }
    else
    {
        this->setMinimumSize(frame_new_proj->width(),frame_new_proj->height());
        this->setMaximumSize(frame_new_proj->width(),frame_new_proj->height());
        this->setGeometry((QApplication::desktop()->screenGeometry(0).width()-frame_new_proj->width())/2,(QApplication::desktop()->screenGeometry(0).height()-frame_new_proj->height())/2,frame_new_proj->width(),frame_new_proj->height());
        frame_holy_param->hide();
    }
}

void mainfrm::f_actionDiaporama_automatique_2()
{
        QString mydir = wg_string_001;
        QDir tmpdir;
        tmpdir.setPath(mydir);
        QStringList filters;
        filters << "*.jpg" << "*.JPG" << "*.jpeg" << "*.JPEG" << "*.png" << "*.PNG"; // << "*.mpg" << "*.mpeg" << "*.MPG" << "*.MPEG" << "*.avi" << "*.AVI";
        tmpdir.setNameFilters(filters);
        if ( combo_pardiapauto->currentIndex() == 0 && checkBox_sort_diapauto->isChecked() == false )
        {
            tmpdir.setSorting(QDir::Name);
        }
        else
        {
            if ( combo_pardiapauto->currentIndex() == 0 && checkBox_sort_diapauto->isChecked() == true )
            {
                tmpdir.setSorting(QDir::Name | QDir::Reversed);
            }
            else
            {
                if ( combo_pardiapauto->currentIndex() == 1 && checkBox_sort_diapauto->isChecked() == false )
                {
                    tmpdir.setSorting(QDir::Time);
                }
                else
                {
                    if ( combo_pardiapauto->currentIndex() == 1 && checkBox_sort_diapauto->isChecked() == true )
                    {
                        tmpdir.setSorting(QDir::Time | QDir::Reversed);
                    }
                    else
                    {
                        if ( combo_pardiapauto->currentIndex() == 2 && checkBox_sort_diapauto->isChecked() == false )
                        {
                            tmpdir.setSorting(QDir::Size);
                        }
                        else
                        {
                            tmpdir.setSorting(QDir::Size | QDir::Reversed);
                        }
                    }
                }
            }
        }
        tmpdir.sorting();
        QString wlfile;
        int wl_int_001 = 0;
        int wl_int_002 = 0;
        int wl_int_003 = 0;
        int wl_int_004 = 0;
        int wl_random_value;
        int wl_i = 0;
        int wl_j = 0;
        int oldthm = 9999;

        QString tab_dia_string[1000];
        QListWidgetItem *wl_item;
        QStringList wl_exp;
        QStringList wl_explode;
        QStringList wl_explode_2;
        QImage wl_img;
        QString nameth;
        QImage wl_img_texture;
        QString wl_str_001;
        QString wl_str_002;
        QString wl_str_003;

        if ( tmpdir.count() > 0 )
        {
            foreach (wlfile, tmpdir.entryList(QDir::Files))
            {
                tab_dia_string[wl_int_001] = mydir + "/" + wlfile;
                wl_int_001++;
            }

            pb_holy->setMaximum(wl_int_001);

            while ( wl_int_002 < wl_int_001 && nbre_diapos < 400 )
            {
                diapos_th *newdiapo = new diapos_th(timeline_diapo);
                newdiapo->setGeometry( nbre_diapos*60, 0, 50, 50 );

                if ( newdiapo->draw_image.load(tab_dia_string[wl_int_002]) == true )
                {
                    newdiapo->draw_image.load(tab_dia_string[wl_int_002]);
                    newdiapo->draw_image = newdiapo->draw_image.scaled(38,38);
                }
                else
                {
                    newdiapo->draw_image.load(":/Interface/Interface/case_diapo_select.png");
                    newdiapo->draw_image = newdiapo->draw_image.scaled(38,38);
                    newdiapo->draw_image.fill(1);
                }
                newdiapo->is_edit = 0;
                newdiapo->show();

                table_hdl_diapo[nbre_diapos] = newdiapo;

                connect(newdiapo, SIGNAL(select_diapoth(diapos_th*) ),this, SLOT(f_select_diapos_th(diapos_th*)));
                connect(newdiapo, SIGNAL(delete_diapoth(diapos_th*) ),this, SLOT(f_delete_diaposth(diapos_th*)));
                connect(newdiapo, SIGNAL(theme_diapoth(diapos_th*) ),this, SLOT(f_theme_diaposth(diapos_th*)));
                connect(newdiapo, SIGNAL(dupliquer_diapoth(diapos_th*) ),this, SLOT(f_dupliquer_diaposth(diapos_th*)));
                connect(newdiapo, SIGNAL(enter_diath(diapos_th*) ),this, SLOT(f_enter_diath(diapos_th*)));
                connect(newdiapo, SIGNAL(leave_diath(diapos_th*) ),this, SLOT(f_leave_diath(diapos_th*)));

                wl_random_value = rand()%(nombre_themes_3d);
                while ( wl_random_value == oldthm )
                {
                    wl_random_value = rand()%(nombre_themes_3d);
                }
                oldthm = wl_random_value;

                if ( wl_random_value < 0 )
                {
                    wl_random_value = 0;
                }

                wl_item = frame_support_th3d->item(wl_random_value);
                nameth = wl_item->text();
                wl_exp = wl_item->statusTip().split("_",QString::KeepEmptyParts);

                timeline_diapo->tab_duration[nbre_diapos] = wl_exp.at(1).toInt();

                timeline_diapo->tab_transition[nbre_diapos] = 1;

                for (wl_int_003 = 3; wl_int_003 < wl_exp.size(); ++wl_int_003)
                {                  
                    if ( wl_img_texture.load(QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/3d/" + nameth + "_" + QString::number(wl_int_003-2) + ".png") == true )
                    {
                        if ( wl_img_texture.width() > wl_img_texture.height() )
                        {
                            wl_img_texture = wl_img_texture.scaledToWidth( pntmygl->sm_mxw ,Qt::SmoothTransformation);
                        }
                        else
                        {
                            wl_img_texture = wl_img_texture.scaledToHeight( pntmygl->sm_mxw ,Qt::SmoothTransformation);
                        }

                        wl_explode = wl_exp.at(wl_int_003).split("$",QString::SkipEmptyParts);

                        wl_str_001 =  wl_explode.at(0).mid(wl_explode.at(0).lastIndexOf( ":" )+1,wl_explode.at(0).length()-(wl_explode.at(0).lastIndexOf( ":" )+1));
                        wl_str_001.replace(QString("underscore"), QString("_"));

                        wl_i = 0;
                        wl_j = 0;
                        while ( wl_i < 3 )
                        {
                            if ( wl_explode.at(0).mid(wl_j,1) == ":" )
                            {
                                wl_i++;
                            }
                            wl_j++;
                        }

                        wl_str_002 = wl_explode.at(0).mid(wl_j,wl_explode.at(0).lastIndexOf( ":" )-wl_j) + "$";

                        wl_explode_2 = wl_explode.at(0).split(":",QString::KeepEmptyParts);

                        wl_int_004 = 1;

                        while ( wl_int_004 < wl_explode.count() )
                        {
                            wl_str_002 = wl_str_002 + wl_explode.at(wl_int_004) + "$";
                            wl_int_004++;
                        }

                        pntmygl->tab_save_diapo[nbre_diapos][wl_int_003-2] = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/3d/" + nameth + "_" + QString::number(wl_int_003-2) + ".png" + "$1024$" + QString::number(1024/(wl_img_texture.width()/wl_img_texture.height())) + "$" + wl_str_001 + "$0:" + wl_explode.at(0) + "$" + wl_explode_2.at(2) + "$" + wl_explode_2.at(1) + "$0/0/0/0$0$" + wl_str_002; // + "$1.0";$
                    }
                    else
                    {
                        if ( wl_int_002 < wl_int_001 )
                        {
                            if ( wl_img.load(tab_dia_string[wl_int_002]) == true )
                            {
                                if ( wl_img.width() > wl_img.height() )
                                {
                                    wl_img = wl_img.scaledToWidth(pntmygl->sm_mxw,Qt::SmoothTransformation);
                                }
                                else
                                {
                                    wl_img = wl_img.scaledToHeight(pntmygl->sm_mxw,Qt::SmoothTransformation);
                                }

                                wl_explode = wl_exp.at(wl_int_003).split("$",QString::SkipEmptyParts);

                                wl_str_001 =  wl_explode.at(0).mid(wl_explode.at(0).lastIndexOf( ":" )+1,wl_explode.at(0).length()-(wl_explode.at(0).lastIndexOf( ":" )+1));
                                wl_str_001.replace(QString("underscore"), QString("_"));

                                wl_i = 0;
                                wl_j = 0;
                                while ( wl_i < 3 )
                                {
                                    if ( wl_explode.at(0).mid(wl_j,1) == ":" )
                                    {
                                        wl_i++;
                                    }
                                    wl_j++;
                                }

                                wl_str_002 = wl_explode.at(0).mid(wl_j,wl_explode.at(0).lastIndexOf( ":" )-wl_j) + "$";

                                wl_explode_2 = wl_explode.at(0).split(":",QString::KeepEmptyParts);

                                wl_int_004 = 1;

                                while ( wl_int_004 < wl_explode.count() )
                                {
                                    wl_str_002 = wl_str_002 + wl_explode.at(wl_int_004) + "$";
                                    wl_int_004++;
                                }

                                int sens = pntmygl->f_load_exif(tab_dia_string[wl_int_002]);

                                pntmygl->tab_save_diapo[nbre_diapos][wl_int_003-2] = tab_dia_string[wl_int_002] + "$" + QString::number(wl_img.width()) + "$" + QString::number(wl_img.height()) + "$" + wl_str_001 + "$0:" + wl_explode.at(0) + "$" + wl_explode_2.at(2) + "$" +wl_explode_2.at(1) + "$0/0/0/0$" + QString::number(sens) + "$" + wl_str_002; // + "$1.0";$
                            }
                            else
                            {
                                wl_explode = wl_exp.at(wl_int_003).split("$",QString::SkipEmptyParts);

                                wl_str_001 =  wl_explode.at(0).mid(wl_explode.at(0).lastIndexOf( ":" )+1,wl_explode.at(0).length()-(wl_explode.at(0).lastIndexOf( ":" )+1));
                                wl_str_001.replace(QString("underscore"), QString("_"));

                                wl_i = 0;
                                wl_j = 0;
                                while ( wl_i < 3 )
                                {
                                    if ( wl_explode.at(0).mid(wl_j,1) == ":" )
                                    {
                                        wl_i++;
                                    }
                                    wl_j++;
                                }

                                wl_str_002 = wl_explode.at(0).mid(wl_j,wl_explode.at(0).lastIndexOf( ":" )-wl_j) + "$";

                                wl_explode_2 = wl_explode.at(0).split(":",QString::KeepEmptyParts);

                                wl_int_004 = 1;

                                while ( wl_int_004 < wl_explode.count() )
                                {
                                    wl_str_002 = wl_str_002 + wl_explode.at(wl_int_004) + "$";
                                    wl_int_004++;
                                }

                                //int sens = pntmygl->f_load_exif(tab_dia_string[wl_int_002]);

                                pntmygl->tab_save_diapo[nbre_diapos][wl_int_003-2] = tab_dia_string[wl_int_002] + "$720$576$" + wl_str_001 + "$0:" + wl_explode.at(0) + "$" + wl_explode_2.at(2) + "$" +wl_explode_2.at(1) + "$0/0/0/0$0$" + wl_str_002; // + "$1.0";$
                            }
                            wl_int_002++;
                        }
                        else
                        {
                            wl_explode = wl_exp.at(wl_int_003).split("$",QString::SkipEmptyParts);

                            wl_str_001 =  wl_explode.at(0).mid(wl_explode.at(0).lastIndexOf( ":" )+1,wl_explode.at(0).length()-(wl_explode.at(0).lastIndexOf( ":" )+1));
                            wl_str_001.replace(QString("underscore"), QString("_"));

                            wl_i = 0;
                            wl_j = 0;
                            while ( wl_i < 3 )
                            {
                                if ( wl_explode.at(0).mid(wl_j,1) == ":" )
                                {
                                    wl_i++;
                                }
                                wl_j++;
                            }

                            wl_str_002 = wl_explode.at(0).mid(wl_j,wl_explode.at(0).lastIndexOf( ":" )-wl_j) + "$";

                            wl_explode_2 = wl_explode.at(0).split(":",QString::KeepEmptyParts);

                            wl_int_004 = 1;

                            while ( wl_int_004 < wl_explode.count() )
                            {
                                wl_str_002 = wl_str_002 + wl_explode.at(wl_int_004) + "$";
                                wl_int_004++;
                            }

                            pntmygl->tab_save_diapo[nbre_diapos][wl_int_003-2] = "NULL$1024$1024$" + wl_str_001 + "$0:" + wl_explode.at(0) + "$" + wl_explode_2.at(2) + "$" + wl_explode_2.at(1) + "$0/0/0/0$0$" + wl_str_002; // + "$1.0";$
                        }
                        pb_holy->setValue(pb_holy->value()+1);
                        pb_holy->repaint();
                    }
                }

                pntmygl->tab_save_diapo[nbre_diapos][wl_int_003-2] = "$#$";

                if ( wl_img_texture.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/3d/" + nameth + ".jpg") == true )
                {
                    pntmygl->tab_save_diapo[nbre_diapos][wl_int_003] = QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/3d/" + nameth + ".jpg";
                }
                else
                {
                    pntmygl->tab_save_diapo[nbre_diapos][wl_int_003] = "0:0:0";
                }

                if ( tr_diapauto_ran->isChecked() == true )
                {
                    wl_random_value = rand()%(nombre_transitions);
                    if ( wl_random_value < 1 )
                    {
                        wl_random_value = 1;
                    }
                    wl_str_003 = lst_trans_smile->itemText(wl_random_value);
                }
                else
                {
                    if ( tr_diapauto_non->isChecked() == true )
                    {
                        wl_str_003 = "";
                    }
                    else
                    {
                        wl_str_003 = combo_pardiapauto_trans->currentText();
                    }
                }

                pntmygl->tab_save_diapo[nbre_diapos][wl_int_003-1] = wl_exp.at(1);
                pntmygl->tab_save_diapo[nbre_diapos][wl_int_003+1] = wl_str_003 + "}1";
                pntmygl->tab_save_diapo[nbre_diapos][wl_int_003+2] = wl_exp.at(2);
                pntmygl->tab_save_diapo[nbre_diapos][wl_int_003+3] = "0:220:220:220:0:500:50:0";

                nbre_diapos++;
            }
            timeline_diapo->max_diapo = nbre_diapos;
        }
        frame_holy->hide();

        f_recalc_length_audio();
        timeline_diapo->repaint();
        screen_timeline->repaint();

        if ( (nbre_diapos*70) > timeline_diapo->width() )
        {
            timeline_diapo->setGeometry(timeline_diapo->geometry().x(),0,nbre_diapos*70,timeline_diapo->height());
            scroll_timeline_smile->setMaximum(timeline_diapo->width()-frame_support_timeline->width());
            
            if ( myeffect_global->opacity() < 1.0 )
            {
                QPropertyAnimation *animation = new QPropertyAnimation(myeffect_global, "opacity");
                animation->setDuration(500);
                animation->setStartValue(qreal(myeffect_global->opacity()));
                animation->setEndValue(qreal(1.0));
                animation->start();
            }
        }

        smenuBar->setEnabled(true);

        mask_interface->hide();
}

void mainfrm::f_dial_smile_light(int)
{
    if ( must_update == 1 )
    {
        if ( pntmygl->tab_diapo[pntmygl->num_select][0] != "NULL"  )
        {
            pntmygl->tab_diapo[pntmygl->num_select][4] = QString::number(dial_smile_light->value()) + ":" + QString::number(dial_smile_contrast->value());
            pntmygl->f_reload_img(pntmygl->num_select);
            pntmygl->updateGL();
        }
    }
}

void mainfrm::f_slider_slide_color(int)
{
    if ( must_update == 1 )
    {
        if ( pntmygl->tab_diapo[pntmygl->num_select][0] != "NULL"  )
        {
            pntmygl->tab_coo[pntmygl->num_select][12] = slider_slide_red->value();
            pntmygl->tab_coo[pntmygl->num_select][13] = slider_slide_green->value();
            pntmygl->tab_coo[pntmygl->num_select][14] = slider_slide_blue->value();
            pntmygl->updateGL();
        }
    }
}

void mainfrm::f_slider_slide_chsize(int)
{
    if ( must_update == 1 )
    {
        if ( pntmygl->tab_diapo[pntmygl->num_select][0] != "NULL"  )
        {
            pntmygl->tab_coo[pntmygl->num_select][3] = slider_size_x_scale->value();
            pntmygl->tab_coo[pntmygl->num_select][4] = slider_size_y_scale->value();
            pntmygl->tab_coo[pntmygl->num_select][15] = slider_size_x_scale_2->value();
            pntmygl->tab_coo[pntmygl->num_select][16] = slider_size_y_scale_2->value();
            pntmygl->updateGL();
        }
    }
}

void mainfrm::f_dial_smile_contraste(int)
{
    if ( must_update == 1 )
    {
        pntmygl->tab_diapo[pntmygl->num_select][4] = QString::number(dial_smile_light->value()) + ":" + QString::number(dial_smile_contrast->value());
        pntmygl->f_reload_img(pntmygl->num_select);
        pntmygl->updateGL();
    }
}

void mainfrm::f_load_diapo(int num_diapo)
{
    lst_calques->clear();
    // *** DEPLACEMENT POINTEUR EDITION ***
    hdl_current_diapo->is_edit = 0;
    hdl_current_diapo->repaint();
    // *** NETTOYAGE DE L'ACCUM BUFFER ***
    pntmygl->f_netbuf();
    pntmygl->f_init_tabcoo();
    pntmygl->f_net_video();

    int wl_int_001 = 1;
    int wl_int_002 = 0;
    int wl_int_003 = 0;
    int wl_int_004 = 0;

    if ( pntmygl->back_color.right(4) == ".avi" || pntmygl->back_color.right(4) == ".AVI" || pntmygl->back_color.right(4) == ".mpg" || pntmygl->back_color.right(4) == ".MPG" || pntmygl->back_color.right(5) == ".MPEG" || pntmygl->back_color.right(5) == ".mpeg" || pntmygl->back_color.right(4) == ".mp4" || pntmygl->back_color.right(4) == ".MP4" )
    {
        pntmygl->wg_tabvid[20]->delete_videowrapper();
        delete pntmygl->wg_tabvid[20];
        pntmygl->wg_tabvid[20] = 0;
    }

    if ( player_isplaying == false && isrendering != 1 )
    {
        while ( pntmygl->tab_save_diapo[num_diapo][wl_int_001] != "$#$" )
        {
            wl_int_001++;
        }

        load_diapo_pb->setMaximum(wl_int_001-1);

        load_diapo_pb->setValue(0);
        QPixmap wl_pix_001(this->width(),this->height());
        wl_pix_001.fill(QColor(0,0,0,240));
        mask_interface->setPixmap(wl_pix_001);
        mask_interface->show();
        mask_interface->raise();
        frame_load_diapo->show();
        frame_load_diapo->raise();
        qApp->processEvents();

        wl_int_001 = 1;
    }

    int oldnum;
    pntmygl->wg_nb_cube = 0;
    QStringList wg_str_002;
    QStringList wg_str_003;
    QStringList wl_explode;
    QImage wl_puis_001(1024,1024,QImage::Format_ARGB32_Premultiplied);
    QImage wl_img_texture;
    QImage f;
    QImage wl_image_2;
    QPainter p;
    QPainter g;
    QFont myfont;
    QString wl_myfic;
    QString wl_str_001;
    QImage wl_over_mask;
    myfont.setPixelSize ( 400 );

    pntmygl->must_update = 0;

    linxtxtslide->setText("");
    bt_bold_txtslide->setChecked(false);
    bt_italic_txtslide->setChecked(false);
    bt_underline_txtslide->setChecked(false);

    linxtxtslide->setDisabled(true);
    bt_bold_txtslide->setDisabled(true);
    bt_italic_txtslide->setDisabled(true);
    bt_underline_txtslide->setDisabled(true);

    pntmygl->must_update = 1;
    pntmygl->nombre_diapos = 0;
    while ( pntmygl->tab_save_diapo[num_diapo][wl_int_001] != "$#$" )
    {
        wg_str_002 = pntmygl->tab_save_diapo[num_diapo][wl_int_001].split("$",QString::KeepEmptyParts); //QString::SkipEmptyParts); //  QString::KeepEmptyParts);

        pntmygl->tab_diapo[wl_int_002+1][0] =  wg_str_002.at(0);
        pntmygl->tab_diapo[wl_int_002+1][1] =  wg_str_002.at(1);
        pntmygl->tab_diapo[wl_int_002+1][2] =  wg_str_002.at(2);
        pntmygl->tab_diapo[wl_int_002+1][3] =  wg_str_002.at(3);
        pntmygl->tab_diapo[wl_int_002+1][4] =  wg_str_002.at(4);
        pntmygl->tab_diapo[wl_int_002+1][5] =  wg_str_002.at(5);
        pntmygl->tab_diapo[wl_int_002+1][6] =  wg_str_002.at(6);
        pntmygl->tab_diapo[wl_int_002+1][7] =  wg_str_002.at(7);
        pntmygl->tab_diapo[wl_int_002+1][8] =  wg_str_002.at(8);

        if ( pntmygl->tab_diapo[wl_int_002+1][0].mid(0,1) != "?" || pntmygl->tab_diapo[wl_int_002+1][0].mid(0,1) == "?9" )
        {
            if ( pntmygl->tab_diapo[wl_int_002+1][1].toInt() > pntmygl->sm_mxw || pntmygl->tab_diapo[wl_int_002+1][2].toInt() > pntmygl->sm_mxw )
            {
                if ( pntmygl->tab_diapo[wl_int_002+1][1].toInt() > pntmygl->tab_diapo[wl_int_002+1][2].toInt() )
                {
                    oldnum = pntmygl->tab_diapo[wl_int_002+1][1].toInt() / pntmygl->sm_mxw;
                    pntmygl->tab_diapo[wl_int_002+1][1] = QString::number(pntmygl->tab_diapo[wl_int_002+1][1].toInt() / oldnum);
                    pntmygl->tab_diapo[wl_int_002+1][2] = QString::number(pntmygl->tab_diapo[wl_int_002+1][2].toInt() / oldnum);
                }
                else
                {
                    oldnum = pntmygl->tab_diapo[wl_int_002+1][2].toInt() / pntmygl->sm_mxw;
                    pntmygl->tab_diapo[wl_int_002+1][1] = QString::number(pntmygl->tab_diapo[wl_int_002+1][1].toInt() / oldnum);
                    pntmygl->tab_diapo[wl_int_002+1][2] = QString::number(pntmygl->tab_diapo[wl_int_002+1][2].toInt() / oldnum);
                }
            }
            else
            {
                if ( pntmygl->tab_diapo[wl_int_002+1][1].toInt() < pntmygl->sm_mxw && pntmygl->tab_diapo[wl_int_002+1][2].toInt() < pntmygl->sm_mxw )
                {
                    if ( pntmygl->tab_diapo[wl_int_002+1][1].toInt() > pntmygl->tab_diapo[wl_int_002+1][2].toInt() )
                    {
                        oldnum = pntmygl->sm_mxw / pntmygl->tab_diapo[wl_int_002+1][1].toInt();
                        pntmygl->tab_diapo[wl_int_002+1][1] = QString::number(pntmygl->tab_diapo[wl_int_002+1][1].toInt() * oldnum);
                        pntmygl->tab_diapo[wl_int_002+1][2] = QString::number(pntmygl->tab_diapo[wl_int_002+1][2].toInt() * oldnum);
                    }
                    else
                    {
                        oldnum = pntmygl->sm_mxw / pntmygl->tab_diapo[wl_int_002+1][2].toInt();
                        pntmygl->tab_diapo[wl_int_002+1][1] = QString::number(pntmygl->tab_diapo[wl_int_002+1][1].toInt() * oldnum);
                        pntmygl->tab_diapo[wl_int_002+1][2] = QString::number(pntmygl->tab_diapo[wl_int_002+1][2].toInt() * oldnum);
                    }
                }
            }
        }

        // *** CHARGEMENT DE LA TEXTURE ***

        if ( pntmygl->tab_diapo[wl_int_002+1][0] != "NULL" )
        {
            if ( wl_img_texture.load(pntmygl->tab_diapo[wl_int_002+1][0]) || pntmygl->tab_diapo[wl_int_002+1][0].mid(0,2) == "?9" || pntmygl->tab_diapo[wl_int_002+1][0].mid(0,2) == "?5" )
            {
                if ( pntmygl->tab_diapo[wl_int_002+1][0].mid(0,2) == "?9" )
                {
                    oldnum = pntmygl->num_select;
                    pntmygl->num_select = wl_int_002+1;
                    pntmygl->f_reload_text();
                    pntmygl->num_select = oldnum;
                }
                else
                {
                    pntmygl->f_reload_img(wl_int_002+1);

                    if ( pntmygl->tab_diapo[wl_int_002+1][0].right(4) == ".gif" || pntmygl->tab_diapo[wl_int_002+1][0].right(4) == ".GIF" )
                    {
                        pntmygl->tabgif[wl_int_002+1].setFileName(pntmygl->tab_diapo[wl_int_002+1][0]);
                        pntmygl->tabgif[wl_int_002+1].setCacheMode( QMovie::CacheAll );
                        pntmygl->tabgif[wl_int_002+1].jumpToFrame( 0 );
                    }
                }
            }
            else
            {
                if ( pntmygl->tab_diapo[wl_int_002+1][0].mid(0,1) != "?" )
                {
                    if ( pntmygl->tab_diapo[wl_int_002+1][0].right(4) == ".avi" || pntmygl->tab_diapo[wl_int_002+1][0].right(4) == ".AVI" || pntmygl->tab_diapo[wl_int_002+1][0].right(4) == ".mpg" || pntmygl->tab_diapo[wl_int_002+1][0].right(4) == ".MPG" || pntmygl->tab_diapo[wl_int_002+1][0].right(5) == ".MPEG" || pntmygl->tab_diapo[wl_int_002+1][0].right(5) == ".mpeg" || pntmygl->tab_diapo[wl_int_002+1][0].right(4) == ".mp4" || pntmygl->tab_diapo[wl_int_002+1][0].right(4) == ".MP4" )
                    {
                        videowrapper *hdlw = new videowrapper();
                        pntmygl->wg_tabvid[wl_int_002+1] = hdlw;


                        int result = hdlw->load_video(pntmygl->tab_diapo[wl_int_002+1][0]);
                        if ( result == 0 )
                        {
                            pntmygl->f_reload_img(wl_int_002+1);
                        }
                        else
                        {
                            qDebug() << "ERROR RELOADING VIDEO FILE : " << pntmygl->tab_diapo[wl_int_002+1][0];
                        }
                    }
                    else
                    {
                        pntmygl->tab_diapo[wl_int_002+1][0] = "NULL";
                        p.begin(&wl_puis_001);
                        p.setBrush(QColor(50,50,50));
                        p.setPen(QColor(20,20,20));
                        p.drawRect(0,0,1024,1024);
                        p.setFont(myfont);
                        p.setPen(QColor(255,255,255));
                        p.drawText(QRect(0,0,1024,1024), Qt::AlignCenter,QString::number(wl_int_002+1));
                        p.end();

                        if ( pntmygl->tab_diapo[wl_int_002+1][3] != "" )
                        {
                            wl_explode = pntmygl->tab_diapo[wl_int_002+1][3].split("%*",QString::KeepEmptyParts);

                            wl_image_2.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wl_explode.at(0)+".png");
                            wl_image_2 = wl_image_2.scaled(wl_puis_001.width(),wl_puis_001.height());
                            wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                            wl_puis_001 = wl_puis_001.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                            QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                            g.begin(&wl_puis_001);
                            g.setCompositionMode ( mode );
                            g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                            wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wl_explode.at(0) + ".png";

                            if ( wl_over_mask.load(wl_str_001) == true )
                            {
                                wl_over_mask = wl_over_mask.scaled(wl_puis_001.width(),wl_puis_001.height());

                                wl_over_mask = pntmygl->f_mutation_overmask(wl_over_mask,wl_explode.at(1) + "%*" + wl_explode.at(2) + "%*" + wl_explode.at(3) + "%*" + wl_explode.at(4) );

                                wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                                g.setCompositionMode ( (QPainter::CompositionMode)0 );
                                g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                            }

                            g.end();
                        }

                        pntmygl->wg_table_photo[wl_int_002+1] = wl_puis_001;

                        f = QGLWidget::convertToGLFormat( wl_puis_001 );

                        glDeleteTextures(1, &pntmygl->texture_diapo[wl_int_002+1] );
                        glGenTextures (1,&pntmygl->texture_diapo[wl_int_002+1]);
                        glBindTexture (GL_TEXTURE_2D, pntmygl->texture_diapo[wl_int_002+1]);

                        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                        glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                        glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                                      0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
                    }
                }
                else
                {
                    if ( pntmygl->tab_diapo[wl_int_002+1][0].mid(0,2) == "?6" )
                    {
                        wg_str_003 = pntmygl->tab_diapo[wl_int_002+1][0].split(")(",QString::SkipEmptyParts); //QString::SkipEmptyParts); //  QString::KeepEmptyParts);
                        wl_int_004 = 0;

                        pntmygl->wg_nb_cube = 1;

                        while ( wl_int_004 < 6 && wl_int_004 < wg_str_003.count() )
                        {
                            wl_myfic = wg_str_003.at(wl_int_004);

                            if ( wl_int_004 == 0 )
                            {
                                wl_myfic = wl_myfic.mid(2,wl_myfic.length()-2);
                            }

                            if ( wl_img_texture.load(wl_myfic) == true )
                            {
                                if ( wl_img_texture.width() < wl_img_texture.height() )
                                {
                                    wl_img_texture = wl_img_texture.scaledToWidth(pntmygl->sm_mxw,Qt::SmoothTransformation);
                                }
                                else
                                {
                                    wl_img_texture = wl_img_texture.scaledToHeight(pntmygl->sm_mxw,Qt::SmoothTransformation);
                                }

                                pntmygl->wg_table_photo[wl_int_002+1] = wl_img_texture;

                                wl_puis_001 = wl_img_texture.copy ( 0, 0, pntmygl->sm_mxw, pntmygl->sm_mxw);

                                f = QGLWidget::convertToGLFormat( wl_puis_001 );

                                glDeleteTextures (1,&pntmygl->texture_diapo_cube[wl_int_004]);
                                glGenTextures (1,&pntmygl->texture_diapo_cube[wl_int_004]);
                                glBindTexture (GL_TEXTURE_2D, pntmygl->texture_diapo_cube[wl_int_004]);

                                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
                                glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

                                glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                                              0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
                            }
                            else
                            {
                                qDebug() << "ERROR LOADING PHOTO FOR CUBE : " << wl_myfic;
                            }
                            wl_int_004++;
                        }
                    }
                }
            }
        }
        else
        {
            p.begin(&wl_puis_001);
            p.setBrush(QColor(50,50,50));
            p.setPen(QColor(20,20,20));
            p.drawRect(0,0,1024,1024);
            p.setFont(myfont);
            p.setPen(QColor(255,255,255));
            p.drawText(QRect(0,0,1024,1024), Qt::AlignCenter,QString::number(wl_int_002+1));
            p.end();

            if ( pntmygl->tab_diapo[wl_int_002+1][3] != "" )
            {
                wl_explode = pntmygl->tab_diapo[wl_int_002+1][3].split("%*",QString::KeepEmptyParts);

                wl_image_2.load(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Masks/"+wl_explode.at(0)+".png");
                wl_image_2 = wl_image_2.scaled(wl_puis_001.width(),wl_puis_001.height());
                wl_image_2 = wl_image_2.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                wl_puis_001 = wl_puis_001.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied

                QPainter::CompositionMode mode = (QPainter::CompositionMode)6;

                g.begin(&wl_puis_001);
                g.setCompositionMode ( mode );
                g.drawImage(QRect(0,0,-1,-1),wl_image_2);

                wl_str_001 = QDir::homePath() + "/.2ManDVD_Library/"  + "/Bibliotheque/Masks/2t_" + wl_explode.at(0) + ".png";

                if ( wl_over_mask.load(wl_str_001) == true )
                {
                    wl_over_mask = wl_over_mask.scaled(wl_puis_001.width(),wl_puis_001.height());

                    wl_over_mask = pntmygl->f_mutation_overmask(wl_over_mask,wl_explode.at(1) + "%*" + wl_explode.at(2) + "%*" + wl_explode.at(3) + "%*" + wl_explode.at(4) );

                    wl_over_mask = wl_over_mask.convertToFormat ( QImage::Format_ARGB32, Qt::AutoColor ); //_Premultiplied
                    g.setCompositionMode ( (QPainter::CompositionMode)0 );
                    g.drawImage(QRect(0,0,-1,-1),wl_over_mask);
                }

                g.end();
            }

            pntmygl->wg_table_photo[wl_int_002+1] = wl_puis_001;

            f = QGLWidget::convertToGLFormat( wl_puis_001 );

            glDeleteTextures(1, &pntmygl->texture_diapo[wl_int_002+1] );
            glGenTextures (1,&pntmygl->texture_diapo[wl_int_002+1]);
            glBindTexture (GL_TEXTURE_2D, pntmygl->texture_diapo[wl_int_002+1]);

            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
            glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

            glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, f.width(), f.height(),
                          0, GL_RGBA, GL_UNSIGNED_BYTE, f.bits());
        }
        pntmygl->nombre_diapos++;
        f_add_diapo_signal();
        wl_int_003 = 0;
        for (int i = 9; i < wg_str_002.size()-1; ++i)
        {
            pntmygl->tab_coo_timeline[wl_int_002+1][wl_int_003] = wg_str_002.at(i);
            wl_int_003++;
        }
        while ( wl_int_003 < 20 )
        {
            pntmygl->tab_coo_timeline[wl_int_002+1][wl_int_003] = "";
            wl_int_003++;
        }

        load_diapo_pb->setValue(wl_int_001);
        qApp->processEvents();

        wl_int_001++;
        wl_int_002++;       
    }
    hdl_current_diapo = table_hdl_diapo[num_diapo];
    hdl_current_diapo->is_edit = 1;
    hdl_current_diapo->repaint();
    pntmygl->length_diapo = pntmygl->tab_save_diapo[num_diapo][wl_int_001+1].toInt();
    pntmygl->back_color = pntmygl->tab_save_diapo[num_diapo][wl_int_001+2];

    wg_str_003 = pntmygl->tab_save_diapo[num_diapo][wl_int_001+3].split("}",QString::KeepEmptyParts);

    pntmygl->str_trans = wg_str_003.at(0);

    if ( wg_str_003.count() > 1 )
    {
        pntmygl->lgt_trans = wg_str_003.at(1).toInt();
    }
    else
    {
        pntmygl->lgt_trans = 1;
    }

    spintrandur->setValue(pntmygl->lgt_trans);

    if ( num_diapo+1 < nbre_diapos )
    {
        int wl_int_999 = 0;
        while ( pntmygl->tab_save_diapo[num_diapo+1][wl_int_999] != "$#$" )
        {
            wl_int_999++;
        }

        wg_str_003 = pntmygl->tab_save_diapo[num_diapo+1][wl_int_999+3].split("}",QString::KeepEmptyParts);

        if ( wg_str_003.count() > 1 )
        {
            pntmygl->lgt_trans_old = wg_str_003.at(1).toInt();
        }
        else
        {
            pntmygl->lgt_trans_old = 1;
        }
    }
    else
    {
        pntmygl->lgt_trans_old = 0;
    }
    pntmygl->is_mblur = pntmygl->tab_save_diapo[num_diapo][wl_int_001+4].toInt();

    must_update = 0;

    if ( pntmygl->str_trans != wg_str_int_004 && pntmygl->str_trans != "" )
    {
        lst_trans_smile->setCurrentIndex(lst_trans_smile->findText(pntmygl->str_trans,Qt::MatchExactly | Qt::MatchCaseSensitive));
    }
    else
    {
        lst_trans_smile->setCurrentIndex(0);
    }
    must_update = 1;
    wl_explode = pntmygl->tab_save_diapo[num_diapo][wl_int_001+5].split(":",QString::KeepEmptyParts);
    if ( pntmygl->tab_save_diapo[num_diapo][wl_int_001+5].mid(0,1) != "0" )
    {
        pntmygl->is_fog = wl_explode.at(0).toInt();
        pntmygl->fog_red = wl_explode.at(1).toInt();
        pntmygl->fog_green = wl_explode.at(2).toInt();
        pntmygl->fog_blue = wl_explode.at(3).toInt();

        pntmygl->is_fog = 2;

        pntwheel9->setColor(pntmygl->fog_red,pntmygl->fog_green,pntmygl->fog_blue);
    }
    else
    {
        pntmygl->is_fog = 0;
    }
    pntmygl->is_flakes = wl_explode.at(4).toInt();
    pntmygl->nbre_flakes = wl_explode.at(5).toInt();
    pntmygl->size_flakes = wl_explode.at(6).toInt();
    pntmygl->type_flakes = wl_explode.at(7).toInt();

    chk_flakes->setChecked(pntmygl->is_flakes);

    if ( pntmygl->is_flakes < 2 )
    {
        combo_tflakes->setDisabled(true);
    }
    else
    {
        combo_tflakes->setEnabled(true);
    }
    sl_part_nombre->setValue(pntmygl->nbre_flakes);
    sl_part_size->setValue(pntmygl->size_flakes);
    combo_tflakes->setCurrentIndex(pntmygl->type_flakes);

    pntmygl->f_flakes_type_changed(pntmygl->type_flakes);

    dial_smile_light->setDisabled(true);
    dial_smile_contrast->setDisabled(true);
    slider_blur_img->setDisabled(true);
    slider_opa_slide->setDisabled(true);

    slider_slide_red->setDisabled(true);
    slider_slide_green->setDisabled(true);
    slider_slide_blue->setDisabled(true);
    slider_size_x_scale->setDisabled(true);
    slider_size_y_scale->setDisabled(true);
    slider_size_x_scale_2->setDisabled(true);
    slider_size_y_scale_2->setDisabled(true);

    f_load_back();

    if ( player_isplaying == false && isrendering != 1 )
    {
        frame_load_diapo->hide();
        mask_interface->hide();
    }
}

void mainfrm::f_effect_run(int lumi, int cont)
{
        QColor trtcolor;
        trtcolor.setRed(0);
        trtcolor.setGreen(0);
        trtcolor.setBlue(0);
        trtcolor.setAlpha(0);

        int rouge = 0;
        int vert = 0;
        int bleu = 0;
        int valueadd_R = 0;
        int valueadd_V = 0;
        int valueadd_B = 0;

        QRgb srcPixel;

        int h;
        int s;
        int v;
        int a;

        //int opacity;

        wg_img_smile_effect = wg_img_smile_effect.convertToFormat(QImage::Format_ARGB32_Premultiplied, Qt::AutoColor);

        for (int y = 0; y < wg_img_smile_effect.height(); y++)
        {
                for (int x = 0; x < wg_img_smile_effect.width(); x++)
                {
                        srcPixel = wg_img_smile_effect.pixel(x, y);
                        trtcolor = srcPixel;
                        //
                        if (qAlpha(srcPixel) > 10 )
                        {
                                //
                                valueadd_R = lumi + rouge;
                                valueadd_V = lumi + vert;
                                valueadd_B = lumi + bleu;
                                //

                                if ( valueadd_R > 0 )
                                {
                                        if ( trtcolor.red() < 255 - valueadd_R)
                                        {
                                                trtcolor.setRed(trtcolor.red() + valueadd_R);
                                        }
                                        else
                                        {
                                                trtcolor.setRed(255);
                                        }
                                }
                                else
                                {
                                        if ( trtcolor.red() > (valueadd_R*-1))
                                        {
                                                trtcolor.setRed(trtcolor.red() + valueadd_R);
                                        }
                                        else
                                        {
                                                trtcolor.setRed(0);
                                        }
                                }

                                if ( valueadd_V > 0 )
                                {
                                        if ( trtcolor.green() < 255 - valueadd_V)
                                        {
                                                trtcolor.setGreen(trtcolor.green() + valueadd_V);
                                        }
                                        else
                                        {
                                                trtcolor.setGreen(255);
                                        }
                                }
                                else
                                {
                                        if ( trtcolor.green() > (valueadd_V*-1))
                                        {
                                                trtcolor.setGreen(trtcolor.green() + valueadd_V);
                                        }
                                        else
                                        {
                                                trtcolor.setGreen(0);
                                        }
                                }

                                if ( valueadd_B > 0 )
                                {
                                        if ( trtcolor.blue() < 255 - valueadd_B)
                                        {
                                                trtcolor.setBlue(trtcolor.blue() + valueadd_B);
                                        }
                                        else
                                        {
                                                trtcolor.setBlue(255);
                                        }
                                }
                                else
                                {
                                        if ( trtcolor.blue() > (valueadd_B*-1))
                                        {
                                                trtcolor.setBlue(trtcolor.blue() + valueadd_B);
                                        }
                                        else
                                        {
                                                trtcolor.setBlue(0);
                                        }
                                }
                                //
                                trtcolor.setAlpha(255);

                                trtcolor.getHsv(&h, &s, &v, &a);

                                trtcolor.setHsv(h,(cont*s)/255,v,a);

                                wg_img_smile_effect.setPixel(x, y, trtcolor.rgba());
                        }
                }
        }
}

void mainfrm::f_switch_coo_diapo()
{
    if ( frame_coorsmile->height() < 1 )
    {
        frame_coorsmile->raise();
        QPropertyAnimation *animation = new QPropertyAnimation(frame_coorsmile, "geometry");
        animation->setDuration(500);
        animation->setStartValue(QRect(frame_coorsmile->geometry().x(),frame_coorsmile->geometry().y(),frame_coorsmile->width(),frame_coorsmile->height()));
        animation->setEndValue(QRect(0,frame_coorsmile->geometry().y()-160,frame_coorsmile->width(),160));
        animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();
    }
    else
    {
        QPropertyAnimation *animation = new QPropertyAnimation(frame_coorsmile, "geometry");
        animation->setDuration(500);
        animation->setStartValue(QRect(frame_coorsmile->geometry().x(),frame_coorsmile->geometry().y(),frame_coorsmile->width(),frame_coorsmile->height()));
        animation->setEndValue(QRect(0,frame_coorsmile->geometry().y()+160,frame_coorsmile->width(),0));
        animation->setEasingCurve(QEasingCurve::InOutCubic);
        animation->start();
    }
}

void mainfrm::f_s_delete_position(int pos)
{
    pntmygl->f_mark_del(pos);
    f_display_mark_on_timeline(pntmygl->num_select);
}

void mainfrm::f_add_diapo_signal()
{
    QListWidgetItem *loc_item = new QListWidgetItem(lst_calques);

    if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0] != "NULL" && pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(0,1) != "?" )
    {
        if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].right(4) == ".avi" || pntmygl->tab_diapo[pntmygl->nombre_diapos][0].right(4) == ".AVI" || pntmygl->tab_diapo[pntmygl->nombre_diapos][0].right(4) == ".mpg" || pntmygl->tab_diapo[pntmygl->nombre_diapos][0].right(4) == ".MPG" || pntmygl->tab_diapo[pntmygl->nombre_diapos][0].right(5) == ".MPEG" || pntmygl->tab_diapo[pntmygl->nombre_diapos][0].right(5) == ".mpeg" || pntmygl->tab_diapo[pntmygl->nombre_diapos][0].right(4) == ".mp4" || pntmygl->tab_diapo[pntmygl->nombre_diapos][0].right(4) == ".MP4" )
        {
            pntmygl->wg_tabvid[pntmygl->nombre_diapos]->oldimg.save(path_project+"/.x1.jpg","JPEG");
            loc_item->setIcon(QIcon(path_project+"/.x1.jpg"));
        }
        else
        {
            loc_item->setIcon(QIcon(pntmygl->tab_diapo[pntmygl->nombre_diapos][0]));
        }
    }
    else
    {
        if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(0,1) != "?" )
        {
            loc_item->setIcon(QIcon(":/Interface/Interface/theme.png"));
        }
        else
        {
            if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(1,1) == "1" )
            {
                loc_item->setIcon(QIcon(":/Interface/Interface/cr.png"));
            }
            if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(1,1) == "2" )
            {
                loc_item->setIcon(QIcon(":/Interface/Interface/cv.png"));
            }
            if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(1,1) == "3" )
            {
                loc_item->setIcon(QIcon(":/Interface/Interface/cb.png"));
            }
            if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(1,1) == "4" )
            {
                loc_item->setIcon(QIcon(":/Interface/Interface/cw.png"));
            }
            if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(1,1) == "5" )
            {
                loc_item->setIcon(QIcon(":/Interface/Interface/snowman.png"));
            }
            if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(1,1) == "6" )
            {
                loc_item->setIcon(QIcon(":/Interface/Interface/cube.png"));
            }
            if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(1,1) == "7" )
            {
                loc_item->setIcon(QIcon(":/Interface/Interface/Earth-icon.png"));
            }
            if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(1,1) == "8" )
            {
                loc_item->setIcon(QIcon(":/Interface/Interface/plane.png"));
            }
            if ( pntmygl->tab_diapo[pntmygl->nombre_diapos][0].mid(1,1) == "9" )
            {
                loc_item->setIcon(QIcon(":/Interface/Interface/subtitle.png"));
            }
        }
    }

    loc_item->setText(tr("Image ") + " " + QString::number(pntmygl->nombre_diapos));
    loc_item->setFlags(loc_item->flags() | Qt::ItemIsUserCheckable);
    loc_item->setCheckState(Qt::Checked);

    pntmygl->tab_msk[pntmygl->nombre_diapos] = true;
}

void mainfrm::f_chk_calq(QListWidgetItem* myitem)
{

    int wl_int_001 = 0;

    QListWidgetItem *clqtxt = new QListWidgetItem;
    clqtxt = myitem;

    wl_int_001 = clqtxt->text().lastIndexOf( " " );

    if (wl_int_001 != -1)
    {
        QString wl_str_001 = clqtxt->text().mid(wl_int_001+1,clqtxt->text().length()-(wl_int_001+1));

        if ( clqtxt->checkState() == 0 )
        {
            pntmygl->tab_msk[wl_str_001.toInt()] = false;
            pntmygl->num_select = 0;
        }
        else
        {
            pntmygl->tab_msk[wl_str_001.toInt()] = true;
            pntmygl->num_select = wl_str_001.toInt();
        }

        pntmygl->updateGL();
    }
}

void mainfrm::f_s_delete_diapo(int num)
{
    lst_calques->removeItemWidget(lst_calques->item(num-1));
    lst_calques->takeItem(num-1);

    int wl_int_001 = num;
    while ( wl_int_001 < pntmygl->nombre_diapos )
    {
        pntmygl->tab_msk[wl_int_001] = pntmygl->tab_msk[wl_int_001+1];
        wl_int_001++;
    }

    f_renum_clq();
    pntmygl->updateGL();
}

void mainfrm::f_delete_image_fc(int nrow)
{
    pntmygl->num_select = nrow;
    pntmygl->f_delete_image();
}

void mainfrm::f_renum_clq()
{

    int wl_int_001 = 0;
    while ( wl_int_001 < lst_calques->count() )
    {
        lst_calques->item(wl_int_001)->setText(tr("Image ") + " " + QString::number(wl_int_001+1));
        wl_int_001++;
    }
}

void mainfrm::f_action_replace(int num)
{
    pntmygl->num_select = num;
    pntmygl->updateGL();
    pntmygl->f_swap_image();
}

void mainfrm::f_action_dupliquer(int num)
{
    pntmygl->num_select = num;
    pntmygl->updateGL();
    pntmygl->f_dupliquer_image();
}

void mainfrm::f_action_ef_image(int)
{
    f_tool_ef_image();
}

void mainfrm::f_update_diapo_signal()
{
    if ( pntmygl->tab_diapo[pntmygl->num_select][0] != "NULL" )
    {
        lst_calques->item(pntmygl->num_select-1)->setIcon(QIcon(pntmygl->tab_diapo[pntmygl->num_select][0]));
        dial_smile_light->setEnabled(true);
        dial_smile_contrast->setEnabled(true);
        slider_blur_img->setEnabled(true);

        slider_slide_red->setEnabled(true);
        slider_slide_green->setEnabled(true);
        slider_slide_blue->setEnabled(true);

        slider_size_x_scale->setEnabled(true);
        slider_size_y_scale->setEnabled(true);
        slider_size_x_scale_2->setEnabled(true);
        slider_size_y_scale_2->setEnabled(true);
    }
    else
    {
        lst_calques->item(pntmygl->num_select-1)->setIcon(QIcon(":/Interface/Interface/theme.png"));
    }
}

void mainfrm::f_select_clq(QListWidgetItem*)
{
    if ( lst_calques->selectedItems().count() < 1 )
    {
        return;
    }

    pntmygl->num_select = lst_calques->currentRow()+1;

    f_display_mark_on_timeline(pntmygl->num_select);

    //pntmygl->updateGL();
}

void mainfrm::f_s_edit_image()
{
    QPixmap wl_pix_001(this->width(),this->height());
    wl_pix_001.fill(QColor(0,0,0,240));
    mask_interface->setPixmap(wl_pix_001);

    if ( wl_pix_001.load(pntmygl->tab_diapo[pntmygl->num_select][0]) == true )
    {
        smenuBar->setDisabled(true);

        mask_interface->show();
        mask_interface->raise();

        if ( pntmygl->tab_diapo[pntmygl->num_select][8] == "1" )
        {
            frame_image_editor->img2resu = wl_pix_001.scaledToWidth( this->height()-50, Qt::SmoothTransformation );
            
            QMatrix matx;
            matx.rotate(-90);
            frame_image_editor->img2resu = frame_image_editor->img2resu.transformed(matx);
        }
        else
        {
            if ( pntmygl->tab_diapo[pntmygl->num_select][8] == "2" )
            {
                frame_image_editor->img2resu = wl_pix_001.scaledToWidth( this->height()-50, Qt::SmoothTransformation );
                
                QMatrix matx;
                matx.rotate(90);
                frame_image_editor->img2resu = frame_image_editor->img2resu.transformed(matx);
            }
            else
            {
                if ( wl_pix_001.width() < wl_pix_001.height() )
                {
                    frame_image_editor->img2resu = wl_pix_001.scaledToHeight( this->height()-50, Qt::SmoothTransformation );
                }
                else
                {
                    frame_image_editor->img2resu = wl_pix_001.scaledToWidth( this->width()-20, Qt::SmoothTransformation );
                }                
            }
        }

        frame_image_editor->setGeometry((this->width()-frame_image_editor->img2resu.width())/2,(this->height()-frame_image_editor->img2resu.height()-smenuBar->height())/2,frame_image_editor->img2resu.width(),frame_image_editor->img2resu.height());

        if ( pntmygl->tab_diapo[pntmygl->num_select][7] == "0/0/0/0" )
        {
            frame_image_editor->startcrop = 3;

            if ( pntmygl->tab_diapo[pntmygl->num_select][8] == "0" )
            {
                crop_ratio_x = (float)wl_pix_001.width()/(float)frame_image_editor->img2resu.width();
                crop_ratio_y = (float)wl_pix_001.height()/(float)frame_image_editor->img2resu.height();
            }
            else
            {
                crop_ratio_y = (float)wl_pix_001.width()/(float)frame_image_editor->img2resu.height();
                crop_ratio_x = (float)wl_pix_001.height()/(float)frame_image_editor->img2resu.width();
            }
        }
        else
        {
            QStringList wl_explode = pntmygl->tab_diapo[pntmygl->num_select][7].split("/",QString::KeepEmptyParts);

            if ( pntmygl->tab_diapo[pntmygl->num_select][8] == "0" )
            {
                crop_ratio_x = (float)wl_pix_001.width()/(float)frame_image_editor->img2resu.width();
                crop_ratio_y = (float)wl_pix_001.height()/(float)frame_image_editor->img2resu.height();
                
                frame_image_editor->crop_dx = wl_explode.at(0).toFloat() / crop_ratio_x;
                frame_image_editor->crop_ex = wl_explode.at(2).toFloat() / crop_ratio_x;
                frame_image_editor->crop_dy = wl_explode.at(1).toFloat() / crop_ratio_y;
                frame_image_editor->crop_ey = wl_explode.at(3).toFloat() / crop_ratio_y;
            }
            else
            {
                crop_ratio_y = (float)wl_pix_001.width()/(float)frame_image_editor->img2resu.height();
                crop_ratio_x = (float)wl_pix_001.height()/(float)frame_image_editor->img2resu.width();

                if ( pntmygl->tab_diapo[pntmygl->num_select][8] == "1" )
                {
                    frame_image_editor->crop_dy = (frame_image_editor->img2resu.height())-(wl_explode.at(0).toFloat() / crop_ratio_x);
                    frame_image_editor->crop_ey = (frame_image_editor->img2resu.height())-(wl_explode.at(2).toFloat() / crop_ratio_x);
                    frame_image_editor->crop_dx = wl_explode.at(1).toFloat() / crop_ratio_y;
                    frame_image_editor->crop_ex = wl_explode.at(3).toFloat() / crop_ratio_y;
                }
                else
                {
                    frame_image_editor->crop_dx = (frame_image_editor->img2resu.width())-(wl_explode.at(1).toFloat() / crop_ratio_y);
                    frame_image_editor->crop_ex = (frame_image_editor->img2resu.width())-(wl_explode.at(3).toFloat() / crop_ratio_y);
                    frame_image_editor->crop_dy = wl_explode.at(0).toFloat() / crop_ratio_x;
                    frame_image_editor->crop_ey = wl_explode.at(2).toFloat() / crop_ratio_x;
                }
            }

            frame_image_editor->startcrop = 4;
        }

        frame_image_editor->show();
        frame_image_editor->raise();
    }
    else
    {
        qDebug() << "ERROR LOADING PICTURE : " << pntmygl->tab_diapo[pntmygl->num_select][0] << " FOR EDITING";
    }
}

void mainfrm::f_s_cancel_image()
{
    frame_image_editor->hide();
    mask_interface->hide();
    smenuBar->setEnabled(true);
}

void mainfrm::f_s_valide_image()
{
    if ( frame_image_editor->crop_dx != 0 || frame_image_editor->crop_ex != 0 || frame_image_editor->crop_dy != 0 || frame_image_editor->crop_ey != 0)
    {
        if ( pntmygl->tab_diapo[pntmygl->num_select][8] == "0" )
        {
            pntmygl->tab_diapo[pntmygl->num_select][7] = QString::number(frame_image_editor->crop_dx*crop_ratio_x) + "/" + QString::number(frame_image_editor->crop_dy*crop_ratio_y) + "/" + QString::number(frame_image_editor->crop_ex*crop_ratio_x) + "/" + QString::number(frame_image_editor->crop_ey*crop_ratio_y);
            //qDebug() << pntmygl->tab_diapo[pntmygl->num_select][7];
        }
        else
        {
            QPixmap wl_pix_001;
            wl_pix_001.load(pntmygl->tab_diapo[pntmygl->num_select][0]);

            float wlx_r = (float)wl_pix_001.width()/(float)frame_image_editor->img2resu.width();
            float wly_r = (float)wl_pix_001.height()/(float)frame_image_editor->img2resu.height();

            //qDebug() << wl_pix_001.width() << " " << wl_pix_001.height() << " " << frame_image_editor->img2resu.width() << " " << frame_image_editor->img2resu.height();

            int w_hdx;
            int w_hdy;
            int w_hex;
            int w_hey;

            if ( pntmygl->tab_diapo[pntmygl->num_select][8] == "1" )
            {
                w_hdx = ((frame_image_editor->img2resu.width()*wlx_r)-(frame_image_editor->crop_dy*crop_ratio_y));
                w_hdy = frame_image_editor->crop_dx*crop_ratio_x;
                w_hex = ((frame_image_editor->img2resu.width()*wlx_r)-(frame_image_editor->crop_ey*crop_ratio_y));
                w_hey = frame_image_editor->crop_ex*crop_ratio_x;
            }
            else
            {
                w_hdx = frame_image_editor->crop_dy*crop_ratio_y;
                w_hdy = ((frame_image_editor->img2resu.height()*wly_r)-(frame_image_editor->crop_dx*crop_ratio_x));
                w_hex = frame_image_editor->crop_ey*crop_ratio_y;
                w_hey = ((frame_image_editor->img2resu.height()*wly_r)-(frame_image_editor->crop_ex*crop_ratio_x));
            }

            int wdx;
            int wdy;
            int wex;
            int wey;

            if ( w_hdx < w_hex )
            {
                wdx = w_hdx;
                wex = w_hex;
            }
            else
            {
                wdx = w_hex;
                wex = w_hdx;
            }

            if ( w_hdy < w_hey )
            {
                wdy = w_hdy;
                wey = w_hey;
            }
            else
            {
                wdy = w_hey;
                wey = w_hdy;
            }


            pntmygl->tab_diapo[pntmygl->num_select][7] = QString::number(wdx) + "/" + QString::number(wdy) + "/" + QString::number(wex) + "/" + QString::number(wey);
        }

        pntmygl->f_reload_img(pntmygl->num_select);
        pntmygl->updateGL();
    }
    else
    {
        pntmygl->tab_diapo[pntmygl->num_select][7] = "0/0/0/0";
        pntmygl->f_reload_img(pntmygl->num_select);
        pntmygl->updateGL();
    }

    frame_image_editor->hide();
    mask_interface->hide();
    smenuBar->setEnabled(true);
}

void mainfrm::f_bt_close_param_render()
{
    smenuBar->setEnabled(true);

    mask_interface->hide();

    frame_choose_encode->hide();
}

void mainfrm::f_bt_start_param_render()
{
    if ( (path_render_smile->text() != "" && frame_path_smile->isEnabled() == true) || frame_path_smile->isEnabled() == false )
    {
        //userSettings::setOtherOption( userSettings::LAST_RENDER, path_render_smile->text() );

        QFile wmyficext;
        QTextStream outext(&wmyficext);

        wmyficext.setFileName(path_project + "/delall.sh");
        wmyficext.open( QIODevice::WriteOnly );
        outext << "rm -rf " + path_project + "/RDR" << endl;
        outext << "rm -f " + path_project + "/delall.sh" << endl;
        outext << "exit" << endl;
        wmyficext.close();

        QString programf = "bash";
        QStringList argumentsf;
        argumentsf << path_project + "/delall.sh";

        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start(programf,argumentsf);

        proc_ffmpeg.waitForFinished(-1);

        if ( combo_fmt_smile->currentIndex() == 3 || combo_fmt_smile->currentIndex() == 0 || combo_fmt_smile->currentIndex() == 6  || combo_fmt_smile->currentIndex() == 7 )
        {
            wg_jpg_qual = 95;
        }
        if ( combo_fmt_smile->currentIndex() == 4 || combo_fmt_smile->currentIndex() == 1 )
        {
            wg_jpg_qual = 85;
        }
        if ( combo_fmt_smile->currentIndex() == 5 || combo_fmt_smile->currentIndex() == 2 )
        {
            wg_jpg_qual = 60;
        }

        QDir mydir(path_project);

        QDir mydir2(path_project + "/RDR");

        if ( mydir2.exists() == false )
        {

            if ( mydir.mkdir("RDR") == false )
            {
                qDebug()  << "ERROR CREATING FOLDER FOR GENERATING SLIDESHOW " << path_project + "/RDR";
                QMessageBox::information(this, name_application, tr("Erreur creation dossier generation : ") + path_project);
                return;
            }
        }

        if ( combo_fmt_smile->currentIndex() < 3 || combo_fmt_smile->currentIndex() == 7 )
        {
            if ( path_render_smile->text().right(4) != ".mpg" && path_render_smile->text().right(5) != ".mpeg" && path_render_smile->text().right(4) != ".MPG" && path_render_smile->text().right(5) != ".MPEG" )
            {
                    path_render_smile->setText(path_render_smile->text() + ".mpg");
            }
        }
        else
        {
            if ( combo_fmt_smile->currentIndex() == 6 )
            {
                if ( path_render_smile->text().right(4) != ".avi" && path_render_smile->text().right(4) != ".AVI" )
                {
                        path_render_smile->setText(path_render_smile->text() + ".avi");
                }
            }
        }

        screen_timeline->num_select = 0;
        pntmygl->num_select = 0;

        frame_toolslide->setDisabled(true);
        frame_bottom_slide->setDisabled(true);
        frame_support_timeline_diapo->setDisabled(true);
        wg_str_int_001 = path_render_smile->text();

        //pntmygl->f_save_diapo(num_current_diapo);
        num_current_diapo = 0;

        f_display_mark_on_timeline(0);

        player_isplaying = true;
        pntmygl->f_follow_timeline(10);
        progress_render_smile->setMaximum(pntmygl->length_diapo*25);
        pos_playing = 10;
        wg_int_001 = 0;
        sx_tr_diapo = dvdxsize;
        sy_tr_diapo = dvdysize;
        cpt_trt_trans = 0;
        thread_save->wg_quality = wg_jpg_qual;

        isrendering = 0;

        QPixmap wl_tmp_001(sx_tr_diapo,sy_tr_diapo);
        wl_tmp_001.fill(QColor(0,0,0));

        while ( isrendering < 251 )
        {
            pntmygl->table_preview_transition[isrendering] = wl_tmp_001.toImage();
            isrendering++;
        }

        isrendering = 1;
        pntmygl->isrendering = 1;

        f_load_diapo(0);

        progress_render_smile->setValue(0);
        progress_render_smile_2->setValue(0);
        progress_render_smile_2->setMaximum(nbre_diapos);
        progress_render_smile_3->setValue(0);

        if ( frame_path_smile->isEnabled() == true )
        {
            frame_render_smile->setGeometry((this->width()-frame_render_smile->width())/2,(this->height()-271)/2,frame_render_smile->width(),271);
        }
        else
        {
            frame_render_smile->setGeometry((this->width()-frame_render_smile->width())/2,(this->height()-211)/2,frame_render_smile->width(),211);
        }

        txt_render_target->setText(path_render_smile->text());
        txt_render_fmt->setText(combo_fmt_smile->currentText());
        label_61->setText(tr("Progression diapositive :") + " 1");

        frame_choose_encode->hide();
        frame_render_smile->show();
        frame_render_smile->raise();

        QTimer::singleShot(5, this, SLOT(f_play_diapo_boucle()));

    }
    else
    {
        QMessageBox::information(this, name_application, tr("Vous devez donner un nom et un emplacement pour la generation"));
    }
}

void mainfrm::f_bt_open_folder_render()
{
    QString wmypro = QFileDialog::getSaveFileName(this, tr("Generation du projet"), path_project, tr("Video (*.mpg *.mpeg *.MPG *.MPEG *.avi *.AVI)"));
    if ( wmypro.isNull() )
    {
        return;
    }
    else
    {
        path_render_smile->setText(wmypro);
    }
}

void mainfrm::f_combo_fmt_smile(int nump)
{
    if ( nump < 3 || nump == 6 || nump == 7 )
    {
        frame_path_smile->setEnabled(true);
    }
    else
    {
        frame_path_smile->setDisabled(true);
    }
}

void mainfrm::f_s_add_sound()
{   
    QString wmypro;
    wmypro = QFileDialog::getOpenFileName(
            this,
            tr("Charger une bande son"),
            path_save,
            "(*.wav *.WAV *.mp3 *.MP3)");

    if ( wmypro.isNull() )
    {
        return;
    }
    else
    {
        f_s_add_sound_step_2(wmypro);
    }
}

void mainfrm::f_s_add_sound_step_2(QString wmypro)
{
        if ( nbre_audio_track >= 1 )
        {
            return;
        }

        // ****************************************************
        // *** IDENTIFICATION DES CARACTERISTIQUES DU MEDIA ***
        // ****************************************************
        QFile wmyficext2;
        QTextStream outext2(&wmyficext2);

        wmyficext2.setFileName(path_project + "/extinf.sh");
        wmyficext2.open( QIODevice::WriteOnly );
        outext2 << "mplayer -identify -frames 0 -vo null -ao null \"" + wmypro + "\"" << endl;
        outext2 << "rm -f " + path_project + "/extinf.sh" << endl;
        outext2 << "exit" << endl;
        wmyficext2.close();

        wg_string_001 = "";
        QString programf = "bash";
        QStringList argumentsf;
        argumentsf << path_project + "/extinf.sh";

        proc_ffmpeg.setProcessChannelMode(QProcess::MergedChannels);
        proc_ffmpeg.start(programf,argumentsf);

        proc_ffmpeg.waitForFinished(-1);

        int wl_intidx = wg_string_003.lastIndexOf( "ID_LENGTH=" );
        if (wl_intidx != -1)
        {
            wl_intidx = wl_intidx + 10;
            int wl_intidx2 = wl_intidx;
            QString wl_lgth_med = "";

            while ( wg_string_003.mid(wl_intidx2,1) != "." && wg_string_003.mid(wl_intidx2,1) != " " )
            {
                wl_intidx2++;
            }
            wl_lgth_med = wg_string_003.mid(wl_intidx,wl_intidx2-wl_intidx);

            hdl_audio = new audio_editor(timeline_diapo);
            hdl_audio->length_media = wl_lgth_med.toInt();
            hdl_audio->title_audio = wmypro;
            connect(hdl_audio, SIGNAL(recalc()),this, SLOT(f_recalc_length_audio()));
            connect(hdl_audio, SIGNAL(s_del_sound()),this, SLOT(f_s_del_sound_from_audiotrack()));

            nbre_audio_track = 1;
            timeline_diapo->nbre_audio_track = nbre_audio_track;

            f_recalc_length_audio();
            hdl_audio->repaint();
            timeline_diapo->repaint();
        }
        else
        {
            QMessageBox::information(this, name_application, tr("Le media ne peut être identifie et ne sera pas utilise."));
        }
}

void mainfrm::f_s_del_sound()
{
    nbre_audio_track = 0;
    timeline_diapo->nbre_audio_track = nbre_audio_track;
    delete hdl_audio;
}

void mainfrm::f_s_del_sound_from_audiotrack()
{
    nbre_audio_track = 0;
    timeline_diapo->nbre_audio_track = nbre_audio_track;
}

void mainfrm::f_s_adj_sound()
{
    int diap_length = round((float)hdl_audio->length_media/(float)nbre_diapos);

    if ( diap_length < 2 )
    {
        diap_length = 2;
    }

    if ( diap_length > 60 )
    {
        diap_length = 60;
    }

    int wl_int_1 = 0;
    int wl_int_2 = 0;
    QStringList wl_explode;

    must_update = 0;
    spin_length_diapo->setValue(diap_length);
    screen_timeline->length_diapo = diap_length;
    pntmygl->length_diapo = diap_length;
    screen_timeline->repaint();
    must_update = 1;

    pntmygl->f_save_diapo(num_current_diapo);

    while ( wl_int_1 < nbre_diapos )
    {
        wl_int_2 = 0;
        while ( pntmygl->tab_save_diapo[wl_int_1][wl_int_2] != "$#$" )
        {
            wl_int_2++;
        }
        pntmygl->tab_save_diapo[wl_int_1][wl_int_2+1]=QString::number(diap_length);

        wl_explode = pntmygl->tab_save_diapo[wl_int_1][wl_int_2+3].split("}",QString::KeepEmptyParts);
        if ( wl_explode.at(1).toInt()+1 >= diap_length )
        {
            pntmygl->tab_save_diapo[wl_int_1][wl_int_2+3] = wl_explode.at(0) + "}1";
            timeline_diapo->tab_transition[wl_int_1] = 1;

        }

        timeline_diapo->tab_duration[wl_int_1] = diap_length;
        wl_int_1++;
    }
    f_recalc_length_audio();
    timeline_diapo->repaint();
}

void mainfrm::f_recalc_length_audio()
{
    if ( nbre_audio_track == 0 )
    {
        return;
    }
    hdl_audio->nbre_diapos = nbre_diapos;

    // *** BOUCLE CALCUL LONGUEUR ***
    int wl_int_001 = hdl_audio->position;
    int wl_ok = 0;
    int wl_cumul = 0;


    while ( wl_int_001 <= nbre_diapos && wl_ok == 0 )
    {
        wl_cumul = wl_cumul + (timeline_diapo->tab_duration[wl_int_001]-timeline_diapo->tab_transition[wl_int_001]);
        if ( wl_cumul >= hdl_audio->length_media )
        {
            wl_ok = 1;
        }
        wl_int_001++;
    }

    if ( wl_ok == 1 )
    {
        hdl_audio->setGeometry(hdl_audio->geometry().x(),66,(wl_int_001-1)*60,18);
    }
    else
    {
        hdl_audio->setGeometry(hdl_audio->geometry().x(),66,(nbre_diapos-(hdl_audio->position))*60,18);
    }

    hdl_audio->show();
}

void mainfrm::f_color_fog()
{
    if ( frame_smile->isVisible() == true )
    {
        pntmygl->fog_red = pntwheel9->red;
        pntmygl->fog_green = pntwheel9->green;
        pntmygl->fog_blue = pntwheel9->blue;

        pntmygl->f_check_fog(pntmygl->is_fog);
    }
}

void mainfrm::f_action_diapauto_fi()
{
    myfileopen *hdlfopen = new myfileopen(this);
    hdlfopen->setDirectory(pntmygl->wg_path_images);
    hdlfopen->source = 1;

    hdlfopen->setFileMode(QFileDialog::ExistingFiles);
    hdlfopen->setWindowTitle(tr("Diapositive"));
    hdlfopen->setFilter("(*.PNG *.png *.jpg *.JPG *.jeg *.JPEG)");
    connect(hdlfopen, SIGNAL(change_image(QString)),pntmygl, SLOT(f_open_ipreview(QString)));
    connect(hdlfopen, SIGNAL(filesSelected( const QStringList )),this, SLOT(f_load_diapo_fi_step_2( const QStringList )));
    connect(hdlfopen, SIGNAL(f_close()),pntmygl, SLOT(f_hide_preview()));
    connect(hdlfopen, SIGNAL(finished(int)),pntmygl, SLOT(f_hide_preview()));
    hdlfopen->show();
}

void mainfrm::f_load_diapo_fi_step_2( const QStringList wl_slmyfic )
{
    int wl_int_001 = 0;
    QString wl_myfic;
    QImage wl_pix1(50,50,QImage::Format_ARGB32_Premultiplied);
    QImage wl_img;
    QPainter p;
    int i;
    int sens;

    wl_myfic = wl_slmyfic.at(wl_int_001);

    i = wl_myfic.lastIndexOf( '/' );
    if ( i >= 0 )
    {
        pntmygl->wg_path_images = wl_myfic.mid(0, i);
    }

    while ( wl_int_001 < wl_slmyfic.count() && nbre_diapos < 400 )
    {
        wl_myfic = wl_slmyfic.at(wl_int_001);

        p.begin(&wl_pix1);
        p.setBrush(QColor(0,0,0));
        p.drawRect(0,0,50,50);
        p.end();

        table_hdl_diapo[nbre_diapos] = new diapos_th(timeline_diapo);

        connect(table_hdl_diapo[nbre_diapos], SIGNAL(select_diapoth(diapos_th*) ),this, SLOT(f_select_diapos_th(diapos_th*)));
        connect(table_hdl_diapo[nbre_diapos], SIGNAL(delete_diapoth(diapos_th*) ),this, SLOT(f_delete_diaposth(diapos_th*)));
        connect(table_hdl_diapo[nbre_diapos], SIGNAL(theme_diapoth(diapos_th*) ),this, SLOT(f_theme_diaposth(diapos_th*)));
        connect(table_hdl_diapo[nbre_diapos], SIGNAL(dupliquer_diapoth(diapos_th*) ),this, SLOT(f_dupliquer_diaposth(diapos_th*)));
        connect(table_hdl_diapo[nbre_diapos], SIGNAL(enter_diath(diapos_th*) ),this, SLOT(f_enter_diath(diapos_th*)));
        connect(table_hdl_diapo[nbre_diapos], SIGNAL(leave_diath(diapos_th*) ),this, SLOT(f_leave_diath(diapos_th*)));

        wl_img.load(wl_myfic);

        if ( wl_img.width() > wl_img.height() )
        {
            wl_img = wl_img.scaledToWidth(1024,Qt::SmoothTransformation);
        }
        else
        {
            wl_img = wl_img.scaledToHeight(1024,Qt::SmoothTransformation);
        }

        table_hdl_diapo[nbre_diapos]->setGeometry( nbre_diapos * 60, 0, 50, 50 );
        table_hdl_diapo[nbre_diapos]->draw_image = wl_img;
        table_hdl_diapo[nbre_diapos]->is_edit = 0;
        table_hdl_diapo[nbre_diapos]->show();

        timeline_diapo->tab_duration[nbre_diapos] = 4;
        timeline_diapo->tab_transition[nbre_diapos] = 0;

        sens = pntmygl->f_load_exif(wl_myfic);

        pntmygl->tab_save_diapo[nbre_diapos][1] = wl_myfic + "$" + QString::number(wl_img.width()) + "$" + QString::number(wl_img.height()) + "$$0:255$1.0$0$0/0/0/0$" + QString::number(sens) + "$10:0.0:0.0:-3.8:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100$690:0.0:0.0:-3.8:0.0:0.0:0.0:110:0:0:255:255:255:100:100:100:100$";
        pntmygl->tab_save_diapo[nbre_diapos][2] = "$#$";
        pntmygl->tab_save_diapo[nbre_diapos][3] = "4";
        pntmygl->tab_save_diapo[nbre_diapos][4] = "0:0:0";
        pntmygl->tab_save_diapo[nbre_diapos][5] = "";
        pntmygl->tab_save_diapo[nbre_diapos][6] = "0";
        pntmygl->tab_save_diapo[nbre_diapos][7] = "0:220:220:220:0:500:50:0";

        nbre_diapos++;
        timeline_diapo->max_diapo = nbre_diapos;
        timeline_diapo->repaint();

        wl_int_001++;
    }
    if ( (nbre_diapos*70) > timeline_diapo->width() )
    {
        timeline_diapo->setGeometry(timeline_diapo->geometry().x(),0,nbre_diapos*70,timeline_diapo->height());
        scroll_timeline_smile->setMaximum(timeline_diapo->width()-frame_support_timeline->width());

        if ( myeffect_global->opacity() < 1.0 )
        {
            QPropertyAnimation *animation = new QPropertyAnimation(myeffect_global, "opacity");
            animation->setDuration(500);
            animation->setStartValue(qreal(myeffect_global->opacity()));
            animation->setEndValue(qreal(1.0));
            animation->start();
        }
    }
    timeline_diapo->repaint();
    f_recalc_length_audio();
}

void mainfrm::f_enter_diath(diapos_th* hdlth)
{
    int wl_int_001 = 0;
    while ( table_hdl_diapo[wl_int_001] != hdlth )
    {
        wl_int_001++;
    }

    int wl_int_002 = 0;

    /*while ( pntmygl->tab_save_diapo[wl_int_001][wl_int_002] != "$#$" && wl_int_002 < 46 )
    {
        wl_int_002++;
    }*/

    while ( pntmygl->tab_save_diapo[wl_int_001][wl_int_002] != "$#$" && wl_int_002 < 46 )
    {
        wl_int_002++;
    }

    if ( wl_int_002 > 45 )
    {
        return;
    }

    frame_info_slide->typeoffr = 1;

    if ( hdlth->pos().x()+220 <= this->width() )
    {
        frame_info_slide->sens = 0;
        frame_info_slide->setGeometry(hdlth->pos().x()+50,6,140,40);
    }
    else
    {
        frame_info_slide->sens = 1;
        frame_info_slide->setGeometry(hdlth->pos().x()-140,6,140,40);
    }

    if ( wl_int_001 == num_current_diapo )
    {
        frame_info_slide->position = tr("Duree : ") + QString::number(spin_length_diapo->value()) + "sec \n" + QString::number(pntmygl->nombre_diapos) + " " + tr("images");

        if ( lst_trans_smile->currentText() != wg_str_int_004 )
        {
                QPixmap wl_ptr(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/" + lst_trans_smile->currentText() + ".png");
                wl_ptr = wl_ptr.scaled(32,32);

                frame_info_slide->trans = wl_ptr;
        }
        else
        {
                QPixmap wl_ptr(":/Interface/Interface/info.png");
                wl_ptr = wl_ptr.scaled(32,32);

                frame_info_slide->trans = wl_ptr;
        }
    }
    else
    {
            frame_info_slide->position = tr("Duree : ") + pntmygl->tab_save_diapo[wl_int_001][wl_int_002+1] + "sec \n" + QString::number(wl_int_002-1) + " " + tr("images");
            if ( pntmygl->tab_save_diapo[wl_int_001][wl_int_002+3] != "" )
            {
                QStringList wl_explode9 = pntmygl->tab_save_diapo[wl_int_001][wl_int_002+3].split("}",QString::KeepEmptyParts);
                if ( wl_explode9.at(0) != "" )
                {
                    QPixmap wl_ptr(QDir::homePath() + "/.2ManDVD_Library/" +"/Bibliotheque/Luma/" + wl_explode9.at(0));
                    wl_ptr = wl_ptr.scaled(32,32);

                    frame_info_slide->trans = wl_ptr;
                }
                else
                {
                    QPixmap wl_ptr(":/Interface/Interface/info.png");
                    wl_ptr = wl_ptr.scaled(32,32);

                    frame_info_slide->trans = wl_ptr;
                }
            }
            else
            {
                QPixmap wl_ptr(":/Interface/Interface/info.png");
                wl_ptr = wl_ptr.scaled(32,32);

                frame_info_slide->trans = wl_ptr;
            }
    }

    frame_info_slide->raise();
    frame_info_slide->letvisible();
}

void mainfrm::f_leave_diath(diapos_th*)
{
    frame_info_slide->lethidden();
}

void mainfrm::f_s_slide_lst(int value)
{
    if ( value == 1 )
    {
        if ( scroll_timeline_smile->value()+60 <= scroll_timeline_smile->maximum() )
        {
            QPropertyAnimation *animation = new QPropertyAnimation(scroll_timeline_smile, "value");
            animation->setDuration(300);
            animation->setStartValue(scroll_timeline_smile->value());
            animation->setEndValue(scroll_timeline_smile->value()+60);
            animation->start();
        }
        else
        {
            QPropertyAnimation *animation = new QPropertyAnimation(scroll_timeline_smile, "value");
            animation->setDuration(300);
            animation->setStartValue(scroll_timeline_smile->value());
            animation->setEndValue(scroll_timeline_smile->maximum());
            animation->start();
        }
    }
    else
    {
        if ( scroll_timeline_smile->value()-60 >= 60 )
        {
            QPropertyAnimation *animation = new QPropertyAnimation(scroll_timeline_smile, "value");
            animation->setDuration(300);
            animation->setStartValue(scroll_timeline_smile->value());
            animation->setEndValue(scroll_timeline_smile->value()-60);
            animation->start();
        }
        else
        {
            QPropertyAnimation *animation = new QPropertyAnimation(scroll_timeline_smile, "value");
            animation->setDuration(300);
            animation->setStartValue(scroll_timeline_smile->value());
            animation->setEndValue(0);
            animation->start();
        }
    }
}

void mainfrm::f_color_txt_slide()
{
    if ( must_update == 1 && pntmygl->num_select > 0 )
    {
        QStringList wl_explode = pntmygl->tab_diapo[pntmygl->num_select][0].split("!;!",QString::KeepEmptyParts);
        pntmygl->tab_diapo[pntmygl->num_select][0] = "?9" + wl_explode.at(0).mid(2,wl_explode.at(0).length()) + "!;!" + QString::number(pntwheel10->red) + "*^*" + QString::number(pntwheel10->green) + "*^*" + QString::number(pntwheel10->blue) + "!;!" + wl_explode.at(2) + "!;!" + wl_explode.at(3);

        pntmygl->f_reload_text();
    }
}

void mainfrm::f_showhide_grid()
{
    if ( pntmygl->affiche_grille == 0 )
    {
        pntmygl->affiche_grille = 1;
        pntmygl->updateGL();
    }
    else
    {
        pntmygl->affiche_grille = 0;
        pntmygl->updateGL();
    }
}
