/* ============================================================
 * File  : back_syno.cpp
 * Author: Stephane Gibault
 * Date  : Sun Feb 4 2007
 * Description :
 *
 * 
 *  (C) 2007 by Stephane Gibault
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */
#include <QtGui>
#include "back_syno.h"

back_syno::back_syno ( QWidget * parent )
    : QFrame(parent)
{
	this->setAttribute(Qt::WA_DeleteOnClose);
        fond_application.load(":/Interface/Interface/fd_transparent.png");
	nbre_menus = 0;
	num_actif = 999;
        QPalette mypal = QApplication::palette();
        wg_color_1 = mypal.color(QPalette::Normal, QPalette::Window);

        action_nmenu = new QAction(tr("Ajouter un menu"), this);
        action_nmenu->setIcon ( QIcon(":/Interface/Interface/new.png") );

        connect(action_nmenu, SIGNAL(triggered()), this, SLOT(f_new_menu()));
}

void back_syno::f_resize(QResizeEvent *)
{
        fond_application = fond_application.scaled(this->width(),this->height() );
        fond_application.fill(QColor(0,0,0,0));

        QPainter p;
        p.begin(&fond_application);

        p.setRenderHint(QPainter::Antialiasing,true);
        QPen mypen;

        int wl_int_001 = 100;
        mypen.setWidth(1);
        mypen.setColor(wg_color_1.dark(90));
        mypen.setStyle(Qt::DotLine);
        p.setPen(mypen);
        while ( wl_int_001 < this->width() )
        {
                p.drawLine(wl_int_001,10,wl_int_001,this->height()-20);
                wl_int_001=wl_int_001+100;
        }

        wl_int_001 = 100;
        while ( wl_int_001 < this->height() )
        {
                p.drawLine(10,wl_int_001,this->width()-20,wl_int_001);
                wl_int_001=wl_int_001+100;
        }

        p.end();
}

void back_syno::f_new_menu()
{
    emit arbo_new_menu();
}

void back_syno::contextMenuEvent(QContextMenuEvent *event)
{
    x = event->x();
    y = event->y();

    QMenu menu(this);
    menu.addAction(action_nmenu);
    menu.exec(event->globalPos());
}

// ************************
// *** DESSIN DU WIDGET ***
// ************************

void back_syno::paintEvent(QPaintEvent *)
{
	QPainter p;
	p.begin(this);
	p.setRenderHint(QPainter::Antialiasing,true);
	QPen mypen;
        p.drawPixmap(0,0,-1,-1,fond_application);
	mypen.setWidth(3);

	wg_int_001 = 0;

	while (wg_int_001 <= nbre_menus)
	{
		// *** RELATIONS ENTRE LES MENUS ***

		wg_int_002 = 0;

                while (tab_rel[wg_int_001][wg_int_002] != "$$$")
		{

			if ( tab_rel[wg_int_001][wg_int_002] != " " )
			{
				if ( wg_int_001 == num_actif )
				{
					mypen.setStyle(Qt::SolidLine);
					mypen.setColor(QColor(132,212,44,200));
					p.setPen(mypen);
                                        p.drawLine(tab_pnt_item[wg_int_001]->geometry().x()+53,tab_pnt_item[wg_int_001]->geometry().y()+53,tab_pnt_item[tab_rel[wg_int_001][wg_int_002].toInt()]->geometry().x()+53,tab_pnt_item[tab_rel[wg_int_001][wg_int_002].toInt()]->geometry().y()+53);
				}
				else
				{
					if ( num_actif == tab_rel[wg_int_001][wg_int_002].toInt() )
					{
						mypen.setStyle(Qt::DotLine);
						mypen.setColor(QColor(255,0,0,200));
						p.setPen(mypen);
						p.drawLine(tab_pnt_item[wg_int_001]->geometry().x()+57,tab_pnt_item[wg_int_001]->geometry().y()+57,tab_pnt_item[tab_rel[wg_int_001][wg_int_002].toInt()]->geometry().x()+57,tab_pnt_item[tab_rel[wg_int_001][wg_int_002].toInt()]->geometry().y()+57);
					}
					else
					{
						mypen.setStyle(Qt::SolidLine);
						mypen.setColor(QColor(117,112,104,200));
						p.setPen(mypen);
						p.drawLine(tab_pnt_item[wg_int_001]->geometry().x()+53,tab_pnt_item[wg_int_001]->geometry().y()+53,tab_pnt_item[tab_rel[wg_int_001][wg_int_002].toInt()]->geometry().x()+53,tab_pnt_item[tab_rel[wg_int_001][wg_int_002].toInt()]->geometry().y()+53);
					}
				}
			}
			wg_int_002++;
                }

		// *** RELATIONS AVEC LES MEDIAS ***

		wg_int_002 = 0;

		while (tab_rel_media[wg_int_001][wg_int_002] != "$$$")
		{

			if ( tab_rel_media[wg_int_001][wg_int_002] != " " )
			{
				if ( wg_int_001 == num_actif )
				{
					mypen.setStyle(Qt::SolidLine);
					mypen.setColor(QColor(50,60,184,200));
					p.setPen(mypen);
					p.drawLine(tab_pnt_item[wg_int_001]->geometry().x()+53,tab_pnt_item[wg_int_001]->geometry().y()+53,tab_pnt_media[tab_rel_media[wg_int_001][wg_int_002].toInt()]->geometry().x()+53,tab_pnt_media[tab_rel_media[wg_int_001][wg_int_002].toInt()]->geometry().y()+53);
				}
				else
				{
					mypen.setStyle(Qt::SolidLine);
					mypen.setColor(QColor(117,112,104,200));
					p.setPen(mypen);
					p.drawLine(tab_pnt_item[wg_int_001]->geometry().x()+53,tab_pnt_item[wg_int_001]->geometry().y()+53,tab_pnt_media[tab_rel_media[wg_int_001][wg_int_002].toInt()]->geometry().x()+53,tab_pnt_media[tab_rel_media[wg_int_001][wg_int_002].toInt()]->geometry().y()+53);
				}
			}
			wg_int_002++;
                }

		wg_int_001++;
	}
	p.end();
}
