/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.utils.DisplayUtils;

public class ContentSplitter {
    private static final int DISABLE_WRAP_LENGTH = 250000;
    private static final int SPLIT_LINE_LENGTH = 15000;
    private static final char NEWLINE = '\n';
    private static Icon warnIcon;
    private static Icon infoIcon;
    private final JPanel panel;
    private HttpPanelSyntaxHighlightTextArea textArea;
    private Boolean lineWrap;
    private JLabel messageLabel;
    private SplitState state;
    private String originalData;
    private int[] highlightOffsets;

    public ContentSplitter(JPanel panel) {
        this.panel = panel;
        this.highlightOffsets = new int[2];
        this.state = SplitState.UNCHANGED;
        this.messageLabel = new JLabel();
    }

    private static Icon getWarnIcon() {
        if (warnIcon == null) {
            warnIcon = ContentSplitter.createIcon("/resource/icon/16/050.png");
        }
        return warnIcon;
    }

    private static Icon createIcon(String name) {
        return DisplayUtils.getScaledIcon(ContentSplitter.class.getResource(name));
    }

    private static Icon getInfoIcon() {
        if (infoIcon == null) {
            infoIcon = ContentSplitter.createIcon("/resource/icon/fugue/information-white.png");
        }
        return infoIcon;
    }

    public void setTextArea(HttpPanelSyntaxHighlightTextArea textArea) {
        this.textArea = textArea;
    }

    public String process(String data) {
        String newData = this.splitContent(data);
        if (this.state == SplitState.UNCHANGED) {
            this.restoreLineWrapState();
            return data;
        }
        this.messageLabel.setText(this.state.toString());
        if (this.lineWrap == null) {
            this.lineWrap = this.textArea.getLineWrap();
            this.textArea.setLineWrap(false);
            this.textArea.setLineWrapDisabled(true);
            this.panel.add("Last", this.messageLabel);
            this.panel.revalidate();
            this.panel.repaint();
        }
        if (this.state == SplitState.LONG_CONTENT) {
            this.messageLabel.setText(Constant.messages.getString("http.panel.response.content.wrapdisabled"));
            this.messageLabel.setIcon(ContentSplitter.getInfoIcon());
            this.messageLabel.setToolTipText(Constant.messages.getString("http.panel.response.content.wrapdisabled.tooltip"));
            this.originalData = null;
            return data;
        }
        this.messageLabel.setText(Constant.messages.getString("http.panel.response.content.modified"));
        this.messageLabel.setIcon(ContentSplitter.getWarnIcon());
        this.messageLabel.setToolTipText(Constant.messages.getString("http.panel.response.content.modified.tooltip"));
        this.originalData = data;
        return newData;
    }

    private void restoreLineWrapState() {
        if (this.lineWrap != null) {
            this.originalData = null;
            this.textArea.setLineWrap(this.lineWrap);
            this.textArea.setLineWrapDisabled(false);
            this.lineWrap = null;
            this.panel.remove(this.messageLabel);
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    private String splitContent(String data) {
        int length = data.length();
        if (length < 15000) {
            this.state = SplitState.UNCHANGED;
            return data;
        }
        int pos = data.indexOf(10);
        if (pos == -1) {
            this.state = SplitState.SINGLE_LINE;
            StringBuilder strBuilder = ContentSplitter.createStringBuilder(length);
            ContentSplitter.splitInto(data, strBuilder, 0, length);
            return strBuilder.toString();
        }
        int curr = 0;
        int maxLineLen = 0;
        StringBuilder strBuilder = null;
        do {
            int lineLenth;
            if ((lineLenth = pos - curr) > 15000) {
                if (strBuilder == null) {
                    strBuilder = ContentSplitter.createStringBuilder(length);
                    strBuilder.append(data, 0, curr);
                    if (data.charAt(curr) == '\n') {
                        ++curr;
                    }
                }
                ContentSplitter.splitInto(data, strBuilder, curr, pos);
            } else if (strBuilder != null) {
                strBuilder.append(data, curr, pos);
            }
            maxLineLen = Math.max(lineLenth, maxLineLen);
            curr = pos;
            pos = data.indexOf(10, curr + 1);
            if (pos != -1) continue;
            pos = length;
        } while (curr < length);
        if (strBuilder == null) {
            this.state = length >= 250000 ? SplitState.LONG_CONTENT : SplitState.UNCHANGED;
            return data;
        }
        this.state = SplitState.LONG_LINES;
        return strBuilder.toString();
    }

    private static StringBuilder createStringBuilder(int length) {
        return new StringBuilder(length + length % 15000);
    }

    private static void splitInto(String data, StringBuilder strBuilder, int start, int end) {
        int splitEnd;
        int pos = start;
        do {
            if (strBuilder.length() != 0) {
                strBuilder.append('\n');
            }
            splitEnd = Math.min(pos + 15000, end);
            strBuilder.append(data, pos, splitEnd);
        } while ((pos = splitEnd) < end);
    }

    public int[] highlightOffsets(int start, int end) {
        this.highlightOffsets[0] = start;
        this.highlightOffsets[1] = end;
        if (this.originalData != null) {
            try {
                int excessChars = 0;
                int pos = 0;
                while ((pos = this.originalData.indexOf(10, pos)) != -1 && pos < end) {
                    ++pos;
                    ++excessChars;
                }
                int offset = this.textArea.getLineOfOffset(start) - excessChars;
                this.highlightOffsets[0] = this.highlightOffsets[0] + offset;
                this.highlightOffsets[1] = this.highlightOffsets[1] + offset;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return this.highlightOffsets;
    }

    private static enum SplitState {
        UNCHANGED,
        SINGLE_LINE,
        LONG_LINES,
        LONG_CONTENT;

    }
}

