/* automatically generated by rust-bindgen 0.68.1 */

#[doc = " EDID data structure."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Get the EDID version."]
    pub fn di_edid_get_version(edid: *const di_edid) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the EDID revision."]
    pub fn di_edid_get_revision(edid: *const di_edid) -> ::std::os::raw::c_int;
}
#[doc = " EDID vendor & product identification."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_vendor_product {
    pub manufacturer: [::std::os::raw::c_char; 3usize],
    pub product: u16,
    pub serial: u32,
    pub manufacture_week: ::std::os::raw::c_int,
    pub manufacture_year: ::std::os::raw::c_int,
    pub model_year: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_di_edid_vendor_product() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_vendor_product> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_vendor_product>(),
        24usize,
        concat!("Size of: ", stringify!(di_edid_vendor_product))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_vendor_product>(),
        4usize,
        concat!("Alignment of ", stringify!(di_edid_vendor_product))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).manufacturer) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_vendor_product),
            "::",
            stringify!(manufacturer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).product) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_vendor_product),
            "::",
            stringify!(product)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).serial) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_vendor_product),
            "::",
            stringify!(serial)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).manufacture_week) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_vendor_product),
            "::",
            stringify!(manufacture_week)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).manufacture_year) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_vendor_product),
            "::",
            stringify!(manufacture_year)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).model_year) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_vendor_product),
            "::",
            stringify!(model_year)
        )
    );
}
extern "C" {
    pub fn di_edid_get_vendor_product(edid: *const di_edid) -> *const di_edid_vendor_product;
}
pub const di_edid_video_input_analog_signal_level_std_DI_EDID_VIDEO_INPUT_ANALOG_SIGNAL_LEVEL_0:
    di_edid_video_input_analog_signal_level_std = 0;
pub const di_edid_video_input_analog_signal_level_std_DI_EDID_VIDEO_INPUT_ANALOG_SIGNAL_LEVEL_1:
    di_edid_video_input_analog_signal_level_std = 1;
pub const di_edid_video_input_analog_signal_level_std_DI_EDID_VIDEO_INPUT_ANALOG_SIGNAL_LEVEL_2:
    di_edid_video_input_analog_signal_level_std = 2;
pub const di_edid_video_input_analog_signal_level_std_DI_EDID_VIDEO_INPUT_ANALOG_SIGNAL_LEVEL_3:
    di_edid_video_input_analog_signal_level_std = 3;
#[doc = " EDID analog signal level standard."]
pub type di_edid_video_input_analog_signal_level_std = ::std::os::raw::c_uint;
pub const di_edid_video_input_analog_video_setup_DI_EDID_VIDEO_INPUT_ANALOG_BLANK_LEVEL_EQ_BLACK:
    di_edid_video_input_analog_video_setup = 0;
pub const di_edid_video_input_analog_video_setup_DI_EDID_VIDEO_INPUT_ANALOG_BLANK_TO_BLACK_SETUP_PEDESTAL : di_edid_video_input_analog_video_setup = 1 ;
#[doc = " EDID analog video setup."]
pub type di_edid_video_input_analog_video_setup = ::std::os::raw::c_uint;
#[doc = " EDID analog video input basic information, defined in section 3.6.1."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_video_input_analog {
    pub signal_level_std: di_edid_video_input_analog_signal_level_std,
    pub video_setup: di_edid_video_input_analog_video_setup,
    pub sync_separate: bool,
    pub sync_composite: bool,
    pub sync_on_green: bool,
    pub sync_serrations: bool,
}
#[test]
fn bindgen_test_layout_di_edid_video_input_analog() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_video_input_analog> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_video_input_analog>(),
        12usize,
        concat!("Size of: ", stringify!(di_edid_video_input_analog))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_video_input_analog>(),
        4usize,
        concat!("Alignment of ", stringify!(di_edid_video_input_analog))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).signal_level_std) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_video_input_analog),
            "::",
            stringify!(signal_level_std)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).video_setup) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_video_input_analog),
            "::",
            stringify!(video_setup)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_separate) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_video_input_analog),
            "::",
            stringify!(sync_separate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_composite) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_video_input_analog),
            "::",
            stringify!(sync_composite)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_on_green) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_video_input_analog),
            "::",
            stringify!(sync_on_green)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_serrations) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_video_input_analog),
            "::",
            stringify!(sync_serrations)
        )
    );
}
extern "C" {
    #[doc = " Get the analog video input basic information.\n\n Returns NULL if this isn't an analog display."]
    pub fn di_edid_get_video_input_analog(
        edid: *const di_edid,
    ) -> *const di_edid_video_input_analog;
}
pub const di_edid_video_input_digital_interface_DI_EDID_VIDEO_INPUT_DIGITAL_UNDEFINED:
    di_edid_video_input_digital_interface = 0;
pub const di_edid_video_input_digital_interface_DI_EDID_VIDEO_INPUT_DIGITAL_DVI:
    di_edid_video_input_digital_interface = 1;
pub const di_edid_video_input_digital_interface_DI_EDID_VIDEO_INPUT_DIGITAL_HDMI_A:
    di_edid_video_input_digital_interface = 2;
pub const di_edid_video_input_digital_interface_DI_EDID_VIDEO_INPUT_DIGITAL_HDMI_B:
    di_edid_video_input_digital_interface = 3;
pub const di_edid_video_input_digital_interface_DI_EDID_VIDEO_INPUT_DIGITAL_MDDI:
    di_edid_video_input_digital_interface = 4;
pub const di_edid_video_input_digital_interface_DI_EDID_VIDEO_INPUT_DIGITAL_DISPLAYPORT:
    di_edid_video_input_digital_interface = 5;
#[doc = " Digital video input interface standard."]
pub type di_edid_video_input_digital_interface = ::std::os::raw::c_uint;
#[doc = " EDID digital video input basic information, defined in section 3.6.1."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_video_input_digital {
    pub dfp1: bool,
    pub color_bit_depth: ::std::os::raw::c_int,
    pub interface: di_edid_video_input_digital_interface,
}
#[test]
fn bindgen_test_layout_di_edid_video_input_digital() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_video_input_digital> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_video_input_digital>(),
        12usize,
        concat!("Size of: ", stringify!(di_edid_video_input_digital))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_video_input_digital>(),
        4usize,
        concat!("Alignment of ", stringify!(di_edid_video_input_digital))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dfp1) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_video_input_digital),
            "::",
            stringify!(dfp1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).color_bit_depth) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_video_input_digital),
            "::",
            stringify!(color_bit_depth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interface) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_video_input_digital),
            "::",
            stringify!(interface)
        )
    );
}
extern "C" {
    #[doc = " Get the digital video input basic information.\n\n Returns NULL if this isn't a digital display."]
    pub fn di_edid_get_video_input_digital(
        edid: *const di_edid,
    ) -> *const di_edid_video_input_digital;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_screen_size {
    pub width_cm: ::std::os::raw::c_int,
    pub height_cm: ::std::os::raw::c_int,
    pub landscape_aspect_ratio: f32,
    pub portait_aspect_ratio: f32,
}
#[test]
fn bindgen_test_layout_di_edid_screen_size() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_screen_size> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_screen_size>(),
        16usize,
        concat!("Size of: ", stringify!(di_edid_screen_size))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_screen_size>(),
        4usize,
        concat!("Alignment of ", stringify!(di_edid_screen_size))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).width_cm) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_screen_size),
            "::",
            stringify!(width_cm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).height_cm) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_screen_size),
            "::",
            stringify!(height_cm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).landscape_aspect_ratio) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_screen_size),
            "::",
            stringify!(landscape_aspect_ratio)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).portait_aspect_ratio) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_screen_size),
            "::",
            stringify!(portait_aspect_ratio)
        )
    );
}
extern "C" {
    #[doc = " Get the screen size."]
    pub fn di_edid_get_screen_size(edid: *const di_edid) -> *const di_edid_screen_size;
}
extern "C" {
    #[doc = " Get the display transfer characteristics from the basic EDID parameters, also\n known as \"gamma\".\n\n Returns 0 if unset (ie, stored in an extension block)."]
    pub fn di_edid_get_basic_gamma(edid: *const di_edid) -> f32;
}
#[doc = " Supported legacy Display Power Management Signaling (DPMS) states, defined in\n section 3.6.4.\n\n Display Power Management (DPM) compliant displays only support \"off\"."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_dpms {
    pub standby: bool,
    pub suspend: bool,
    pub off: bool,
}
#[test]
fn bindgen_test_layout_di_edid_dpms() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_dpms> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_dpms>(),
        3usize,
        concat!("Size of: ", stringify!(di_edid_dpms))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_dpms>(),
        1usize,
        concat!("Alignment of ", stringify!(di_edid_dpms))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).standby) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_dpms),
            "::",
            stringify!(standby)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).suspend) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_dpms),
            "::",
            stringify!(suspend)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).off) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_dpms),
            "::",
            stringify!(off)
        )
    );
}
extern "C" {
    #[doc = " Get the set of supported legacy DPMS states."]
    pub fn di_edid_get_dpms(edid: *const di_edid) -> *const di_edid_dpms;
}
pub const di_edid_display_color_type_DI_EDID_DISPLAY_COLOR_MONOCHROME: di_edid_display_color_type =
    0;
pub const di_edid_display_color_type_DI_EDID_DISPLAY_COLOR_RGB: di_edid_display_color_type = 1;
pub const di_edid_display_color_type_DI_EDID_DISPLAY_COLOR_NON_RGB: di_edid_display_color_type = 2;
pub const di_edid_display_color_type_DI_EDID_DISPLAY_COLOR_UNDEFINED: di_edid_display_color_type =
    3;
#[doc = " Display color type."]
pub type di_edid_display_color_type = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Get the display color type.\n\n For digital displays using EDID 1.4 and later, DI_EDID_DISPLAY_COLOR_UNDEFINED\n is always returned."]
    pub fn di_edid_get_display_color_type(edid: *const di_edid) -> di_edid_display_color_type;
}
#[doc = " Basic color encoding formats, defined in section 3.6.4."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_color_encoding_formats {
    pub rgb444: bool,
    pub ycrcb444: bool,
    pub ycrcb422: bool,
}
#[test]
fn bindgen_test_layout_di_edid_color_encoding_formats() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_color_encoding_formats> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_color_encoding_formats>(),
        3usize,
        concat!("Size of: ", stringify!(di_edid_color_encoding_formats))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_color_encoding_formats>(),
        1usize,
        concat!("Alignment of ", stringify!(di_edid_color_encoding_formats))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rgb444) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_encoding_formats),
            "::",
            stringify!(rgb444)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ycrcb444) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_encoding_formats),
            "::",
            stringify!(ycrcb444)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ycrcb422) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_encoding_formats),
            "::",
            stringify!(ycrcb422)
        )
    );
}
extern "C" {
    #[doc = " Get the set of supported color encoding formats.\n\n Returns NULL if the display is analog or if the color encoding formats are\n not specified."]
    pub fn di_edid_get_color_encoding_formats(
        edid: *const di_edid,
    ) -> *const di_edid_color_encoding_formats;
}
#[doc = " Miscellaneous basic features, defined in section 3.6.4.\n\n Note, the enum values don't match the specification."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_misc_features {
    #[doc = " First detailed timing is the preferred timing.\n\n Always set for EDID 1.4 and later."]
    pub has_preferred_timing: bool,
    #[doc = " GTF using the default parameters is supported.\n\n Never set for EDID 1.4 and later."]
    pub default_gtf: bool,
    #[doc = " sRGB standard default color space is primary color space."]
    pub srgb_is_primary: bool,
    #[doc = " Preferred timing mode includes native pixel format and rate.\n\n Never set for EDID 1.3 and earlier."]
    pub preferred_timing_is_native: bool,
    #[doc = " GTF or CVT generated timings within the display's range limits are\n accepted.\n\n Never set for EDID 1.3 and earlier."]
    pub continuous_freq: bool,
}
#[test]
fn bindgen_test_layout_di_edid_misc_features() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_misc_features> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_misc_features>(),
        5usize,
        concat!("Size of: ", stringify!(di_edid_misc_features))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_misc_features>(),
        1usize,
        concat!("Alignment of ", stringify!(di_edid_misc_features))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_preferred_timing) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_misc_features),
            "::",
            stringify!(has_preferred_timing)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).default_gtf) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_misc_features),
            "::",
            stringify!(default_gtf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).srgb_is_primary) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_misc_features),
            "::",
            stringify!(srgb_is_primary)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preferred_timing_is_native) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_misc_features),
            "::",
            stringify!(preferred_timing_is_native)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).continuous_freq) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_misc_features),
            "::",
            stringify!(continuous_freq)
        )
    );
}
extern "C" {
    #[doc = " Get the set of miscellaneous basic features."]
    pub fn di_edid_get_misc_features(edid: *const di_edid) -> *const di_edid_misc_features;
}
#[doc = " EDID display chromaticity coordinates, defined in section 3.7.\n\n The values are accurate to the thousandth place. The red, green and blue\n values are zero for monochrome displays."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_chromaticity_coords {
    pub red_x: f32,
    pub red_y: f32,
    pub green_x: f32,
    pub green_y: f32,
    pub blue_x: f32,
    pub blue_y: f32,
    pub white_x: f32,
    pub white_y: f32,
}
#[test]
fn bindgen_test_layout_di_edid_chromaticity_coords() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_chromaticity_coords> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_chromaticity_coords>(),
        32usize,
        concat!("Size of: ", stringify!(di_edid_chromaticity_coords))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_chromaticity_coords>(),
        4usize,
        concat!("Alignment of ", stringify!(di_edid_chromaticity_coords))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).red_x) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_chromaticity_coords),
            "::",
            stringify!(red_x)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).red_y) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_chromaticity_coords),
            "::",
            stringify!(red_y)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).green_x) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_chromaticity_coords),
            "::",
            stringify!(green_x)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).green_y) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_chromaticity_coords),
            "::",
            stringify!(green_y)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blue_x) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_chromaticity_coords),
            "::",
            stringify!(blue_x)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blue_y) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_chromaticity_coords),
            "::",
            stringify!(blue_y)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).white_x) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_chromaticity_coords),
            "::",
            stringify!(white_x)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).white_y) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_chromaticity_coords),
            "::",
            stringify!(white_y)
        )
    );
}
extern "C" {
    #[doc = " Get chromaticity coordinates."]
    pub fn di_edid_get_chromaticity_coords(
        edid: *const di_edid,
    ) -> *const di_edid_chromaticity_coords;
}
#[doc = " Established timings I and II, defined in section 3.8."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_established_timings_i_ii {
    pub has_720x400_70hz: bool,
    pub has_720x400_88hz: bool,
    pub has_640x480_60hz: bool,
    pub has_640x480_67hz: bool,
    pub has_640x480_72hz: bool,
    pub has_640x480_75hz: bool,
    pub has_800x600_56hz: bool,
    pub has_800x600_60hz: bool,
    pub has_800x600_72hz: bool,
    pub has_800x600_75hz: bool,
    pub has_832x624_75hz: bool,
    pub has_1024x768_87hz_interlaced: bool,
    pub has_1024x768_60hz: bool,
    pub has_1024x768_70hz: bool,
    pub has_1024x768_75hz: bool,
    pub has_1280x1024_75hz: bool,
    pub has_1152x870_75hz: bool,
}
#[test]
fn bindgen_test_layout_di_edid_established_timings_i_ii() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_established_timings_i_ii> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_established_timings_i_ii>(),
        17usize,
        concat!("Size of: ", stringify!(di_edid_established_timings_i_ii))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_established_timings_i_ii>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(di_edid_established_timings_i_ii)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_720x400_70hz) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_720x400_70hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_720x400_88hz) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_720x400_88hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_640x480_60hz) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_640x480_60hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_640x480_67hz) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_640x480_67hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_640x480_72hz) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_640x480_72hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_640x480_75hz) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_640x480_75hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_800x600_56hz) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_800x600_56hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_800x600_60hz) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_800x600_60hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_800x600_72hz) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_800x600_72hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_800x600_75hz) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_800x600_75hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_832x624_75hz) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_832x624_75hz)
        )
    );
    assert_eq!(
        unsafe {
            ::std::ptr::addr_of!((*ptr).has_1024x768_87hz_interlaced) as usize - ptr as usize
        },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_1024x768_87hz_interlaced)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_1024x768_60hz) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_1024x768_60hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_1024x768_70hz) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_1024x768_70hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_1024x768_75hz) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_1024x768_75hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_1280x1024_75hz) as usize - ptr as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_1280x1024_75hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).has_1152x870_75hz) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_established_timings_i_ii),
            "::",
            stringify!(has_1152x870_75hz)
        )
    );
}
extern "C" {
    #[doc = " Get established timings I and II."]
    pub fn di_edid_get_established_timings_i_ii(
        edid: *const di_edid,
    ) -> *const di_edid_established_timings_i_ii;
}
pub const di_edid_standard_timing_aspect_ratio_DI_EDID_STANDARD_TIMING_16_10:
    di_edid_standard_timing_aspect_ratio = 0;
pub const di_edid_standard_timing_aspect_ratio_DI_EDID_STANDARD_TIMING_4_3:
    di_edid_standard_timing_aspect_ratio = 1;
pub const di_edid_standard_timing_aspect_ratio_DI_EDID_STANDARD_TIMING_5_4:
    di_edid_standard_timing_aspect_ratio = 2;
pub const di_edid_standard_timing_aspect_ratio_DI_EDID_STANDARD_TIMING_16_9:
    di_edid_standard_timing_aspect_ratio = 3;
#[doc = " Aspect ratio for an EDID standard timing."]
pub type di_edid_standard_timing_aspect_ratio = ::std::os::raw::c_uint;
#[doc = " EDID standard timing, defined in section 3.9."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_standard_timing {
    pub horiz_video: i32,
    pub aspect_ratio: di_edid_standard_timing_aspect_ratio,
    pub refresh_rate_hz: i32,
}
#[test]
fn bindgen_test_layout_di_edid_standard_timing() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_standard_timing> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_standard_timing>(),
        12usize,
        concat!("Size of: ", stringify!(di_edid_standard_timing))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_standard_timing>(),
        4usize,
        concat!("Alignment of ", stringify!(di_edid_standard_timing))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).horiz_video) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_standard_timing),
            "::",
            stringify!(horiz_video)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).aspect_ratio) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_standard_timing),
            "::",
            stringify!(aspect_ratio)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).refresh_rate_hz) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_standard_timing),
            "::",
            stringify!(refresh_rate_hz)
        )
    );
}
extern "C" {
    #[doc = " Get the vertical addressable line count of an EDID standard timing."]
    pub fn di_edid_standard_timing_get_vert_video(t: *const di_edid_standard_timing) -> i32;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_dmt_timing {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Get the VESA Display Monitor Timing (DMT), if any.\n\n NULL is returned if the standard timing doesn't have a DMT."]
    pub fn di_edid_standard_timing_get_dmt(
        t: *const di_edid_standard_timing,
    ) -> *const di_dmt_timing;
}
extern "C" {
    #[doc = " Get a list of EDID standard timings.\n\n The returned array is NULL-terminated."]
    pub fn di_edid_get_standard_timings(
        edid: *const di_edid,
    ) -> *const *const di_edid_standard_timing;
}
pub const di_edid_detailed_timing_def_stereo_DI_EDID_DETAILED_TIMING_DEF_STEREO_NONE:
    di_edid_detailed_timing_def_stereo = 0;
pub const di_edid_detailed_timing_def_stereo_DI_EDID_DETAILED_TIMING_DEF_STEREO_FIELD_SEQ_RIGHT:
    di_edid_detailed_timing_def_stereo = 1;
pub const di_edid_detailed_timing_def_stereo_DI_EDID_DETAILED_TIMING_DEF_STEREO_FIELD_SEQ_LEFT:
    di_edid_detailed_timing_def_stereo = 2;
pub const di_edid_detailed_timing_def_stereo_DI_EDID_DETAILED_TIMING_DEF_STEREO_2_WAY_INTERLEAVED_RIGHT : di_edid_detailed_timing_def_stereo = 3 ;
pub const di_edid_detailed_timing_def_stereo_DI_EDID_DETAILED_TIMING_DEF_STEREO_2_WAY_INTERLEAVED_LEFT : di_edid_detailed_timing_def_stereo = 4 ;
pub const di_edid_detailed_timing_def_stereo_DI_EDID_DETAILED_TIMING_DEF_STEREO_4_WAY_INTERLEAVED : di_edid_detailed_timing_def_stereo = 5 ;
pub const di_edid_detailed_timing_def_stereo_DI_EDID_DETAILED_TIMING_DEF_STEREO_SIDE_BY_SIDE_INTERLEAVED : di_edid_detailed_timing_def_stereo = 6 ;
#[doc = " Stereo viewing support."]
pub type di_edid_detailed_timing_def_stereo = ::std::os::raw::c_uint;
pub const di_edid_detailed_timing_def_signal_type_DI_EDID_DETAILED_TIMING_DEF_SIGNAL_ANALOG_COMPOSITE : di_edid_detailed_timing_def_signal_type = 0 ;
pub const di_edid_detailed_timing_def_signal_type_DI_EDID_DETAILED_TIMING_DEF_SIGNAL_BIPOLAR_ANALOG_COMPOSITE : di_edid_detailed_timing_def_signal_type = 1 ;
pub const di_edid_detailed_timing_def_signal_type_DI_EDID_DETAILED_TIMING_DEF_SIGNAL_DIGITAL_COMPOSITE : di_edid_detailed_timing_def_signal_type = 2 ;
pub const di_edid_detailed_timing_def_signal_type_DI_EDID_DETAILED_TIMING_DEF_SIGNAL_DIGITAL_SEPARATE : di_edid_detailed_timing_def_signal_type = 3 ;
#[doc = " Signal definitions for EDID detailed timings, defined in notes for table 3.22."]
pub type di_edid_detailed_timing_def_signal_type = ::std::os::raw::c_uint;
pub const di_edid_detailed_timing_def_sync_polarity_DI_EDID_DETAILED_TIMING_DEF_SYNC_NEGATIVE:
    di_edid_detailed_timing_def_sync_polarity = 0;
pub const di_edid_detailed_timing_def_sync_polarity_DI_EDID_DETAILED_TIMING_DEF_SYNC_POSITIVE:
    di_edid_detailed_timing_def_sync_polarity = 1;
#[doc = " Digital separate sync polarity for EDID detailed timings."]
pub type di_edid_detailed_timing_def_sync_polarity = ::std::os::raw::c_uint;
#[doc = " Flags for ANALOG_COMPOSITE signals"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_detailed_timing_analog_composite {
    pub sync_serrations: bool,
    pub sync_on_green: bool,
}
#[test]
fn bindgen_test_layout_di_edid_detailed_timing_analog_composite() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_detailed_timing_analog_composite> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_detailed_timing_analog_composite>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(di_edid_detailed_timing_analog_composite)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_detailed_timing_analog_composite>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(di_edid_detailed_timing_analog_composite)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_serrations) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_analog_composite),
            "::",
            stringify!(sync_serrations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_on_green) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_analog_composite),
            "::",
            stringify!(sync_on_green)
        )
    );
}
#[doc = " Flags for BIPOLAR_ANALOG_COMPOSITE signals"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_detailed_timing_bipolar_analog_composite {
    pub sync_serrations: bool,
    pub sync_on_green: bool,
}
#[test]
fn bindgen_test_layout_di_edid_detailed_timing_bipolar_analog_composite() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_detailed_timing_bipolar_analog_composite> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_detailed_timing_bipolar_analog_composite>(),
        2usize,
        concat!(
            "Size of: ",
            stringify!(di_edid_detailed_timing_bipolar_analog_composite)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_detailed_timing_bipolar_analog_composite>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(di_edid_detailed_timing_bipolar_analog_composite)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_serrations) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_bipolar_analog_composite),
            "::",
            stringify!(sync_serrations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_on_green) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_bipolar_analog_composite),
            "::",
            stringify!(sync_on_green)
        )
    );
}
#[doc = " Flags for DIGITAL_COMPOSITE signals"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_detailed_timing_digital_composite {
    pub sync_serrations: bool,
    pub sync_horiz_polarity: di_edid_detailed_timing_def_sync_polarity,
}
#[test]
fn bindgen_test_layout_di_edid_detailed_timing_digital_composite() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_detailed_timing_digital_composite> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_detailed_timing_digital_composite>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(di_edid_detailed_timing_digital_composite)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_detailed_timing_digital_composite>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(di_edid_detailed_timing_digital_composite)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_serrations) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_digital_composite),
            "::",
            stringify!(sync_serrations)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_horiz_polarity) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_digital_composite),
            "::",
            stringify!(sync_horiz_polarity)
        )
    );
}
#[doc = " Flags for DIGITAL_SEPARATE signals"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_detailed_timing_digital_separate {
    pub sync_vert_polarity: di_edid_detailed_timing_def_sync_polarity,
    pub sync_horiz_polarity: di_edid_detailed_timing_def_sync_polarity,
}
#[test]
fn bindgen_test_layout_di_edid_detailed_timing_digital_separate() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_detailed_timing_digital_separate> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_detailed_timing_digital_separate>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(di_edid_detailed_timing_digital_separate)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_detailed_timing_digital_separate>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(di_edid_detailed_timing_digital_separate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_vert_polarity) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_digital_separate),
            "::",
            stringify!(sync_vert_polarity)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_horiz_polarity) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_digital_separate),
            "::",
            stringify!(sync_horiz_polarity)
        )
    );
}
#[doc = " EDID detailed timing definition, defined in section 3.10.2."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_detailed_timing_def {
    pub pixel_clock_hz: i32,
    pub horiz_video: i32,
    pub vert_video: i32,
    pub horiz_blank: i32,
    pub vert_blank: i32,
    pub horiz_front_porch: i32,
    pub vert_front_porch: i32,
    pub horiz_sync_pulse: i32,
    pub vert_sync_pulse: i32,
    pub horiz_image_mm: i32,
    pub vert_image_mm: i32,
    pub horiz_border: i32,
    pub vert_border: i32,
    pub interlaced: bool,
    pub stereo: di_edid_detailed_timing_def_stereo,
    pub signal_type: di_edid_detailed_timing_def_signal_type,
    pub analog_composite: *const di_edid_detailed_timing_analog_composite,
    pub bipolar_analog_composite: *const di_edid_detailed_timing_bipolar_analog_composite,
    pub digital_composite: *const di_edid_detailed_timing_digital_composite,
    pub digital_separate: *const di_edid_detailed_timing_digital_separate,
}
#[test]
fn bindgen_test_layout_di_edid_detailed_timing_def() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_detailed_timing_def> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_detailed_timing_def>(),
        96usize,
        concat!("Size of: ", stringify!(di_edid_detailed_timing_def))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_detailed_timing_def>(),
        8usize,
        concat!("Alignment of ", stringify!(di_edid_detailed_timing_def))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pixel_clock_hz) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(pixel_clock_hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).horiz_video) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(horiz_video)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vert_video) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(vert_video)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).horiz_blank) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(horiz_blank)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vert_blank) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(vert_blank)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).horiz_front_porch) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(horiz_front_porch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vert_front_porch) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(vert_front_porch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).horiz_sync_pulse) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(horiz_sync_pulse)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vert_sync_pulse) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(vert_sync_pulse)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).horiz_image_mm) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(horiz_image_mm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vert_image_mm) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(vert_image_mm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).horiz_border) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(horiz_border)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vert_border) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(vert_border)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interlaced) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(interlaced)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stereo) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(stereo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).signal_type) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(signal_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).analog_composite) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(analog_composite)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bipolar_analog_composite) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(bipolar_analog_composite)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).digital_composite) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(digital_composite)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).digital_separate) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_detailed_timing_def),
            "::",
            stringify!(digital_separate)
        )
    );
}
extern "C" {
    #[doc = " Get a list of EDID detailed timing definitions.\n\n The returned array is NULL-terminated."]
    pub fn di_edid_get_detailed_timing_defs(
        edid: *const di_edid,
    ) -> *const *const di_edid_detailed_timing_def;
}
#[doc = " EDID display descriptor."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_display_descriptor {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Get a list of EDID display descriptors.\n\n The returned array is NULL-terminated."]
    pub fn di_edid_get_display_descriptors(
        edid: *const di_edid,
    ) -> *const *const di_edid_display_descriptor;
}
pub const di_edid_display_descriptor_tag_DI_EDID_DISPLAY_DESCRIPTOR_PRODUCT_SERIAL:
    di_edid_display_descriptor_tag = 255;
pub const di_edid_display_descriptor_tag_DI_EDID_DISPLAY_DESCRIPTOR_DATA_STRING:
    di_edid_display_descriptor_tag = 254;
pub const di_edid_display_descriptor_tag_DI_EDID_DISPLAY_DESCRIPTOR_RANGE_LIMITS:
    di_edid_display_descriptor_tag = 253;
pub const di_edid_display_descriptor_tag_DI_EDID_DISPLAY_DESCRIPTOR_PRODUCT_NAME:
    di_edid_display_descriptor_tag = 252;
pub const di_edid_display_descriptor_tag_DI_EDID_DISPLAY_DESCRIPTOR_COLOR_POINT:
    di_edid_display_descriptor_tag = 251;
pub const di_edid_display_descriptor_tag_DI_EDID_DISPLAY_DESCRIPTOR_STD_TIMING_IDS:
    di_edid_display_descriptor_tag = 250;
pub const di_edid_display_descriptor_tag_DI_EDID_DISPLAY_DESCRIPTOR_DCM_DATA:
    di_edid_display_descriptor_tag = 249;
pub const di_edid_display_descriptor_tag_DI_EDID_DISPLAY_DESCRIPTOR_CVT_TIMING_CODES:
    di_edid_display_descriptor_tag = 248;
pub const di_edid_display_descriptor_tag_DI_EDID_DISPLAY_DESCRIPTOR_ESTABLISHED_TIMINGS_III:
    di_edid_display_descriptor_tag = 247;
pub const di_edid_display_descriptor_tag_DI_EDID_DISPLAY_DESCRIPTOR_DUMMY:
    di_edid_display_descriptor_tag = 16;
#[doc = " EDID display descriptor tag, defined in section 3.10.3."]
pub type di_edid_display_descriptor_tag = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Get the tag of an EDID display descriptor."]
    pub fn di_edid_display_descriptor_get_tag(
        desc: *const di_edid_display_descriptor,
    ) -> di_edid_display_descriptor_tag;
}
extern "C" {
    #[doc = " Get the contents of a product serial number, a data string, or a product name\n display descriptor.\n\n Returns NULL if the display descriptor tag isn't either\n DI_EDID_DISPLAY_DESCRIPTOR_PRODUCT_SERIAL_NUMBER,\n DI_EDID_DISPLAY_DESCRIPTOR_DATA_STRING or\n DI_EDID_DISPLAY_DESCRIPTOR_PRODUCT_NAME."]
    pub fn di_edid_display_descriptor_get_string(
        desc: *const di_edid_display_descriptor,
    ) -> *const ::std::os::raw::c_char;
}
pub const di_edid_display_range_limits_type_DI_EDID_DISPLAY_RANGE_LIMITS_BARE:
    di_edid_display_range_limits_type = 0;
pub const di_edid_display_range_limits_type_DI_EDID_DISPLAY_RANGE_LIMITS_DEFAULT_GTF:
    di_edid_display_range_limits_type = 1;
pub const di_edid_display_range_limits_type_DI_EDID_DISPLAY_RANGE_LIMITS_SECONDARY_GTF:
    di_edid_display_range_limits_type = 2;
pub const di_edid_display_range_limits_type_DI_EDID_DISPLAY_RANGE_LIMITS_CVT:
    di_edid_display_range_limits_type = 3;
#[doc = " EDID display range limits type.\n\n The values do not match the EDID specification.\n\n The CVT entry was introduced in EDID 1.4."]
pub type di_edid_display_range_limits_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_display_range_limits_secondary_gtf {
    pub start_freq_hz: ::std::os::raw::c_int,
    pub c: f32,
    pub m: f32,
    pub k: f32,
    pub j: f32,
}
#[test]
fn bindgen_test_layout_di_edid_display_range_limits_secondary_gtf() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_display_range_limits_secondary_gtf> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_display_range_limits_secondary_gtf>(),
        20usize,
        concat!(
            "Size of: ",
            stringify!(di_edid_display_range_limits_secondary_gtf)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_display_range_limits_secondary_gtf>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(di_edid_display_range_limits_secondary_gtf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_freq_hz) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_secondary_gtf),
            "::",
            stringify!(start_freq_hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).c) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_secondary_gtf),
            "::",
            stringify!(c)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).m) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_secondary_gtf),
            "::",
            stringify!(m)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).k) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_secondary_gtf),
            "::",
            stringify!(k)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).j) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_secondary_gtf),
            "::",
            stringify!(j)
        )
    );
}
pub const di_edid_cvt_aspect_ratio_DI_EDID_CVT_ASPECT_RATIO_4_3: di_edid_cvt_aspect_ratio = 128;
pub const di_edid_cvt_aspect_ratio_DI_EDID_CVT_ASPECT_RATIO_16_9: di_edid_cvt_aspect_ratio = 64;
pub const di_edid_cvt_aspect_ratio_DI_EDID_CVT_ASPECT_RATIO_16_10: di_edid_cvt_aspect_ratio = 32;
pub const di_edid_cvt_aspect_ratio_DI_EDID_CVT_ASPECT_RATIO_5_4: di_edid_cvt_aspect_ratio = 16;
pub const di_edid_cvt_aspect_ratio_DI_EDID_CVT_ASPECT_RATIO_15_9: di_edid_cvt_aspect_ratio = 8;
pub type di_edid_cvt_aspect_ratio = ::std::os::raw::c_uint;
pub const di_edid_cvt_scaling_DI_EDID_CVT_SCALING_HORIZ_SHRINK: di_edid_cvt_scaling = 128;
pub const di_edid_cvt_scaling_DI_EDID_CVT_SCALING_HORIZ_STRETCH: di_edid_cvt_scaling = 64;
pub const di_edid_cvt_scaling_DI_EDID_CVT_SCALING_VERT_SHRINK: di_edid_cvt_scaling = 32;
pub const di_edid_cvt_scaling_DI_EDID_CVT_SCALING_VERT_STRETCH: di_edid_cvt_scaling = 16;
pub type di_edid_cvt_scaling = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_display_range_limits_cvt {
    pub version: i32,
    pub revision: i32,
    pub max_horiz_px: i32,
    pub supported_aspect_ratio: u32,
    pub preferred_aspect_ratio: di_edid_cvt_aspect_ratio,
    pub standard_blanking: bool,
    pub reduced_blanking: bool,
    pub supported_scaling: u32,
    pub preferred_vert_refresh_hz: i32,
}
#[test]
fn bindgen_test_layout_di_edid_display_range_limits_cvt() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_display_range_limits_cvt> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_display_range_limits_cvt>(),
        32usize,
        concat!("Size of: ", stringify!(di_edid_display_range_limits_cvt))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_display_range_limits_cvt>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(di_edid_display_range_limits_cvt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_cvt),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).revision) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_cvt),
            "::",
            stringify!(revision)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_horiz_px) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_cvt),
            "::",
            stringify!(max_horiz_px)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).supported_aspect_ratio) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_cvt),
            "::",
            stringify!(supported_aspect_ratio)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preferred_aspect_ratio) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_cvt),
            "::",
            stringify!(preferred_aspect_ratio)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).standard_blanking) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_cvt),
            "::",
            stringify!(standard_blanking)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reduced_blanking) as usize - ptr as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_cvt),
            "::",
            stringify!(reduced_blanking)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).supported_scaling) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_cvt),
            "::",
            stringify!(supported_scaling)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preferred_vert_refresh_hz) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits_cvt),
            "::",
            stringify!(preferred_vert_refresh_hz)
        )
    );
}
#[doc = " EDID display range limits, defined in section 3.10.3.3.1."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_display_range_limits {
    pub min_vert_rate_hz: i32,
    pub max_vert_rate_hz: i32,
    pub min_horiz_rate_hz: i32,
    pub max_horiz_rate_hz: i32,
    pub max_pixel_clock_hz: i32,
    pub type_: di_edid_display_range_limits_type,
    pub secondary_gtf: *const di_edid_display_range_limits_secondary_gtf,
    pub cvt: *const di_edid_display_range_limits_cvt,
}
#[test]
fn bindgen_test_layout_di_edid_display_range_limits() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_display_range_limits> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_display_range_limits>(),
        40usize,
        concat!("Size of: ", stringify!(di_edid_display_range_limits))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_display_range_limits>(),
        8usize,
        concat!("Alignment of ", stringify!(di_edid_display_range_limits))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_vert_rate_hz) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits),
            "::",
            stringify!(min_vert_rate_hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_vert_rate_hz) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits),
            "::",
            stringify!(max_vert_rate_hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_horiz_rate_hz) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits),
            "::",
            stringify!(min_horiz_rate_hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_horiz_rate_hz) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits),
            "::",
            stringify!(max_horiz_rate_hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_pixel_clock_hz) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits),
            "::",
            stringify!(max_pixel_clock_hz)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).secondary_gtf) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits),
            "::",
            stringify!(secondary_gtf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cvt) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_display_range_limits),
            "::",
            stringify!(cvt)
        )
    );
}
extern "C" {
    #[doc = " Get the contents of a display range limits descriptor.\n\n Returns NULL if the display descriptor tag isn't\n DI_EDID_DISPLAY_DESCRIPTOR_RANGE_LIMITS."]
    pub fn di_edid_display_descriptor_get_range_limits(
        desc: *const di_edid_display_descriptor,
    ) -> *const di_edid_display_range_limits;
}
extern "C" {
    #[doc = " Get a standard timing list from an EDID display descriptor.\n\n The returned array is NULL-terminated.\n\n Returns NULL if the display descriptor tag isn't\n DI_EDID_DISPLAY_DESCRIPTOR_STD_TIMING_IDS."]
    pub fn di_edid_display_descriptor_get_standard_timings(
        desc: *const di_edid_display_descriptor,
    ) -> *const *const di_edid_standard_timing;
}
#[doc = " EDID Color Points, defined in section 3.10.3.5."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_color_point {
    pub index: ::std::os::raw::c_int,
    pub white_x: f32,
    pub white_y: f32,
    pub gamma: f32,
}
#[test]
fn bindgen_test_layout_di_edid_color_point() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_color_point> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_color_point>(),
        16usize,
        concat!("Size of: ", stringify!(di_edid_color_point))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_color_point>(),
        4usize,
        concat!("Alignment of ", stringify!(di_edid_color_point))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_point),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).white_x) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_point),
            "::",
            stringify!(white_x)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).white_y) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_point),
            "::",
            stringify!(white_y)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gamma) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_point),
            "::",
            stringify!(gamma)
        )
    );
}
extern "C" {
    #[doc = " Get a color point list from an EDID display descriptor.\n\n The returned array is NULL-terminated.\n\n Returns NULL if the display descriptor tag isn't\n DI_EDID_DISPLAY_DESCRIPTOR_COLOR_POINT.\n\n Upstream is not aware of any EDID blob containing Color Point Descriptors.\n If such a blob is found, please share it with upstream!"]
    pub fn di_edid_display_descriptor_get_color_points(
        desc: *const di_edid_display_descriptor,
    ) -> *const *const di_edid_color_point;
}
extern "C" {
    #[doc = " Get a list of established timings III from an EDID display descriptor.\n\n The returned array is NULL-terminated.\n\n Returns NULL if the display descriptor tag isn't\n DI_EDID_DISPLAY_DESCRIPTOR_ESTABLISHED_TIMINGS_III."]
    pub fn di_edid_display_descriptor_get_established_timings_iii(
        desc: *const di_edid_display_descriptor,
    ) -> *const *const di_dmt_timing;
}
#[doc = " EDID display Color Management Data, defined in section 3.10.3.7\n\n Contains the coefficients for the function `L = a₃ × v³ + a₂ × v²`\n describing the luminance response L to some voltage v [0, 0.7] for each color\n channel.\n\n For more information see VESA DCM Standard, Version 1; January 6, 2003"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_color_management_data {
    pub version: ::std::os::raw::c_int,
    pub red_a3: f32,
    pub red_a2: f32,
    pub green_a3: f32,
    pub green_a2: f32,
    pub blue_a3: f32,
    pub blue_a2: f32,
}
#[test]
fn bindgen_test_layout_di_edid_color_management_data() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_color_management_data> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_color_management_data>(),
        28usize,
        concat!("Size of: ", stringify!(di_edid_color_management_data))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_color_management_data>(),
        4usize,
        concat!("Alignment of ", stringify!(di_edid_color_management_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_management_data),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).red_a3) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_management_data),
            "::",
            stringify!(red_a3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).red_a2) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_management_data),
            "::",
            stringify!(red_a2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).green_a3) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_management_data),
            "::",
            stringify!(green_a3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).green_a2) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_management_data),
            "::",
            stringify!(green_a2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blue_a3) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_management_data),
            "::",
            stringify!(blue_a3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blue_a2) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_color_management_data),
            "::",
            stringify!(blue_a2)
        )
    );
}
extern "C" {
    #[doc = " Get the contents of a Display Color Management (DCM) Data descriptor.\n\n Returns NULL if the display descriptor tag isn't\n DI_EDID_DISPLAY_DESCRIPTOR_DCM_DATA.\n\n Upstream is not aware of any EDID blob containing DCM Data descriptors.\n If such a blob is found, please share it with upstream!"]
    pub fn di_edid_display_descriptor_get_color_management_data(
        desc: *const di_edid_display_descriptor,
    ) -> *const di_edid_color_management_data;
}
pub const di_edid_cvt_timing_code_aspect_ratio_DI_EDID_CVT_TIMING_CODE_4_3:
    di_edid_cvt_timing_code_aspect_ratio = 0;
pub const di_edid_cvt_timing_code_aspect_ratio_DI_EDID_CVT_TIMING_CODE_16_9:
    di_edid_cvt_timing_code_aspect_ratio = 1;
pub const di_edid_cvt_timing_code_aspect_ratio_DI_EDID_CVT_TIMING_CODE_16_10:
    di_edid_cvt_timing_code_aspect_ratio = 2;
pub const di_edid_cvt_timing_code_aspect_ratio_DI_EDID_CVT_TIMING_CODE_15_9:
    di_edid_cvt_timing_code_aspect_ratio = 3;
#[doc = " Aspect ratio for an EDID CVT Timing Code."]
pub type di_edid_cvt_timing_code_aspect_ratio = ::std::os::raw::c_uint;
pub const di_edid_cvt_timing_code_preferred_vrate_DI_EDID_CVT_TIMING_CODE_PREFERRED_VRATE_50HZ:
    di_edid_cvt_timing_code_preferred_vrate = 0;
pub const di_edid_cvt_timing_code_preferred_vrate_DI_EDID_CVT_TIMING_CODE_PREFERRED_VRATE_60HZ:
    di_edid_cvt_timing_code_preferred_vrate = 1;
pub const di_edid_cvt_timing_code_preferred_vrate_DI_EDID_CVT_TIMING_CODE_PREFERRED_VRATE_75HZ:
    di_edid_cvt_timing_code_preferred_vrate = 2;
pub const di_edid_cvt_timing_code_preferred_vrate_DI_EDID_CVT_TIMING_CODE_PREFERRED_VRATE_85HZ:
    di_edid_cvt_timing_code_preferred_vrate = 3;
#[doc = " Preferred Vertical Rate for an EDID CVT Timing Code."]
pub type di_edid_cvt_timing_code_preferred_vrate = ::std::os::raw::c_uint;
#[doc = " EDID CVT Timing Code, defined in section 3.10.3.8\n\n For more information see VESA Coordinated Video Timings (CVT) Standard."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_cvt_timing_code {
    pub addressable_lines_per_field: i32,
    pub aspect_ratio: di_edid_cvt_timing_code_aspect_ratio,
    pub supports_50hz_sb: bool,
    pub supports_60hz_sb: bool,
    pub supports_75hz_sb: bool,
    pub supports_85hz_sb: bool,
    pub supports_60hz_rb: bool,
    pub preferred_vertical_rate: di_edid_cvt_timing_code_preferred_vrate,
}
#[test]
fn bindgen_test_layout_di_edid_cvt_timing_code() {
    const UNINIT: ::std::mem::MaybeUninit<di_edid_cvt_timing_code> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<di_edid_cvt_timing_code>(),
        20usize,
        concat!("Size of: ", stringify!(di_edid_cvt_timing_code))
    );
    assert_eq!(
        ::std::mem::align_of::<di_edid_cvt_timing_code>(),
        4usize,
        concat!("Alignment of ", stringify!(di_edid_cvt_timing_code))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addressable_lines_per_field) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_cvt_timing_code),
            "::",
            stringify!(addressable_lines_per_field)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).aspect_ratio) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_cvt_timing_code),
            "::",
            stringify!(aspect_ratio)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).supports_50hz_sb) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_cvt_timing_code),
            "::",
            stringify!(supports_50hz_sb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).supports_60hz_sb) as usize - ptr as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_cvt_timing_code),
            "::",
            stringify!(supports_60hz_sb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).supports_75hz_sb) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_cvt_timing_code),
            "::",
            stringify!(supports_75hz_sb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).supports_85hz_sb) as usize - ptr as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_cvt_timing_code),
            "::",
            stringify!(supports_85hz_sb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).supports_60hz_rb) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_cvt_timing_code),
            "::",
            stringify!(supports_60hz_rb)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preferred_vertical_rate) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(di_edid_cvt_timing_code),
            "::",
            stringify!(preferred_vertical_rate)
        )
    );
}
extern "C" {
    #[doc = " Get a list of CVT timing codes from an EDID display descriptor.\n The highest priority code comes first, the lowest priority code last.\n\n The returned array is NULL-terminated.\n\n Returns NULL if the display descriptor tag isn't\n DI_EDID_DISPLAY_DESCRIPTOR_CVT_TIMING_CODES."]
    pub fn di_edid_display_descriptor_get_cvt_timing_codes(
        desc: *const di_edid_display_descriptor,
    ) -> *const *const di_edid_cvt_timing_code;
}
#[doc = " EDID extension block."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_ext {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Get a list of EDID extensions.\n\n The returned array is NULL-terminated."]
    pub fn di_edid_get_extensions(edid: *const di_edid) -> *const *const di_edid_ext;
}
pub const di_edid_ext_tag_DI_EDID_EXT_CEA: di_edid_ext_tag = 2;
pub const di_edid_ext_tag_DI_EDID_EXT_VTB: di_edid_ext_tag = 16;
pub const di_edid_ext_tag_DI_EDID_EXT_DI: di_edid_ext_tag = 64;
pub const di_edid_ext_tag_DI_EDID_EXT_LS: di_edid_ext_tag = 80;
pub const di_edid_ext_tag_DI_EDID_EXT_DPVL: di_edid_ext_tag = 96;
pub const di_edid_ext_tag_DI_EDID_EXT_BLOCK_MAP: di_edid_ext_tag = 240;
pub const di_edid_ext_tag_DI_EDID_EXT_VENDOR: di_edid_ext_tag = 255;
pub const di_edid_ext_tag_DI_EDID_EXT_DISPLAYID: di_edid_ext_tag = 112;
#[doc = " EDID extension block tags, defined in section 2.2.4."]
pub type di_edid_ext_tag = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " Get the tag of an EDID extension block."]
    pub fn di_edid_ext_get_tag(ext: *const di_edid_ext) -> di_edid_ext_tag;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_edid_cta {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Get a CTA-861 extension block.\n\n Returns NULL if the extension block tag is not DI_EDID_EXT_CEA."]
    pub fn di_edid_ext_get_cta(ext: *const di_edid_ext) -> *const di_edid_cta;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct di_displayid {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Get a DisplayID extension block.\n\n Returns NULL if the extension block tag is not DI_EDID_EXT_DISPLAYID."]
    pub fn di_edid_ext_get_displayid(ext: *const di_edid_ext) -> *const di_displayid;
}
