# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class EnforcementState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enforcement status."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    NOT_AVAILABLE = "NotAvailable"


class GroupType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the group."""

    ALLOCATION_GROUP = "AllocationGroup"
    """The group is used for subscription group quota allocations."""
    ENFORCED_GROUP = "EnforcedGroup"
    """The group is used for the enforced shared limit scenario"""


class LimitType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The limit object type."""

    LIMIT_VALUE = "LimitValue"


class QuotaLimitTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The quota or usages limit types."""

    INDEPENDENT = "Independent"
    SHARED = "Shared"


class QuotaRequestState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Quota request status."""

    ACCEPTED = "Accepted"
    INVALID = "Invalid"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    IN_PROGRESS = "InProgress"


class RequestState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Request status."""

    ACCEPTED = "Accepted"
    """The quota request has been accepted."""
    CREATED = "Created"
    """The quota request has been created."""
    INVALID = "Invalid"
    """The quota request is invalid."""
    SUCCEEDED = "Succeeded"
    """The quota request has succeeded."""
    ESCALATED = "Escalated"
    """The quota request has been escalated for further review. Please file a support ticket. A
    support engineer will follow up."""
    FAILED = "Failed"
    """The quota request has failed."""
    IN_PROGRESS = "InProgress"
    """The quota request is currently being processed."""
    CANCELED = "Canceled"
    """The quota request has been canceled."""


class UsagesTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The quota or usages limit types."""

    INDIVIDUAL = "Individual"
    COMBINED = "Combined"
