# WARNING: this file is auto-generated by 'build_sync_library.py'
# from the original file 'test_limit_size.py'
# DO NOT CHANGE! Change the original file instead.
import pytest
from key_value.shared.errors.wrappers.limit_size import EntryTooLargeError, EntryTooSmallError
from key_value.shared.utils.managed_entry import estimate_serialized_size
from typing_extensions import override

from key_value.sync.code_gen.stores.memory.store import MemoryStore
from key_value.sync.code_gen.wrappers.limit_size import LimitSizeWrapper
from tests.code_gen.stores.base import BaseStoreTests


class TestLimitSizeWrapper(BaseStoreTests):
    @override
    @pytest.fixture
    def store(self, memory_store: MemoryStore) -> LimitSizeWrapper:
        # Set a reasonable max size for normal test operations (20KB to handle large test strings)
        return LimitSizeWrapper(key_value=memory_store, max_size=20 * 1024, raise_on_too_large=False, raise_on_too_small=False)

    def test_put_within_limit(self, memory_store: MemoryStore):
        limit_size_store: LimitSizeWrapper = LimitSizeWrapper(
            key_value=memory_store, max_size=1024, raise_on_too_large=True, raise_on_too_small=False
        )

        # Small value should succeed
        limit_size_store.put(collection="test", key="test", value={"test": "test"})
        result = limit_size_store.get(collection="test", key="test")
        assert result is not None
        assert result["test"] == "test"

    def test_put_exceeds_limit_with_raise(self, memory_store: MemoryStore):
        limit_size_store: LimitSizeWrapper = LimitSizeWrapper(key_value=memory_store, max_size=100, raise_on_too_large=True)

        # Large value should raise an error
        large_value = {"data": "x" * 1000}
        with pytest.raises(EntryTooLargeError):
            limit_size_store.put(collection="test", key="test", value=large_value)

        # Verify nothing was stored
        result = limit_size_store.get(collection="test", key="test")
        assert result is None

    def test_put_exceeds_limit_without_raise(self, memory_store: MemoryStore):
        limit_size_store: LimitSizeWrapper = LimitSizeWrapper(key_value=memory_store, max_size=100, raise_on_too_large=False)

        # Large value should be silently ignored
        large_value = {"data": "x" * 1000}
        limit_size_store.put(collection="test", key="test", value=large_value)

        # Verify nothing was stored
        result = limit_size_store.get(collection="test", key="test")
        assert result is None

    def test_put_below_min_size_with_raise_on_too_small(self, memory_store: MemoryStore):
        limit_size_store: LimitSizeWrapper = LimitSizeWrapper(key_value=memory_store, min_size=100, raise_on_too_small=True)

        # Small value should raise an error
        small_value = {"data": "x"}
        with pytest.raises(EntryTooSmallError):
            limit_size_store.put(collection="test", key="test", value=small_value)

        # Verify nothing was stored
        result = limit_size_store.get(collection="test", key="test")
        assert result is None

    def test_put_below_min_size_without_raise_on_too_small(self, memory_store: MemoryStore):
        limit_size_store: LimitSizeWrapper = LimitSizeWrapper(key_value=memory_store, min_size=100, raise_on_too_small=False)

        # Small value should be silently ignored
        small_value = {"data": "x"}
        limit_size_store.put(collection="test", key="test", value=small_value)

        # Verify nothing was stored
        result = limit_size_store.get(collection="test", key="test")
        assert result is None

    def test_put_many_mixed_sizes_with_raise(self, memory_store: MemoryStore):
        limit_size_store: LimitSizeWrapper = LimitSizeWrapper(key_value=memory_store, max_size=100, raise_on_too_large=True)

        # Mix of small and large values
        keys = ["small1", "large1", "small2"]
        values = [{"data": "x"}, {"data": "x" * 1000}, {"data": "y"}]

        # Should raise on the large value
        with pytest.raises(EntryTooLargeError):
            limit_size_store.put_many(collection="test", keys=keys, values=values)

        # Verify nothing was stored due to the error
        results = limit_size_store.get_many(collection="test", keys=keys)
        assert results[0] is None
        assert results[1] is None
        assert results[2] is None

    def test_put_many_mixed_sizes_without_raise(self, memory_store: MemoryStore):
        limit_size_store: LimitSizeWrapper = LimitSizeWrapper(key_value=memory_store, max_size=100, raise_on_too_large=False)

        # Mix of small and large values
        keys = ["small1", "large1", "small2"]
        values = [{"data": "x"}, {"data": "x" * 1000}, {"data": "y"}]

        # Should silently filter out large value
        limit_size_store.put_many(collection="test", keys=keys, values=values)

        # Verify only small values were stored
        results = limit_size_store.get_many(collection="test", keys=keys)
        assert results[0] == {"data": "x"}
        assert results[1] is None  # Large value was filtered out
        assert results[2] == {"data": "y"}

    def test_put_many_with_ttl_sequence(self, memory_store: MemoryStore):
        limit_size_store: LimitSizeWrapper = LimitSizeWrapper(key_value=memory_store, max_size=100, raise_on_too_large=False)

        # Mix of small and large values with single TTL
        keys = ["small1", "large1", "small2"]
        values = [{"data": "x"}, {"data": "x" * 1000}, {"data": "y"}]

        # Should filter out large value
        limit_size_store.put_many(collection="test", keys=keys, values=values, ttl=100)

        # Verify only small values were stored
        results = limit_size_store.get_many(collection="test", keys=keys)
        assert results[0] == {"data": "x"}
        assert results[1] is None  # Large value was filtered out
        assert results[2] == {"data": "y"}

    def test_put_many_all_too_large_without_raise(self, memory_store: MemoryStore):
        limit_size_store: LimitSizeWrapper = LimitSizeWrapper(key_value=memory_store, max_size=10, raise_on_too_large=False)

        # All values too large
        keys = ["key1", "key2"]
        values = [{"data": "x" * 1000}, {"data": "y" * 1000}]

        # Should not raise, but nothing should be stored
        limit_size_store.put_many(collection="test", keys=keys, values=values)

        # Verify nothing was stored
        results = limit_size_store.get_many(collection="test", keys=keys)
        assert results[0] is None
        assert results[1] is None

    def test_exact_size_limit(self, memory_store: MemoryStore):
        # First, determine the exact size of a small value
        test_value = {"test": "value"}
        exact_size = estimate_serialized_size(value=test_value)

        # Create a store with exact size limit
        limit_size_store: LimitSizeWrapper = LimitSizeWrapper(key_value=memory_store, max_size=exact_size, raise_on_too_large=True)

        # Should succeed at exact limit
        limit_size_store.put(collection="test", key="test", value=test_value)
        result = limit_size_store.get(collection="test", key="test")
        assert result == test_value

        # Should fail if one byte over
        limit_size_store_under: LimitSizeWrapper = LimitSizeWrapper(
            key_value=memory_store, max_size=exact_size - 1, raise_on_too_large=True
        )
        with pytest.raises(EntryTooLargeError):
            limit_size_store_under.put(collection="test", key="test2", value=test_value)
