# WARNING: this file is auto-generated by 'build_sync_library.py'
# from the original file 'test_duckdb.py'
# DO NOT CHANGE! Change the original file instead.
from collections.abc import Generator
from pathlib import Path
from tempfile import TemporaryDirectory

import pytest
from duckdb import CatalogException, DuckDBPyConnection
from inline_snapshot import snapshot
from typing_extensions import override

from key_value.sync.code_gen.stores.base import BaseStore
from key_value.sync.code_gen.stores.duckdb import DuckDBStore
from tests.code_gen.stores.base import BaseStoreTests, ContextManagerStoreTestMixin


def get_client_from_store(store: DuckDBStore) -> DuckDBPyConnection:
    return store._connection  # pyright: ignore[reportPrivateUsage]


@pytest.mark.filterwarnings("ignore:A configured store is unstable and may change in a backwards incompatible way. Use at your own risk.")
class TestDuckDBStore(ContextManagerStoreTestMixin, BaseStoreTests):
    @override
    @pytest.fixture
    def store(self) -> Generator[DuckDBStore, None, None]:
        """Test with in-memory DuckDB database."""
        duckdb_store = DuckDBStore()
        yield duckdb_store
        duckdb_store.close()

    @pytest.mark.skip(reason="Local disk stores are unbounded")
    def test_not_unbounded(self, store: BaseStore): ...


@pytest.mark.filterwarnings("ignore:A configured store is unstable and may change in a backwards incompatible way. Use at your own risk.")
class TestDuckDBStorePersistent(ContextManagerStoreTestMixin, BaseStoreTests):
    @override
    @pytest.fixture
    def store(self, per_test_temp_dir: Path) -> Generator[DuckDBStore, None, None]:
        """Test with persistent DuckDB database file."""
        duckdb_store = DuckDBStore(database_path=per_test_temp_dir / "test.db")

        yield duckdb_store

        duckdb_store.close()

    @pytest.mark.skip(reason="Local disk stores are unbounded")
    def test_not_unbounded(self, store: BaseStore): ...


@pytest.mark.filterwarnings("ignore:A configured store is unstable and may change in a backwards incompatible way. Use at your own risk.")
class TestDuckDBStoreSpecific:
    """Test DuckDB-specific functionality."""

    @pytest.fixture
    def store(self) -> Generator[DuckDBStore, None, None]:
        """Provide DuckDB store instance."""
        duckdb_store = DuckDBStore()
        yield duckdb_store
        duckdb_store.close()

    def test_native_sql_queryability(self):
        """Test that users can query the database directly with SQL."""
        store = DuckDBStore()

        # Store some test data with known metadata
        store.put(collection="products", key="item1", value={"name": "Widget", "price": 10.99}, ttl=3600)
        store.put(collection="products", key="item2", value={"name": "Gadget", "price": 25.5}, ttl=7200)
        store.put(collection="orders", key="order1", value={"total": 100.0, "items": 3})

        # Query directly via SQL to verify native storage
        # Check that value is stored as JSON (can extract fields)
        result = (
            get_client_from_store(store)
            .execute("""
            SELECT key, value->'name' as name, value->'price' as price
            FROM kv_entries
            WHERE collection = 'products'
            ORDER BY key
        """)
            .fetchall()
        )  # pyright: ignore[reportPrivateUsage]

        assert len(result) == 2
        assert result[0][0] == "item1"
        assert result[0][1] == '"Widget"'  # JSON strings are quoted
        assert result[1][0] == "item2"

        # Query by expiration timestamp
        count_result = (
            get_client_from_store(store)
            .execute("""
            SELECT COUNT(*)
            FROM kv_entries
            WHERE expires_at > now() OR expires_at IS NULL
        """)
            .fetchone()
        )  # pyright: ignore[reportPrivateUsage]

        assert count_result is not None
        assert count_result[0] == 3  # All 3 entries should not be expired

        store.close()

    def test_database_path_initialization(self):
        """Test that store can be initialized with different database path options."""
        # In-memory (default)
        store1 = DuckDBStore()
        store1.put(collection="test", key="key1", value={"test": "value1"})
        result1 = store1.get(collection="test", key="key1")
        assert result1 == {"test": "value1"}
        store1.close()

        # Explicit in-memory
        store2 = DuckDBStore(database_path=":memory:")
        store2.put(collection="test", key="key2", value={"test": "value2"})
        result2 = store2.get(collection="test", key="key2")
        assert result2 == {"test": "value2"}
        store2.close()

    def test_persistent_database(self):
        """Test that data persists across store instances when using file database."""
        with TemporaryDirectory() as temp_dir:
            db_path = Path(temp_dir) / "persist_test.db"

            # Store data in first instance
            store1 = DuckDBStore(database_path=db_path)
            store1.put(collection="test", key="persist_key", value={"data": "persistent"})
            store1.close()

            # Create second instance with same database file
            store2 = DuckDBStore(database_path=db_path)
            result = store2.get(collection="test", key="persist_key")
            store2.close()

            assert result == {"data": "persistent"}

    def test_sql_injection_protection(self, store: DuckDBStore):
        """Test that the store is protected against SQL injection attacks."""
        malicious_collection = "test'; DROP TABLE kv_entries; --"
        malicious_key = "key'; DELETE FROM kv_entries; --"

        # These operations should not cause SQL injection
        store.put(collection=malicious_collection, key=malicious_key, value={"safe": "data"})
        result = store.get(collection=malicious_collection, key=malicious_key)
        assert result == {"safe": "data"}

        # Verify the table still exists and other data is safe
        store.put(collection="normal", key="normal_key", value={"normal": "data"})
        normal_result = store.get(collection="normal", key="normal_key")
        assert normal_result == {"normal": "data"}

    def test_large_data_storage(self, store: DuckDBStore):
        """Test storing and retrieving large data values."""
        # Create a large value (1MB of data)
        large_value = {"large_data": "x" * (1024 * 1024)}

        store.put(collection="test", key="large_key", value=large_value)
        result = store.get(collection="test", key="large_key")

        assert result == large_value

    def test_unicode_support(self, store: DuckDBStore):
        """Test that the store properly handles Unicode characters."""
        unicode_data = {
            "english": "Hello World",
            "chinese": "你好世界",
            "japanese": "こんにちは世界",
            "arabic": "مرحبا بالعالم",
            "emoji": "🌍🚀💻",
            "special": "Special chars: !@#$%^&*()_+-={}[]|\\:;\"'<>?,./",
        }

        store.put(collection="unicode_test", key="unicode_key", value=unicode_data)
        result = store.get(collection="unicode_test", key="unicode_key")

        assert result == unicode_data

    def test_connection_initialization(self):
        """Test that store can be initialized with existing DuckDB connection."""
        import duckdb

        conn = duckdb.connect(":memory:")
        store = DuckDBStore(connection=conn)

        store.put(collection="test", key="conn_test", value={"test": "value"})
        result = store.get(collection="test", key="conn_test")
        assert result == {"test": "value"}

        store.close()

    def test_custom_table_name(self):
        """Test that store can use custom table name."""
        custom_table = "my_custom_kv_table"
        store = DuckDBStore(table_name=custom_table)

        # Store some data
        store.put(collection="test", key="key1", value={"data": "value"})

        # Verify the custom table exists and contains the data
        tables = (
            get_client_from_store(store)
            .table(custom_table)
            .filter(filter_expr="key = 'key1'")
            .select("key", "collection")
            .execute()
            .fetchone()
        )

        assert tables == snapshot(("key1", "test"))

        # Verify default table doesn't exist
        with pytest.raises(CatalogException):
            get_client_from_store(store).table("kv_entries")

        store.close()

    @pytest.mark.skip(reason="Local disk stores are unbounded")
    def test_not_unbounded(self, store: BaseStore): ...
