# -*- coding: binary -*-

# This module provides a way of interacting with Splunk search
module Msf::Exploit::Remote::HTTP::Splunk::Search
  # Executes a Splunk search in the specified namespace
  #
  # @param namespace [String] The Splunk namespace (user or app context) for the search
  # @param query [String] The search query to execute
  # @param cookie [String] Valid admin's cookie
  # @return [Rex::Proto::Http::Response] HTTP response object containing the search results
  def search(namespace, query, cookie)
    csrf = extract_csrf_token(cookie)

    res = send_request_cgi(
      'uri' => splunk_search_api_url(namespace),
      'method' => 'POST',
      'cookie' => cookie,
      'headers' => {
        'X-Splunk-Form-Key' => csrf,
        'X-Requested-With': 'XMLHttpRequest'
      },
      'vars_post' => {
        search: query
      }
    )

    unless res&.code == 201
      fail_with(Msf::Module::Failure::UnexpectedReply, "#{peer} Server did not respond with the expected HTTP 201")
    end

    res
  end
end
