# Copyright 2021-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8
PYTHON_COMPAT=( python3_{11..13} )

inherit meson python-single-r1 systemd udev

DESCRIPTION="D-Bus service to check the availability of dual-GPU"
HOMEPAGE="https://gitlab.freedesktop.org/hadess/switcheroo-control/"
SRC_URI="https://gitlab.freedesktop.org/hadess/switcheroo-control/-/releases/${PV}/downloads/${P}.tar.xz"

LICENSE="GPL-3"
SLOT="0"
KEYWORDS="~amd64 ~arm ~arm64 ~loong ~ppc64 ~riscv ~x86"

IUSE="gtk-doc selinux test video_cards_amdgpu video_cards_nouveau"
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

RDEPEND="${PYTHON_DEPS}
	$(python_gen_cond_dep 'dev-python/pygobject:3[${PYTHON_USEDEP}]')
	>=dev-libs/glib-2.56.0:2
	>=dev-libs/libgudev-232:=
	>=x11-libs/libdrm-2.4.97[video_cards_amdgpu?,video_cards_nouveau?]
	selinux? ( sec-policy/selinux-switcheroo )
"
DEPEND="${RDEPEND}"
BDEPEND="
	$(python_gen_cond_dep 'dev-python/pygobject:3[${PYTHON_USEDEP}]')
	dev-util/gdbus-codegen
	gtk-doc? ( dev-util/gtk-doc )
	test? (
		$(python_gen_cond_dep 'dev-python/python-dbusmock[${PYTHON_USEDEP}]')
		dev-util/umockdev
	)
"

RESTRICT="!test? ( test )"

python_check_deps() {
	if use test; then
		python_has_version "dev-python/python-dbusmock[${PYTHON_USEDEP}]" &&
		python_has_version "dev-python/pygobject:3[${PYTHON_USEDEP}]"
	else
		python_has_version "dev-python/pygobject:3[${PYTHON_USEDEP}]"
	fi
}

src_prepare() {
	default

	# GPU detection fails when running on sandbox
	sed -i -e '/discrete-detection/d' tests/meson.build || die
}

src_configure() {
	local emesonargs=(
		-Drulesdir="$(get_udevdir)"/rules.d
		-Dsystemdsystemunitdir="$(systemd_get_systemunitdir)"
		$(meson_use gtk-doc gtk_doc)
		$(meson_use test tests)
	)
	meson_src_configure
}

src_install() {
	meson_src_install
	python_fix_shebang "${ED}"/usr/bin/switcherooctl
	newinitd "${FILESDIR}"/${PN}-init.d ${PN}
}

pkg_postinst() {
	udev_reload

	if [[ -z "${REPLACING_VERSIONS}" ]]; then
		elog "You need to enable the service:"
		if systemd_is_booted; then
			elog "# systemctl enable ${PN}"
		else
			elog "# rc-update add ${PN} default"
		fi
	fi
}

pkg_postrm() {
	udev_reload
}
