/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.value.Value;

public class XPathException
extends TransformerException {
    private boolean isTypeError = false;
    private boolean isStaticError = false;
    private boolean isGlobalError = false;
    private String locationText = null;
    private StructuredQName errorCode;
    private Value errorObject;
    private boolean hasBeenReported = false;
    transient XPathContext context;

    public XPathException(String message) {
        super(message);
    }

    public XPathException(Throwable err) {
        super(err);
    }

    public XPathException(String message, Throwable err) {
        super(message, err);
    }

    public XPathException(String message, SourceLocator loc) {
        super(message, loc);
    }

    public XPathException(String message, SourceLocator loc, Throwable err) {
        super(message, loc, err);
    }

    public XPathException(String message, String errorCode) {
        super(message);
        this.setErrorCode(errorCode);
    }

    public XPathException(String message, String errorCode, XPathContext context) {
        super(message);
        this.setErrorCode(errorCode);
        this.setXPathContext(context);
    }

    public static XPathException makeXPathException(TransformerException err) {
        if (err instanceof XPathException) {
            return (XPathException)err;
        }
        if (err.getException() instanceof XPathException) {
            return (XPathException)err.getException();
        }
        return new XPathException(err);
    }

    public XPathException makeStatic() {
        this.setIsStaticError(true);
        return this;
    }

    public void setXPathContext(XPathContext context) {
        this.context = context;
    }

    public XPathContext getXPathContext() {
        return this.context;
    }

    public void setAdditionalLocationText(String text) {
        this.locationText = text;
    }

    public String getAdditionalLocationText() {
        return this.locationText;
    }

    public void setIsStaticError(boolean is) {
        this.isStaticError = is;
    }

    public boolean isStaticError() {
        return this.isStaticError;
    }

    public void setIsTypeError(boolean is) {
        this.isTypeError = is;
    }

    public boolean isTypeError() {
        return this.isTypeError;
    }

    public void setIsGlobalError(boolean is) {
        this.isGlobalError = is;
    }

    public boolean isGlobalError() {
        return this.isGlobalError;
    }

    public void setErrorCode(String code) {
        if (code != null) {
            this.errorCode = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", code);
        }
    }

    public void maybeSetErrorCode(String code) {
        if (this.errorCode == null && code != null) {
            this.errorCode = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", code);
        }
    }

    public void setErrorCodeQName(StructuredQName code) {
        this.errorCode = code;
    }

    public StructuredQName getErrorCodeQName() {
        return this.errorCode;
    }

    public String getErrorCodeLocalPart() {
        return this.errorCode == null ? null : this.errorCode.getLocalName();
    }

    public String getErrorCodeNamespace() {
        return this.errorCode == null ? null : this.errorCode.getNamespaceURI();
    }

    public void setErrorObject(Value value) {
        this.errorObject = value;
    }

    public Value getErrorObject() {
        return this.errorObject;
    }

    public void setHasBeenReported(boolean reported) {
        this.hasBeenReported = reported;
    }

    public boolean hasBeenReported() {
        return this.hasBeenReported;
    }

    public void maybeSetLocation(SourceLocator locator) {
        if ((this.getLocator() == null || this.getLocator().getLineNumber() == -1) && locator != null) {
            this.setLocator(locator);
        }
    }

    public void maybeSetContext(XPathContext context) {
        if (this.getXPathContext() == null) {
            this.setXPathContext(context);
        }
    }

    public boolean isReportableStatically() {
        if (this.isStaticError() || this.isTypeError()) {
            return true;
        }
        if (this.errorCode != null && this.errorCode.getNamespaceURI().equals("http://www.w3.org/2005/xqt-errors")) {
            String local = this.errorCode.getLocalName();
            return local.equals("XTDE1260") || local.equals("XTDE1280") || local.equals("XTDE1390") || local.equals("XTDE1400") || local.equals("XDTE1428") || local.equals("XTDE1440") || local.equals("XTDE1460");
        }
        return false;
    }

    public static class Circularity
    extends XPathException {
        public Circularity(String message) {
            super(message);
        }
    }
}

