/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.deltaxml.core.DXPConfiguration;
import com.deltaxml.core.PipelinedComparator;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

public class DeltaXML
extends DefaultStep {
    private ReadablePipe source = null;
    private ReadablePipe alternate = null;
    private ReadablePipe dxp = null;
    private WritablePipe result = null;

    public DeltaXML(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else if ("alternate".equals(string)) {
            this.alternate = readablePipe;
        } else {
            this.dxp = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode xdmNode = this.source.read();
        XdmNode xdmNode2 = this.alternate.read();
        XdmNode xdmNode3 = this.dxp.read();
        try {
            DXPConfiguration dXPConfiguration = new DXPConfiguration(S9apiUtils.xdmToInputSource(this.runtime, xdmNode3), null, false);
            PipelinedComparator pipelinedComparator = dXPConfiguration.generate();
            StringWriter stringWriter = new StringWriter();
            Serializer serializer = new Serializer();
            serializer.setOutputWriter((Writer)stringWriter);
            S9apiUtils.serialize(this.runtime, xdmNode, serializer);
            String string = stringWriter.toString();
            stringWriter = new StringWriter();
            serializer = new Serializer();
            serializer.setOutputWriter((Writer)stringWriter);
            S9apiUtils.serialize(this.runtime, xdmNode2, serializer);
            String string2 = stringWriter.toString();
            StringBuffer stringBuffer = new StringBuffer();
            pipelinedComparator.compare(string, string2, stringBuffer);
            StringReader stringReader = new StringReader(stringBuffer.toString());
            XdmNode xdmNode4 = this.runtime.parse(new InputSource(stringReader));
            this.result.write(xdmNode4);
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
    }
}

