/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.ByteBlockPool;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.CharBlockPool;
import org.apache.lucene.index.DocInverterPerField;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IntBlockPool;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.RawPostingList;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashPerThread;

final class TermsHashPerField
extends InvertedDocConsumerPerField {
    final TermsHashConsumerPerField consumer;
    final TermsHashPerField nextPerField;
    final TermsHashPerThread perThread;
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState;
    TermAttribute termAtt;
    final CharBlockPool charPool;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    final int streamCount;
    final int numPostingInt;
    final FieldInfo fieldInfo;
    boolean postingsCompacted;
    int numPostings;
    private int postingsHashSize = 4;
    private int postingsHashHalfSize = this.postingsHashSize / 2;
    private int postingsHashMask = this.postingsHashSize - 1;
    private RawPostingList[] postingsHash = new RawPostingList[this.postingsHashSize];
    private RawPostingList p;
    private boolean doCall;
    private boolean doNextCall;
    int[] intUptos;
    int intUptoStart;

    public TermsHashPerField(DocInverterPerField docInverterPerField, TermsHashPerThread perThread, TermsHashPerThread nextPerThread, FieldInfo fieldInfo) {
        this.perThread = perThread;
        this.intPool = perThread.intPool;
        this.charPool = perThread.charPool;
        this.bytePool = perThread.bytePool;
        this.docState = perThread.docState;
        this.fieldState = docInverterPerField.fieldState;
        this.consumer = perThread.consumer.addField(this, fieldInfo);
        this.streamCount = this.consumer.getStreamCount();
        this.numPostingInt = 2 * this.streamCount;
        this.fieldInfo = fieldInfo;
        this.nextPerField = nextPerThread != null ? (TermsHashPerField)nextPerThread.addField(docInverterPerField, fieldInfo) : null;
    }

    void shrinkHash(int targetSize) {
        int newSize;
        assert (this.postingsCompacted || this.numPostings == 0);
        for (newSize = this.postingsHash.length; newSize >= 8 && newSize / 4 > targetSize; newSize /= 2) {
        }
        if (newSize != this.postingsHash.length) {
            this.postingsHash = new RawPostingList[newSize];
            this.postingsHashSize = newSize;
            this.postingsHashHalfSize = newSize / 2;
            this.postingsHashMask = newSize - 1;
        }
    }

    public void reset() {
        if (!this.postingsCompacted) {
            this.compactPostings();
        }
        assert (this.numPostings <= this.postingsHash.length);
        if (this.numPostings > 0) {
            this.perThread.termsHash.recyclePostings(this.postingsHash, this.numPostings);
            Arrays.fill(this.postingsHash, 0, this.numPostings, null);
            this.numPostings = 0;
        }
        this.postingsCompacted = false;
        if (this.nextPerField != null) {
            this.nextPerField.reset();
        }
    }

    public synchronized void abort() {
        this.reset();
        if (this.nextPerField != null) {
            this.nextPerField.abort();
        }
    }

    public void initReader(ByteSliceReader reader, RawPostingList p, int stream) {
        assert (stream < this.streamCount);
        int[] ints = this.intPool.buffers[p.intStart >> 13];
        int upto = p.intStart & 0x1FFF;
        reader.init(this.bytePool, p.byteStart + stream * ByteBlockPool.FIRST_LEVEL_SIZE, ints[upto + stream]);
    }

    private synchronized void compactPostings() {
        int upto = 0;
        for (int i = 0; i < this.postingsHashSize; ++i) {
            if (this.postingsHash[i] == null) continue;
            if (upto < i) {
                this.postingsHash[upto] = this.postingsHash[i];
                this.postingsHash[i] = null;
            }
            ++upto;
        }
        assert (upto == this.numPostings);
        this.postingsCompacted = true;
    }

    public RawPostingList[] sortPostings() {
        this.compactPostings();
        this.quickSort(this.postingsHash, 0, this.numPostings - 1);
        return this.postingsHash;
    }

    void quickSort(RawPostingList[] postings, int lo, int hi) {
        int right;
        int left;
        RawPostingList tmp;
        if (lo >= hi) {
            return;
        }
        if (hi == 1 + lo) {
            if (this.comparePostings(postings[lo], postings[hi]) > 0) {
                RawPostingList tmp2 = postings[lo];
                postings[lo] = postings[hi];
                postings[hi] = tmp2;
            }
            return;
        }
        int mid = lo + hi >>> 1;
        if (this.comparePostings(postings[lo], postings[mid]) > 0) {
            tmp = postings[lo];
            postings[lo] = postings[mid];
            postings[mid] = tmp;
        }
        if (this.comparePostings(postings[mid], postings[hi]) > 0) {
            tmp = postings[mid];
            postings[mid] = postings[hi];
            postings[hi] = tmp;
            if (this.comparePostings(postings[lo], postings[mid]) > 0) {
                RawPostingList tmp2 = postings[lo];
                postings[lo] = postings[mid];
                postings[mid] = tmp2;
            }
        }
        if ((left = lo + 1) >= (right = hi - 1)) {
            return;
        }
        RawPostingList partition = postings[mid];
        while (true) {
            if (this.comparePostings(postings[right], partition) > 0) {
                --right;
                continue;
            }
            while (left < right && this.comparePostings(postings[left], partition) <= 0) {
                ++left;
            }
            if (left >= right) break;
            RawPostingList tmp3 = postings[left];
            postings[left] = postings[right];
            postings[right] = tmp3;
            --right;
        }
        this.quickSort(postings, lo, left);
        this.quickSort(postings, left + 1, hi);
    }

    int comparePostings(RawPostingList p1, RawPostingList p2) {
        char c1;
        if (p1 == p2) {
            return 0;
        }
        char[] text1 = this.charPool.buffers[p1.textStart >> 14];
        int pos1 = p1.textStart & 0x3FFF;
        char[] text2 = this.charPool.buffers[p2.textStart >> 14];
        int pos2 = p2.textStart & 0x3FFF;
        assert (text1 != text2 || pos1 != pos2);
        while (true) {
            char c2;
            if ((c1 = text1[pos1++]) == (c2 = text2[pos2++])) continue;
            if ('\uffff' == c2) {
                return 1;
            }
            if ('\uffff' == c1) {
                return -1;
            }
            return c1 - c2;
            assert (c1 != '\uffff');
        }
    }

    private boolean postingEquals(char[] tokenText, int tokenTextLen) {
        char[] text = this.perThread.charPool.buffers[this.p.textStart >> 14];
        assert (text != null);
        int pos = this.p.textStart & 0x3FFF;
        for (int tokenPos = 0; tokenPos < tokenTextLen; ++tokenPos) {
            if (tokenText[tokenPos] != text[pos]) {
                return false;
            }
            ++pos;
        }
        return '\uffff' == text[pos];
    }

    void start(Fieldable f) {
        this.termAtt = this.fieldState.attributeSource.addAttribute(TermAttribute.class);
        this.consumer.start(f);
        if (this.nextPerField != null) {
            this.nextPerField.start(f);
        }
    }

    boolean start(Fieldable[] fields, int count) throws IOException {
        this.doCall = this.consumer.start(fields, count);
        if (this.nextPerField != null) {
            this.doNextCall = this.nextPerField.start(fields, count);
        }
        return this.doCall || this.doNextCall;
    }

    public void add(int textStart) throws IOException {
        int code = textStart;
        int hashPos = code & this.postingsHashMask;
        assert (!this.postingsCompacted);
        this.p = this.postingsHash[hashPos];
        if (this.p != null && this.p.textStart != textStart) {
            int inc = (code >> 8) + code | 1;
            do {
                hashPos = (code += inc) & this.postingsHashMask;
                this.p = this.postingsHash[hashPos];
            } while (this.p != null && this.p.textStart != textStart);
        }
        if (this.p == null) {
            if (0 == this.perThread.freePostingsCount) {
                this.perThread.morePostings();
            }
            this.p = this.perThread.freePostings[--this.perThread.freePostingsCount];
            assert (this.p != null);
            this.p.textStart = textStart;
            assert (this.postingsHash[hashPos] == null);
            this.postingsHash[hashPos] = this.p;
            ++this.numPostings;
            if (this.numPostings == this.postingsHashHalfSize) {
                this.rehashPostings(2 * this.postingsHashSize);
            }
            if (this.numPostingInt + this.intPool.intUpto > 8192) {
                this.intPool.nextBuffer();
            }
            if (32768 - this.bytePool.byteUpto < this.numPostingInt * ByteBlockPool.FIRST_LEVEL_SIZE) {
                this.bytePool.nextBuffer();
            }
            this.intUptos = this.intPool.buffer;
            this.intUptoStart = this.intPool.intUpto;
            this.intPool.intUpto += this.streamCount;
            this.p.intStart = this.intUptoStart + this.intPool.intOffset;
            for (int i = 0; i < this.streamCount; ++i) {
                int upto = this.bytePool.newSlice(ByteBlockPool.FIRST_LEVEL_SIZE);
                this.intUptos[this.intUptoStart + i] = upto + this.bytePool.byteOffset;
            }
            this.p.byteStart = this.intUptos[this.intUptoStart];
            this.consumer.newTerm(this.p);
        } else {
            this.intUptos = this.intPool.buffers[this.p.intStart >> 13];
            this.intUptoStart = this.p.intStart & 0x1FFF;
            this.consumer.addTerm(this.p);
        }
    }

    void add() throws IOException {
        int tokenTextLen;
        assert (!this.postingsCompacted);
        char[] tokenText = this.termAtt.termBuffer();
        int downto = tokenTextLen = this.termAtt.termLength();
        int code = 0;
        while (downto > 0) {
            int ch;
            if ((ch = tokenText[--downto]) >= 56320 && ch <= 57343) {
                if (0 == downto) {
                    tokenText[downto] = 65533;
                    ch = 65533;
                } else {
                    char ch2 = tokenText[downto - 1];
                    if (ch2 >= '\ud800' && ch2 <= '\udbff') {
                        code = (code * 31 + ch) * 31 + ch2;
                        --downto;
                        continue;
                    }
                    tokenText[downto] = 65533;
                    ch = 65533;
                }
            } else if (ch >= 55296 && (ch <= 56319 || ch == 65535)) {
                tokenText[downto] = 65533;
                ch = 65533;
            }
            code = code * 31 + ch;
        }
        int hashPos = code & this.postingsHashMask;
        this.p = this.postingsHash[hashPos];
        if (this.p != null && !this.postingEquals(tokenText, tokenTextLen)) {
            int inc = (code >> 8) + code | 1;
            do {
                hashPos = (code += inc) & this.postingsHashMask;
                this.p = this.postingsHash[hashPos];
            } while (this.p != null && !this.postingEquals(tokenText, tokenTextLen));
        }
        if (this.p == null) {
            int textLen1 = 1 + tokenTextLen;
            if (textLen1 + this.charPool.charUpto > 16384) {
                if (textLen1 > 16384) {
                    if (this.docState.maxTermPrefix == null) {
                        this.docState.maxTermPrefix = new String(tokenText, 0, 30);
                    }
                    this.consumer.skippingLongTerm();
                    return;
                }
                this.charPool.nextBuffer();
            }
            if (0 == this.perThread.freePostingsCount) {
                this.perThread.morePostings();
            }
            this.p = this.perThread.freePostings[--this.perThread.freePostingsCount];
            assert (this.p != null);
            char[] text = this.charPool.buffer;
            int textUpto = this.charPool.charUpto;
            this.p.textStart = textUpto + this.charPool.charOffset;
            this.charPool.charUpto += textLen1;
            System.arraycopy(tokenText, 0, text, textUpto, tokenTextLen);
            text[textUpto + tokenTextLen] = 65535;
            assert (this.postingsHash[hashPos] == null);
            this.postingsHash[hashPos] = this.p;
            ++this.numPostings;
            if (this.numPostings == this.postingsHashHalfSize) {
                this.rehashPostings(2 * this.postingsHashSize);
            }
            if (this.numPostingInt + this.intPool.intUpto > 8192) {
                this.intPool.nextBuffer();
            }
            if (32768 - this.bytePool.byteUpto < this.numPostingInt * ByteBlockPool.FIRST_LEVEL_SIZE) {
                this.bytePool.nextBuffer();
            }
            this.intUptos = this.intPool.buffer;
            this.intUptoStart = this.intPool.intUpto;
            this.intPool.intUpto += this.streamCount;
            this.p.intStart = this.intUptoStart + this.intPool.intOffset;
            for (int i = 0; i < this.streamCount; ++i) {
                int upto = this.bytePool.newSlice(ByteBlockPool.FIRST_LEVEL_SIZE);
                this.intUptos[this.intUptoStart + i] = upto + this.bytePool.byteOffset;
            }
            this.p.byteStart = this.intUptos[this.intUptoStart];
            this.consumer.newTerm(this.p);
        } else {
            this.intUptos = this.intPool.buffers[this.p.intStart >> 13];
            this.intUptoStart = this.p.intStart & 0x1FFF;
            this.consumer.addTerm(this.p);
        }
        if (this.doNextCall) {
            this.nextPerField.add(this.p.textStart);
        }
    }

    void writeByte(int stream, byte b) {
        int upto = this.intUptos[this.intUptoStart + stream];
        byte[] bytes = this.bytePool.buffers[upto >> 15];
        assert (bytes != null);
        int offset = upto & Short.MAX_VALUE;
        if (bytes[offset] != 0) {
            offset = this.bytePool.allocSlice(bytes, offset);
            bytes = this.bytePool.buffer;
            this.intUptos[this.intUptoStart + stream] = offset + this.bytePool.byteOffset;
        }
        bytes[offset] = b;
        int n = this.intUptoStart + stream;
        this.intUptos[n] = this.intUptos[n] + 1;
    }

    public void writeBytes(int stream, byte[] b, int offset, int len) {
        int end = offset + len;
        for (int i = offset; i < end; ++i) {
            this.writeByte(stream, b[i]);
        }
    }

    void writeVInt(int stream, int i) {
        assert (stream < this.streamCount);
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte(stream, (byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte(stream, (byte)i);
    }

    void finish() throws IOException {
        this.consumer.finish();
        if (this.nextPerField != null) {
            this.nextPerField.finish();
        }
    }

    void rehashPostings(int newSize) {
        int newMask = newSize - 1;
        RawPostingList[] newHash = new RawPostingList[newSize];
        for (int i = 0; i < this.postingsHashSize; ++i) {
            int code;
            RawPostingList p0 = this.postingsHash[i];
            if (p0 == null) continue;
            if (this.perThread.primary) {
                int start = p0.textStart & 0x3FFF;
                char[] text = this.charPool.buffers[p0.textStart >> 14];
                int pos = start;
                while (text[pos] != '\uffff') {
                    ++pos;
                }
                code = 0;
                while (pos > start) {
                    code = code * 31 + text[--pos];
                }
            } else {
                code = p0.textStart;
            }
            int hashPos = code & newMask;
            assert (hashPos >= 0);
            if (newHash[hashPos] != null) {
                int inc = (code >> 8) + code | 1;
                while (newHash[hashPos = (code += inc) & newMask] != null) {
                }
            }
            newHash[hashPos] = p0;
        }
        this.postingsHashMask = newMask;
        this.postingsHash = newHash;
        this.postingsHashSize = newSize;
        this.postingsHashHalfSize = newSize >> 1;
    }
}

