/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.util.Map;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class Rename
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("", "match");
    private static final QName _new_name = new QName("", "new-name");
    private static final QName _new_prefix = new QName("", "new-prefix");
    private static final QName _new_namespace = new QName("", "new-namespace");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Map<QName, RuntimeValue> inScopeOptions = null;
    private ProcessMatch matcher = null;
    private QName newName = null;

    public Rename(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue runtimeValue = this.getOption(_new_name);
        String string = runtimeValue.getString();
        String string2 = this.getOption(_new_prefix, (String)null);
        String string3 = this.getOption(_new_namespace, (String)null);
        if (string2 != null && string3 == null) {
            throw XProcException.dynamicError(34, "You can't specify a prefix without a namespace");
        }
        if (string3 != null && string.contains(":")) {
            throw XProcException.dynamicError(34, "You can't specify a namespace if the new-name contains a colon");
        }
        this.newName = string.contains(":") ? new QName(string, runtimeValue.getNode()) : new QName(string2 == null ? "" : string2, string3, string);
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
    }

    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addStartElement(xdmNode, this.newName);
        this.matcher.addAttributes(xdmNode);
        return true;
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        if (!"".equals(this.newName.getNamespaceURI())) {
            throw XProcException.stepError(13);
        }
        this.matcher.addPI(this.newName.getLocalName(), xdmNode.getStringValue());
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addAttribute(this.newName, xdmNode.getStringValue());
    }
}

