/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.util.regex.Pattern;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.util.StringUtil;

public class binascii {
    public static String __doc__ = "Conversion between binary data and ASCII";
    public static final PyObject Error = Py.makeClass("Error", Py.Exception, binascii.exceptionNamespace());
    public static final PyObject Incomplete = Py.makeClass("Incomplete", Py.Exception, binascii.exceptionNamespace());
    private static char RUNCHAR = (char)144;
    private static short DONE = (short)127;
    private static short SKIP = (short)126;
    private static short FAIL = (short)125;
    private static short[] table_a2b_hqx = new short[]{FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, SKIP, FAIL, FAIL, SKIP, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, FAIL, FAIL, 13, 14, 15, 16, 17, 18, 19, FAIL, 20, 21, DONE, FAIL, FAIL, FAIL, FAIL, FAIL, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, FAIL, 37, 38, 39, 40, 41, 42, 43, FAIL, 44, 45, 46, 47, FAIL, FAIL, FAIL, FAIL, 48, 49, 50, 51, 52, 53, 54, FAIL, 55, 56, 57, 58, 59, 60, FAIL, FAIL, 61, 62, 63, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL, FAIL};
    private static byte[] table_b2a_hqx = StringUtil.toBytes("!\"#$%&'()*+,-012345689@ABCDEFGHIJKLMNPQRSTUVXYZ[`abcdefhijklmpqr");
    private static short[] table_a2b_base64 = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    private static char BASE64_PAD = (char)61;
    private static int BASE64_MAXBIN = 0x3FFFFFFC;
    private static byte[] table_b2a_base64 = StringUtil.toBytes("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    private static int[] crctab_hqx = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935, 4657, 528, 12915, 8786, 21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076, 62463, 58334, 9314, 13379, 1056, 5121, 25830, 29895, 17572, 21637, 42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669, 13907, 9842, 5649, 1584, 30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616, 63455, 59390, 55197, 51132, 18628, 22757, 26758, 30887, 2112, 6241, 10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403, 23285, 19156, 31415, 27286, 6769, 2640, 14899, 10770, 56317, 52188, 64447, 60318, 39801, 35672, 47931, 43802, 27814, 31879, 19684, 23749, 11298, 15363, 3168, 7233, 60846, 64911, 52716, 56781, 44330, 48395, 36200, 40265, 32407, 28342, 24277, 20212, 15891, 11826, 7761, 3696, 65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728, 37256, 33193, 45514, 41451, 53516, 49453, 61774, 57711, 4224, 161, 12482, 8419, 20484, 16421, 28742, 24679, 33721, 37784, 41979, 46042, 49981, 54044, 58239, 62302, 689, 4752, 8947, 13010, 16949, 21012, 25207, 29270, 46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411, 5280, 1153, 29798, 25671, 21540, 17413, 42971, 47098, 34713, 38840, 59231, 63358, 50973, 55100, 9939, 14066, 1681, 5808, 26199, 30326, 17941, 22068, 55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435, 22596, 18533, 30726, 26663, 6336, 2273, 14466, 10403, 52093, 56156, 60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254, 2801, 6864, 10931, 14994, 64814, 60687, 56684, 52557, 48554, 44427, 40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392, 3265, 61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310, 20053, 24180, 11923, 16050, 3793, 7920};
    public static PyString __doc__a2b_uu = new PyString("(ascii) -> bin. Decode a line of uuencoded data");
    public static PyString __doc__b2a_uu = new PyString("(bin) -> ascii. Uuencode line of data");
    public static PyString __doc__a2b_base64 = new PyString("(ascii) -> bin. Decode a line of base64 data");
    public static PyString __doc__b2a_base64 = new PyString("(bin) -> ascii. Base64-code line of data");
    public static PyString __doc__a2b_hqx = new PyString("ascii -> bin, done. Decode .hqx coding");
    public static PyString __doc__rlecode_hqx = new PyString("Binhex RLE-code binary data");
    public static PyString __doc__b2a_hqx = new PyString("Encode .hqx data");
    public static PyString __doc__rledecode_hqx = new PyString("Decode hexbin RLE-coded string");
    public static PyString __doc__crc_hqx = new PyString("(data, oldcrc) -> newcrc. Compute hqx CRC incrementally");
    static long[] crc_32_tab = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};
    private static char[] hexdigit = "0123456789abcdef".toCharArray();
    public static PyString __doc__b2a_hex = new PyString("b2a_hex(data) -> s; Hexadecimal representation of binary data.\n\nThis function is also available as \"hexlify()\".");
    public static PyString a2b_hex$doc = new PyString("a2b_hex(hexstr) -> s; Binary data of hexadecimal representation.\n\nhexstr must contain an even number of hex digits (upper or lower case).\nThis function is also available as \"unhexlify()\"");
    private static final char[] upper_hexdigit = "0123456789ABCDEF".toCharArray();
    private static final Pattern UNDERSCORE = Pattern.compile("_");
    public static final PyString __doc__a2b_qp = new PyString("Decode a string of qp-encoded data");
    private static final Pattern RN_TO_N = Pattern.compile("\r\n");
    private static final Pattern N_TO_RN = Pattern.compile("(?<!\r)\n");
    public static final PyString __doc__b2a_qp = new PyString("b2a_qp(data, quotetabs=0, istext=1, header=0) -> s;\nEncode a string using quoted-printable encoding.\n\nOn encoding, when istext is set, newlines are not encoded, and white\nspace at end of lines is.  When istext is not set, \r and \n (CR/LF) are\nboth encoded.  When quotetabs is set, space and tabs are encoded.");

    public static PyObject exceptionNamespace() {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__module__", (PyObject)new PyString("binascii"));
        return dict;
    }

    /*
     * WARNING - void declaration
     */
    public static PyString a2b_uu(String ascii_data) {
        void this_ch;
        char bin_len;
        void i;
        int leftbits = 0;
        int leftchar = 0;
        if (ascii_data.length() == 0) {
            return new PyString("");
        }
        StringBuilder bin_data = new StringBuilder();
        int n = ascii_data.length() - 1;
        int n2 = ascii_data.charAt(0) - 32 & 0x3F;
        int ascii_len = 0;
        while (i > 0 && n > 0) {
            bin_len = ascii_data.charAt(ascii_len + 1);
            if (bin_len == '\n' || bin_len == '\r' || this_ch <= 0) {
                bin_len = '\u0000';
            } else {
                if (bin_len < ' ' || bin_len > '`') {
                    throw new PyException(Error, "Illegal char");
                }
                bin_len = (char)(bin_len - 32 & 0x3F);
            }
            leftchar = leftchar << 6 | bin_len;
            if ((leftbits += 6) >= 8) {
                bin_data.append((char)(leftchar >> (leftbits -= 8) & 0xFF));
                leftchar &= (1 << leftbits) - 1;
                --i;
            }
            ++ascii_len;
            --this_ch;
        }
        while (this_ch-- > 0) {
            if ((bin_len = ascii_data.charAt(++ascii_len)) == ' ' || bin_len == '@' || bin_len == '\n' || bin_len == '\r') continue;
            throw new PyException(Error, "Trailing garbage");
        }
        while (ascii_len < i) {
            bin_data.append('\u0000');
            ++ascii_len;
        }
        return new PyString(bin_data.toString());
    }

    public static PyString b2a_uu(String bin_data) {
        int leftbits = 0;
        int n = 0;
        int leftchar = bin_data.length();
        if (leftchar > 45) {
            throw new PyException(Error, "At most 45 bytes at once");
        }
        StringBuilder bin_len = new StringBuilder();
        bin_len.append((char)(32 + (leftchar & 0x3F)));
        int ascii_data = 0;
        while (leftchar > 0 || leftbits != 0) {
            n = leftchar > 0 ? n << 8 | bin_data.charAt(ascii_data) : (n <<= 8);
            leftbits += 8;
            while (leftbits >= 6) {
                char i = (char)(n >> leftbits - 6 & 0x3F);
                leftbits -= 6;
                bin_len.append((char)(i + 32));
            }
            ++ascii_data;
            --leftchar;
        }
        bin_len.append('\n');
        return new PyString(bin_len.toString());
    }

    private static int binascii_find_valid(String s, int offset, int num) {
        int ret = -1;
        for (int slen = s.length() - offset; slen > 0 && ret == -1; --slen) {
            char c = s.charAt(offset);
            short b64val = table_a2b_base64[c & 0x7F];
            if (c <= '\u007f' && b64val != -1) {
                if (num == 0) {
                    ret = c;
                }
                --num;
            }
            ++offset;
        }
        return ret;
    }

    public static PyString a2b_base64(String ascii_data) {
        int leftbits = 0;
        boolean bl = false;
        int leftchar = 0;
        int quad_pos = ascii_data.length();
        int ascii_len = 0;
        StringBuilder bin_len = new StringBuilder();
        int bin_data = 0;
        while (quad_pos > 0) {
            char i = ascii_data.charAt(bin_data);
            if (i <= '\u007f' && i != '\r' && i != '\n' && i != ' ') {
                if (i == BASE64_PAD) {
                    if (leftchar >= 2 && (leftchar != 2 || binascii.binascii_find_valid(ascii_data, bin_data, 1) == BASE64_PAD)) {
                        leftbits = 0;
                        break;
                    }
                } else {
                    short this_v = table_a2b_base64[i];
                    if (this_v != -1) {
                        int this_ch;
                        leftchar = leftchar + 1 & 3;
                        this_ch = this_ch << 6 | this_v;
                        if ((leftbits += 6) >= 8) {
                            bin_len.append((char)(this_ch >> (leftbits -= 8) & 0xFF));
                            ++ascii_len;
                            this_ch &= (1 << leftbits) - 1;
                        }
                    }
                }
            }
            --quad_pos;
            ++bin_data;
        }
        if (leftbits != 0) {
            throw new PyException(Error, "Incorrect padding");
        }
        return new PyString(bin_len.toString());
    }

    public static PyString b2a_base64(String bin_data) {
        int leftbits = 0;
        int n = 0;
        StringBuilder leftchar = new StringBuilder();
        int ascii_data = bin_data.length();
        if (ascii_data > BASE64_MAXBIN) {
            throw new PyException(Error, "Too much data for base64 line");
        }
        int bin_len = 0;
        while (ascii_data > 0) {
            n = n << 8 | bin_data.charAt(bin_len);
            leftbits += 8;
            while (leftbits >= 6) {
                char i = (char)(n >> leftbits - 6 & 0x3F);
                leftbits -= 6;
                leftchar.append((char)table_b2a_base64[i]);
            }
            --ascii_data;
            ++bin_len;
        }
        if (leftbits == 2) {
            leftchar.append((char)table_b2a_base64[(n & 3) << 4]);
            leftchar.append(BASE64_PAD);
            leftchar.append(BASE64_PAD);
        } else if (leftbits == 4) {
            leftchar.append((char)table_b2a_base64[(n & 0xF) << 2]);
            leftchar.append(BASE64_PAD);
        }
        leftchar.append('\n');
        return new PyString(leftchar.toString());
    }

    public static PyTuple a2b_hqx(String ascii_data) {
        int leftbits = 0;
        boolean bl = false;
        boolean leftchar = false;
        int done = ascii_data.length();
        StringBuilder len = new StringBuilder();
        int bin_data = 0;
        while (done > 0) {
            char i = (char)table_a2b_hqx[ascii_data.charAt(bin_data)];
            if (i != SKIP) {
                int this_ch;
                if (i == FAIL) {
                    throw new PyException(Error, "Illegal char");
                }
                if (i == DONE) {
                    leftchar = true;
                    break;
                }
                this_ch = this_ch << 6 | i;
                if ((leftbits += 6) >= 8) {
                    len.append((char)(this_ch >> (leftbits -= 8) & 0xFF));
                    this_ch &= (1 << leftbits) - 1;
                }
            }
            --done;
            ++bin_data;
        }
        if (leftbits != 0 && !leftchar) {
            throw new PyException(Incomplete, "String has incomplete number of bytes");
        }
        return new PyTuple(Py.java2py(len.toString()), Py.newInteger(leftchar ? 1 : 0));
    }

    public static String rlecode_hqx(String in_data) {
        int len = in_data.length();
        StringBuilder out_data = new StringBuilder();
        for (int in = 0; in < len; ++in) {
            int inend;
            char ch = in_data.charAt(in);
            if (ch == RUNCHAR) {
                out_data.append(RUNCHAR);
                out_data.append(0);
                continue;
            }
            for (inend = in + 1; inend < len && in_data.charAt(inend) == ch && inend < in + 255; ++inend) {
            }
            if (inend - in > 3) {
                out_data.append(ch);
                out_data.append(RUNCHAR);
                out_data.append((char)(inend - in));
                in = inend - 1;
                continue;
            }
            out_data.append(ch);
        }
        return out_data.toString();
    }

    public static PyString b2a_hqx(String bin_data) {
        int leftbits = 0;
        int n = 0;
        int leftchar = bin_data.length();
        StringBuilder len = new StringBuilder();
        int ascii_data = 0;
        while (leftchar > 0) {
            n = n << 8 | bin_data.charAt(ascii_data);
            leftbits += 8;
            while (leftbits >= 6) {
                char i = (char)(n >> leftbits - 6 & 0x3F);
                leftbits -= 6;
                len.append((char)table_b2a_hqx[i]);
            }
            --leftchar;
            ++ascii_data;
        }
        if (leftbits != 0) {
            len.append((char)table_b2a_hqx[(n <<= 6 - leftbits) & 0x3F]);
        }
        return new PyString(len.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static String rledecode_hqx(String in_data) {
        char out_data;
        void in_byte;
        char i;
        int n = in_data.length();
        int n2 = 0;
        if (n == 0) {
            return "";
        }
        StringBuilder in_len = new StringBuilder();
        if (--n < 0) {
            throw new PyException(Incomplete);
        }
        if ((i = in_data.charAt(n2++)) == RUNCHAR) {
            if (--in_byte < 0) {
                throw new PyException(Incomplete);
            }
            if ((out_data = in_data.charAt(n2++)) != '\u0000') {
                throw new PyException(Error, "Orphaned RLE code at start");
            }
            in_len.append(RUNCHAR);
        } else {
            in_len.append(i);
        }
        while (in_byte > 0) {
            void in_repeat;
            if (--in_byte < 0) {
                throw new PyException(Incomplete);
            }
            if ((i = in_data.charAt((int)in_repeat++)) == RUNCHAR) {
                if (--in_byte < 0) {
                    throw new PyException(Incomplete);
                }
                if ((out_data = in_data.charAt((int)in_repeat++)) == '\u0000') {
                    in_len.append(RUNCHAR);
                    continue;
                }
                i = in_len.charAt(in_len.length() - 1);
                while ((out_data = (char)(out_data - '\u0001')) > '\u0000') {
                    in_len.append(i);
                }
                continue;
            }
            in_len.append(i);
        }
        return in_len.toString();
    }

    public static int crc_hqx(String bin_data, int crc) {
        int len = bin_data.length();
        int i = 0;
        while (len-- > 0) {
            crc = crc << 8 & 0xFF00 ^ crctab_hqx[crc >> 8 & 0xFF ^ bin_data.charAt(i++)];
        }
        return crc;
    }

    public static int crc32(String bin_data) {
        return binascii.crc32(bin_data, 0L);
    }

    public static int crc32(String bin_data, long crc) {
        int len = bin_data.length();
        crc &= 0xFFFFFFFFL;
        crc ^= 0xFFFFFFFFL;
        for (int i = 0; i < len; ++i) {
            char ch = bin_data.charAt(i);
            crc = (long)((int)crc_32_tab[(int)((crc ^ (long)ch) & 0xFFL)]) ^ crc >> 8;
            crc &= 0xFFFFFFFFL;
        }
        if (crc >= Integer.MIN_VALUE) {
            return -((int)(crc + 1L & 0xFFFFFFFFFFFFFFFFL));
        }
        return (int)(crc & 0xFFFFFFFFFFFFFFFFL);
    }

    public static PyString b2a_hex(String argbuf) {
        int arglen = argbuf.length();
        StringBuilder retbuf = new StringBuilder(arglen * 2);
        for (int i = 0; i < arglen; ++i) {
            char ch = argbuf.charAt(i);
            retbuf.append(hexdigit[ch >>> 4 & 0xF]);
            retbuf.append(hexdigit[ch & 0xF]);
        }
        return new PyString(retbuf.toString());
    }

    public static PyString hexlify(String argbuf) {
        return binascii.b2a_hex(argbuf);
    }

    public static PyString a2b_hex(String argbuf) {
        int arglen = argbuf.length();
        if (arglen % 2 != 0) {
            throw Py.TypeError("Odd-length string");
        }
        StringBuilder retbuf = new StringBuilder(arglen / 2);
        for (int i = 0; i < arglen; i += 2) {
            int top = Character.digit(argbuf.charAt(i), 16);
            int bot = Character.digit(argbuf.charAt(i + 1), 16);
            if (top == -1 || bot == -1) {
                throw Py.TypeError("Non-hexadecimal digit found");
            }
            retbuf.append((char)((top << 4) + bot));
        }
        return new PyString(retbuf.toString());
    }

    public static PyString unhexlify(String argbuf) {
        return binascii.a2b_hex(argbuf);
    }

    private static StringBuilder qpEscape(StringBuilder sb, char c) {
        sb.append('=');
        sb.append(upper_hexdigit[c >>> 4 & 0xF]);
        sb.append(upper_hexdigit[c & 0xF]);
        return sb;
    }

    public static boolean getIntFlagAsBool(ArgParser ap, int index, int dflt, String errMsg) {
        boolean val;
        try {
            val = ap.getInt(index, dflt) != 0;
        }
        catch (PyException e) {
            if (e.match(Py.AttributeError) || e.match(Py.ValueError)) {
                throw Py.TypeError(errMsg);
            }
            throw e;
        }
        return val;
    }

    public static PyString a2b_qp(PyObject[] arg, String[] kws) {
        ArgParser ap = new ArgParser("a2b_qp", arg, kws, new String[]{"s", "header"});
        String s = ap.getString(0);
        StringBuilder sb = new StringBuilder();
        boolean header = binascii.getIntFlagAsBool(ap, 1, 0, "an integer is required");
        if (header) {
            s = UNDERSCORE.matcher(s).replaceAll(" ");
        }
        int i = 0;
        int m = s.length();
        while (i < m) {
            char c;
            if ((c = s.charAt(i++)) == '=') {
                if (i >= m) continue;
                if ((c = s.charAt(i++)) == '=') {
                    sb.append(c);
                    continue;
                }
                if (c == ' ') {
                    sb.append("= ");
                    continue;
                }
                if ((c >= '0' && c <= '9' || c >= 'A' && c <= 'F') && i < m) {
                    char nc;
                    if ((nc = s.charAt(i++)) >= '0' && nc <= '9' || nc >= 'A' && nc <= 'F') {
                        sb.append((char)(Character.digit(c, 16) << 4 | Character.digit(nc, 16)));
                        continue;
                    }
                    sb.append('=').append(c).append(nc);
                    continue;
                }
                if (c == '\n') continue;
                sb.append('=').append(c);
                continue;
            }
            sb.append(c);
        }
        return new PyString(sb.toString());
    }

    public static PyString b2a_qp(PyObject[] arg, String[] kws) {
        String pos;
        ArgParser ap = new ArgParser("b2a_qp", arg, kws, new String[]{"s", "quotetabs", "istext", "header"});
        String s = ap.getString(0);
        boolean quotetabs = binascii.getIntFlagAsBool(ap, 1, 0, "an integer is required");
        boolean istext = binascii.getIntFlagAsBool(ap, 2, 1, "an integer is required");
        boolean header = binascii.getIntFlagAsBool(ap, 3, 0, "an integer is required");
        int n = s.indexOf(10);
        if (n > 0 && s.charAt(n - 1) == '\r') {
            pos = "\r\n";
            s = N_TO_RN.matcher(s).replaceAll("\r\n");
        } else {
            pos = "\n";
            s = RN_TO_N.matcher(s).replaceAll("\n");
        }
        StringBuilder sb = new StringBuilder();
        int count = 0;
        int m = s.length();
        for (int i = 0; i < m; ++i) {
            char c = s.charAt(i);
            if (binascii.lineEnding(s, pos, i)) {
                count = 0;
                sb.append(pos);
                if (pos.length() <= 1) continue;
                ++i;
                continue;
            }
            if ((c == '\t' || c == ' ') && binascii.endOfLine(s, pos, i + 1)) {
                count += 3;
                binascii.qpEscape(sb, c);
                continue;
            }
            if ('!' <= c && c <= '<' || '>' <= c && c <= '^' || '`' <= c && c <= '~' || c == '_' && !header || c == '\n' || c == '\r' && istext) {
                if (count == 75 && !binascii.endOfLine(s, pos, i + 1)) {
                    sb.append("=").append(pos);
                    count = 0;
                }
                sb.append(c);
                ++count;
                continue;
            }
            if (!(quotetabs || c != '\t' && c != ' ')) {
                if (count >= 72) {
                    sb.append("=").append(pos);
                    count = 0;
                }
                if (count >= 71) {
                    count += 3;
                    binascii.qpEscape(sb, c);
                    continue;
                }
                if (c == ' ' && header) {
                    sb.append('_');
                } else {
                    sb.append(c);
                }
                ++count;
                continue;
            }
            if (count >= 72) {
                sb.append("=").append(pos);
                count = 0;
            }
            count += 3;
            binascii.qpEscape(sb, c);
        }
        return new PyString(sb.toString());
    }

    private static boolean endOfLine(String s, String lineEnd, int i) {
        return s.length() == i || binascii.lineEnding(s, lineEnd, i);
    }

    private static boolean lineEnding(String s, String lineEnd, int i) {
        return s.length() > i && s.substring(i).startsWith(lineEnd);
    }
}

