/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.Emitter;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class DocumentHandlerProxy
extends Emitter {
    protected DocumentHandler handler;
    protected AttributeListImpl outputAtts = new AttributeListImpl();
    private int depth = 0;

    public void setUnderlyingDocumentHandler(DocumentHandler documentHandler) {
        this.handler = documentHandler;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.handler != null) {
            this.handler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws TransformerException {
        if (this.handler == null) {
            throw new TransformerException("DocumentHandlerProxy.startDocument(): no underlying handler provided");
        }
        try {
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        this.depth = 0;
    }

    public void endDocument() throws TransformerException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        ++this.depth;
        this.outputAtts.clear();
        int n3 = 0;
        while (n3 < attributes.getLength()) {
            this.outputAtts.addAttribute(attributes.getQName(n3), attributes.getType(n3), attributes.getValue(n3));
            ++n3;
        }
        if (this.depth > 0) {
            int n4 = 0;
            while (n4 < n2) {
                String string = this.namePool.getPrefixFromNamespaceCode(nArray[n4]);
                String string2 = this.namePool.getURIFromNamespaceCode(nArray[n4]);
                if (string.equals("")) {
                    this.outputAtts.addAttribute("xmlns", "NMTOKEN", string2);
                } else {
                    this.outputAtts.addAttribute("xmlns:" + string, "NMTOKEN", string2);
                }
                ++n4;
            }
            try {
                this.handler.startElement(this.namePool.getDisplayName(n), this.outputAtts);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
        }
    }

    public void endElement(int n) throws TransformerException {
        if (this.depth > 0) {
            try {
                this.handler.endElement(this.namePool.getDisplayName(n));
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
        }
        --this.depth;
        if (this.depth <= 0) {
            this.depth = Integer.MIN_VALUE;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        if (this.depth > 0) {
            try {
                this.handler.characters(cArray, n, n2);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
        }
    }

    public void processingInstruction(String string, String string2) throws TransformerException {
        try {
            this.handler.processingInstruction(string, string2);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void comment(char[] cArray, int n, int n2) {
    }
}

