/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.common;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.HttpProvider;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ClientBuilderBase<B extends ClientBuilderBase, C> {
    final Service service;
    protected ClientConfiguration configuration;
    protected ClientConfigurator clientConfigurator;
    protected List<ClientConfigurator> additionalClientConfigurators = new ArrayList<ClientConfigurator>();
    protected RequestSignerFactory requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
    Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories = DefaultRequestSignerFactory.createDefaultRequestSignerFactories();
    protected String endpoint;
    HttpProvider httpProvider;

    public ClientBuilderBase(Service service) {
        this.service = service;
    }

    public B configuration(ClientConfiguration configuration) {
        this.configuration = configuration;
        return (B)this;
    }

    public B clientConfigurator(ClientConfigurator clientConfigurator) {
        this.clientConfigurator = clientConfigurator;
        return (B)this;
    }

    public B additionalClientConfigurator(@Nonnull ClientConfigurator additionalClientConfigurator) {
        if (additionalClientConfigurator == null) {
            throw new NullPointerException("additionalClientConfigurator is marked non-null but is null");
        }
        this.additionalClientConfigurators.add(additionalClientConfigurator);
        return (B)this;
    }

    public B additionalClientConfigurators(@Nonnull List<ClientConfigurator> additionalClientConfigurators) {
        if (additionalClientConfigurators == null) {
            throw new NullPointerException("additionalClientConfigurators");
        }
        this.additionalClientConfigurators.addAll(additionalClientConfigurators);
        return (B)this;
    }

    public B requestSignerFactory(RequestSignerFactory requestSignerFactory) {
        this.requestSignerFactory = requestSignerFactory == null ? new DefaultRequestSignerFactory(SigningStrategy.STANDARD) : requestSignerFactory;
        return (B)this;
    }

    public B endpoint(String endpoint) {
        this.endpoint = endpoint;
        return (B)this;
    }

    public B signingStrategyRequestSignerFactories(Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories) {
        HashMap<SigningStrategy, RequestSignerFactory> copy = new HashMap<SigningStrategy, RequestSignerFactory>(signingStrategyRequestSignerFactories);
        this.signingStrategyRequestSignerFactories = Collections.unmodifiableMap(copy);
        return (B)this;
    }

    public final B httpProvider(HttpProvider httpProvider) {
        this.httpProvider = httpProvider;
        return (B)this;
    }

    public abstract C build(@Nonnull AbstractAuthenticationDetailsProvider var1);

    public B copyFrom(B fromBuilder) {
        return ((ClientBuilderBase)((ClientBuilderBase)((ClientBuilderBase)((ClientBuilderBase)((ClientBuilderBase)((ClientBuilderBase)this.configuration(((ClientBuilderBase)fromBuilder).configuration)).clientConfigurator(((ClientBuilderBase)fromBuilder).clientConfigurator)).additionalClientConfigurators(((ClientBuilderBase)fromBuilder).additionalClientConfigurators)).requestSignerFactory(((ClientBuilderBase)fromBuilder).requestSignerFactory)).endpoint(((ClientBuilderBase)fromBuilder).endpoint)).signingStrategyRequestSignerFactories(((ClientBuilderBase)fromBuilder).signingStrategyRequestSignerFactories)).httpProvider(((ClientBuilderBase)fromBuilder).httpProvider);
    }
}

