/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5
extends AbstractCommand {
    public static final String MD5 = "MD5";
    public static final String MMD5 = "MMD5";
    private final Logger LOG = LoggerFactory.getLogger(MD5.class);
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException {
        session.resetState();
        boolean isMMD5 = MMD5.equals(request.getCommand());
        String argument = request.getArgument();
        if (argument == null || argument.trim().length() == 0) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 504, "MD5.invalid", null));
            return;
        }
        String[] fileNames = null;
        fileNames = isMMD5 ? argument.split(",") : new String[]{argument};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i].trim();
            FtpFile file = null;
            try {
                file = session.getFileSystemView().getFile(fileName);
            }
            catch (Exception ex) {
                this.LOG.debug("Exception getting the file object: {}", (Object)fileName, (Object)ex);
            }
            if (file == null) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 504, "MD5.invalid", fileName));
                return;
            }
            if (!file.isFile()) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 504, "MD5.invalid", fileName));
                return;
            }
            try (InputStream is = file.createInputStream(0L);){
                String md5Hash = this.md5(is);
                if (i > 0) {
                    sb.append(", ");
                }
                if (fileName.indexOf(32) >= 0) {
                    sb.append('\"');
                    sb.append(fileName);
                    sb.append('\"');
                } else {
                    sb.append(fileName);
                }
                sb.append(' ');
                sb.append(md5Hash);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                this.LOG.debug("MD5 algorithm not available", (Throwable)e);
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 502, "MD5.notimplemened", null));
            }
        }
        if (isMMD5) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 252, MMD5, sb.toString()));
        } else {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 251, MD5, sb.toString()));
        }
    }

    private String md5(InputStream is) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(MD5);
        DigestInputStream dis = new DigestInputStream(is, digest);
        byte[] buffer = new byte[1024];
        int read = dis.read(buffer);
        while (read > -1) {
            read = dis.read(buffer);
        }
        return new String(org.apache.ftpserver.command.impl.MD5.encodeHex(dis.getMessageDigest().digest()));
    }

    public static char[] encodeHex(byte[] data) {
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }
}

