﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/billingconductor/model/MatchOption.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace BillingConductor {
namespace Model {
namespace MatchOptionMapper {

static const int NOT_EQUAL_HASH = HashingUtils::HashString("NOT_EQUAL");

MatchOption GetMatchOptionForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == NOT_EQUAL_HASH) {
    return MatchOption::NOT_EQUAL;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<MatchOption>(hashCode);
  }

  return MatchOption::NOT_SET;
}

Aws::String GetNameForMatchOption(MatchOption enumValue) {
  switch (enumValue) {
    case MatchOption::NOT_SET:
      return {};
    case MatchOption::NOT_EQUAL:
      return "NOT_EQUAL";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace MatchOptionMapper
}  // namespace Model
}  // namespace BillingConductor
}  // namespace Aws
