// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivsrealtime

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateEncoderConfiguration = "CreateEncoderConfiguration"

// CreateEncoderConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateEncoderConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEncoderConfiguration for more information on using the CreateEncoderConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEncoderConfigurationRequest method.
//	req, resp := client.CreateEncoderConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateEncoderConfiguration
func (c *IVSRealTime) CreateEncoderConfigurationRequest(input *CreateEncoderConfigurationInput) (req *request.Request, output *CreateEncoderConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateEncoderConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateEncoderConfiguration",
	}

	if input == nil {
		input = &CreateEncoderConfigurationInput{}
	}

	output = &CreateEncoderConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEncoderConfiguration API operation for Amazon Interactive Video Service RealTime.
//
// Creates an EncoderConfiguration object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation CreateEncoderConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateEncoderConfiguration
func (c *IVSRealTime) CreateEncoderConfiguration(input *CreateEncoderConfigurationInput) (*CreateEncoderConfigurationOutput, error) {
	req, out := c.CreateEncoderConfigurationRequest(input)
	return out, req.Send()
}

// CreateEncoderConfigurationWithContext is the same as CreateEncoderConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEncoderConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) CreateEncoderConfigurationWithContext(ctx aws.Context, input *CreateEncoderConfigurationInput, opts ...request.Option) (*CreateEncoderConfigurationOutput, error) {
	req, out := c.CreateEncoderConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateParticipantToken = "CreateParticipantToken"

// CreateParticipantTokenRequest generates a "aws/request.Request" representing the
// client's request for the CreateParticipantToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateParticipantToken for more information on using the CreateParticipantToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateParticipantTokenRequest method.
//	req, resp := client.CreateParticipantTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateParticipantToken
func (c *IVSRealTime) CreateParticipantTokenRequest(input *CreateParticipantTokenInput) (req *request.Request, output *CreateParticipantTokenOutput) {
	op := &request.Operation{
		Name:       opCreateParticipantToken,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateParticipantToken",
	}

	if input == nil {
		input = &CreateParticipantTokenInput{}
	}

	output = &CreateParticipantTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateParticipantToken API operation for Amazon Interactive Video Service RealTime.
//
// Creates an additional token for a specified stage. This can be done after
// stage creation or when tokens expire. Tokens always are scoped to the stage
// for which they are created.
//
// Encryption keys are owned by Amazon IVS and never used directly by your application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation CreateParticipantToken for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ServiceQuotaExceededException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateParticipantToken
func (c *IVSRealTime) CreateParticipantToken(input *CreateParticipantTokenInput) (*CreateParticipantTokenOutput, error) {
	req, out := c.CreateParticipantTokenRequest(input)
	return out, req.Send()
}

// CreateParticipantTokenWithContext is the same as CreateParticipantToken with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParticipantToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) CreateParticipantTokenWithContext(ctx aws.Context, input *CreateParticipantTokenInput, opts ...request.Option) (*CreateParticipantTokenOutput, error) {
	req, out := c.CreateParticipantTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStage = "CreateStage"

// CreateStageRequest generates a "aws/request.Request" representing the
// client's request for the CreateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStage for more information on using the CreateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStageRequest method.
//	req, resp := client.CreateStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStage
func (c *IVSRealTime) CreateStageRequest(input *CreateStageInput) (req *request.Request, output *CreateStageOutput) {
	op := &request.Operation{
		Name:       opCreateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateStage",
	}

	if input == nil {
		input = &CreateStageInput{}
	}

	output = &CreateStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStage API operation for Amazon Interactive Video Service RealTime.
//
// Creates a new stage (and optionally participant tokens).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation CreateStage for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ServiceQuotaExceededException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStage
func (c *IVSRealTime) CreateStage(input *CreateStageInput) (*CreateStageOutput, error) {
	req, out := c.CreateStageRequest(input)
	return out, req.Send()
}

// CreateStageWithContext is the same as CreateStage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) CreateStageWithContext(ctx aws.Context, input *CreateStageInput, opts ...request.Option) (*CreateStageOutput, error) {
	req, out := c.CreateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStorageConfiguration = "CreateStorageConfiguration"

// CreateStorageConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateStorageConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStorageConfiguration for more information on using the CreateStorageConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStorageConfigurationRequest method.
//	req, resp := client.CreateStorageConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStorageConfiguration
func (c *IVSRealTime) CreateStorageConfigurationRequest(input *CreateStorageConfigurationInput) (req *request.Request, output *CreateStorageConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateStorageConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateStorageConfiguration",
	}

	if input == nil {
		input = &CreateStorageConfigurationInput{}
	}

	output = &CreateStorageConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStorageConfiguration API operation for Amazon Interactive Video Service RealTime.
//
// Creates a new storage configuration, used to enable recording to Amazon S3.
// When a StorageConfiguration is created, IVS will modify the S3 bucketPolicy
// of the provided bucket. This will ensure that IVS has sufficient permissions
// to write content to the provided bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation CreateStorageConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStorageConfiguration
func (c *IVSRealTime) CreateStorageConfiguration(input *CreateStorageConfigurationInput) (*CreateStorageConfigurationOutput, error) {
	req, out := c.CreateStorageConfigurationRequest(input)
	return out, req.Send()
}

// CreateStorageConfigurationWithContext is the same as CreateStorageConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStorageConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) CreateStorageConfigurationWithContext(ctx aws.Context, input *CreateStorageConfigurationInput, opts ...request.Option) (*CreateStorageConfigurationOutput, error) {
	req, out := c.CreateStorageConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEncoderConfiguration = "DeleteEncoderConfiguration"

// DeleteEncoderConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEncoderConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEncoderConfiguration for more information on using the DeleteEncoderConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEncoderConfigurationRequest method.
//	req, resp := client.DeleteEncoderConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteEncoderConfiguration
func (c *IVSRealTime) DeleteEncoderConfigurationRequest(input *DeleteEncoderConfigurationInput) (req *request.Request, output *DeleteEncoderConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteEncoderConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteEncoderConfiguration",
	}

	if input == nil {
		input = &DeleteEncoderConfigurationInput{}
	}

	output = &DeleteEncoderConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEncoderConfiguration API operation for Amazon Interactive Video Service RealTime.
//
// Deletes an EncoderConfiguration resource. Ensures that no Compositions are
// using this template; otherwise, returns an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation DeleteEncoderConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteEncoderConfiguration
func (c *IVSRealTime) DeleteEncoderConfiguration(input *DeleteEncoderConfigurationInput) (*DeleteEncoderConfigurationOutput, error) {
	req, out := c.DeleteEncoderConfigurationRequest(input)
	return out, req.Send()
}

// DeleteEncoderConfigurationWithContext is the same as DeleteEncoderConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEncoderConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) DeleteEncoderConfigurationWithContext(ctx aws.Context, input *DeleteEncoderConfigurationInput, opts ...request.Option) (*DeleteEncoderConfigurationOutput, error) {
	req, out := c.DeleteEncoderConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePublicKey = "DeletePublicKey"

// DeletePublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePublicKey for more information on using the DeletePublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePublicKeyRequest method.
//	req, resp := client.DeletePublicKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeletePublicKey
func (c *IVSRealTime) DeletePublicKeyRequest(input *DeletePublicKeyInput) (req *request.Request, output *DeletePublicKeyOutput) {
	op := &request.Operation{
		Name:       opDeletePublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/DeletePublicKey",
	}

	if input == nil {
		input = &DeletePublicKeyInput{}
	}

	output = &DeletePublicKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePublicKey API operation for Amazon Interactive Video Service RealTime.
//
// Deletes the specified public key used to sign stage participant tokens. This
// invalidates future participant tokens generated using the key pair’s private
// key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation DeletePublicKey for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ConflictException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeletePublicKey
func (c *IVSRealTime) DeletePublicKey(input *DeletePublicKeyInput) (*DeletePublicKeyOutput, error) {
	req, out := c.DeletePublicKeyRequest(input)
	return out, req.Send()
}

// DeletePublicKeyWithContext is the same as DeletePublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) DeletePublicKeyWithContext(ctx aws.Context, input *DeletePublicKeyInput, opts ...request.Option) (*DeletePublicKeyOutput, error) {
	req, out := c.DeletePublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStage = "DeleteStage"

// DeleteStageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStage for more information on using the DeleteStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStageRequest method.
//	req, resp := client.DeleteStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStage
func (c *IVSRealTime) DeleteStageRequest(input *DeleteStageInput) (req *request.Request, output *DeleteStageOutput) {
	op := &request.Operation{
		Name:       opDeleteStage,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteStage",
	}

	if input == nil {
		input = &DeleteStageInput{}
	}

	output = &DeleteStageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStage API operation for Amazon Interactive Video Service RealTime.
//
// Shuts down and deletes the specified stage (disconnecting all participants).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation DeleteStage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ConflictException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStage
func (c *IVSRealTime) DeleteStage(input *DeleteStageInput) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	return out, req.Send()
}

// DeleteStageWithContext is the same as DeleteStage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) DeleteStageWithContext(ctx aws.Context, input *DeleteStageInput, opts ...request.Option) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStorageConfiguration = "DeleteStorageConfiguration"

// DeleteStorageConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStorageConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStorageConfiguration for more information on using the DeleteStorageConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStorageConfigurationRequest method.
//	req, resp := client.DeleteStorageConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStorageConfiguration
func (c *IVSRealTime) DeleteStorageConfigurationRequest(input *DeleteStorageConfigurationInput) (req *request.Request, output *DeleteStorageConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteStorageConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteStorageConfiguration",
	}

	if input == nil {
		input = &DeleteStorageConfigurationInput{}
	}

	output = &DeleteStorageConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStorageConfiguration API operation for Amazon Interactive Video Service RealTime.
//
// Deletes the storage configuration for the specified ARN.
//
// If you try to delete a storage configuration that is used by a Composition,
// you will get an error (409 ConflictException). To avoid this, for all Compositions
// that reference the storage configuration, first use StopComposition and wait
// for it to complete, then use DeleteStorageConfiguration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation DeleteStorageConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStorageConfiguration
func (c *IVSRealTime) DeleteStorageConfiguration(input *DeleteStorageConfigurationInput) (*DeleteStorageConfigurationOutput, error) {
	req, out := c.DeleteStorageConfigurationRequest(input)
	return out, req.Send()
}

// DeleteStorageConfigurationWithContext is the same as DeleteStorageConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStorageConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) DeleteStorageConfigurationWithContext(ctx aws.Context, input *DeleteStorageConfigurationInput, opts ...request.Option) (*DeleteStorageConfigurationOutput, error) {
	req, out := c.DeleteStorageConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisconnectParticipant = "DisconnectParticipant"

// DisconnectParticipantRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectParticipant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectParticipant for more information on using the DisconnectParticipant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisconnectParticipantRequest method.
//	req, resp := client.DisconnectParticipantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DisconnectParticipant
func (c *IVSRealTime) DisconnectParticipantRequest(input *DisconnectParticipantInput) (req *request.Request, output *DisconnectParticipantOutput) {
	op := &request.Operation{
		Name:       opDisconnectParticipant,
		HTTPMethod: "POST",
		HTTPPath:   "/DisconnectParticipant",
	}

	if input == nil {
		input = &DisconnectParticipantInput{}
	}

	output = &DisconnectParticipantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisconnectParticipant API operation for Amazon Interactive Video Service RealTime.
//
// Disconnects a specified participant and revokes the participant permanently
// from a specified stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation DisconnectParticipant for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DisconnectParticipant
func (c *IVSRealTime) DisconnectParticipant(input *DisconnectParticipantInput) (*DisconnectParticipantOutput, error) {
	req, out := c.DisconnectParticipantRequest(input)
	return out, req.Send()
}

// DisconnectParticipantWithContext is the same as DisconnectParticipant with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectParticipant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) DisconnectParticipantWithContext(ctx aws.Context, input *DisconnectParticipantInput, opts ...request.Option) (*DisconnectParticipantOutput, error) {
	req, out := c.DisconnectParticipantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComposition = "GetComposition"

// GetCompositionRequest generates a "aws/request.Request" representing the
// client's request for the GetComposition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComposition for more information on using the GetComposition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCompositionRequest method.
//	req, resp := client.GetCompositionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetComposition
func (c *IVSRealTime) GetCompositionRequest(input *GetCompositionInput) (req *request.Request, output *GetCompositionOutput) {
	op := &request.Operation{
		Name:       opGetComposition,
		HTTPMethod: "POST",
		HTTPPath:   "/GetComposition",
	}

	if input == nil {
		input = &GetCompositionInput{}
	}

	output = &GetCompositionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComposition API operation for Amazon Interactive Video Service RealTime.
//
// Get information about the specified Composition resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetComposition for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetComposition
func (c *IVSRealTime) GetComposition(input *GetCompositionInput) (*GetCompositionOutput, error) {
	req, out := c.GetCompositionRequest(input)
	return out, req.Send()
}

// GetCompositionWithContext is the same as GetComposition with the addition of
// the ability to pass a context and additional request options.
//
// See GetComposition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetCompositionWithContext(ctx aws.Context, input *GetCompositionInput, opts ...request.Option) (*GetCompositionOutput, error) {
	req, out := c.GetCompositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEncoderConfiguration = "GetEncoderConfiguration"

// GetEncoderConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetEncoderConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEncoderConfiguration for more information on using the GetEncoderConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEncoderConfigurationRequest method.
//	req, resp := client.GetEncoderConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetEncoderConfiguration
func (c *IVSRealTime) GetEncoderConfigurationRequest(input *GetEncoderConfigurationInput) (req *request.Request, output *GetEncoderConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetEncoderConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetEncoderConfiguration",
	}

	if input == nil {
		input = &GetEncoderConfigurationInput{}
	}

	output = &GetEncoderConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEncoderConfiguration API operation for Amazon Interactive Video Service RealTime.
//
// Gets information about the specified EncoderConfiguration resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetEncoderConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetEncoderConfiguration
func (c *IVSRealTime) GetEncoderConfiguration(input *GetEncoderConfigurationInput) (*GetEncoderConfigurationOutput, error) {
	req, out := c.GetEncoderConfigurationRequest(input)
	return out, req.Send()
}

// GetEncoderConfigurationWithContext is the same as GetEncoderConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetEncoderConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetEncoderConfigurationWithContext(ctx aws.Context, input *GetEncoderConfigurationInput, opts ...request.Option) (*GetEncoderConfigurationOutput, error) {
	req, out := c.GetEncoderConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParticipant = "GetParticipant"

// GetParticipantRequest generates a "aws/request.Request" representing the
// client's request for the GetParticipant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParticipant for more information on using the GetParticipant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParticipantRequest method.
//	req, resp := client.GetParticipantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetParticipant
func (c *IVSRealTime) GetParticipantRequest(input *GetParticipantInput) (req *request.Request, output *GetParticipantOutput) {
	op := &request.Operation{
		Name:       opGetParticipant,
		HTTPMethod: "POST",
		HTTPPath:   "/GetParticipant",
	}

	if input == nil {
		input = &GetParticipantInput{}
	}

	output = &GetParticipantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParticipant API operation for Amazon Interactive Video Service RealTime.
//
// Gets information about the specified participant token.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetParticipant for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetParticipant
func (c *IVSRealTime) GetParticipant(input *GetParticipantInput) (*GetParticipantOutput, error) {
	req, out := c.GetParticipantRequest(input)
	return out, req.Send()
}

// GetParticipantWithContext is the same as GetParticipant with the addition of
// the ability to pass a context and additional request options.
//
// See GetParticipant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetParticipantWithContext(ctx aws.Context, input *GetParticipantInput, opts ...request.Option) (*GetParticipantOutput, error) {
	req, out := c.GetParticipantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicKey = "GetPublicKey"

// GetPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicKey for more information on using the GetPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPublicKeyRequest method.
//	req, resp := client.GetPublicKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetPublicKey
func (c *IVSRealTime) GetPublicKeyRequest(input *GetPublicKeyInput) (req *request.Request, output *GetPublicKeyOutput) {
	op := &request.Operation{
		Name:       opGetPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/GetPublicKey",
	}

	if input == nil {
		input = &GetPublicKeyInput{}
	}

	output = &GetPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPublicKey API operation for Amazon Interactive Video Service RealTime.
//
// Gets information for the specified public key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetPublicKey for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetPublicKey
func (c *IVSRealTime) GetPublicKey(input *GetPublicKeyInput) (*GetPublicKeyOutput, error) {
	req, out := c.GetPublicKeyRequest(input)
	return out, req.Send()
}

// GetPublicKeyWithContext is the same as GetPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetPublicKeyWithContext(ctx aws.Context, input *GetPublicKeyInput, opts ...request.Option) (*GetPublicKeyOutput, error) {
	req, out := c.GetPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStage = "GetStage"

// GetStageRequest generates a "aws/request.Request" representing the
// client's request for the GetStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStage for more information on using the GetStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStageRequest method.
//	req, resp := client.GetStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStage
func (c *IVSRealTime) GetStageRequest(input *GetStageInput) (req *request.Request, output *GetStageOutput) {
	op := &request.Operation{
		Name:       opGetStage,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStage",
	}

	if input == nil {
		input = &GetStageInput{}
	}

	output = &GetStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStage API operation for Amazon Interactive Video Service RealTime.
//
// Gets information for the specified stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetStage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStage
func (c *IVSRealTime) GetStage(input *GetStageInput) (*GetStageOutput, error) {
	req, out := c.GetStageRequest(input)
	return out, req.Send()
}

// GetStageWithContext is the same as GetStage with the addition of
// the ability to pass a context and additional request options.
//
// See GetStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetStageWithContext(ctx aws.Context, input *GetStageInput, opts ...request.Option) (*GetStageOutput, error) {
	req, out := c.GetStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStageSession = "GetStageSession"

// GetStageSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetStageSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStageSession for more information on using the GetStageSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStageSessionRequest method.
//	req, resp := client.GetStageSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStageSession
func (c *IVSRealTime) GetStageSessionRequest(input *GetStageSessionInput) (req *request.Request, output *GetStageSessionOutput) {
	op := &request.Operation{
		Name:       opGetStageSession,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStageSession",
	}

	if input == nil {
		input = &GetStageSessionInput{}
	}

	output = &GetStageSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStageSession API operation for Amazon Interactive Video Service RealTime.
//
// Gets information for the specified stage session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetStageSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStageSession
func (c *IVSRealTime) GetStageSession(input *GetStageSessionInput) (*GetStageSessionOutput, error) {
	req, out := c.GetStageSessionRequest(input)
	return out, req.Send()
}

// GetStageSessionWithContext is the same as GetStageSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetStageSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetStageSessionWithContext(ctx aws.Context, input *GetStageSessionInput, opts ...request.Option) (*GetStageSessionOutput, error) {
	req, out := c.GetStageSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStorageConfiguration = "GetStorageConfiguration"

// GetStorageConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetStorageConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStorageConfiguration for more information on using the GetStorageConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStorageConfigurationRequest method.
//	req, resp := client.GetStorageConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStorageConfiguration
func (c *IVSRealTime) GetStorageConfigurationRequest(input *GetStorageConfigurationInput) (req *request.Request, output *GetStorageConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetStorageConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStorageConfiguration",
	}

	if input == nil {
		input = &GetStorageConfigurationInput{}
	}

	output = &GetStorageConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStorageConfiguration API operation for Amazon Interactive Video Service RealTime.
//
// Gets the storage configuration for the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetStorageConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStorageConfiguration
func (c *IVSRealTime) GetStorageConfiguration(input *GetStorageConfigurationInput) (*GetStorageConfigurationOutput, error) {
	req, out := c.GetStorageConfigurationRequest(input)
	return out, req.Send()
}

// GetStorageConfigurationWithContext is the same as GetStorageConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetStorageConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetStorageConfigurationWithContext(ctx aws.Context, input *GetStorageConfigurationInput, opts ...request.Option) (*GetStorageConfigurationOutput, error) {
	req, out := c.GetStorageConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportPublicKey = "ImportPublicKey"

// ImportPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the ImportPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportPublicKey for more information on using the ImportPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportPublicKeyRequest method.
//	req, resp := client.ImportPublicKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ImportPublicKey
func (c *IVSRealTime) ImportPublicKeyRequest(input *ImportPublicKeyInput) (req *request.Request, output *ImportPublicKeyOutput) {
	op := &request.Operation{
		Name:       opImportPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/ImportPublicKey",
	}

	if input == nil {
		input = &ImportPublicKeyInput{}
	}

	output = &ImportPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportPublicKey API operation for Amazon Interactive Video Service RealTime.
//
// Import a public key to be used for signing stage participant tokens.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ImportPublicKey for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ImportPublicKey
func (c *IVSRealTime) ImportPublicKey(input *ImportPublicKeyInput) (*ImportPublicKeyOutput, error) {
	req, out := c.ImportPublicKeyRequest(input)
	return out, req.Send()
}

// ImportPublicKeyWithContext is the same as ImportPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See ImportPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ImportPublicKeyWithContext(ctx aws.Context, input *ImportPublicKeyInput, opts ...request.Option) (*ImportPublicKeyOutput, error) {
	req, out := c.ImportPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCompositions = "ListCompositions"

// ListCompositionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCompositions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCompositions for more information on using the ListCompositions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCompositionsRequest method.
//	req, resp := client.ListCompositionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListCompositions
func (c *IVSRealTime) ListCompositionsRequest(input *ListCompositionsInput) (req *request.Request, output *ListCompositionsOutput) {
	op := &request.Operation{
		Name:       opListCompositions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListCompositions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCompositionsInput{}
	}

	output = &ListCompositionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCompositions API operation for Amazon Interactive Video Service RealTime.
//
// Gets summary information about all Compositions in your account, in the AWS
// region where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListCompositions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListCompositions
func (c *IVSRealTime) ListCompositions(input *ListCompositionsInput) (*ListCompositionsOutput, error) {
	req, out := c.ListCompositionsRequest(input)
	return out, req.Send()
}

// ListCompositionsWithContext is the same as ListCompositions with the addition of
// the ability to pass a context and additional request options.
//
// See ListCompositions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListCompositionsWithContext(ctx aws.Context, input *ListCompositionsInput, opts ...request.Option) (*ListCompositionsOutput, error) {
	req, out := c.ListCompositionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCompositionsPages iterates over the pages of a ListCompositions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCompositions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCompositions operation.
//	pageNum := 0
//	err := client.ListCompositionsPages(params,
//	    func(page *ivsrealtime.ListCompositionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListCompositionsPages(input *ListCompositionsInput, fn func(*ListCompositionsOutput, bool) bool) error {
	return c.ListCompositionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCompositionsPagesWithContext same as ListCompositionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListCompositionsPagesWithContext(ctx aws.Context, input *ListCompositionsInput, fn func(*ListCompositionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCompositionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCompositionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCompositionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEncoderConfigurations = "ListEncoderConfigurations"

// ListEncoderConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListEncoderConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEncoderConfigurations for more information on using the ListEncoderConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEncoderConfigurationsRequest method.
//	req, resp := client.ListEncoderConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListEncoderConfigurations
func (c *IVSRealTime) ListEncoderConfigurationsRequest(input *ListEncoderConfigurationsInput) (req *request.Request, output *ListEncoderConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListEncoderConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/ListEncoderConfigurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEncoderConfigurationsInput{}
	}

	output = &ListEncoderConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEncoderConfigurations API operation for Amazon Interactive Video Service RealTime.
//
// Gets summary information about all EncoderConfigurations in your account,
// in the AWS region where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListEncoderConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListEncoderConfigurations
func (c *IVSRealTime) ListEncoderConfigurations(input *ListEncoderConfigurationsInput) (*ListEncoderConfigurationsOutput, error) {
	req, out := c.ListEncoderConfigurationsRequest(input)
	return out, req.Send()
}

// ListEncoderConfigurationsWithContext is the same as ListEncoderConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListEncoderConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListEncoderConfigurationsWithContext(ctx aws.Context, input *ListEncoderConfigurationsInput, opts ...request.Option) (*ListEncoderConfigurationsOutput, error) {
	req, out := c.ListEncoderConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEncoderConfigurationsPages iterates over the pages of a ListEncoderConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEncoderConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEncoderConfigurations operation.
//	pageNum := 0
//	err := client.ListEncoderConfigurationsPages(params,
//	    func(page *ivsrealtime.ListEncoderConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListEncoderConfigurationsPages(input *ListEncoderConfigurationsInput, fn func(*ListEncoderConfigurationsOutput, bool) bool) error {
	return c.ListEncoderConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEncoderConfigurationsPagesWithContext same as ListEncoderConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListEncoderConfigurationsPagesWithContext(ctx aws.Context, input *ListEncoderConfigurationsInput, fn func(*ListEncoderConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEncoderConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEncoderConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEncoderConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListParticipantEvents = "ListParticipantEvents"

// ListParticipantEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListParticipantEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListParticipantEvents for more information on using the ListParticipantEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListParticipantEventsRequest method.
//	req, resp := client.ListParticipantEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantEvents
func (c *IVSRealTime) ListParticipantEventsRequest(input *ListParticipantEventsInput) (req *request.Request, output *ListParticipantEventsOutput) {
	op := &request.Operation{
		Name:       opListParticipantEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/ListParticipantEvents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListParticipantEventsInput{}
	}

	output = &ListParticipantEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParticipantEvents API operation for Amazon Interactive Video Service RealTime.
//
// Lists events for a specified participant that occurred during a specified
// stage session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListParticipantEvents for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantEvents
func (c *IVSRealTime) ListParticipantEvents(input *ListParticipantEventsInput) (*ListParticipantEventsOutput, error) {
	req, out := c.ListParticipantEventsRequest(input)
	return out, req.Send()
}

// ListParticipantEventsWithContext is the same as ListParticipantEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListParticipantEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListParticipantEventsWithContext(ctx aws.Context, input *ListParticipantEventsInput, opts ...request.Option) (*ListParticipantEventsOutput, error) {
	req, out := c.ListParticipantEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListParticipantEventsPages iterates over the pages of a ListParticipantEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParticipantEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListParticipantEvents operation.
//	pageNum := 0
//	err := client.ListParticipantEventsPages(params,
//	    func(page *ivsrealtime.ListParticipantEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListParticipantEventsPages(input *ListParticipantEventsInput, fn func(*ListParticipantEventsOutput, bool) bool) error {
	return c.ListParticipantEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListParticipantEventsPagesWithContext same as ListParticipantEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListParticipantEventsPagesWithContext(ctx aws.Context, input *ListParticipantEventsInput, fn func(*ListParticipantEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListParticipantEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListParticipantEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListParticipantEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListParticipants = "ListParticipants"

// ListParticipantsRequest generates a "aws/request.Request" representing the
// client's request for the ListParticipants operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListParticipants for more information on using the ListParticipants
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListParticipantsRequest method.
//	req, resp := client.ListParticipantsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipants
func (c *IVSRealTime) ListParticipantsRequest(input *ListParticipantsInput) (req *request.Request, output *ListParticipantsOutput) {
	op := &request.Operation{
		Name:       opListParticipants,
		HTTPMethod: "POST",
		HTTPPath:   "/ListParticipants",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListParticipantsInput{}
	}

	output = &ListParticipantsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParticipants API operation for Amazon Interactive Video Service RealTime.
//
// Lists all participants in a specified stage session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListParticipants for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipants
func (c *IVSRealTime) ListParticipants(input *ListParticipantsInput) (*ListParticipantsOutput, error) {
	req, out := c.ListParticipantsRequest(input)
	return out, req.Send()
}

// ListParticipantsWithContext is the same as ListParticipants with the addition of
// the ability to pass a context and additional request options.
//
// See ListParticipants for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListParticipantsWithContext(ctx aws.Context, input *ListParticipantsInput, opts ...request.Option) (*ListParticipantsOutput, error) {
	req, out := c.ListParticipantsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListParticipantsPages iterates over the pages of a ListParticipants operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParticipants method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListParticipants operation.
//	pageNum := 0
//	err := client.ListParticipantsPages(params,
//	    func(page *ivsrealtime.ListParticipantsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListParticipantsPages(input *ListParticipantsInput, fn func(*ListParticipantsOutput, bool) bool) error {
	return c.ListParticipantsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListParticipantsPagesWithContext same as ListParticipantsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListParticipantsPagesWithContext(ctx aws.Context, input *ListParticipantsInput, fn func(*ListParticipantsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListParticipantsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListParticipantsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListParticipantsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPublicKeys = "ListPublicKeys"

// ListPublicKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListPublicKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPublicKeys for more information on using the ListPublicKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPublicKeysRequest method.
//	req, resp := client.ListPublicKeysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListPublicKeys
func (c *IVSRealTime) ListPublicKeysRequest(input *ListPublicKeysInput) (req *request.Request, output *ListPublicKeysOutput) {
	op := &request.Operation{
		Name:       opListPublicKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/ListPublicKeys",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPublicKeysInput{}
	}

	output = &ListPublicKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPublicKeys API operation for Amazon Interactive Video Service RealTime.
//
// Gets summary information about all public keys in your account, in the AWS
// region where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListPublicKeys for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListPublicKeys
func (c *IVSRealTime) ListPublicKeys(input *ListPublicKeysInput) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	return out, req.Send()
}

// ListPublicKeysWithContext is the same as ListPublicKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListPublicKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListPublicKeysWithContext(ctx aws.Context, input *ListPublicKeysInput, opts ...request.Option) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPublicKeysPages iterates over the pages of a ListPublicKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPublicKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPublicKeys operation.
//	pageNum := 0
//	err := client.ListPublicKeysPages(params,
//	    func(page *ivsrealtime.ListPublicKeysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListPublicKeysPages(input *ListPublicKeysInput, fn func(*ListPublicKeysOutput, bool) bool) error {
	return c.ListPublicKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPublicKeysPagesWithContext same as ListPublicKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListPublicKeysPagesWithContext(ctx aws.Context, input *ListPublicKeysInput, fn func(*ListPublicKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPublicKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPublicKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPublicKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStageSessions = "ListStageSessions"

// ListStageSessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListStageSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStageSessions for more information on using the ListStageSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStageSessionsRequest method.
//	req, resp := client.ListStageSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStageSessions
func (c *IVSRealTime) ListStageSessionsRequest(input *ListStageSessionsInput) (req *request.Request, output *ListStageSessionsOutput) {
	op := &request.Operation{
		Name:       opListStageSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStageSessions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStageSessionsInput{}
	}

	output = &ListStageSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStageSessions API operation for Amazon Interactive Video Service RealTime.
//
// Gets all sessions for a specified stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListStageSessions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStageSessions
func (c *IVSRealTime) ListStageSessions(input *ListStageSessionsInput) (*ListStageSessionsOutput, error) {
	req, out := c.ListStageSessionsRequest(input)
	return out, req.Send()
}

// ListStageSessionsWithContext is the same as ListStageSessions with the addition of
// the ability to pass a context and additional request options.
//
// See ListStageSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStageSessionsWithContext(ctx aws.Context, input *ListStageSessionsInput, opts ...request.Option) (*ListStageSessionsOutput, error) {
	req, out := c.ListStageSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStageSessionsPages iterates over the pages of a ListStageSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStageSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStageSessions operation.
//	pageNum := 0
//	err := client.ListStageSessionsPages(params,
//	    func(page *ivsrealtime.ListStageSessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListStageSessionsPages(input *ListStageSessionsInput, fn func(*ListStageSessionsOutput, bool) bool) error {
	return c.ListStageSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStageSessionsPagesWithContext same as ListStageSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStageSessionsPagesWithContext(ctx aws.Context, input *ListStageSessionsInput, fn func(*ListStageSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStageSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStageSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStageSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStages = "ListStages"

// ListStagesRequest generates a "aws/request.Request" representing the
// client's request for the ListStages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStages for more information on using the ListStages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStagesRequest method.
//	req, resp := client.ListStagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStages
func (c *IVSRealTime) ListStagesRequest(input *ListStagesInput) (req *request.Request, output *ListStagesOutput) {
	op := &request.Operation{
		Name:       opListStages,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStagesInput{}
	}

	output = &ListStagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStages API operation for Amazon Interactive Video Service RealTime.
//
// Gets summary information about all stages in your account, in the AWS region
// where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListStages for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStages
func (c *IVSRealTime) ListStages(input *ListStagesInput) (*ListStagesOutput, error) {
	req, out := c.ListStagesRequest(input)
	return out, req.Send()
}

// ListStagesWithContext is the same as ListStages with the addition of
// the ability to pass a context and additional request options.
//
// See ListStages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStagesWithContext(ctx aws.Context, input *ListStagesInput, opts ...request.Option) (*ListStagesOutput, error) {
	req, out := c.ListStagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStagesPages iterates over the pages of a ListStages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStages operation.
//	pageNum := 0
//	err := client.ListStagesPages(params,
//	    func(page *ivsrealtime.ListStagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListStagesPages(input *ListStagesInput, fn func(*ListStagesOutput, bool) bool) error {
	return c.ListStagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStagesPagesWithContext same as ListStagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStagesPagesWithContext(ctx aws.Context, input *ListStagesInput, fn func(*ListStagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStorageConfigurations = "ListStorageConfigurations"

// ListStorageConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListStorageConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStorageConfigurations for more information on using the ListStorageConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStorageConfigurationsRequest method.
//	req, resp := client.ListStorageConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStorageConfigurations
func (c *IVSRealTime) ListStorageConfigurationsRequest(input *ListStorageConfigurationsInput) (req *request.Request, output *ListStorageConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListStorageConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStorageConfigurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStorageConfigurationsInput{}
	}

	output = &ListStorageConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStorageConfigurations API operation for Amazon Interactive Video Service RealTime.
//
// Gets summary information about all storage configurations in your account,
// in the AWS region where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListStorageConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStorageConfigurations
func (c *IVSRealTime) ListStorageConfigurations(input *ListStorageConfigurationsInput) (*ListStorageConfigurationsOutput, error) {
	req, out := c.ListStorageConfigurationsRequest(input)
	return out, req.Send()
}

// ListStorageConfigurationsWithContext is the same as ListStorageConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListStorageConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStorageConfigurationsWithContext(ctx aws.Context, input *ListStorageConfigurationsInput, opts ...request.Option) (*ListStorageConfigurationsOutput, error) {
	req, out := c.ListStorageConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStorageConfigurationsPages iterates over the pages of a ListStorageConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStorageConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStorageConfigurations operation.
//	pageNum := 0
//	err := client.ListStorageConfigurationsPages(params,
//	    func(page *ivsrealtime.ListStorageConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListStorageConfigurationsPages(input *ListStorageConfigurationsInput, fn func(*ListStorageConfigurationsOutput, bool) bool) error {
	return c.ListStorageConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStorageConfigurationsPagesWithContext same as ListStorageConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStorageConfigurationsPagesWithContext(ctx aws.Context, input *ListStorageConfigurationsInput, fn func(*ListStorageConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStorageConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStorageConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStorageConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListTagsForResource
func (c *IVSRealTime) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Interactive Video Service RealTime.
//
// Gets information about AWS tags for the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListTagsForResource
func (c *IVSRealTime) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartComposition = "StartComposition"

// StartCompositionRequest generates a "aws/request.Request" representing the
// client's request for the StartComposition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartComposition for more information on using the StartComposition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartCompositionRequest method.
//	req, resp := client.StartCompositionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StartComposition
func (c *IVSRealTime) StartCompositionRequest(input *StartCompositionInput) (req *request.Request, output *StartCompositionOutput) {
	op := &request.Operation{
		Name:       opStartComposition,
		HTTPMethod: "POST",
		HTTPPath:   "/StartComposition",
	}

	if input == nil {
		input = &StartCompositionInput{}
	}

	output = &StartCompositionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartComposition API operation for Amazon Interactive Video Service RealTime.
//
// Starts a Composition from a stage based on the configuration provided in
// the request.
//
// A Composition is an ephemeral resource that exists after this endpoint returns
// successfully. Composition stops and the resource is deleted:
//
//   - When StopComposition is called.
//
//   - After a 1-minute timeout, when all participants are disconnected from
//     the stage.
//
//   - After a 1-minute timeout, if there are no participants in the stage
//     when StartComposition is called.
//
//   - When broadcasting to the IVS channel fails and all retries are exhausted.
//
//   - When broadcasting is disconnected and all attempts to reconnect are
//     exhausted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation StartComposition for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StartComposition
func (c *IVSRealTime) StartComposition(input *StartCompositionInput) (*StartCompositionOutput, error) {
	req, out := c.StartCompositionRequest(input)
	return out, req.Send()
}

// StartCompositionWithContext is the same as StartComposition with the addition of
// the ability to pass a context and additional request options.
//
// See StartComposition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) StartCompositionWithContext(ctx aws.Context, input *StartCompositionInput, opts ...request.Option) (*StartCompositionOutput, error) {
	req, out := c.StartCompositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopComposition = "StopComposition"

// StopCompositionRequest generates a "aws/request.Request" representing the
// client's request for the StopComposition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopComposition for more information on using the StopComposition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopCompositionRequest method.
//	req, resp := client.StopCompositionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StopComposition
func (c *IVSRealTime) StopCompositionRequest(input *StopCompositionInput) (req *request.Request, output *StopCompositionOutput) {
	op := &request.Operation{
		Name:       opStopComposition,
		HTTPMethod: "POST",
		HTTPPath:   "/StopComposition",
	}

	if input == nil {
		input = &StopCompositionInput{}
	}

	output = &StopCompositionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopComposition API operation for Amazon Interactive Video Service RealTime.
//
// Stops and deletes a Composition resource. Any broadcast from the Composition
// resource is stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation StopComposition for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - InternalServerException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StopComposition
func (c *IVSRealTime) StopComposition(input *StopCompositionInput) (*StopCompositionOutput, error) {
	req, out := c.StopCompositionRequest(input)
	return out, req.Send()
}

// StopCompositionWithContext is the same as StopComposition with the addition of
// the ability to pass a context and additional request options.
//
// See StopComposition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) StopCompositionWithContext(ctx aws.Context, input *StopCompositionInput, opts ...request.Option) (*StopCompositionOutput, error) {
	req, out := c.StopCompositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/TagResource
func (c *IVSRealTime) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Interactive Video Service RealTime.
//
// Adds or updates tags for the AWS resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/TagResource
func (c *IVSRealTime) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UntagResource
func (c *IVSRealTime) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Interactive Video Service RealTime.
//
// Removes tags from the resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UntagResource
func (c *IVSRealTime) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStage = "UpdateStage"

// UpdateStageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStage for more information on using the UpdateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStageRequest method.
//	req, resp := client.UpdateStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UpdateStage
func (c *IVSRealTime) UpdateStageRequest(input *UpdateStageInput) (req *request.Request, output *UpdateStageOutput) {
	op := &request.Operation{
		Name:       opUpdateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateStage",
	}

	if input == nil {
		input = &UpdateStageInput{}
	}

	output = &UpdateStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStage API operation for Amazon Interactive Video Service RealTime.
//
// Updates a stage’s configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation UpdateStage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ServiceQuotaExceededException
//
//   - ConflictException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UpdateStage
func (c *IVSRealTime) UpdateStage(input *UpdateStageInput) (*UpdateStageOutput, error) {
	req, out := c.UpdateStageRequest(input)
	return out, req.Send()
}

// UpdateStageWithContext is the same as UpdateStage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) UpdateStageWithContext(ctx aws.Context, input *UpdateStageInput, opts ...request.Option) (*UpdateStageOutput, error) {
	req, out := c.UpdateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// User does not have sufficient access to perform this action.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object specifying a configuration for individual participant recording.
type AutoParticipantRecordingConfiguration struct {
	_ struct{} `type:"structure"`

	// Types of media to be recorded. Default: AUDIO_VIDEO.
	MediaTypes []*string `locationName:"mediaTypes" type:"list" enum:"ParticipantRecordingMediaType"`

	// ARN of the StorageConfiguration resource to use for individual participant
	// recording. Default: "" (empty string, no storage configuration is specified).
	// Individual participant recording cannot be started unless a storage configuration
	// is specified, when a Stage is created or updated.
	//
	// StorageConfigurationArn is a required field
	StorageConfigurationArn *string `locationName:"storageConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoParticipantRecordingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoParticipantRecordingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoParticipantRecordingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoParticipantRecordingConfiguration"}
	if s.StorageConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaTypes sets the MediaTypes field's value.
func (s *AutoParticipantRecordingConfiguration) SetMediaTypes(v []*string) *AutoParticipantRecordingConfiguration {
	s.MediaTypes = v
	return s
}

// SetStorageConfigurationArn sets the StorageConfigurationArn field's value.
func (s *AutoParticipantRecordingConfiguration) SetStorageConfigurationArn(v string) *AutoParticipantRecordingConfiguration {
	s.StorageConfigurationArn = &v
	return s
}

// Object specifying a channel as a destination.
type ChannelDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// ARN of the channel to use for broadcasting. The channel and stage resources
	// must be in the same AWS account and region. The channel must be offline (not
	// broadcasting).
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// ARN of the EncoderConfiguration resource. The encoder configuration and stage
	// resources must be in the same AWS account and region.
	EncoderConfigurationArn *string `locationName:"encoderConfigurationArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChannelDestinationConfiguration"}
	if s.ChannelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelArn", 1))
	}
	if s.EncoderConfigurationArn != nil && len(*s.EncoderConfigurationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncoderConfigurationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelArn sets the ChannelArn field's value.
func (s *ChannelDestinationConfiguration) SetChannelArn(v string) *ChannelDestinationConfiguration {
	s.ChannelArn = &v
	return s
}

// SetEncoderConfigurationArn sets the EncoderConfigurationArn field's value.
func (s *ChannelDestinationConfiguration) SetEncoderConfigurationArn(v string) *ChannelDestinationConfiguration {
	s.EncoderConfigurationArn = &v
	return s
}

// Object specifying a Composition resource.
type Composition struct {
	_ struct{} `type:"structure"`

	// ARN of the Composition resource.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Array of Destination objects. A Composition can contain either one destination
	// (channel or s3) or two (one channel and one s3).
	//
	// Destinations is a required field
	Destinations []*Destination `locationName:"destinations" min:"1" type:"list" required:"true"`

	// UTC time of the Composition end. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// Layout object to configure composition parameters.
	//
	// Layout is a required field
	Layout *LayoutConfiguration `locationName:"layout" type:"structure" required:"true"`

	// ARN of the stage used as input
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`

	// UTC time of the Composition start. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// State of the Composition.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"CompositionState"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Composition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Composition) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Composition) SetArn(v string) *Composition {
	s.Arn = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *Composition) SetDestinations(v []*Destination) *Composition {
	s.Destinations = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Composition) SetEndTime(v time.Time) *Composition {
	s.EndTime = &v
	return s
}

// SetLayout sets the Layout field's value.
func (s *Composition) SetLayout(v *LayoutConfiguration) *Composition {
	s.Layout = v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *Composition) SetStageArn(v string) *Composition {
	s.StageArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Composition) SetStartTime(v time.Time) *Composition {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Composition) SetState(v string) *Composition {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Composition) SetTags(v map[string]*string) *Composition {
	s.Tags = v
	return s
}

// Summary information about a Composition.
type CompositionSummary struct {
	_ struct{} `type:"structure"`

	// ARN of the Composition resource.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Array of Destination objects.
	//
	// Destinations is a required field
	Destinations []*DestinationSummary `locationName:"destinations" min:"1" type:"list" required:"true"`

	// UTC time of the Composition end. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// ARN of the attached stage.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`

	// UTC time of the Composition start. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// State of the Composition resource.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"CompositionState"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CompositionSummary) SetArn(v string) *CompositionSummary {
	s.Arn = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *CompositionSummary) SetDestinations(v []*DestinationSummary) *CompositionSummary {
	s.Destinations = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CompositionSummary) SetEndTime(v time.Time) *CompositionSummary {
	s.EndTime = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *CompositionSummary) SetStageArn(v string) *CompositionSummary {
	s.StageArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CompositionSummary) SetStartTime(v time.Time) *CompositionSummary {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *CompositionSummary) SetState(v string) *CompositionSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CompositionSummary) SetTags(v map[string]*string) *CompositionSummary {
	s.Tags = v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Updating or deleting a resource can cause an inconsistent state.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateEncoderConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Optional name to identify the resource.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Video configuration. Default: video resolution 1280x720, bitrate 2500 kbps,
	// 30 fps.
	Video *Video `locationName:"video" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEncoderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEncoderConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEncoderConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEncoderConfigurationInput"}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateEncoderConfigurationInput) SetName(v string) *CreateEncoderConfigurationInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEncoderConfigurationInput) SetTags(v map[string]*string) *CreateEncoderConfigurationInput {
	s.Tags = v
	return s
}

// SetVideo sets the Video field's value.
func (s *CreateEncoderConfigurationInput) SetVideo(v *Video) *CreateEncoderConfigurationInput {
	s.Video = v
	return s
}

type CreateEncoderConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The EncoderConfiguration that was created.
	EncoderConfiguration *EncoderConfiguration `locationName:"encoderConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEncoderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEncoderConfigurationOutput) GoString() string {
	return s.String()
}

// SetEncoderConfiguration sets the EncoderConfiguration field's value.
func (s *CreateEncoderConfigurationOutput) SetEncoderConfiguration(v *EncoderConfiguration) *CreateEncoderConfigurationOutput {
	s.EncoderConfiguration = v
	return s
}

type CreateParticipantTokenInput struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the token and attach to a
	// stage. Map keys and values can contain UTF-8 encoded text. The maximum length
	// of this field is 1 KB total. This field is exposed to all stage participants
	// and should not be used for personally identifying, confidential, or sensitive
	// information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Set of capabilities that the user is allowed to perform in the stage. Default:
	// PUBLISH, SUBSCRIBE.
	Capabilities []*string `locationName:"capabilities" type:"list" enum:"ParticipantTokenCapability"`

	// Duration (in minutes), after which the token expires. Default: 720 (12 hours).
	Duration *int64 `locationName:"duration" min:"1" type:"integer"`

	// ARN of the stage to which this token is scoped.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`

	// Name that can be specified to help identify the token. This can be any UTF-8
	// encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParticipantTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateParticipantTokenInput"}
	if s.Duration != nil && *s.Duration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Duration", 1))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreateParticipantTokenInput) SetAttributes(v map[string]*string) *CreateParticipantTokenInput {
	s.Attributes = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateParticipantTokenInput) SetCapabilities(v []*string) *CreateParticipantTokenInput {
	s.Capabilities = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *CreateParticipantTokenInput) SetDuration(v int64) *CreateParticipantTokenInput {
	s.Duration = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *CreateParticipantTokenInput) SetStageArn(v string) *CreateParticipantTokenInput {
	s.StageArn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateParticipantTokenInput) SetUserId(v string) *CreateParticipantTokenInput {
	s.UserId = &v
	return s
}

type CreateParticipantTokenOutput struct {
	_ struct{} `type:"structure"`

	// The participant token that was created.
	ParticipantToken *ParticipantToken `locationName:"participantToken" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenOutput) GoString() string {
	return s.String()
}

// SetParticipantToken sets the ParticipantToken field's value.
func (s *CreateParticipantTokenOutput) SetParticipantToken(v *ParticipantToken) *CreateParticipantTokenOutput {
	s.ParticipantToken = v
	return s
}

type CreateStageInput struct {
	_ struct{} `type:"structure"`

	// Configuration object for individual participant recording, to attach to the
	// new stage.
	AutoParticipantRecordingConfiguration *AutoParticipantRecordingConfiguration `locationName:"autoParticipantRecordingConfiguration" type:"structure"`

	// Optional name that can be specified for the stage being created.
	Name *string `locationName:"name" type:"string"`

	// Array of participant token configuration objects to attach to the new stage.
	ParticipantTokenConfigurations []*ParticipantTokenConfiguration `locationName:"participantTokenConfigurations" type:"list"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStageInput"}
	if s.AutoParticipantRecordingConfiguration != nil {
		if err := s.AutoParticipantRecordingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AutoParticipantRecordingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ParticipantTokenConfigurations != nil {
		for i, v := range s.ParticipantTokenConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParticipantTokenConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoParticipantRecordingConfiguration sets the AutoParticipantRecordingConfiguration field's value.
func (s *CreateStageInput) SetAutoParticipantRecordingConfiguration(v *AutoParticipantRecordingConfiguration) *CreateStageInput {
	s.AutoParticipantRecordingConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStageInput) SetName(v string) *CreateStageInput {
	s.Name = &v
	return s
}

// SetParticipantTokenConfigurations sets the ParticipantTokenConfigurations field's value.
func (s *CreateStageInput) SetParticipantTokenConfigurations(v []*ParticipantTokenConfiguration) *CreateStageInput {
	s.ParticipantTokenConfigurations = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStageInput) SetTags(v map[string]*string) *CreateStageInput {
	s.Tags = v
	return s
}

type CreateStageOutput struct {
	_ struct{} `type:"structure"`

	// Participant tokens attached to the stage. These correspond to the participants
	// in the request.
	ParticipantTokens []*ParticipantToken `locationName:"participantTokens" type:"list"`

	// The stage that was created.
	Stage *Stage `locationName:"stage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageOutput) GoString() string {
	return s.String()
}

// SetParticipantTokens sets the ParticipantTokens field's value.
func (s *CreateStageOutput) SetParticipantTokens(v []*ParticipantToken) *CreateStageOutput {
	s.ParticipantTokens = v
	return s
}

// SetStage sets the Stage field's value.
func (s *CreateStageOutput) SetStage(v *Stage) *CreateStageOutput {
	s.Stage = v
	return s
}

type CreateStorageConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Storage configuration name. The value does not need to be unique.
	Name *string `locationName:"name" type:"string"`

	// A complex type that contains a storage configuration for where recorded video
	// will be stored.
	//
	// S3 is a required field
	S3 *S3StorageConfiguration `locationName:"s3" type:"structure" required:"true"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStorageConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStorageConfigurationInput"}
	if s.S3 == nil {
		invalidParams.Add(request.NewErrParamRequired("S3"))
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateStorageConfigurationInput) SetName(v string) *CreateStorageConfigurationInput {
	s.Name = &v
	return s
}

// SetS3 sets the S3 field's value.
func (s *CreateStorageConfigurationInput) SetS3(v *S3StorageConfiguration) *CreateStorageConfigurationInput {
	s.S3 = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStorageConfigurationInput) SetTags(v map[string]*string) *CreateStorageConfigurationInput {
	s.Tags = v
	return s
}

type CreateStorageConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The StorageConfiguration that was created.
	StorageConfiguration *StorageConfiguration `locationName:"storageConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageConfigurationOutput) GoString() string {
	return s.String()
}

// SetStorageConfiguration sets the StorageConfiguration field's value.
func (s *CreateStorageConfigurationOutput) SetStorageConfiguration(v *StorageConfiguration) *CreateStorageConfigurationOutput {
	s.StorageConfiguration = v
	return s
}

type DeleteEncoderConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ARN of the EncoderConfiguration.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEncoderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEncoderConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEncoderConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEncoderConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteEncoderConfigurationInput) SetArn(v string) *DeleteEncoderConfigurationInput {
	s.Arn = &v
	return s
}

type DeleteEncoderConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEncoderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEncoderConfigurationOutput) GoString() string {
	return s.String()
}

type DeletePublicKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN of the public key to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePublicKeyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeletePublicKeyInput) SetArn(v string) *DeletePublicKeyInput {
	s.Arn = &v
	return s
}

type DeletePublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicKeyOutput) GoString() string {
	return s.String()
}

type DeleteStageInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stage to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStageInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteStageInput) SetArn(v string) *DeleteStageInput {
	s.Arn = &v
	return s
}

type DeleteStageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageOutput) GoString() string {
	return s.String()
}

type DeleteStorageConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ARN of the storage configuration to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStorageConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStorageConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteStorageConfigurationInput) SetArn(v string) *DeleteStorageConfigurationInput {
	s.Arn = &v
	return s
}

type DeleteStorageConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageConfigurationOutput) GoString() string {
	return s.String()
}

// Object specifying the status of a Destination.
type Destination struct {
	_ struct{} `type:"structure"`

	// Configuration used to create this destination.
	//
	// Configuration is a required field
	Configuration *DestinationConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// Optional details regarding the status of the destination.
	Detail *DestinationDetail `locationName:"detail" type:"structure"`

	// UTC time of the destination end. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// Unique identifier for this destination, assigned by IVS.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// UTC time of the destination start. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// State of the Composition Destination.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"DestinationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *Destination) SetConfiguration(v *DestinationConfiguration) *Destination {
	s.Configuration = v
	return s
}

// SetDetail sets the Detail field's value.
func (s *Destination) SetDetail(v *DestinationDetail) *Destination {
	s.Detail = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Destination) SetEndTime(v time.Time) *Destination {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *Destination) SetId(v string) *Destination {
	s.Id = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Destination) SetStartTime(v time.Time) *Destination {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Destination) SetState(v string) *Destination {
	s.State = &v
	return s
}

// Complex data type that defines destination-configuration objects.
type DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// An IVS channel to be used for broadcasting, for server-side composition.
	// Either a channel or an s3 must be specified.
	Channel *ChannelDestinationConfiguration `locationName:"channel" type:"structure"`

	// Name that can be specified to help identify the destination.
	Name *string `locationName:"name" type:"string"`

	// An S3 storage configuration to be used for recording video data. Either a
	// channel or an s3 must be specified.
	S3 *S3DestinationConfiguration `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationConfiguration"}
	if s.Channel != nil {
		if err := s.Channel.Validate(); err != nil {
			invalidParams.AddNested("Channel", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannel sets the Channel field's value.
func (s *DestinationConfiguration) SetChannel(v *ChannelDestinationConfiguration) *DestinationConfiguration {
	s.Channel = v
	return s
}

// SetName sets the Name field's value.
func (s *DestinationConfiguration) SetName(v string) *DestinationConfiguration {
	s.Name = &v
	return s
}

// SetS3 sets the S3 field's value.
func (s *DestinationConfiguration) SetS3(v *S3DestinationConfiguration) *DestinationConfiguration {
	s.S3 = v
	return s
}

// Complex data type that defines destination-detail objects.
type DestinationDetail struct {
	_ struct{} `type:"structure"`

	// An S3 detail object to return information about the S3 destination.
	S3 *S3Detail `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationDetail) GoString() string {
	return s.String()
}

// SetS3 sets the S3 field's value.
func (s *DestinationDetail) SetS3(v *S3Detail) *DestinationDetail {
	s.S3 = v
	return s
}

// Summary information about a Destination.
type DestinationSummary struct {
	_ struct{} `type:"structure"`

	// UTC time of the destination end. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// Unique identifier for this destination, assigned by IVS.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// UTC time of the destination start. This is an ISO 8601 timestamp; note that
	// this is returned as a string.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`

	// State of the Composition Destination.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"DestinationState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationSummary) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *DestinationSummary) SetEndTime(v time.Time) *DestinationSummary {
	s.EndTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *DestinationSummary) SetId(v string) *DestinationSummary {
	s.Id = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DestinationSummary) SetStartTime(v time.Time) *DestinationSummary {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *DestinationSummary) SetState(v string) *DestinationSummary {
	s.State = &v
	return s
}

type DisconnectParticipantInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the participant to be disconnected. This is assigned by IVS
	// and returned by CreateParticipantToken.
	//
	// ParticipantId is a required field
	ParticipantId *string `locationName:"participantId" type:"string" required:"true"`

	// Description of why this participant is being disconnected.
	Reason *string `locationName:"reason" type:"string"`

	// ARN of the stage to which the participant is attached.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectParticipantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectParticipantInput"}
	if s.ParticipantId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantId"))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParticipantId sets the ParticipantId field's value.
func (s *DisconnectParticipantInput) SetParticipantId(v string) *DisconnectParticipantInput {
	s.ParticipantId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *DisconnectParticipantInput) SetReason(v string) *DisconnectParticipantInput {
	s.Reason = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *DisconnectParticipantInput) SetStageArn(v string) *DisconnectParticipantInput {
	s.StageArn = &v
	return s
}

type DisconnectParticipantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantOutput) GoString() string {
	return s.String()
}

// Settings for transcoding.
type EncoderConfiguration struct {
	_ struct{} `type:"structure"`

	// ARN of the EncoderConfiguration resource.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Optional name to identify the resource.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Video configuration. Default: video resolution 1280x720, bitrate 2500 kbps,
	// 30 fps
	Video *Video `locationName:"video" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncoderConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncoderConfiguration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EncoderConfiguration) SetArn(v string) *EncoderConfiguration {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *EncoderConfiguration) SetName(v string) *EncoderConfiguration {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EncoderConfiguration) SetTags(v map[string]*string) *EncoderConfiguration {
	s.Tags = v
	return s
}

// SetVideo sets the Video field's value.
func (s *EncoderConfiguration) SetVideo(v *Video) *EncoderConfiguration {
	s.Video = v
	return s
}

// Summary information about an EncoderConfiguration.
type EncoderConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// ARN of the EncoderConfiguration resource.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Optional name to identify the resource.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncoderConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncoderConfigurationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EncoderConfigurationSummary) SetArn(v string) *EncoderConfigurationSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *EncoderConfigurationSummary) SetName(v string) *EncoderConfigurationSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EncoderConfigurationSummary) SetTags(v map[string]*string) *EncoderConfigurationSummary {
	s.Tags = v
	return s
}

// An occurrence during a stage session.
type Event struct {
	_ struct{} `type:"structure"`

	// If the event is an error event, the error code is provided to give insight
	// into the specific error that occurred. If the event is not an error event,
	// this field is null. INSUFFICIENT_CAPABILITIES indicates that the participant
	// tried to take an action that the participant’s token is not allowed to
	// do. For more information about participant capabilities, see the capabilities
	// field in CreateParticipantToken. QUOTA_EXCEEDED indicates that the number
	// of participants who want to publish/subscribe to a stage exceeds the quota;
	// for more information, see Service Quotas (https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html).
	// PUBLISHER_NOT_FOUND indicates that the participant tried to subscribe to
	// a publisher that doesn’t exist.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"EventErrorCode"`

	// ISO 8601 timestamp (returned as a string) for when the event occurred.
	EventTime *time.Time `locationName:"eventTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the event.
	Name *string `locationName:"name" type:"string" enum:"EventName"`

	// Unique identifier for the participant who triggered the event. This is assigned
	// by IVS.
	ParticipantId *string `locationName:"participantId" type:"string"`

	// Unique identifier for the remote participant. For a subscribe event, this
	// is the publisher. For a publish or join event, this is null. This is assigned
	// by IVS.
	RemoteParticipantId *string `locationName:"remoteParticipantId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Event) SetErrorCode(v string) *Event {
	s.ErrorCode = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *Event) SetEventTime(v time.Time) *Event {
	s.EventTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Event) SetName(v string) *Event {
	s.Name = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *Event) SetParticipantId(v string) *Event {
	s.ParticipantId = &v
	return s
}

// SetRemoteParticipantId sets the RemoteParticipantId field's value.
func (s *Event) SetRemoteParticipantId(v string) *Event {
	s.RemoteParticipantId = &v
	return s
}

type GetCompositionInput struct {
	_ struct{} `type:"structure"`

	// ARN of the Composition resource.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCompositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCompositionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetCompositionInput) SetArn(v string) *GetCompositionInput {
	s.Arn = &v
	return s
}

type GetCompositionOutput struct {
	_ struct{} `type:"structure"`

	// The Composition that was returned.
	Composition *Composition `locationName:"composition" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCompositionOutput) GoString() string {
	return s.String()
}

// SetComposition sets the Composition field's value.
func (s *GetCompositionOutput) SetComposition(v *Composition) *GetCompositionOutput {
	s.Composition = v
	return s
}

type GetEncoderConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ARN of the EncoderConfiguration resource.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncoderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncoderConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEncoderConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEncoderConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetEncoderConfigurationInput) SetArn(v string) *GetEncoderConfigurationInput {
	s.Arn = &v
	return s
}

type GetEncoderConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The EncoderConfiguration that was returned.
	EncoderConfiguration *EncoderConfiguration `locationName:"encoderConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncoderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEncoderConfigurationOutput) GoString() string {
	return s.String()
}

// SetEncoderConfiguration sets the EncoderConfiguration field's value.
func (s *GetEncoderConfigurationOutput) SetEncoderConfiguration(v *EncoderConfiguration) *GetEncoderConfigurationOutput {
	s.EncoderConfiguration = v
	return s
}

type GetParticipantInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the participant. This is assigned by IVS and returned
	// by CreateParticipantToken.
	//
	// ParticipantId is a required field
	ParticipantId *string `locationName:"participantId" type:"string" required:"true"`

	// ID of a session within the stage.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"16" type:"string" required:"true"`

	// Stage ARN.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParticipantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParticipantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParticipantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParticipantInput"}
	if s.ParticipantId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantId"))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 16))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParticipantId sets the ParticipantId field's value.
func (s *GetParticipantInput) SetParticipantId(v string) *GetParticipantInput {
	s.ParticipantId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetParticipantInput) SetSessionId(v string) *GetParticipantInput {
	s.SessionId = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *GetParticipantInput) SetStageArn(v string) *GetParticipantInput {
	s.StageArn = &v
	return s
}

type GetParticipantOutput struct {
	_ struct{} `type:"structure"`

	// The participant that is returned.
	Participant *Participant `locationName:"participant" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParticipantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetParticipantOutput) GoString() string {
	return s.String()
}

// SetParticipant sets the Participant field's value.
func (s *GetParticipantOutput) SetParticipant(v *Participant) *GetParticipantOutput {
	s.Participant = v
	return s
}

type GetPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// ARN of the public key for which the information is to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicKeyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetPublicKeyInput) SetArn(v string) *GetPublicKeyInput {
	s.Arn = &v
	return s
}

type GetPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// The public key that is returned.
	PublicKey *PublicKey `locationName:"publicKey" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicKeyOutput) GoString() string {
	return s.String()
}

// SetPublicKey sets the PublicKey field's value.
func (s *GetPublicKeyOutput) SetPublicKey(v *PublicKey) *GetPublicKeyOutput {
	s.PublicKey = v
	return s
}

type GetStageInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stage for which the information is to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStageInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetStageInput) SetArn(v string) *GetStageInput {
	s.Arn = &v
	return s
}

type GetStageOutput struct {
	_ struct{} `type:"structure"`

	// The stage that is returned.
	Stage *Stage `locationName:"stage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageOutput) GoString() string {
	return s.String()
}

// SetStage sets the Stage field's value.
func (s *GetStageOutput) SetStage(v *Stage) *GetStageOutput {
	s.Stage = v
	return s
}

type GetStageSessionInput struct {
	_ struct{} `type:"structure"`

	// ID of a session within the stage.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"16" type:"string" required:"true"`

	// ARN of the stage for which the information is to be retrieved.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStageSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStageSessionInput"}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 16))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSessionId sets the SessionId field's value.
func (s *GetStageSessionInput) SetSessionId(v string) *GetStageSessionInput {
	s.SessionId = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *GetStageSessionInput) SetStageArn(v string) *GetStageSessionInput {
	s.StageArn = &v
	return s
}

type GetStageSessionOutput struct {
	_ struct{} `type:"structure"`

	// The stage session that is returned.
	StageSession *StageSession `locationName:"stageSession" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageSessionOutput) GoString() string {
	return s.String()
}

// SetStageSession sets the StageSession field's value.
func (s *GetStageSessionOutput) SetStageSession(v *StageSession) *GetStageSessionOutput {
	s.StageSession = v
	return s
}

type GetStorageConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ARN of the storage configuration to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStorageConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStorageConfigurationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetStorageConfigurationInput) SetArn(v string) *GetStorageConfigurationInput {
	s.Arn = &v
	return s
}

type GetStorageConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The StorageConfiguration that was returned.
	StorageConfiguration *StorageConfiguration `locationName:"storageConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageConfigurationOutput) GoString() string {
	return s.String()
}

// SetStorageConfiguration sets the StorageConfiguration field's value.
func (s *GetStorageConfigurationOutput) SetStorageConfiguration(v *StorageConfiguration) *GetStorageConfigurationOutput {
	s.StorageConfiguration = v
	return s
}

// Configuration information specific to Grid layout, for server-side composition.
// See "Layouts" in Server-Side Composition (https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/server-side-composition.html).
type GridConfiguration struct {
	_ struct{} `type:"structure"`

	// This attribute name identifies the featured slot. A participant with this
	// attribute set to "true" (as a string value) in ParticipantTokenConfiguration
	// is placed in the featured slot. Default: "" (no featured participant).
	FeaturedParticipantAttribute *string `locationName:"featuredParticipantAttribute" type:"string"`

	// Specifies the spacing between participant tiles in pixels. Default: 2.
	GridGap *int64 `locationName:"gridGap" type:"integer"`

	// Determines whether to omit participants with stopped video in the composition.
	// Default: false.
	OmitStoppedVideo *bool `locationName:"omitStoppedVideo" type:"boolean"`

	// Sets the non-featured participant display mode, to control the aspect ratio
	// of video tiles. VIDEO is 16:9, SQUARE is 1:1, and PORTRAIT is 3:4. Default:
	// VIDEO.
	VideoAspectRatio *string `locationName:"videoAspectRatio" type:"string" enum:"VideoAspectRatio"`

	// Defines how video content fits within the participant tile: FILL (stretched),
	// COVER (cropped), or CONTAIN (letterboxed). When not set, videoFillMode defaults
	// to COVER fill mode for participants in the grid and to CONTAIN fill mode
	// for featured participants.
	VideoFillMode *string `locationName:"videoFillMode" type:"string" enum:"VideoFillMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GridConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GridConfiguration) GoString() string {
	return s.String()
}

// SetFeaturedParticipantAttribute sets the FeaturedParticipantAttribute field's value.
func (s *GridConfiguration) SetFeaturedParticipantAttribute(v string) *GridConfiguration {
	s.FeaturedParticipantAttribute = &v
	return s
}

// SetGridGap sets the GridGap field's value.
func (s *GridConfiguration) SetGridGap(v int64) *GridConfiguration {
	s.GridGap = &v
	return s
}

// SetOmitStoppedVideo sets the OmitStoppedVideo field's value.
func (s *GridConfiguration) SetOmitStoppedVideo(v bool) *GridConfiguration {
	s.OmitStoppedVideo = &v
	return s
}

// SetVideoAspectRatio sets the VideoAspectRatio field's value.
func (s *GridConfiguration) SetVideoAspectRatio(v string) *GridConfiguration {
	s.VideoAspectRatio = &v
	return s
}

// SetVideoFillMode sets the VideoFillMode field's value.
func (s *GridConfiguration) SetVideoFillMode(v string) *GridConfiguration {
	s.VideoFillMode = &v
	return s
}

type ImportPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// Name of the public key to be imported.
	Name *string `locationName:"name" type:"string"`

	// The content of the public key to be imported.
	//
	// PublicKeyMaterial is a required field
	PublicKeyMaterial *string `locationName:"publicKeyMaterial" type:"string" required:"true"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportPublicKeyInput"}
	if s.PublicKeyMaterial == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyMaterial"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ImportPublicKeyInput) SetName(v string) *ImportPublicKeyInput {
	s.Name = &v
	return s
}

// SetPublicKeyMaterial sets the PublicKeyMaterial field's value.
func (s *ImportPublicKeyInput) SetPublicKeyMaterial(v string) *ImportPublicKeyInput {
	s.PublicKeyMaterial = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportPublicKeyInput) SetTags(v map[string]*string) *ImportPublicKeyInput {
	s.Tags = v
	return s
}

type ImportPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// The public key that was imported.
	PublicKey *PublicKey `locationName:"publicKey" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportPublicKeyOutput) GoString() string {
	return s.String()
}

// SetPublicKey sets the PublicKey field's value.
func (s *ImportPublicKeyOutput) SetPublicKey(v *PublicKey) *ImportPublicKeyOutput {
	s.PublicKey = v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Unexpected error during processing of request.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Configuration information of supported layouts for server-side composition.
type LayoutConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration related to grid layout. Default: Grid layout.
	Grid *GridConfiguration `locationName:"grid" type:"structure"`

	// Configuration related to PiP layout.
	Pip *PipConfiguration `locationName:"pip" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayoutConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LayoutConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LayoutConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LayoutConfiguration"}
	if s.Pip != nil {
		if err := s.Pip.Validate(); err != nil {
			invalidParams.AddNested("Pip", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrid sets the Grid field's value.
func (s *LayoutConfiguration) SetGrid(v *GridConfiguration) *LayoutConfiguration {
	s.Grid = v
	return s
}

// SetPip sets the Pip field's value.
func (s *LayoutConfiguration) SetPip(v *PipConfiguration) *LayoutConfiguration {
	s.Pip = v
	return s
}

type ListCompositionsInput struct {
	_ struct{} `type:"structure"`

	// Filters the Composition list to match the specified EncoderConfiguration
	// attached to at least one of its output.
	FilterByEncoderConfigurationArn *string `locationName:"filterByEncoderConfigurationArn" min:"1" type:"string"`

	// Filters the Composition list to match the specified Stage ARN.
	FilterByStageArn *string `locationName:"filterByStageArn" min:"1" type:"string"`

	// Maximum number of results to return. Default: 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first Composition to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCompositionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCompositionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCompositionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCompositionsInput"}
	if s.FilterByEncoderConfigurationArn != nil && len(*s.FilterByEncoderConfigurationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterByEncoderConfigurationArn", 1))
	}
	if s.FilterByStageArn != nil && len(*s.FilterByStageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterByStageArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterByEncoderConfigurationArn sets the FilterByEncoderConfigurationArn field's value.
func (s *ListCompositionsInput) SetFilterByEncoderConfigurationArn(v string) *ListCompositionsInput {
	s.FilterByEncoderConfigurationArn = &v
	return s
}

// SetFilterByStageArn sets the FilterByStageArn field's value.
func (s *ListCompositionsInput) SetFilterByStageArn(v string) *ListCompositionsInput {
	s.FilterByStageArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCompositionsInput) SetMaxResults(v int64) *ListCompositionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCompositionsInput) SetNextToken(v string) *ListCompositionsInput {
	s.NextToken = &v
	return s
}

type ListCompositionsOutput struct {
	_ struct{} `type:"structure"`

	// List of the matching Compositions (summary information only).
	//
	// Compositions is a required field
	Compositions []*CompositionSummary `locationName:"compositions" type:"list" required:"true"`

	// If there are more compositions than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCompositionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCompositionsOutput) GoString() string {
	return s.String()
}

// SetCompositions sets the Compositions field's value.
func (s *ListCompositionsOutput) SetCompositions(v []*CompositionSummary) *ListCompositionsOutput {
	s.Compositions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCompositionsOutput) SetNextToken(v string) *ListCompositionsOutput {
	s.NextToken = &v
	return s
}

type ListEncoderConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Default: 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first encoder configuration to retrieve. This is used for pagination;
	// see the nextToken response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEncoderConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEncoderConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEncoderConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEncoderConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEncoderConfigurationsInput) SetMaxResults(v int64) *ListEncoderConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEncoderConfigurationsInput) SetNextToken(v string) *ListEncoderConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListEncoderConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// List of the matching EncoderConfigurations (summary information only).
	//
	// EncoderConfigurations is a required field
	EncoderConfigurations []*EncoderConfigurationSummary `locationName:"encoderConfigurations" type:"list" required:"true"`

	// If there are more encoder configurations than maxResults, use nextToken in
	// the request to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEncoderConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEncoderConfigurationsOutput) GoString() string {
	return s.String()
}

// SetEncoderConfigurations sets the EncoderConfigurations field's value.
func (s *ListEncoderConfigurationsOutput) SetEncoderConfigurations(v []*EncoderConfigurationSummary) *ListEncoderConfigurationsOutput {
	s.EncoderConfigurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEncoderConfigurationsOutput) SetNextToken(v string) *ListEncoderConfigurationsOutput {
	s.NextToken = &v
	return s
}

type ListParticipantEventsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first participant event to retrieve. This is used for pagination; see
	// the nextToken response field.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Unique identifier for this participant. This is assigned by IVS and returned
	// by CreateParticipantToken.
	//
	// ParticipantId is a required field
	ParticipantId *string `locationName:"participantId" type:"string" required:"true"`

	// ID of a session within the stage.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"16" type:"string" required:"true"`

	// Stage ARN.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListParticipantEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListParticipantEventsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ParticipantId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantId"))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 16))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListParticipantEventsInput) SetMaxResults(v int64) *ListParticipantEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListParticipantEventsInput) SetNextToken(v string) *ListParticipantEventsInput {
	s.NextToken = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *ListParticipantEventsInput) SetParticipantId(v string) *ListParticipantEventsInput {
	s.ParticipantId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *ListParticipantEventsInput) SetSessionId(v string) *ListParticipantEventsInput {
	s.SessionId = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *ListParticipantEventsInput) SetStageArn(v string) *ListParticipantEventsInput {
	s.StageArn = &v
	return s
}

type ListParticipantEventsOutput struct {
	_ struct{} `type:"structure"`

	// List of the matching events.
	//
	// Events is a required field
	Events []*Event `locationName:"events" type:"list" required:"true"`

	// If there are more events than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *ListParticipantEventsOutput) SetEvents(v []*Event) *ListParticipantEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListParticipantEventsOutput) SetNextToken(v string) *ListParticipantEventsOutput {
	s.NextToken = &v
	return s
}

type ListParticipantsInput struct {
	_ struct{} `type:"structure"`

	// Filters the response list to only show participants who published during
	// the stage session. Only one of filterByUserId, filterByPublished, filterByState,
	// or filterByRecordingState can be provided per request.
	FilterByPublished *bool `locationName:"filterByPublished" type:"boolean"`

	// Filters the response list to only show participants with the specified recording
	// state. Only one of filterByUserId, filterByPublished, filterByState, or filterByRecordingState
	// can be provided per request.
	FilterByRecordingState *string `locationName:"filterByRecordingState" type:"string" enum:"ParticipantRecordingFilterByRecordingState"`

	// Filters the response list to only show participants in the specified state.
	// Only one of filterByUserId, filterByPublished, filterByState, or filterByRecordingState
	// can be provided per request.
	FilterByState *string `locationName:"filterByState" type:"string" enum:"ParticipantState"`

	// Filters the response list to match the specified user ID. Only one of filterByUserId,
	// filterByPublished, filterByState, or filterByRecordingState can be provided
	// per request. A userId is a customer-assigned name to help identify the token;
	// this can be used to link a participant to a user in the customer’s own
	// systems.
	FilterByUserId *string `locationName:"filterByUserId" type:"string"`

	// Maximum number of results to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first participant to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`

	// ID of the session within the stage.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" min:"16" type:"string" required:"true"`

	// Stage ARN.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListParticipantsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListParticipantsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 16))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterByPublished sets the FilterByPublished field's value.
func (s *ListParticipantsInput) SetFilterByPublished(v bool) *ListParticipantsInput {
	s.FilterByPublished = &v
	return s
}

// SetFilterByRecordingState sets the FilterByRecordingState field's value.
func (s *ListParticipantsInput) SetFilterByRecordingState(v string) *ListParticipantsInput {
	s.FilterByRecordingState = &v
	return s
}

// SetFilterByState sets the FilterByState field's value.
func (s *ListParticipantsInput) SetFilterByState(v string) *ListParticipantsInput {
	s.FilterByState = &v
	return s
}

// SetFilterByUserId sets the FilterByUserId field's value.
func (s *ListParticipantsInput) SetFilterByUserId(v string) *ListParticipantsInput {
	s.FilterByUserId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListParticipantsInput) SetMaxResults(v int64) *ListParticipantsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListParticipantsInput) SetNextToken(v string) *ListParticipantsInput {
	s.NextToken = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *ListParticipantsInput) SetSessionId(v string) *ListParticipantsInput {
	s.SessionId = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *ListParticipantsInput) SetStageArn(v string) *ListParticipantsInput {
	s.StageArn = &v
	return s
}

type ListParticipantsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more participants than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of the matching participants (summary information only).
	//
	// Participants is a required field
	Participants []*ParticipantSummary `locationName:"participants" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListParticipantsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListParticipantsOutput) SetNextToken(v string) *ListParticipantsOutput {
	s.NextToken = &v
	return s
}

// SetParticipants sets the Participants field's value.
func (s *ListParticipantsOutput) SetParticipants(v []*ParticipantSummary) *ListParticipantsOutput {
	s.Participants = v
	return s
}

type ListPublicKeysInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first public key to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPublicKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPublicKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPublicKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPublicKeysInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPublicKeysInput) SetMaxResults(v int64) *ListPublicKeysInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPublicKeysInput) SetNextToken(v string) *ListPublicKeysInput {
	s.NextToken = &v
	return s
}

type ListPublicKeysOutput struct {
	_ struct{} `type:"structure"`

	// If there are more public keys than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of the matching public keys (summary information only).
	//
	// PublicKeys is a required field
	PublicKeys []*PublicKeySummary `locationName:"publicKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPublicKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPublicKeysOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPublicKeysOutput) SetNextToken(v string) *ListPublicKeysOutput {
	s.NextToken = &v
	return s
}

// SetPublicKeys sets the PublicKeys field's value.
func (s *ListPublicKeysOutput) SetPublicKeys(v []*PublicKeySummary) *ListPublicKeysOutput {
	s.PublicKeys = v
	return s
}

type ListStageSessionsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stage session to retrieve. This is used for pagination; see the
	// nextToken response field.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Stage ARN.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStageSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStageSessionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStageSessionsInput) SetMaxResults(v int64) *ListStageSessionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStageSessionsInput) SetNextToken(v string) *ListStageSessionsInput {
	s.NextToken = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *ListStageSessionsInput) SetStageArn(v string) *ListStageSessionsInput {
	s.StageArn = &v
	return s
}

type ListStageSessionsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more stage sessions than maxResults, use nextToken in the request
	// to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of matching stage sessions.
	//
	// StageSessions is a required field
	StageSessions []*StageSessionSummary `locationName:"stageSessions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStageSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStageSessionsOutput) SetNextToken(v string) *ListStageSessionsOutput {
	s.NextToken = &v
	return s
}

// SetStageSessions sets the StageSessions field's value.
func (s *ListStageSessionsOutput) SetStageSessions(v []*StageSessionSummary) *ListStageSessionsOutput {
	s.StageSessions = v
	return s
}

type ListStagesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stage to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStagesInput) SetMaxResults(v int64) *ListStagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStagesInput) SetNextToken(v string) *ListStagesInput {
	s.NextToken = &v
	return s
}

type ListStagesOutput struct {
	_ struct{} `type:"structure"`

	// If there are more stages than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of the matching stages (summary information only).
	//
	// Stages is a required field
	Stages []*StageSummary `locationName:"stages" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStagesOutput) SetNextToken(v string) *ListStagesOutput {
	s.NextToken = &v
	return s
}

// SetStages sets the Stages field's value.
func (s *ListStagesOutput) SetStages(v []*StageSummary) *ListStagesOutput {
	s.Stages = v
	return s
}

type ListStorageConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of storage configurations to return. Default: your service
	// quota or 100, whichever is smaller.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first storage configuration to retrieve. This is used for pagination;
	// see the nextToken response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStorageConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStorageConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStorageConfigurationsInput) SetMaxResults(v int64) *ListStorageConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageConfigurationsInput) SetNextToken(v string) *ListStorageConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListStorageConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more storage configurations than maxResults, use nextToken in
	// the request to get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of the matching storage configurations.
	//
	// StorageConfigurations is a required field
	StorageConfigurations []*StorageConfigurationSummary `locationName:"storageConfigurations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageConfigurationsOutput) SetNextToken(v string) *ListStorageConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetStorageConfigurations sets the StorageConfigurations field's value.
func (s *ListStorageConfigurationsOutput) SetStorageConfigurations(v []*StorageConfigurationSummary) *ListStorageConfigurationsOutput {
	s.StorageConfigurations = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to be retrieved. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value).
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Object describing a participant that has joined a stage.
type Participant struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the token and attach to a
	// stage. Map keys and values can contain UTF-8 encoded text. The maximum length
	// of this field is 1 KB total. This field is exposed to all stage participants
	// and should not be used for personally identifying, confidential, or sensitive
	// information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The participant’s browser.
	BrowserName *string `locationName:"browserName" type:"string"`

	// The participant’s browser version.
	BrowserVersion *string `locationName:"browserVersion" type:"string"`

	// ISO 8601 timestamp (returned as a string) when the participant first joined
	// the stage session.
	FirstJoinTime *time.Time `locationName:"firstJoinTime" type:"timestamp" timestampFormat:"iso8601"`

	// The participant’s Internet Service Provider.
	IspName *string `locationName:"ispName" type:"string"`

	// The participant’s operating system.
	OsName *string `locationName:"osName" type:"string"`

	// The participant’s operating system version.
	OsVersion *string `locationName:"osVersion" type:"string"`

	// Unique identifier for this participant, assigned by IVS.
	ParticipantId *string `locationName:"participantId" type:"string"`

	// Whether the participant ever published to the stage session.
	Published *bool `locationName:"published" type:"boolean"`

	// Name of the S3 bucket to where the participant is being recorded, if individual
	// participant recording is enabled, or "" (empty string), if recording is not
	// enabled.
	RecordingS3BucketName *string `locationName:"recordingS3BucketName" type:"string"`

	// S3 prefix of the S3 bucket where the participant is being recorded, if individual
	// participant recording is enabled, or "" (empty string), if recording is not
	// enabled.
	RecordingS3Prefix *string `locationName:"recordingS3Prefix" type:"string"`

	// The participant’s recording state.
	RecordingState *string `locationName:"recordingState" type:"string" enum:"ParticipantRecordingState"`

	// The participant’s SDK version.
	SdkVersion *string `locationName:"sdkVersion" type:"string"`

	// Whether the participant is connected to or disconnected from the stage.
	State *string `locationName:"state" type:"string" enum:"ParticipantState"`

	// Customer-assigned name to help identify the token; this can be used to link
	// a participant to a user in the customer’s own systems. This can be any
	// UTF-8 encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Participant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Participant) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *Participant) SetAttributes(v map[string]*string) *Participant {
	s.Attributes = v
	return s
}

// SetBrowserName sets the BrowserName field's value.
func (s *Participant) SetBrowserName(v string) *Participant {
	s.BrowserName = &v
	return s
}

// SetBrowserVersion sets the BrowserVersion field's value.
func (s *Participant) SetBrowserVersion(v string) *Participant {
	s.BrowserVersion = &v
	return s
}

// SetFirstJoinTime sets the FirstJoinTime field's value.
func (s *Participant) SetFirstJoinTime(v time.Time) *Participant {
	s.FirstJoinTime = &v
	return s
}

// SetIspName sets the IspName field's value.
func (s *Participant) SetIspName(v string) *Participant {
	s.IspName = &v
	return s
}

// SetOsName sets the OsName field's value.
func (s *Participant) SetOsName(v string) *Participant {
	s.OsName = &v
	return s
}

// SetOsVersion sets the OsVersion field's value.
func (s *Participant) SetOsVersion(v string) *Participant {
	s.OsVersion = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *Participant) SetParticipantId(v string) *Participant {
	s.ParticipantId = &v
	return s
}

// SetPublished sets the Published field's value.
func (s *Participant) SetPublished(v bool) *Participant {
	s.Published = &v
	return s
}

// SetRecordingS3BucketName sets the RecordingS3BucketName field's value.
func (s *Participant) SetRecordingS3BucketName(v string) *Participant {
	s.RecordingS3BucketName = &v
	return s
}

// SetRecordingS3Prefix sets the RecordingS3Prefix field's value.
func (s *Participant) SetRecordingS3Prefix(v string) *Participant {
	s.RecordingS3Prefix = &v
	return s
}

// SetRecordingState sets the RecordingState field's value.
func (s *Participant) SetRecordingState(v string) *Participant {
	s.RecordingState = &v
	return s
}

// SetSdkVersion sets the SdkVersion field's value.
func (s *Participant) SetSdkVersion(v string) *Participant {
	s.SdkVersion = &v
	return s
}

// SetState sets the State field's value.
func (s *Participant) SetState(v string) *Participant {
	s.State = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *Participant) SetUserId(v string) *Participant {
	s.UserId = &v
	return s
}

// Summary object describing a participant that has joined a stage.
type ParticipantSummary struct {
	_ struct{} `type:"structure"`

	// ISO 8601 timestamp (returned as a string) when the participant first joined
	// the stage session.
	FirstJoinTime *time.Time `locationName:"firstJoinTime" type:"timestamp" timestampFormat:"iso8601"`

	// Unique identifier for this participant, assigned by IVS.
	ParticipantId *string `locationName:"participantId" type:"string"`

	// Whether the participant ever published to the stage session.
	Published *bool `locationName:"published" type:"boolean"`

	// The participant’s recording state.
	RecordingState *string `locationName:"recordingState" type:"string" enum:"ParticipantRecordingState"`

	// Whether the participant is connected to or disconnected from the stage.
	State *string `locationName:"state" type:"string" enum:"ParticipantState"`

	// Customer-assigned name to help identify the token; this can be used to link
	// a participant to a user in the customer’s own systems. This can be any
	// UTF-8 encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantSummary) GoString() string {
	return s.String()
}

// SetFirstJoinTime sets the FirstJoinTime field's value.
func (s *ParticipantSummary) SetFirstJoinTime(v time.Time) *ParticipantSummary {
	s.FirstJoinTime = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *ParticipantSummary) SetParticipantId(v string) *ParticipantSummary {
	s.ParticipantId = &v
	return s
}

// SetPublished sets the Published field's value.
func (s *ParticipantSummary) SetPublished(v bool) *ParticipantSummary {
	s.Published = &v
	return s
}

// SetRecordingState sets the RecordingState field's value.
func (s *ParticipantSummary) SetRecordingState(v string) *ParticipantSummary {
	s.RecordingState = &v
	return s
}

// SetState sets the State field's value.
func (s *ParticipantSummary) SetState(v string) *ParticipantSummary {
	s.State = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ParticipantSummary) SetUserId(v string) *ParticipantSummary {
	s.UserId = &v
	return s
}

// Object specifying a participant token in a stage.
//
// Important: Treat tokens as opaque; i.e., do not build functionality based
// on token contents. The format of tokens could change in the future.
type ParticipantToken struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the token and attach to a
	// stage. This field is exposed to all stage participants and should not be
	// used for personally identifying, confidential, or sensitive information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Set of capabilities that the user is allowed to perform in the stage.
	Capabilities []*string `locationName:"capabilities" type:"list" enum:"ParticipantTokenCapability"`

	// Duration (in minutes), after which the participant token expires. Default:
	// 720 (12 hours).
	Duration *int64 `locationName:"duration" min:"1" type:"integer"`

	// ISO 8601 timestamp (returned as a string) for when this token expires.
	ExpirationTime *time.Time `locationName:"expirationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Unique identifier for this participant token, assigned by IVS.
	ParticipantId *string `locationName:"participantId" type:"string"`

	// The issued client token, encrypted.
	//
	// Token is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ParticipantToken's
	// String and GoString methods.
	Token *string `locationName:"token" type:"string" sensitive:"true"`

	// Customer-assigned name to help identify the token; this can be used to link
	// a participant to a user in the customer’s own systems. This can be any
	// UTF-8 encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantToken) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantToken) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ParticipantToken) SetAttributes(v map[string]*string) *ParticipantToken {
	s.Attributes = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *ParticipantToken) SetCapabilities(v []*string) *ParticipantToken {
	s.Capabilities = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ParticipantToken) SetDuration(v int64) *ParticipantToken {
	s.Duration = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *ParticipantToken) SetExpirationTime(v time.Time) *ParticipantToken {
	s.ExpirationTime = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *ParticipantToken) SetParticipantId(v string) *ParticipantToken {
	s.ParticipantId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *ParticipantToken) SetToken(v string) *ParticipantToken {
	s.Token = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ParticipantToken) SetUserId(v string) *ParticipantToken {
	s.UserId = &v
	return s
}

// Object specifying a participant token configuration in a stage.
type ParticipantTokenConfiguration struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the corresponding participant
	// token and attach to a stage. Map keys and values can contain UTF-8 encoded
	// text. The maximum length of this field is 1 KB total. This field is exposed
	// to all stage participants and should not be used for personally identifying,
	// confidential, or sensitive information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Set of capabilities that the user is allowed to perform in the stage.
	Capabilities []*string `locationName:"capabilities" type:"list" enum:"ParticipantTokenCapability"`

	// Duration (in minutes), after which the corresponding participant token expires.
	// Default: 720 (12 hours).
	Duration *int64 `locationName:"duration" min:"1" type:"integer"`

	// Customer-assigned name to help identify the token; this can be used to link
	// a participant to a user in the customer’s own systems. This can be any
	// UTF-8 encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantTokenConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantTokenConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParticipantTokenConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParticipantTokenConfiguration"}
	if s.Duration != nil && *s.Duration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Duration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *ParticipantTokenConfiguration) SetAttributes(v map[string]*string) *ParticipantTokenConfiguration {
	s.Attributes = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *ParticipantTokenConfiguration) SetCapabilities(v []*string) *ParticipantTokenConfiguration {
	s.Capabilities = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ParticipantTokenConfiguration) SetDuration(v int64) *ParticipantTokenConfiguration {
	s.Duration = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ParticipantTokenConfiguration) SetUserId(v string) *ParticipantTokenConfiguration {
	s.UserId = &v
	return s
}

type PendingVerification struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Your account is pending verification.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingVerification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingVerification) GoString() string {
	return s.String()
}

func newErrorPendingVerification(v protocol.ResponseMetadata) error {
	return &PendingVerification{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PendingVerification) Code() string {
	return "PendingVerification"
}

// Message returns the exception's message.
func (s *PendingVerification) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PendingVerification) OrigErr() error {
	return nil
}

func (s *PendingVerification) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PendingVerification) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PendingVerification) RequestID() string {
	return s.RespMetadata.RequestID
}

// Configuration information specific to Picture-in-Picture (PiP) layout, for
// server-side composition (https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/server-side-composition.html).
type PipConfiguration struct {
	_ struct{} `type:"structure"`

	// This attribute name identifies the featured slot. A participant with this
	// attribute set to "true" (as a string value) in ParticipantTokenConfiguration
	// is placed in the featured slot. Default: "" (no featured participant).
	FeaturedParticipantAttribute *string `locationName:"featuredParticipantAttribute" type:"string"`

	// Specifies the spacing between participant tiles in pixels. Default: 0.
	GridGap *int64 `locationName:"gridGap" type:"integer"`

	// Determines whether to omit participants with stopped video in the composition.
	// Default: false.
	OmitStoppedVideo *bool `locationName:"omitStoppedVideo" type:"boolean"`

	// Defines PiP behavior when all participants have left: STATIC (maintains original
	// position/size) or DYNAMIC (expands to full composition). Default: STATIC.
	PipBehavior *string `locationName:"pipBehavior" type:"string" enum:"PipBehavior"`

	// Specifies the height of the PiP window in pixels. When this is not set explicitly,
	// pipHeight’s value will be based on the size of the composition and the
	// aspect ratio of the participant’s video.
	PipHeight *int64 `locationName:"pipHeight" min:"1" type:"integer"`

	// Sets the PiP window’s offset position in pixels from the closest edges
	// determined by PipPosition. Default: 0.
	PipOffset *int64 `locationName:"pipOffset" type:"integer"`

	// Specifies the participant for the PiP window. A participant with this attribute
	// set to "true" (as a string value) in ParticipantTokenConfiguration is placed
	// in the PiP slot. Default: "" (no PiP participant).
	PipParticipantAttribute *string `locationName:"pipParticipantAttribute" type:"string"`

	// Determines the corner position of the PiP window. Default: BOTTOM_RIGHT.
	PipPosition *string `locationName:"pipPosition" type:"string" enum:"PipPosition"`

	// Specifies the width of the PiP window in pixels. When this is not set explicitly,
	// pipWidth’s value will be based on the size of the composition and the aspect
	// ratio of the participant’s video.
	PipWidth *int64 `locationName:"pipWidth" min:"1" type:"integer"`

	// Defines how video content fits within the participant tile: FILL (stretched),
	// COVER (cropped), or CONTAIN (letterboxed). Default: COVER.
	VideoFillMode *string `locationName:"videoFillMode" type:"string" enum:"VideoFillMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipConfiguration"}
	if s.PipHeight != nil && *s.PipHeight < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PipHeight", 1))
	}
	if s.PipWidth != nil && *s.PipWidth < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PipWidth", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeaturedParticipantAttribute sets the FeaturedParticipantAttribute field's value.
func (s *PipConfiguration) SetFeaturedParticipantAttribute(v string) *PipConfiguration {
	s.FeaturedParticipantAttribute = &v
	return s
}

// SetGridGap sets the GridGap field's value.
func (s *PipConfiguration) SetGridGap(v int64) *PipConfiguration {
	s.GridGap = &v
	return s
}

// SetOmitStoppedVideo sets the OmitStoppedVideo field's value.
func (s *PipConfiguration) SetOmitStoppedVideo(v bool) *PipConfiguration {
	s.OmitStoppedVideo = &v
	return s
}

// SetPipBehavior sets the PipBehavior field's value.
func (s *PipConfiguration) SetPipBehavior(v string) *PipConfiguration {
	s.PipBehavior = &v
	return s
}

// SetPipHeight sets the PipHeight field's value.
func (s *PipConfiguration) SetPipHeight(v int64) *PipConfiguration {
	s.PipHeight = &v
	return s
}

// SetPipOffset sets the PipOffset field's value.
func (s *PipConfiguration) SetPipOffset(v int64) *PipConfiguration {
	s.PipOffset = &v
	return s
}

// SetPipParticipantAttribute sets the PipParticipantAttribute field's value.
func (s *PipConfiguration) SetPipParticipantAttribute(v string) *PipConfiguration {
	s.PipParticipantAttribute = &v
	return s
}

// SetPipPosition sets the PipPosition field's value.
func (s *PipConfiguration) SetPipPosition(v string) *PipConfiguration {
	s.PipPosition = &v
	return s
}

// SetPipWidth sets the PipWidth field's value.
func (s *PipConfiguration) SetPipWidth(v int64) *PipConfiguration {
	s.PipWidth = &v
	return s
}

// SetVideoFillMode sets the VideoFillMode field's value.
func (s *PipConfiguration) SetVideoFillMode(v string) *PipConfiguration {
	s.VideoFillMode = &v
	return s
}

// Object specifying a public key used to sign stage participant tokens.
type PublicKey struct {
	_ struct{} `type:"structure"`

	// Public key ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The public key fingerprint, a short string used to identify or verify the
	// full public key.
	Fingerprint *string `locationName:"fingerprint" type:"string"`

	// Public key name.
	Name *string `locationName:"name" type:"string"`

	// Public key material.
	PublicKeyMaterial *string `locationName:"publicKeyMaterial" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicKey) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PublicKey) SetArn(v string) *PublicKey {
	s.Arn = &v
	return s
}

// SetFingerprint sets the Fingerprint field's value.
func (s *PublicKey) SetFingerprint(v string) *PublicKey {
	s.Fingerprint = &v
	return s
}

// SetName sets the Name field's value.
func (s *PublicKey) SetName(v string) *PublicKey {
	s.Name = &v
	return s
}

// SetPublicKeyMaterial sets the PublicKeyMaterial field's value.
func (s *PublicKey) SetPublicKeyMaterial(v string) *PublicKey {
	s.PublicKeyMaterial = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PublicKey) SetTags(v map[string]*string) *PublicKey {
	s.Tags = v
	return s
}

// Summary information about a public key.
type PublicKeySummary struct {
	_ struct{} `type:"structure"`

	// Public key ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Public key name.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicKeySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicKeySummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PublicKeySummary) SetArn(v string) *PublicKeySummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *PublicKeySummary) SetName(v string) *PublicKeySummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PublicKeySummary) SetTags(v map[string]*string) *PublicKeySummary {
	s.Tags = v
	return s
}

// An object representing a configuration to record a stage stream.
type RecordingConfiguration struct {
	_ struct{} `type:"structure"`

	// The recording format for storing a recording in Amazon S3.
	Format *string `locationName:"format" type:"string" enum:"RecordingConfigurationFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordingConfiguration) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *RecordingConfiguration) SetFormat(v string) *RecordingConfiguration {
	s.Format = &v
	return s
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request references a resource which does not exist.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type that describes an S3 location where recorded videos will be
// stored.
type S3DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// ARNs of the EncoderConfiguration resource. The encoder configuration and
	// stage resources must be in the same AWS account and region.
	//
	// EncoderConfigurationArns is a required field
	EncoderConfigurationArns []*string `locationName:"encoderConfigurationArns" min:"1" type:"list" required:"true"`

	// Array of maps, each of the form string:string (key:value). This is an optional
	// customer specification, currently used only to specify the recording format
	// for storing a recording in Amazon S3.
	RecordingConfiguration *RecordingConfiguration `locationName:"recordingConfiguration" type:"structure"`

	// ARN of the StorageConfiguration where recorded videos will be stored.
	//
	// StorageConfigurationArn is a required field
	StorageConfigurationArn *string `locationName:"storageConfigurationArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationConfiguration"}
	if s.EncoderConfigurationArns == nil {
		invalidParams.Add(request.NewErrParamRequired("EncoderConfigurationArns"))
	}
	if s.EncoderConfigurationArns != nil && len(s.EncoderConfigurationArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncoderConfigurationArns", 1))
	}
	if s.StorageConfigurationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageConfigurationArn"))
	}
	if s.StorageConfigurationArn != nil && len(*s.StorageConfigurationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StorageConfigurationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncoderConfigurationArns sets the EncoderConfigurationArns field's value.
func (s *S3DestinationConfiguration) SetEncoderConfigurationArns(v []*string) *S3DestinationConfiguration {
	s.EncoderConfigurationArns = v
	return s
}

// SetRecordingConfiguration sets the RecordingConfiguration field's value.
func (s *S3DestinationConfiguration) SetRecordingConfiguration(v *RecordingConfiguration) *S3DestinationConfiguration {
	s.RecordingConfiguration = v
	return s
}

// SetStorageConfigurationArn sets the StorageConfigurationArn field's value.
func (s *S3DestinationConfiguration) SetStorageConfigurationArn(v string) *S3DestinationConfiguration {
	s.StorageConfigurationArn = &v
	return s
}

// Complex data type that defines S3Detail objects.
type S3Detail struct {
	_ struct{} `type:"structure"`

	// The S3 bucket prefix under which the recording is stored.
	//
	// RecordingPrefix is a required field
	RecordingPrefix *string `locationName:"recordingPrefix" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Detail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Detail) GoString() string {
	return s.String()
}

// SetRecordingPrefix sets the RecordingPrefix field's value.
func (s *S3Detail) SetRecordingPrefix(v string) *S3Detail {
	s.RecordingPrefix = &v
	return s
}

// A complex type that describes an S3 location where recorded videos will be
// stored.
type S3StorageConfiguration struct {
	_ struct{} `type:"structure"`

	// Location (S3 bucket name) where recorded videos will be stored. Note that
	// the StorageConfiguration and S3 bucket must be in the same region as the
	// Composition.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3StorageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3StorageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3StorageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3StorageConfiguration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3StorageConfiguration) SetBucketName(v string) *S3StorageConfiguration {
	s.BucketName = &v
	return s
}

type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request would cause a service quota to be exceeded.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object specifying a stage.
type Stage struct {
	_ struct{} `type:"structure"`

	// ID of the active session within the stage.
	ActiveSessionId *string `locationName:"activeSessionId" min:"16" type:"string"`

	// Stage ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Configuration object for individual participant recording, attached to the
	// stage.
	AutoParticipantRecordingConfiguration *AutoParticipantRecordingConfiguration `locationName:"autoParticipantRecordingConfiguration" type:"structure"`

	// Summary information about various endpoints for a stage.
	Endpoints *StageEndpoints `locationName:"endpoints" type:"structure"`

	// Stage name.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) GoString() string {
	return s.String()
}

// SetActiveSessionId sets the ActiveSessionId field's value.
func (s *Stage) SetActiveSessionId(v string) *Stage {
	s.ActiveSessionId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Stage) SetArn(v string) *Stage {
	s.Arn = &v
	return s
}

// SetAutoParticipantRecordingConfiguration sets the AutoParticipantRecordingConfiguration field's value.
func (s *Stage) SetAutoParticipantRecordingConfiguration(v *AutoParticipantRecordingConfiguration) *Stage {
	s.AutoParticipantRecordingConfiguration = v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *Stage) SetEndpoints(v *StageEndpoints) *Stage {
	s.Endpoints = v
	return s
}

// SetName sets the Name field's value.
func (s *Stage) SetName(v string) *Stage {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Stage) SetTags(v map[string]*string) *Stage {
	s.Tags = v
	return s
}

// Summary information about various endpoints for a stage.
type StageEndpoints struct {
	_ struct{} `type:"structure"`

	// Events endpoint.
	Events *string `locationName:"events" type:"string"`

	// WHIP endpoint.
	Whip *string `locationName:"whip" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageEndpoints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageEndpoints) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *StageEndpoints) SetEvents(v string) *StageEndpoints {
	s.Events = &v
	return s
}

// SetWhip sets the Whip field's value.
func (s *StageEndpoints) SetWhip(v string) *StageEndpoints {
	s.Whip = &v
	return s
}

// A stage session begins when the first participant joins a stage and ends
// after the last participant leaves the stage. A stage session helps with debugging
// stages by grouping events and participants into shorter periods of time (i.e.,
// a session), which is helpful when stages are used over long periods of time.
type StageSession struct {
	_ struct{} `type:"structure"`

	// ISO 8601 timestamp (returned as a string) when the stage session ended. This
	// is null if the stage is active.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// ID of the session within the stage.
	SessionId *string `locationName:"sessionId" min:"16" type:"string"`

	// ISO 8601 timestamp (returned as a string) when this stage session began.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSession) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *StageSession) SetEndTime(v time.Time) *StageSession {
	s.EndTime = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StageSession) SetSessionId(v string) *StageSession {
	s.SessionId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StageSession) SetStartTime(v time.Time) *StageSession {
	s.StartTime = &v
	return s
}

// Summary information about a stage session.
type StageSessionSummary struct {
	_ struct{} `type:"structure"`

	// ISO 8601 timestamp (returned as a string) when the stage session ended. This
	// is null if the stage is active.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// ID of the session within the stage.
	SessionId *string `locationName:"sessionId" min:"16" type:"string"`

	// ISO 8601 timestamp (returned as a string) when this stage session began.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSessionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSessionSummary) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *StageSessionSummary) SetEndTime(v time.Time) *StageSessionSummary {
	s.EndTime = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StageSessionSummary) SetSessionId(v string) *StageSessionSummary {
	s.SessionId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StageSessionSummary) SetStartTime(v time.Time) *StageSessionSummary {
	s.StartTime = &v
	return s
}

// Summary information about a stage.
type StageSummary struct {
	_ struct{} `type:"structure"`

	// ID of the active session within the stage.
	ActiveSessionId *string `locationName:"activeSessionId" min:"16" type:"string"`

	// Stage ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Stage name.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSummary) GoString() string {
	return s.String()
}

// SetActiveSessionId sets the ActiveSessionId field's value.
func (s *StageSummary) SetActiveSessionId(v string) *StageSummary {
	s.ActiveSessionId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *StageSummary) SetArn(v string) *StageSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *StageSummary) SetName(v string) *StageSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StageSummary) SetTags(v map[string]*string) *StageSummary {
	s.Tags = v
	return s
}

type StartCompositionInput struct {
	_ struct{} `type:"structure"`

	// Array of destination configuration.
	//
	// Destinations is a required field
	Destinations []*DestinationConfiguration `locationName:"destinations" min:"1" type:"list" required:"true"`

	// Idempotency token.
	IdempotencyToken *string `locationName:"idempotencyToken" min:"1" type:"string" idempotencyToken:"true"`

	// Layout object to configure composition parameters.
	Layout *LayoutConfiguration `locationName:"layout" type:"structure"`

	// ARN of the stage to be used for compositing.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCompositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCompositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCompositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCompositionInput"}
	if s.Destinations == nil {
		invalidParams.Add(request.NewErrParamRequired("Destinations"))
	}
	if s.Destinations != nil && len(s.Destinations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Destinations", 1))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Layout != nil {
		if err := s.Layout.Validate(); err != nil {
			invalidParams.AddNested("Layout", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *StartCompositionInput) SetDestinations(v []*DestinationConfiguration) *StartCompositionInput {
	s.Destinations = v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *StartCompositionInput) SetIdempotencyToken(v string) *StartCompositionInput {
	s.IdempotencyToken = &v
	return s
}

// SetLayout sets the Layout field's value.
func (s *StartCompositionInput) SetLayout(v *LayoutConfiguration) *StartCompositionInput {
	s.Layout = v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *StartCompositionInput) SetStageArn(v string) *StartCompositionInput {
	s.StageArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartCompositionInput) SetTags(v map[string]*string) *StartCompositionInput {
	s.Tags = v
	return s
}

type StartCompositionOutput struct {
	_ struct{} `type:"structure"`

	// The Composition that was created.
	Composition *Composition `locationName:"composition" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCompositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCompositionOutput) GoString() string {
	return s.String()
}

// SetComposition sets the Composition field's value.
func (s *StartCompositionOutput) SetComposition(v *Composition) *StartCompositionOutput {
	s.Composition = v
	return s
}

type StopCompositionInput struct {
	_ struct{} `type:"structure"`

	// ARN of the Composition.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCompositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCompositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopCompositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopCompositionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *StopCompositionInput) SetArn(v string) *StopCompositionInput {
	s.Arn = &v
	return s
}

type StopCompositionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCompositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopCompositionOutput) GoString() string {
	return s.String()
}

// A complex type that describes a location where recorded videos will be stored.
type StorageConfiguration struct {
	_ struct{} `type:"structure"`

	// ARN of the storage configuration.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Name of the storage configuration.
	Name *string `locationName:"name" type:"string"`

	// An S3 destination configuration where recorded videos will be stored.
	S3 *S3StorageConfiguration `locationName:"s3" type:"structure"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfiguration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StorageConfiguration) SetArn(v string) *StorageConfiguration {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *StorageConfiguration) SetName(v string) *StorageConfiguration {
	s.Name = &v
	return s
}

// SetS3 sets the S3 field's value.
func (s *StorageConfiguration) SetS3(v *S3StorageConfiguration) *StorageConfiguration {
	s.S3 = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StorageConfiguration) SetTags(v map[string]*string) *StorageConfiguration {
	s.Tags = v
	return s
}

// Summary information about a storage configuration.
type StorageConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// ARN of the storage configuration.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Name of the storage configuration.
	Name *string `locationName:"name" type:"string"`

	// An S3 destination configuration where recorded videos will be stored.
	S3 *S3StorageConfiguration `locationName:"s3" type:"structure"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfigurationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StorageConfigurationSummary) SetArn(v string) *StorageConfigurationSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *StorageConfigurationSummary) SetName(v string) *StorageConfigurationSummary {
	s.Name = &v
	return s
}

// SetS3 sets the S3 field's value.
func (s *StorageConfigurationSummary) SetS3(v *S3StorageConfiguration) *StorageConfigurationSummary {
	s.S3 = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StorageConfigurationSummary) SetTags(v map[string]*string) *StorageConfigurationSummary {
	s.Tags = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to be tagged. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be added or updated. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints beyond what is documented
	// there.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to be untagged. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be removed. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints beyond what is documented
	// there.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateStageInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stage to be updated.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Configuration object for individual participant recording, to attach to the
	// stage. Note that this cannot be updated while recording is active.
	AutoParticipantRecordingConfiguration *AutoParticipantRecordingConfiguration `locationName:"autoParticipantRecordingConfiguration" type:"structure"`

	// Name of the stage to be updated.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStageInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.AutoParticipantRecordingConfiguration != nil {
		if err := s.AutoParticipantRecordingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AutoParticipantRecordingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateStageInput) SetArn(v string) *UpdateStageInput {
	s.Arn = &v
	return s
}

// SetAutoParticipantRecordingConfiguration sets the AutoParticipantRecordingConfiguration field's value.
func (s *UpdateStageInput) SetAutoParticipantRecordingConfiguration(v *AutoParticipantRecordingConfiguration) *UpdateStageInput {
	s.AutoParticipantRecordingConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStageInput) SetName(v string) *UpdateStageInput {
	s.Name = &v
	return s
}

type UpdateStageOutput struct {
	_ struct{} `type:"structure"`

	// The updated stage.
	Stage *Stage `locationName:"stage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageOutput) GoString() string {
	return s.String()
}

// SetStage sets the Stage field's value.
func (s *UpdateStageOutput) SetStage(v *Stage) *UpdateStageOutput {
	s.Stage = v
	return s
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The input fails to satisfy the constraints specified by an Amazon Web Services
	// service.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Settings for video.
type Video struct {
	_ struct{} `type:"structure"`

	// Bitrate for generated output, in bps. Default: 2500000.
	Bitrate *int64 `locationName:"bitrate" min:"1" type:"integer"`

	// Video frame rate, in fps. Default: 30.
	Framerate *float64 `locationName:"framerate" min:"1" type:"float"`

	// Video-resolution height. Note that the maximum value is determined by width
	// times height, such that the maximum total pixels is 2073600 (1920x1080 or
	// 1080x1920). Default: 720.
	Height *int64 `locationName:"height" min:"1" type:"integer"`

	// Video-resolution width. Note that the maximum value is determined by width
	// times height, such that the maximum total pixels is 2073600 (1920x1080 or
	// 1080x1920). Default: 1280.
	Width *int64 `locationName:"width" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Video) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Video) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Video) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Video"}
	if s.Bitrate != nil && *s.Bitrate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Bitrate", 1))
	}
	if s.Framerate != nil && *s.Framerate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Framerate", 1))
	}
	if s.Height != nil && *s.Height < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Height", 1))
	}
	if s.Width != nil && *s.Width < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Width", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBitrate sets the Bitrate field's value.
func (s *Video) SetBitrate(v int64) *Video {
	s.Bitrate = &v
	return s
}

// SetFramerate sets the Framerate field's value.
func (s *Video) SetFramerate(v float64) *Video {
	s.Framerate = &v
	return s
}

// SetHeight sets the Height field's value.
func (s *Video) SetHeight(v int64) *Video {
	s.Height = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *Video) SetWidth(v int64) *Video {
	s.Width = &v
	return s
}

const (
	// CompositionStateStarting is a CompositionState enum value
	CompositionStateStarting = "STARTING"

	// CompositionStateActive is a CompositionState enum value
	CompositionStateActive = "ACTIVE"

	// CompositionStateStopping is a CompositionState enum value
	CompositionStateStopping = "STOPPING"

	// CompositionStateFailed is a CompositionState enum value
	CompositionStateFailed = "FAILED"

	// CompositionStateStopped is a CompositionState enum value
	CompositionStateStopped = "STOPPED"
)

// CompositionState_Values returns all elements of the CompositionState enum
func CompositionState_Values() []string {
	return []string{
		CompositionStateStarting,
		CompositionStateActive,
		CompositionStateStopping,
		CompositionStateFailed,
		CompositionStateStopped,
	}
}

const (
	// DestinationStateStarting is a DestinationState enum value
	DestinationStateStarting = "STARTING"

	// DestinationStateActive is a DestinationState enum value
	DestinationStateActive = "ACTIVE"

	// DestinationStateStopping is a DestinationState enum value
	DestinationStateStopping = "STOPPING"

	// DestinationStateReconnecting is a DestinationState enum value
	DestinationStateReconnecting = "RECONNECTING"

	// DestinationStateFailed is a DestinationState enum value
	DestinationStateFailed = "FAILED"

	// DestinationStateStopped is a DestinationState enum value
	DestinationStateStopped = "STOPPED"
)

// DestinationState_Values returns all elements of the DestinationState enum
func DestinationState_Values() []string {
	return []string{
		DestinationStateStarting,
		DestinationStateActive,
		DestinationStateStopping,
		DestinationStateReconnecting,
		DestinationStateFailed,
		DestinationStateStopped,
	}
}

const (
	// EventErrorCodeInsufficientCapabilities is a EventErrorCode enum value
	EventErrorCodeInsufficientCapabilities = "INSUFFICIENT_CAPABILITIES"

	// EventErrorCodeQuotaExceeded is a EventErrorCode enum value
	EventErrorCodeQuotaExceeded = "QUOTA_EXCEEDED"

	// EventErrorCodePublisherNotFound is a EventErrorCode enum value
	EventErrorCodePublisherNotFound = "PUBLISHER_NOT_FOUND"
)

// EventErrorCode_Values returns all elements of the EventErrorCode enum
func EventErrorCode_Values() []string {
	return []string{
		EventErrorCodeInsufficientCapabilities,
		EventErrorCodeQuotaExceeded,
		EventErrorCodePublisherNotFound,
	}
}

const (
	// EventNameJoined is a EventName enum value
	EventNameJoined = "JOINED"

	// EventNameLeft is a EventName enum value
	EventNameLeft = "LEFT"

	// EventNamePublishStarted is a EventName enum value
	EventNamePublishStarted = "PUBLISH_STARTED"

	// EventNamePublishStopped is a EventName enum value
	EventNamePublishStopped = "PUBLISH_STOPPED"

	// EventNameSubscribeStarted is a EventName enum value
	EventNameSubscribeStarted = "SUBSCRIBE_STARTED"

	// EventNameSubscribeStopped is a EventName enum value
	EventNameSubscribeStopped = "SUBSCRIBE_STOPPED"

	// EventNamePublishError is a EventName enum value
	EventNamePublishError = "PUBLISH_ERROR"

	// EventNameSubscribeError is a EventName enum value
	EventNameSubscribeError = "SUBSCRIBE_ERROR"

	// EventNameJoinError is a EventName enum value
	EventNameJoinError = "JOIN_ERROR"
)

// EventName_Values returns all elements of the EventName enum
func EventName_Values() []string {
	return []string{
		EventNameJoined,
		EventNameLeft,
		EventNamePublishStarted,
		EventNamePublishStopped,
		EventNameSubscribeStarted,
		EventNameSubscribeStopped,
		EventNamePublishError,
		EventNameSubscribeError,
		EventNameJoinError,
	}
}

const (
	// ParticipantRecordingFilterByRecordingStateStarting is a ParticipantRecordingFilterByRecordingState enum value
	ParticipantRecordingFilterByRecordingStateStarting = "STARTING"

	// ParticipantRecordingFilterByRecordingStateActive is a ParticipantRecordingFilterByRecordingState enum value
	ParticipantRecordingFilterByRecordingStateActive = "ACTIVE"

	// ParticipantRecordingFilterByRecordingStateStopping is a ParticipantRecordingFilterByRecordingState enum value
	ParticipantRecordingFilterByRecordingStateStopping = "STOPPING"

	// ParticipantRecordingFilterByRecordingStateStopped is a ParticipantRecordingFilterByRecordingState enum value
	ParticipantRecordingFilterByRecordingStateStopped = "STOPPED"

	// ParticipantRecordingFilterByRecordingStateFailed is a ParticipantRecordingFilterByRecordingState enum value
	ParticipantRecordingFilterByRecordingStateFailed = "FAILED"
)

// ParticipantRecordingFilterByRecordingState_Values returns all elements of the ParticipantRecordingFilterByRecordingState enum
func ParticipantRecordingFilterByRecordingState_Values() []string {
	return []string{
		ParticipantRecordingFilterByRecordingStateStarting,
		ParticipantRecordingFilterByRecordingStateActive,
		ParticipantRecordingFilterByRecordingStateStopping,
		ParticipantRecordingFilterByRecordingStateStopped,
		ParticipantRecordingFilterByRecordingStateFailed,
	}
}

const (
	// ParticipantRecordingMediaTypeAudioVideo is a ParticipantRecordingMediaType enum value
	ParticipantRecordingMediaTypeAudioVideo = "AUDIO_VIDEO"

	// ParticipantRecordingMediaTypeAudioOnly is a ParticipantRecordingMediaType enum value
	ParticipantRecordingMediaTypeAudioOnly = "AUDIO_ONLY"
)

// ParticipantRecordingMediaType_Values returns all elements of the ParticipantRecordingMediaType enum
func ParticipantRecordingMediaType_Values() []string {
	return []string{
		ParticipantRecordingMediaTypeAudioVideo,
		ParticipantRecordingMediaTypeAudioOnly,
	}
}

const (
	// ParticipantRecordingStateStarting is a ParticipantRecordingState enum value
	ParticipantRecordingStateStarting = "STARTING"

	// ParticipantRecordingStateActive is a ParticipantRecordingState enum value
	ParticipantRecordingStateActive = "ACTIVE"

	// ParticipantRecordingStateStopping is a ParticipantRecordingState enum value
	ParticipantRecordingStateStopping = "STOPPING"

	// ParticipantRecordingStateStopped is a ParticipantRecordingState enum value
	ParticipantRecordingStateStopped = "STOPPED"

	// ParticipantRecordingStateFailed is a ParticipantRecordingState enum value
	ParticipantRecordingStateFailed = "FAILED"

	// ParticipantRecordingStateDisabled is a ParticipantRecordingState enum value
	ParticipantRecordingStateDisabled = "DISABLED"
)

// ParticipantRecordingState_Values returns all elements of the ParticipantRecordingState enum
func ParticipantRecordingState_Values() []string {
	return []string{
		ParticipantRecordingStateStarting,
		ParticipantRecordingStateActive,
		ParticipantRecordingStateStopping,
		ParticipantRecordingStateStopped,
		ParticipantRecordingStateFailed,
		ParticipantRecordingStateDisabled,
	}
}

const (
	// ParticipantStateConnected is a ParticipantState enum value
	ParticipantStateConnected = "CONNECTED"

	// ParticipantStateDisconnected is a ParticipantState enum value
	ParticipantStateDisconnected = "DISCONNECTED"
)

// ParticipantState_Values returns all elements of the ParticipantState enum
func ParticipantState_Values() []string {
	return []string{
		ParticipantStateConnected,
		ParticipantStateDisconnected,
	}
}

const (
	// ParticipantTokenCapabilityPublish is a ParticipantTokenCapability enum value
	ParticipantTokenCapabilityPublish = "PUBLISH"

	// ParticipantTokenCapabilitySubscribe is a ParticipantTokenCapability enum value
	ParticipantTokenCapabilitySubscribe = "SUBSCRIBE"
)

// ParticipantTokenCapability_Values returns all elements of the ParticipantTokenCapability enum
func ParticipantTokenCapability_Values() []string {
	return []string{
		ParticipantTokenCapabilityPublish,
		ParticipantTokenCapabilitySubscribe,
	}
}

const (
	// PipBehaviorStatic is a PipBehavior enum value
	PipBehaviorStatic = "STATIC"

	// PipBehaviorDynamic is a PipBehavior enum value
	PipBehaviorDynamic = "DYNAMIC"
)

// PipBehavior_Values returns all elements of the PipBehavior enum
func PipBehavior_Values() []string {
	return []string{
		PipBehaviorStatic,
		PipBehaviorDynamic,
	}
}

const (
	// PipPositionTopLeft is a PipPosition enum value
	PipPositionTopLeft = "TOP_LEFT"

	// PipPositionTopRight is a PipPosition enum value
	PipPositionTopRight = "TOP_RIGHT"

	// PipPositionBottomLeft is a PipPosition enum value
	PipPositionBottomLeft = "BOTTOM_LEFT"

	// PipPositionBottomRight is a PipPosition enum value
	PipPositionBottomRight = "BOTTOM_RIGHT"
)

// PipPosition_Values returns all elements of the PipPosition enum
func PipPosition_Values() []string {
	return []string{
		PipPositionTopLeft,
		PipPositionTopRight,
		PipPositionBottomLeft,
		PipPositionBottomRight,
	}
}

const (
	// RecordingConfigurationFormatHls is a RecordingConfigurationFormat enum value
	RecordingConfigurationFormatHls = "HLS"
)

// RecordingConfigurationFormat_Values returns all elements of the RecordingConfigurationFormat enum
func RecordingConfigurationFormat_Values() []string {
	return []string{
		RecordingConfigurationFormatHls,
	}
}

const (
	// VideoAspectRatioAuto is a VideoAspectRatio enum value
	VideoAspectRatioAuto = "AUTO"

	// VideoAspectRatioVideo is a VideoAspectRatio enum value
	VideoAspectRatioVideo = "VIDEO"

	// VideoAspectRatioSquare is a VideoAspectRatio enum value
	VideoAspectRatioSquare = "SQUARE"

	// VideoAspectRatioPortrait is a VideoAspectRatio enum value
	VideoAspectRatioPortrait = "PORTRAIT"
)

// VideoAspectRatio_Values returns all elements of the VideoAspectRatio enum
func VideoAspectRatio_Values() []string {
	return []string{
		VideoAspectRatioAuto,
		VideoAspectRatioVideo,
		VideoAspectRatioSquare,
		VideoAspectRatioPortrait,
	}
}

const (
	// VideoFillModeFill is a VideoFillMode enum value
	VideoFillModeFill = "FILL"

	// VideoFillModeCover is a VideoFillMode enum value
	VideoFillModeCover = "COVER"

	// VideoFillModeContain is a VideoFillMode enum value
	VideoFillModeContain = "CONTAIN"
)

// VideoFillMode_Values returns all elements of the VideoFillMode enum
func VideoFillMode_Values() []string {
	return []string{
		VideoFillModeFill,
		VideoFillModeCover,
		VideoFillModeContain,
	}
}
