package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricCandidateOrganizations invokes the baas.DescribeFabricCandidateOrganizations API synchronously
// api document: https://help.aliyun.com/api/baas/describefabriccandidateorganizations.html
func (client *Client) DescribeFabricCandidateOrganizations(request *DescribeFabricCandidateOrganizationsRequest) (response *DescribeFabricCandidateOrganizationsResponse, err error) {
	response = CreateDescribeFabricCandidateOrganizationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricCandidateOrganizationsWithChan invokes the baas.DescribeFabricCandidateOrganizations API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabriccandidateorganizations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricCandidateOrganizationsWithChan(request *DescribeFabricCandidateOrganizationsRequest) (<-chan *DescribeFabricCandidateOrganizationsResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricCandidateOrganizationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricCandidateOrganizations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricCandidateOrganizationsWithCallback invokes the baas.DescribeFabricCandidateOrganizations API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabriccandidateorganizations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricCandidateOrganizationsWithCallback(request *DescribeFabricCandidateOrganizationsRequest, callback func(response *DescribeFabricCandidateOrganizationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricCandidateOrganizationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricCandidateOrganizations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricCandidateOrganizationsRequest is the request struct for api DescribeFabricCandidateOrganizations
type DescribeFabricCandidateOrganizationsRequest struct {
	*requests.RpcRequest
	Location string `position:"Body" name:"Location"`
}

// DescribeFabricCandidateOrganizationsResponse is the response struct for api DescribeFabricCandidateOrganizations
type DescribeFabricCandidateOrganizationsResponse struct {
	*responses.BaseResponse
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Success   bool                            `json:"Success" xml:"Success"`
	ErrorCode int                             `json:"ErrorCode" xml:"ErrorCode"`
	Result    []DescribeCandidateOrganization `json:"Result" xml:"Result"`
}

// CreateDescribeFabricCandidateOrganizationsRequest creates a request to invoke DescribeFabricCandidateOrganizations API
func CreateDescribeFabricCandidateOrganizationsRequest() (request *DescribeFabricCandidateOrganizationsRequest) {
	request = &DescribeFabricCandidateOrganizationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricCandidateOrganizations", "baas", "openAPI")
	return
}

// CreateDescribeFabricCandidateOrganizationsResponse creates a response to parse from DescribeFabricCandidateOrganizations response
func CreateDescribeFabricCandidateOrganizationsResponse() (response *DescribeFabricCandidateOrganizationsResponse) {
	response = &DescribeFabricCandidateOrganizationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
