/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	v1alpha1 "kubevirt.io/api/instancetype/v1alpha1"
	scheme "kubevirt.io/client-go/kubevirt/scheme"
)

// VirtualMachineClusterPreferencesGetter has a method to return a VirtualMachineClusterPreferenceInterface.
// A group's client should implement this interface.
type VirtualMachineClusterPreferencesGetter interface {
	VirtualMachineClusterPreferences() VirtualMachineClusterPreferenceInterface
}

// VirtualMachineClusterPreferenceInterface has methods to work with VirtualMachineClusterPreference resources.
type VirtualMachineClusterPreferenceInterface interface {
	Create(ctx context.Context, virtualMachineClusterPreference *v1alpha1.VirtualMachineClusterPreference, opts v1.CreateOptions) (*v1alpha1.VirtualMachineClusterPreference, error)
	Update(ctx context.Context, virtualMachineClusterPreference *v1alpha1.VirtualMachineClusterPreference, opts v1.UpdateOptions) (*v1alpha1.VirtualMachineClusterPreference, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.VirtualMachineClusterPreference, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.VirtualMachineClusterPreferenceList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VirtualMachineClusterPreference, err error)
	VirtualMachineClusterPreferenceExpansion
}

// virtualMachineClusterPreferences implements VirtualMachineClusterPreferenceInterface
type virtualMachineClusterPreferences struct {
	*gentype.ClientWithList[*v1alpha1.VirtualMachineClusterPreference, *v1alpha1.VirtualMachineClusterPreferenceList]
}

// newVirtualMachineClusterPreferences returns a VirtualMachineClusterPreferences
func newVirtualMachineClusterPreferences(c *InstancetypeV1alpha1Client) *virtualMachineClusterPreferences {
	return &virtualMachineClusterPreferences{
		gentype.NewClientWithList[*v1alpha1.VirtualMachineClusterPreference, *v1alpha1.VirtualMachineClusterPreferenceList](
			"virtualmachineclusterpreferences",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v1alpha1.VirtualMachineClusterPreference { return &v1alpha1.VirtualMachineClusterPreference{} },
			func() *v1alpha1.VirtualMachineClusterPreferenceList {
				return &v1alpha1.VirtualMachineClusterPreferenceList{}
			}),
	}
}
