/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.jaxp;

import com.sun.msv.verifier.util.ErrorHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DocumentBuilderImpl
extends DocumentBuilder {
    private final DocumentBuilder core;
    private final Verifier verifier;

    DocumentBuilderImpl(DocumentBuilder documentBuilder, Schema schema) throws ParserConfigurationException {
        this.core = documentBuilder;
        try {
            this.verifier = schema.newVerifier();
        }
        catch (Exception exception) {
            throw new ParserConfigurationException(exception.toString());
        }
        this.verifier.setErrorHandler(ErrorHandlerImpl.theInstance);
    }

    public DOMImplementation getDOMImplementation() {
        return this.core.getDOMImplementation();
    }

    public boolean isNamespaceAware() {
        return this.core.isNamespaceAware();
    }

    public boolean isValidating() {
        return true;
    }

    public Document newDocument() {
        return this.core.newDocument();
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        return this.verify(this.core.parse(inputSource));
    }

    public Document parse(File file) throws SAXException, IOException {
        return this.verify(this.core.parse(file));
    }

    public Document parse(InputStream inputStream) throws SAXException, IOException {
        return this.verify(this.core.parse(inputStream));
    }

    public Document parse(InputStream inputStream, String string) throws SAXException, IOException {
        return this.verify(this.core.parse(inputStream, string));
    }

    public Document parse(String string) throws SAXException, IOException {
        return this.verify(this.core.parse(string));
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.verifier.setEntityResolver(entityResolver);
        this.core.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.verifier.setErrorHandler(errorHandler);
        this.core.setErrorHandler(errorHandler);
    }

    private Document verify(Document document) throws SAXException, IOException {
        if (this.verifier.verify(document)) {
            return document;
        }
        throw new SAXException("the document is invalid");
    }
}

