/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.trex.ng.comp;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.util.ExpressionWalker;
import com.sun.msv.grammar.util.RefExpRemover;
import com.sun.msv.reader.trex.ng.comp.CompatibilityChecker;
import com.sun.msv.reader.trex.ng.comp.RELAXNGCompReader;
import com.sun.msv.util.StringPair;
import com.sun.msv.verifier.regexp.ResidualCalculator;
import com.sun.msv.verifier.regexp.StringToken;
import com.sun.msv.verifier.regexp.Token;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.relaxng.datatype.Datatype;
import org.xml.sax.Locator;

class DefAttCompatibilityChecker
extends CompatibilityChecker {
    private final Map defaultedAttributes;
    private final RefExpRemover refRemover;
    private ExpressionWalker contextDependentTypeChecker;
    public static final String CERR_DEFVALUE_NAME_IS_NOT_SIMPLE = "RELAXNGReader.Compatibility.DefaultValue.NameIsNotSimple";
    public static final String CERR_DEFVALUE_INVALID = "RELAXNGReader.Compatibility.DefaultValue.Invalid";
    public static final String CERR_DEFVALUE_NOT_OPTIONAL = "RELAXNGReader.Compatibility.DefaultValue.NotOptional";
    public static final String CERR_DEFVALUE_REPEATABLE = "RELAXNGReader.Compatibility.DefaultValue.Repeatable";
    public static final String CERR_DEFVALUE_COMPLEX_ELEMENTNAME = "RELAXNGReader.Compatibility.DefaultValue.ComplexElementName";
    public static final String CERR_DEFVALUE_DIFFERENT_VALUES = "RELAXNGReader.Compatibility.DefaultValue.DifferentValues";
    public static final String CERR_DEFVALUE_CONTEXT_DEPENDENT_TYPE = "RELAXNGReader.Compatibility.DefaultValue.ContextDependentType";
    public static final String CERR_DEFVALUE_COMPETING_ELEMENTS = "RELAXNGReader.Compatibility.DefaultValue.CompetingElements";

    DefAttCompatibilityChecker(RELAXNGCompReader rELAXNGCompReader, Map map) {
        super(rELAXNGCompReader);
        this.refRemover = new RefExpRemover(this.reader.pool, false);
        this.contextDependentTypeChecker = new ExpressionWalker(){

            public void onData(DataExp dataExp) {
                this.check(dataExp.dt, dataExp.name);
            }

            public void onValue(ValueExp valueExp) {
                this.check(valueExp.dt, valueExp.name);
            }

            private void check(Datatype datatype, StringPair stringPair) {
                if (datatype.isContextDependent()) {
                    DefAttCompatibilityChecker.this.reportCompError(null, DefAttCompatibilityChecker.CERR_DEFVALUE_CONTEXT_DEPENDENT_TYPE, new Object[]{stringPair.localName});
                    throw new Abort();
                }
            }
        };
        this.defaultedAttributes = map;
    }

    protected void setCompatibility(boolean bl) {
        this.grammar.isDefaultAttributeValueCompatible = bl;
    }

    private boolean isEpsilon(Expression expression) {
        if (expression == Expression.epsilon) {
            return true;
        }
        return expression.visit(this.refRemover) == Expression.epsilon;
    }

    public void test() {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        this.grammar.isDefaultAttributeValueCompatible = true;
        if (this.defaultedAttributes.size() == 0) {
            return;
        }
        Iterator iterator = this.defaultedAttributes.entrySet().iterator();
        ResidualCalculator residualCalculator = new ResidualCalculator(this.reader.pool);
        while (iterator.hasNext()) {
            object3 = iterator.next();
            serializable = (AttributeExp)object3.getKey();
            object2 = (String)object3.getValue();
            if (!(((AttributeExp)serializable).nameClass instanceof SimpleNameClass)) {
                this.reportCompError(new Locator[]{this.reader.getDeclaredLocationOf(serializable)}, CERR_DEFVALUE_NAME_IS_NOT_SIMPLE);
            }
            try {
                ((AttributeExp)serializable).exp.visit(this.contextDependentTypeChecker);
            }
            catch (Abort abort) {
                continue;
            }
            object = new StringToken(residualCalculator, (String)object2, null, null);
            if (residualCalculator.calcResidual(((AttributeExp)serializable).exp, (Token)object).isEpsilonReducible()) continue;
            this.reportCompError(new Locator[]{this.reader.getDeclaredLocationOf(serializable)}, CERR_DEFVALUE_INVALID, new Object[]{object2});
        }
        if (!this.grammar.isDefaultAttributeValueCompatible) {
            return;
        }
        object3 = new HashMap();
        serializable = new HashSet();
        this.grammar.visit(new ExpressionWalker((Set)((Object)serializable), (Map)object3){
            private boolean inOneOrMore = false;
            private boolean inChoice = false;
            private boolean inOptionalChoice = false;
            private boolean inSimpleElement = false;
            private Map currentAttributes = null;
            private SimpleNameClass currentElementName = null;
            private final /* synthetic */ Set val$elements;
            private final /* synthetic */ Map val$name2value;
            {
                this.val$elements = set;
                this.val$name2value = map;
            }

            public void onElement(ElementExp elementExp) {
                if (!this.val$elements.add(elementExp)) {
                    return;
                }
                boolean bl = this.inSimpleElement;
                boolean bl2 = this.inOptionalChoice;
                boolean bl3 = this.inChoice;
                boolean bl4 = this.inOneOrMore;
                SimpleNameClass simpleNameClass = this.currentElementName;
                Map map = this.currentAttributes;
                this.inSimpleElement = elementExp.getNameClass() instanceof SimpleNameClass;
                this.inOptionalChoice = true;
                this.inChoice = false;
                this.inOneOrMore = false;
                StringPair stringPair = null;
                if (this.inSimpleElement) {
                    this.currentElementName = (SimpleNameClass)elementExp.getNameClass();
                    stringPair = new StringPair(this.currentElementName);
                    this.currentAttributes = new HashMap();
                } else {
                    this.currentElementName = null;
                }
                elementExp.contentModel.visit(this);
                if (stringPair != null) {
                    DefAttMap defAttMap = (DefAttMap)this.val$name2value.get(stringPair);
                    if (defAttMap == null) {
                        this.val$name2value.put(stringPair, new DefAttMap(elementExp, this.currentAttributes));
                    } else if (!defAttMap.defaultAttributes.equals(this.currentAttributes)) {
                        DefAttCompatibilityChecker.this.reportCompError(new Locator[]{DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(defAttMap.sampleDecl), DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(elementExp)}, DefAttCompatibilityChecker.CERR_DEFVALUE_COMPETING_ELEMENTS, new Object[]{((SimpleNameClass)defAttMap.sampleDecl.getNameClass()).localName});
                        this.val$name2value.remove(stringPair);
                    }
                }
                this.inSimpleElement = bl;
                this.inOptionalChoice = bl2;
                this.inChoice = bl3;
                this.inOneOrMore = bl4;
                this.currentElementName = simpleNameClass;
                this.currentAttributes = map;
            }

            public void onOneOrMore(OneOrMoreExp oneOrMoreExp) {
                boolean bl = this.inOneOrMore;
                this.inOneOrMore = true;
                oneOrMoreExp.exp.visit(this);
                this.inOneOrMore = bl;
            }

            public void onChoice(ChoiceExp choiceExp) {
                boolean bl = this.inOptionalChoice;
                boolean bl2 = this.inChoice;
                this.inChoice = true;
                if (!DefAttCompatibilityChecker.this.isEpsilon(choiceExp.exp1) && !DefAttCompatibilityChecker.this.isEpsilon(choiceExp.exp2)) {
                    this.inOptionalChoice = false;
                }
                super.onChoice(choiceExp);
                this.inOptionalChoice = bl;
                this.inChoice = bl2;
            }

            public void onAttribute(AttributeExp attributeExp) {
                if (DefAttCompatibilityChecker.this.defaultedAttributes.containsKey(attributeExp)) {
                    if (!this.inOptionalChoice || !this.inChoice) {
                        DefAttCompatibilityChecker.this.reportCompError(new Locator[]{DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(attributeExp)}, DefAttCompatibilityChecker.CERR_DEFVALUE_NOT_OPTIONAL);
                        return;
                    }
                    if (this.inOneOrMore) {
                        DefAttCompatibilityChecker.this.reportCompError(new Locator[]{DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(attributeExp)}, DefAttCompatibilityChecker.CERR_DEFVALUE_REPEATABLE);
                        return;
                    }
                    if (!this.inSimpleElement) {
                        DefAttCompatibilityChecker.this.reportCompError(new Locator[]{DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(attributeExp)}, DefAttCompatibilityChecker.CERR_DEFVALUE_COMPLEX_ELEMENTNAME);
                        return;
                    }
                    String string = (String)DefAttCompatibilityChecker.this.defaultedAttributes.get(attributeExp);
                    String string2 = this.currentAttributes.put(new StringPair((SimpleNameClass)attributeExp.nameClass), string);
                    if (string2 != null && !string2.equals(string)) {
                        DefAttCompatibilityChecker.this.reportCompError(new Locator[]{DefAttCompatibilityChecker.this.reader.getDeclaredLocationOf(attributeExp)}, DefAttCompatibilityChecker.CERR_DEFVALUE_DIFFERENT_VALUES, new Object[]{string2, string, this.currentElementName.localName, ((SimpleNameClass)attributeExp.nameClass).localName});
                    }
                }
            }

            public void onList(ListExp listExp) {
            }
        });
        iterator = serializable.iterator();
        while (iterator.hasNext()) {
            object2 = (ElementExp)((Object)iterator.next());
            object = ((ElementExp)object2).getNameClass();
            if (object instanceof SimpleNameClass) continue;
            Iterator iterator2 = object3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                if (!((NameClass)object).accepts((StringPair)entry.getKey())) continue;
                DefAttMap defAttMap = (DefAttMap)entry.getValue();
                if (defAttMap.defaultAttributes.size() <= 0) continue;
                this.reportCompError(new Locator[]{this.reader.getDeclaredLocationOf(defAttMap.sampleDecl), this.reader.getDeclaredLocationOf(object2)}, CERR_DEFVALUE_COMPETING_ELEMENTS, new Object[]{((SimpleNameClass)defAttMap.sampleDecl.getNameClass()).localName});
                return;
            }
        }
    }

    private static final class DefAttMap {
        final Map defaultAttributes;
        final ElementExp sampleDecl;

        DefAttMap(ElementExp elementExp, Map map) {
            this.sampleDecl = elementExp;
            this.defaultAttributes = map;
        }
    }

    private static final class Abort
    extends RuntimeException {
        private Abort() {
        }
    }
}

