/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.driver.textui;

import com.sun.msv.driver.textui.Driver;
import com.sun.msv.verifier.ValidationUnrecoverableException;
import com.sun.msv.verifier.ValidityViolation;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReportErrorHandler
implements ErrorHandler {
    private int counter = 0;
    public boolean hadError = false;
    public static final String MSG_TOO_MANY_ERRORS = "ReportErrorHandler.TooManyErrors";
    public static final String MSG_ERROR = "ReportErrorHandler.Error";
    public static final String MSG_WARNING = "ReportErrorHandler.Warning";
    public static final String MSG_FATAL = "ReportErrorHandler.Fatal";

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.hadError = true;
        this.countCheck(sAXParseException);
        ReportErrorHandler.printSAXParseException(sAXParseException, MSG_ERROR);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.hadError = true;
        ReportErrorHandler.printSAXParseException(sAXParseException, MSG_FATAL);
        throw new ValidationUnrecoverableException(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        ReportErrorHandler.printSAXParseException(sAXParseException, MSG_WARNING);
    }

    protected static void printSAXParseException(SAXParseException sAXParseException, String string) {
        System.out.println(Driver.localize(string, new Object[]{new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.getSystemId(), sAXParseException.getLocalizedMessage()}));
    }

    private void print(ValidityViolation validityViolation, String string) {
        System.out.println(Driver.localize(string, new Object[]{new Integer(validityViolation.getLineNumber()), new Integer(validityViolation.getColumnNumber()), validityViolation.getSystemId(), validityViolation.getMessage()}));
    }

    private void countCheck(SAXParseException sAXParseException) throws ValidationUnrecoverableException {
        if (this.counter++ < 20) {
            return;
        }
        System.out.println(Driver.localize(MSG_TOO_MANY_ERRORS));
        throw new ValidationUnrecoverableException(sAXParseException);
    }
}

