/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableIntList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
class ImmutableIntElement
implements ImmutableIntList {
    private final int element;

    ImmutableIntElement(int element) {
        this.element = element;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int get(int index) {
        Checks.index(index, 1);
        return this.element;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableIntList)) {
            return false;
        }
        ImmutableIntList that = (ImmutableIntList)o;
        return that.size() == 1 && this.element == that.get(0);
    }

    public int hashCode() {
        return 31 + this.element;
    }

    @NotNull
    public String toString() {
        return "[" + this.element + "]";
    }
}

