/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.jivesoftware.smack.util.StringUtils;

public class ToStringUtil {
    public static Builder builderFor(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getSimpleName()).append('(');
        return new Builder(sb);
    }

    public static final class Builder {
        private final StringBuilder sb;

        private Builder(StringBuilder sb) {
            this.sb = sb;
        }

        public Builder addValue(String name, Object value) {
            if (value == null) {
                return this;
            }
            if (this.sb.charAt(this.sb.length() - 1) != '(') {
                this.sb.append(' ');
            }
            this.sb.append(name).append("='").append(value).append('\'');
            return this;
        }

        public <V> Builder add(String name, Collection<? extends V> values, Function<V, ?> toStringFunction) {
            if (values.isEmpty()) {
                return this;
            }
            this.sb.append(' ').append(name).append('[');
            ArrayList<String> stringValues = new ArrayList<String>(values.size());
            for (V value : values) {
                String valueString = toStringFunction.apply(value).toString();
                stringValues.add(valueString);
            }
            StringUtils.appendTo(stringValues, ", ", this.sb);
            this.sb.append(']');
            return this;
        }

        public String build() {
            this.sb.append(')');
            return this.sb.toString();
        }
    }
}

