// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `JoiningType`](https://docs.rs/icu/latest/icu/properties/props/struct.JoiningType.html) for more information.
 */


export class JoiningType {
    #value = undefined;

    static #values = new Map([
        ["NonJoining", 0],
        ["JoinCausing", 1],
        ["DualJoining", 2],
        ["LeftJoining", 3],
        ["RightJoining", 4],
        ["Transparent", 5]
    ]);

    static getAllEntries() {
        return JoiningType.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return JoiningType.#objectValues[arguments[1]];
        }

        if (value instanceof JoiningType) {
            return value;
        }

        let intVal = JoiningType.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return JoiningType.#objectValues[intVal];
        }

        throw TypeError(value + " is not a JoiningType and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new JoiningType(value);
    }

    get value(){
        return [...JoiningType.#values.keys()][this.#value];
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = [
        new JoiningType(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        new JoiningType(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
        new JoiningType(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 2),
        new JoiningType(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 3),
        new JoiningType(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 4),
        new JoiningType(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 5),
    ];

    static NonJoining = JoiningType.#objectValues[0];
    static JoinCausing = JoiningType.#objectValues[1];
    static DualJoining = JoiningType.#objectValues[2];
    static LeftJoining = JoiningType.#objectValues[3];
    static RightJoining = JoiningType.#objectValues[4];
    static Transparent = JoiningType.#objectValues[5];


    /**
     * See the [Rust documentation for `for_char`](https://docs.rs/icu/latest/icu/properties/props/trait.EnumeratedProperty.html#tymethod.for_char) for more information.
     */
    static forChar(ch) {

        const result = wasm.icu4x_JoiningType_for_char_mv1(ch);

        try {
            return new JoiningType(diplomatRuntime.internalConstructor, result);
        }

        finally {
        }
    }

    /**
     * Get the "long" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesLongBorrowed.html#method.get) for more information.
     */
    longName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_JoiningType_long_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Get the "short" name of this property value (returns empty if property value is unknown)
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.PropertyNamesShortBorrowed.html#method.get) for more information.
     */
    shortName() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_JoiningType_short_name_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new diplomatRuntime.DiplomatSliceStr(wasm, diplomatReceive.buffer,  "string8", []).getValue();
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Convert to an integer value usable with ICU4C and CodePointMapData
     *
     * See the [Rust documentation for `to_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.JoiningType.html#method.to_icu4c_value) for more information.
     */
    toIntegerValue() {

        const result = wasm.icu4x_JoiningType_to_integer_value_mv1(this.ffiValue);

        try {
            return result;
        }

        finally {
        }
    }

    /**
     * Convert from an integer value from ICU4C or CodePointMapData
     *
     * See the [Rust documentation for `from_icu4c_value`](https://docs.rs/icu/latest/icu/properties/props/struct.JoiningType.html#method.from_icu4c_value) for more information.
     */
    static fromIntegerValue(other) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_JoiningType_from_integer_value_mv1(diplomatReceive.buffer, other);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new JoiningType(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}