/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.typographic.internal;

import com.vladsch.flexmark.ext.typographic.TypographicSmarts;
import com.vladsch.flexmark.ext.typographic.internal.SmartsParsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartsInlineParser
implements InlineParserExtension {
    private final SmartsParsing parsing;

    public SmartsInlineParser(LightInlineParser inlineParser) {
        this.parsing = new SmartsParsing(inlineParser.getParsing());
    }

    public void finalizeDocument(@NotNull InlineParser inlineParser) {
    }

    public void finalizeBlock(@NotNull InlineParser inlineParser) {
    }

    public boolean parse(@NotNull LightInlineParser inlineParser) {
        BasedSequence input = inlineParser.getInput();
        String typographicSmarts = null;
        BasedSequence match = null;
        int i = inlineParser.getIndex();
        char c = input.charAt(i);
        if (c == '.') {
            if (input.matchChars((CharSequence)this.parsing.ELIPSIS, i)) {
                match = input.subSequence(i, i + this.parsing.ELIPSIS.length());
                typographicSmarts = "&hellip;";
            } else if (input.matchChars((CharSequence)this.parsing.ELIPSIS_SPACED, i)) {
                match = input.subSequence(i, i + this.parsing.ELIPSIS_SPACED.length());
                typographicSmarts = "&hellip;";
            }
        } else if (c == '-') {
            if (input.matchChars((CharSequence)this.parsing.EM_DASH, i)) {
                match = input.subSequence(i, i + this.parsing.EM_DASH.length());
                typographicSmarts = "&mdash;";
            } else if (input.matchChars((CharSequence)this.parsing.EN_DASH, i)) {
                match = input.subSequence(i, i + this.parsing.EN_DASH.length());
                typographicSmarts = "&ndash;";
            }
        }
        if (match != null) {
            inlineParser.flushTextNode();
            inlineParser.setIndex(i + match.length());
            TypographicSmarts smarts = new TypographicSmarts(match, typographicSmarts);
            inlineParser.getBlock().appendChild((Node)smarts);
            return true;
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @NotNull
        public CharSequence getCharacters() {
            return ".-";
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @NotNull
        public InlineParserExtension apply(@NotNull LightInlineParser lightInlineParser) {
            return new SmartsInlineParser(lightInlineParser);
        }

        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

