/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.decoder;

import com.sun.beans.decoder.ArrayElementHandler;
import com.sun.beans.decoder.BooleanElementHandler;
import com.sun.beans.decoder.ByteElementHandler;
import com.sun.beans.decoder.CharElementHandler;
import com.sun.beans.decoder.ClassElementHandler;
import com.sun.beans.decoder.DoubleElementHandler;
import com.sun.beans.decoder.ElementHandler;
import com.sun.beans.decoder.FalseElementHandler;
import com.sun.beans.decoder.FieldElementHandler;
import com.sun.beans.decoder.FloatElementHandler;
import com.sun.beans.decoder.IntElementHandler;
import com.sun.beans.decoder.JavaElementHandler;
import com.sun.beans.decoder.LongElementHandler;
import com.sun.beans.decoder.MethodElementHandler;
import com.sun.beans.decoder.NewElementHandler;
import com.sun.beans.decoder.NullElementHandler;
import com.sun.beans.decoder.ObjectElementHandler;
import com.sun.beans.decoder.PropertyElementHandler;
import com.sun.beans.decoder.ShortElementHandler;
import com.sun.beans.decoder.StringElementHandler;
import com.sun.beans.decoder.TrueElementHandler;
import com.sun.beans.decoder.VarElementHandler;
import com.sun.beans.decoder.VoidElementHandler;
import com.sun.beans.finder.ClassFinder;
import java.beans.ExceptionListener;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sun.misc.SharedSecrets;

public final class DocumentHandler
extends DefaultHandler {
    private final AccessControlContext acc = AccessController.getContext();
    private final Map<String, Class<? extends ElementHandler>> handlers = new HashMap<String, Class<? extends ElementHandler>>();
    private final Map<String, Object> environment = new HashMap<String, Object>();
    private final List<Object> objects = new ArrayList<Object>();
    private Reference<ClassLoader> loader;
    private ExceptionListener listener;
    private Object owner;
    private ElementHandler handler;

    public DocumentHandler() {
        this.setElementHandler("java", JavaElementHandler.class);
        this.setElementHandler("null", NullElementHandler.class);
        this.setElementHandler("array", ArrayElementHandler.class);
        this.setElementHandler("class", ClassElementHandler.class);
        this.setElementHandler("string", StringElementHandler.class);
        this.setElementHandler("object", ObjectElementHandler.class);
        this.setElementHandler("void", VoidElementHandler.class);
        this.setElementHandler("char", CharElementHandler.class);
        this.setElementHandler("byte", ByteElementHandler.class);
        this.setElementHandler("short", ShortElementHandler.class);
        this.setElementHandler("int", IntElementHandler.class);
        this.setElementHandler("long", LongElementHandler.class);
        this.setElementHandler("float", FloatElementHandler.class);
        this.setElementHandler("double", DoubleElementHandler.class);
        this.setElementHandler("boolean", BooleanElementHandler.class);
        this.setElementHandler("new", NewElementHandler.class);
        this.setElementHandler("var", VarElementHandler.class);
        this.setElementHandler("true", TrueElementHandler.class);
        this.setElementHandler("false", FalseElementHandler.class);
        this.setElementHandler("field", FieldElementHandler.class);
        this.setElementHandler("method", MethodElementHandler.class);
        this.setElementHandler("property", PropertyElementHandler.class);
    }

    public ClassLoader getClassLoader() {
        return this.loader != null ? this.loader.get() : null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = new WeakReference<ClassLoader>(classLoader);
    }

    public ExceptionListener getExceptionListener() {
        return this.listener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.listener = exceptionListener;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    public Class<? extends ElementHandler> getElementHandler(String string) {
        Class<? extends ElementHandler> clazz = this.handlers.get(string);
        if (clazz == null) {
            throw new IllegalArgumentException("Unsupported element: " + string);
        }
        return clazz;
    }

    public void setElementHandler(String string, Class<? extends ElementHandler> clazz) {
        this.handlers.put(string, clazz);
    }

    public boolean hasVariable(String string) {
        return this.environment.containsKey(string);
    }

    public Object getVariable(String string) {
        if (!this.environment.containsKey(string)) {
            throw new IllegalArgumentException("Unbound variable: " + string);
        }
        return this.environment.get(string);
    }

    public void setVariable(String string, Object object) {
        this.environment.put(string, object);
    }

    public Object[] getObjects() {
        return this.objects.toArray();
    }

    void addObject(Object object) {
        this.objects.add(object);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void startDocument() {
        this.objects.clear();
        this.handler = null;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ElementHandler elementHandler = this.handler;
        try {
            this.handler = this.getElementHandler(string3).newInstance();
            this.handler.setOwner(this);
            this.handler.setParent(elementHandler);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            try {
                String string4 = attributes.getQName(i);
                String string5 = attributes.getValue(i);
                this.handler.addAttribute(string4, string5);
                continue;
            }
            catch (RuntimeException runtimeException) {
                this.handleException(runtimeException);
            }
        }
        this.handler.startElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String string, String string2, String string3) {
        try {
            this.handler.endElement();
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
        finally {
            this.handler = this.handler.getParent();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.handler != null) {
            try {
                while (0 < n2--) {
                    this.handler.addCharacter(cArray[n++]);
                }
            }
            catch (RuntimeException runtimeException) {
                this.handleException(runtimeException);
            }
        }
    }

    public void handleException(Exception exception) {
        if (this.listener == null) {
            throw new IllegalStateException(exception);
        }
        this.listener.exceptionThrown(exception);
    }

    public void parse(final InputSource inputSource) {
        if (this.acc == null && null != System.getSecurityManager()) {
            throw new SecurityException("AccessControlContext is not set");
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        SharedSecrets.getJavaSecurityAccess().doIntersectionPrivilege(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)DocumentHandler.this);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    DocumentHandler.this.handleException(parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    Exception exception = sAXException.getException();
                    if (exception == null) {
                        exception = sAXException;
                    }
                    DocumentHandler.this.handleException(exception);
                }
                catch (IOException iOException) {
                    DocumentHandler.this.handleException(iOException);
                }
                return null;
            }
        }, accessControlContext, this.acc);
    }

    public Class<?> findClass(String string) {
        try {
            return ClassFinder.resolveClass(string, this.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.handleException(classNotFoundException);
            return null;
        }
    }
}

