//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-audio-types")]
use objc2_core_audio_types::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-midi")]
use objc2_core_midi::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetversionkey?language=objc)
pub const kAUPresetVersionKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"version\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresettypekey?language=objc)
pub const kAUPresetTypeKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"type\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetsubtypekey?language=objc)
pub const kAUPresetSubtypeKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"subtype\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetmanufacturerkey?language=objc)
pub const kAUPresetManufacturerKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"manufacturer\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetdatakey?language=objc)
pub const kAUPresetDataKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"data\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetnamekey?language=objc)
pub const kAUPresetNameKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"name\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetnumberkey?language=objc)
pub const kAUPresetNumberKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"preset-number\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetrenderqualitykey?language=objc)
pub const kAUPresetRenderQualityKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"render-quality\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetcpuloadkey?language=objc)
pub const kAUPresetCPULoadKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"cpu-load\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetelementnamekey?language=objc)
pub const kAUPresetElementNameKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"element-name\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetexternalfilerefs?language=objc)
pub const kAUPresetExternalFileRefs: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"file-references\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetvstdatakey?language=objc)
pub const kAUPresetVSTDataKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"vstdata\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetvstpresetkey?language=objc)
pub const kAUPresetVSTPresetKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"vstpreset\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetmasdatakey?language=objc)
pub const kAUPresetMASDataKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"masdata\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaupresetpartkey?language=objc)
pub const kAUPresetPartKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"part\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitconfigurationinfo_hascustomview?language=objc)
pub const kAudioUnitConfigurationInfo_HasCustomView: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"HasCustomView\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitconfigurationinfo_channelconfigurations?language=objc)
pub const kAudioUnitConfigurationInfo_ChannelConfigurations: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"ChannelConfigurations\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitconfigurationinfo_initialinputs?language=objc)
pub const kAudioUnitConfigurationInfo_InitialInputs: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"InitialInputs\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitconfigurationinfo_initialoutputs?language=objc)
pub const kAudioUnitConfigurationInfo_InitialOutputs: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"InitialOutputs\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitconfigurationinfo_iconurl?language=objc)
pub const kAudioUnitConfigurationInfo_IconURL: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"IconURL\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitconfigurationinfo_buscountwritable?language=objc)
pub const kAudioUnitConfigurationInfo_BusCountWritable: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"BusCountWritable\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitconfigurationinfo_supportedchannellayouttags?language=objc)
pub const kAudioUnitConfigurationInfo_SupportedChannelLayoutTags: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"SupportedChannelLayoutTags\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitconfigurationinfo_midiprotocol?language=objc)
pub const kAudioUnitConfigurationInfo_MIDIProtocol: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"MIDIProtocol\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitconfigurationinfo_migratefromplugin?language=objc)
pub const kAudioUnitConfigurationInfo_MigrateFromPlugin: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"MigrateFromPlugin\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitconfigurationinfo_availablearchitectures?language=objc)
pub const kAudioUnitConfigurationInfo_AvailableArchitectures: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"AvailableArchitectures\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitscope_global?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitScope_Global: AudioUnitScope = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitscope_input?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitScope_Input: AudioUnitScope = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitscope_output?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitScope_Output: AudioUnitScope = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitscope_group?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitScope_Group: AudioUnitScope = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitscope_part?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitScope_Part: AudioUnitScope = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitscope_note?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitScope_Note: AudioUnitScope = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitscope_layer?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitScope_Layer: AudioUnitScope = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitscope_layeritem?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitScope_LayerItem: AudioUnitScope = 7;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_classinfo?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ClassInfo: AudioUnitPropertyID = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_makeconnection?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MakeConnection: AudioUnitPropertyID = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_samplerate?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SampleRate: AudioUnitPropertyID = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_parameterlist?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ParameterList: AudioUnitPropertyID = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_parameterinfo?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ParameterInfo: AudioUnitPropertyID = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_cpuload?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_CPULoad: AudioUnitPropertyID = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_streamformat?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_StreamFormat: AudioUnitPropertyID = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_elementcount?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ElementCount: AudioUnitPropertyID = 11;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_latency?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_Latency: AudioUnitPropertyID = 12;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_supportednumchannels?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SupportedNumChannels: AudioUnitPropertyID = 13;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_maximumframesperslice?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MaximumFramesPerSlice: AudioUnitPropertyID = 14;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_parametervaluestrings?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ParameterValueStrings: AudioUnitPropertyID = 16;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_audiochannellayout?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_AudioChannelLayout: AudioUnitPropertyID = 19;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_tailtime?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_TailTime: AudioUnitPropertyID = 20;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_bypasseffect?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_BypassEffect: AudioUnitPropertyID = 21;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_lastrendererror?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_LastRenderError: AudioUnitPropertyID = 22;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_setrendercallback?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SetRenderCallback: AudioUnitPropertyID = 23;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_factorypresets?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_FactoryPresets: AudioUnitPropertyID = 24;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_renderquality?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_RenderQuality: AudioUnitPropertyID = 26;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_hostcallbacks?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_HostCallbacks: AudioUnitPropertyID = 27;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_inplaceprocessing?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_InPlaceProcessing: AudioUnitPropertyID = 29;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_elementname?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ElementName: AudioUnitPropertyID = 30;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_supportedchannellayouttags?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SupportedChannelLayoutTags: AudioUnitPropertyID = 32;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_presentpreset?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_PresentPreset: AudioUnitPropertyID = 36;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_dependentparameters?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_DependentParameters: AudioUnitPropertyID = 45;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_inputsamplesinoutput?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_InputSamplesInOutput: AudioUnitPropertyID = 49;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_shouldallocatebuffer?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ShouldAllocateBuffer: AudioUnitPropertyID = 51;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_frequencyresponse?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_FrequencyResponse: AudioUnitPropertyID = 52;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_parameterhistoryinfo?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ParameterHistoryInfo: AudioUnitPropertyID = 53;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_nickname?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_NickName: AudioUnitPropertyID = 54;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_offlinerender?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_OfflineRender: AudioUnitPropertyID = 37;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_parameteridname?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ParameterIDName: AudioUnitPropertyID = 34;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_parameterstringfromvalue?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ParameterStringFromValue: AudioUnitPropertyID = 33;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_parameterclumpname?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ParameterClumpName: AudioUnitPropertyID = 35;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_parametervaluefromstring?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ParameterValueFromString: AudioUnitPropertyID = 38;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_contextname?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ContextName: AudioUnitPropertyID = 25;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_presentationlatency?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_PresentationLatency: AudioUnitPropertyID = 40;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_classinfofromdocument?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ClassInfoFromDocument: AudioUnitPropertyID = 50;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_requestviewcontroller?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_RequestViewController: AudioUnitPropertyID = 56;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_parametersforoverview?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ParametersForOverview: AudioUnitPropertyID = 57;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_supportsmpe?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SupportsMPE: AudioUnitPropertyID = 58;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_rendercontextobserver?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_RenderContextObserver: AudioUnitPropertyID = 60;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_lastrendersampletime?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_LastRenderSampleTime: AudioUnitPropertyID = 61;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_loadedoutofprocess?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_LoadedOutOfProcess: AudioUnitPropertyID = 62;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_fastdispatch?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_FastDispatch: AudioUnitPropertyID = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_setexternalbuffer?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SetExternalBuffer: AudioUnitPropertyID = 15;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_getuicomponentlist?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_GetUIComponentList: AudioUnitPropertyID = 18;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_cocoaui?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_CocoaUI: AudioUnitPropertyID = 31;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_iconlocation?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_IconLocation: AudioUnitPropertyID = 39;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_auhostidentifier?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_AUHostIdentifier: AudioUnitPropertyID = 46;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_midioutputcallbackinfo?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MIDIOutputCallbackInfo: AudioUnitPropertyID = 47;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_midioutputcallback?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MIDIOutputCallback: AudioUnitPropertyID = 48;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_midioutputeventlistcallback?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MIDIOutputEventListCallback: AudioUnitPropertyID = 63;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_audiounitmidiprotocol?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_AudioUnitMIDIProtocol: AudioUnitPropertyID = 64;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_hostmidiprotocol?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_HostMIDIProtocol: AudioUnitPropertyID = 65;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_midioutputbuffersizehint?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MIDIOutputBufferSizeHint: AudioUnitPropertyID = 66;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_remotecontroleventlistener?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_RemoteControlEventListener: AudioUnitPropertyID = 100;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_isinterappconnected?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_IsInterAppConnected: AudioUnitPropertyID = 101;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_peerurl?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_PeerURL: AudioUnitPropertyID = 102;

/// This structure contains the information needed to make a connection between a source
/// and destination audio unit.
///
/// The structure is set on the destination audio unit's input element
///
/// The audio unit that is the source for the connection
///
/// The source audio unit's output element to be used in the connection
///
/// The destination audio unit's input element to be used in the connection
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitconnection?language=objc)
#[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitConnection {
    pub sourceAudioUnit: AudioUnit,
    pub sourceOutputNumber: u32,
    pub destInputNumber: u32,
}

#[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
unsafe impl Encode for AudioUnitConnection {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitConnection",
        &[<AudioUnit>::ENCODING, <u32>::ENCODING, <u32>::ENCODING],
    );
}

#[cfg(all(feature = "AUComponent", feature = "AudioComponent"))]
unsafe impl RefEncode for AudioUnitConnection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Define an audio unit's channel handling capabilities
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auchannelinfo?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUChannelInfo {
    pub inChannels: i16,
    pub outChannels: i16,
}

unsafe impl Encode for AUChannelInfo {
    const ENCODING: Encoding =
        Encoding::Struct("AUChannelInfo", &[<i16>::ENCODING, <i16>::ENCODING]);
}

unsafe impl RefEncode for AUChannelInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Allow a host to tell an audio unit to use the provided memory for its input callback
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitexternalbuffer?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitExternalBuffer {
    pub buffer: NonNull<Byte>,
    pub size: u32,
}

unsafe impl Encode for AudioUnitExternalBuffer {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitExternalBuffer",
        &[<NonNull<Byte>>::ENCODING, <u32>::ENCODING],
    );
}

unsafe impl RefEncode for AudioUnitExternalBuffer {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Used by a host when registering a callback with the audio unit to provide input
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/aurendercallbackstruct?language=objc)
#[cfg(all(feature = "AUComponent", feature = "objc2-core-audio-types"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AURenderCallbackStruct {
    pub inputProc: AURenderCallback,
    pub inputProcRefCon: *mut c_void,
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-audio-types"))]
unsafe impl Encode for AURenderCallbackStruct {
    const ENCODING: Encoding = Encoding::Struct(
        "AURenderCallbackStruct",
        &[<AURenderCallback>::ENCODING, <*mut c_void>::ENCODING],
    );
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-audio-types"))]
unsafe impl RefEncode for AURenderCallbackStruct {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Used to publish and set factory presets on an audio unit
///
/// If
/// <
/// 0, then preset is a user preset
/// If >= 0, then this field is used to select the factory preset
///
/// If a factory preset, the name of the specified factory preset
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/aupreset?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUPreset {
    pub presetNumber: i32,
    pub presetName: *const CFString,
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AUPreset {
    const ENCODING: Encoding =
        Encoding::Struct("AUPreset", &[<i32>::ENCODING, <*const CFString>::ENCODING]);
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AUPreset {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/krenderquality_max?language=objc)
pub const kRenderQuality_Max: c_uint = 127;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/krenderquality_high?language=objc)
pub const kRenderQuality_High: c_uint = 96;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/krenderquality_medium?language=objc)
pub const kRenderQuality_Medium: c_uint = 64;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/krenderquality_low?language=objc)
pub const kRenderQuality_Low: c_uint = 32;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/krenderquality_min?language=objc)
pub const kRenderQuality_Min: c_uint = 0;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/knumberofresponsefrequencies?language=objc)
pub const kNumberOfResponseFrequencies: c_uint = 1024;

/// Structure used to get the magnitude of the frequency response at a particular frequency via kAudioUnitProperty_FrequencyResponse.
///
/// An array of AudioUnitFrequencyResponseBin are passed in to kAudioUnitProperty_FrequencyResponse
/// with the mFrequency field filled in. The array is returned with the mMagnitude fields filled in.
/// If fewer than kNumberOfResponseFrequencies are needed, then the first unused bin should be marked with
/// a negative frequency.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitfrequencyresponsebin?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitFrequencyResponseBin {
    pub mFrequency: f64,
    pub mMagnitude: f64,
}

unsafe impl Encode for AudioUnitFrequencyResponseBin {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitFrequencyResponseBin",
        &[<f64>::ENCODING, <f64>::ENCODING],
    );
}

unsafe impl RefEncode for AudioUnitFrequencyResponseBin {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Retrieve information about the current beat and/or tempo
///
/// If the host app has set this callback, then the audio unit can use this to get the current
/// beat and tempo as they relate to the first sample in the render buffer. The audio unit can
/// call this callback only from within the audio unit render call (otherwise the host is unable
/// to provide information accurately to the audio unit as the information obtained is relate to
/// the current AudioUnitRender call). If the host cannot provide the requested information, it
/// will return kAudioUnitErr_CannotDoInCurrentContext.
///
/// The AudioUnit can provide NULL for any of the requested parameters (except for
/// inHostUserData) if it is not interested in that particular piece of information
///
///
/// Parameter `inHostUserData`: Must be provided by the audio unit when it makes this call. It is the client data provided by the host when it set the HostCallbacks property
///
/// Parameter `outCurrentBeat`: The current beat, where 0 is the first beat. Tempo is defined as the number of whole-number (integer) beat values (as indicated by the outCurrentBeat field) per minute.
///
/// Parameter `outCurrentTempo`: The current tempo
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/hostcallback_getbeatandtempo?language=objc)
pub type HostCallback_GetBeatAndTempo =
    Option<unsafe extern "C-unwind" fn(*mut c_void, *mut f64, *mut f64) -> OSStatus>;

/// Retrieve information about the musical time state of the host
///
/// If the host app has set this callback, then the audio unit can use this to obtain
/// information about the state of musical time in the host. The audio unit can call this
/// callback only from within the audio unit render call (otherwise the host is unable to
/// provide information accurately to the audio unit as the information obtained is relate to
/// the current AudioUnitRender call). If the host cannot provide the requested information, it
/// will return kAudioUnitErr_CannotDoInCurrentContext.
///
/// The AudioUnit can provide NULL for any of the requested parameters (except for
/// inHostUserData) if it is not interested in that particular piece of information
///
///
/// Parameter `inHostUserData`: Must be provided by the audio unit when it makes this call. It is the client data provided by the host when it set the HostCallbacks property
///
/// Parameter `outDeltaSampleOffsetToNextBeat`: The number of samples until the next whole beat from the start sample of the current rendering buffer
///
/// Parameter `outTimeSig_Numerator`: The Numerator of the current time signature
///
/// Parameter `outTimeSig_Denominator`: The Denominator of the current time signature (4 is a quarter note, etc)
///
/// Parameter `outCurrentMeasureDownBeat`: The beat that corresponds to the downbeat (first beat) of the current measure that is being rendered
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/hostcallback_getmusicaltimelocation?language=objc)
pub type HostCallback_GetMusicalTimeLocation = Option<
    unsafe extern "C-unwind" fn(*mut c_void, *mut u32, *mut f32, *mut u32, *mut f64) -> OSStatus,
>;

/// Retrieve information about the time line's (or transport) state of the host.
///
/// If the host app has set this callback, then the audio unit can use this to obtain
/// information about the transport state of the host's time line. The audio unit can call this
/// callback only from within the audio unit render call (otherwise the host is unable to
/// provide information accurately to the audio unit as the information obtained is relate to
/// the current AudioUnitRender call. If the host cannot provide the requested information, it
/// will return kAudioUnitErr_CannotDoInCurrentContext.
///
/// The AudioUnit can provide NULL for any of the requested parameters (except for
/// inHostUserData) if it is not interested in that particular piece of information
///
///
/// Parameter `inHostUserData`: Must be provided by the audio unit when it makes this call. It is the client data provided by the host when it set the HostCallbacks property
///
/// Parameter `outIsPlaying`: Returns true if the host's transport is currently playing, false if stopped
///
/// Parameter `outTransportStateChanged`: Returns true if there was a change to the state of, or discontinuities in, the host's transport (generally since the callback was last called). Can indicate such state changes as start/top, time moves (jump from one time line to another).
///
/// Parameter `outCurrentSampleInTimeLine`: Returns the current sample count in the time line of the host's transport time.
///
/// Parameter `outIsCycling`: Returns true if the host's transport is currently cycling or looping
///
/// Parameter `outCycleStartBeat`: If cycling is true, the start beat of the cycle or loop point in the host's transport
///
/// Parameter `outCycleEndBeat`: If cycling is true, the end beat of the cycle or loop point in the host's transport
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/hostcallback_gettransportstate?language=objc)
pub type HostCallback_GetTransportState = Option<
    unsafe extern "C-unwind" fn(
        *mut c_void,
        *mut Boolean,
        *mut Boolean,
        *mut f64,
        *mut Boolean,
        *mut f64,
        *mut f64,
    ) -> OSStatus,
>;

/// Retrieve information about the time line's (or transport) state of the host.
///
/// If the host app has set this callback, then the audio unit can use this to obtain
/// information about the transport state of the host's time line. The audio unit can call this
/// callback only from within the audio unit render call (otherwise the host is unable to
/// provide information accurately to the audio unit as the information obtained is relate to
/// the current AudioUnitRender call. If the host cannot provide the requested information, it
/// will return kAudioUnitErr_CannotDoInCurrentContext.
///
/// The AudioUnit can provide NULL for any of the requested parameters (except for
/// inHostUserData) if it is not interested in that particular piece of information
///
///
/// Parameter `inHostUserData`: Must be provided by the audio unit when it makes this call. It is the client data provided by the host when it set the HostCallbacks property
///
/// Parameter `outIsPlaying`: Returns true if the host's transport is currently playing, false if stopped
///
/// Parameter `outIsRecording`: Returns true if the host is currently record-enabled, otherwise false.
///
/// Parameter `outTransportStateChanged`: Returns true if there was a change to the state of, or discontinuities in, the host's transport (generally since the callback was last called). Can indicate such state changes as start/top, time moves (jump from one time line to another).
///
/// Parameter `outCurrentSampleInTimeLine`: Returns the current sample count in the time line of the host's transport time.
///
/// Parameter `outIsCycling`: Returns true if the host's transport is currently cycling or looping
///
/// Parameter `outCycleStartBeat`: If cycling is true, the start beat of the cycle or loop point in the host's transport
///
/// Parameter `outCycleEndBeat`: If cycling is true, the end beat of the cycle or loop point in the host's transport
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/hostcallback_gettransportstate2?language=objc)
pub type HostCallback_GetTransportState2 = Option<
    unsafe extern "C-unwind" fn(
        *mut c_void,
        *mut Boolean,
        *mut Boolean,
        *mut Boolean,
        *mut f64,
        *mut Boolean,
        *mut f64,
        *mut f64,
    ) -> OSStatus,
>;

/// Contains the various callbacks for an audio unit to call
///
/// Any callback can be NULL.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/hostcallbackinfo?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct HostCallbackInfo {
    pub hostUserData: *mut c_void,
    pub beatAndTempoProc: HostCallback_GetBeatAndTempo,
    pub musicalTimeLocationProc: HostCallback_GetMusicalTimeLocation,
    pub transportStateProc: HostCallback_GetTransportState,
    pub transportStateProc2: HostCallback_GetTransportState2,
}

unsafe impl Encode for HostCallbackInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "HostCallbackInfo",
        &[
            <*mut c_void>::ENCODING,
            <HostCallback_GetBeatAndTempo>::ENCODING,
            <HostCallback_GetMusicalTimeLocation>::ENCODING,
            <HostCallback_GetTransportState>::ENCODING,
            <HostCallback_GetTransportState2>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for HostCallbackInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Used to represent a dependent parameter that can change as a result of its parent meta-parameter
/// changing
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audependentparameter?language=objc)
#[cfg(feature = "AUComponent")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUDependentParameter {
    pub mScope: AudioUnitScope,
    pub mParameterID: AudioUnitParameterID,
}

#[cfg(feature = "AUComponent")]
unsafe impl Encode for AUDependentParameter {
    const ENCODING: Encoding = Encoding::Struct(
        "AUDependentParameter",
        &[<AudioUnitScope>::ENCODING, <AudioUnitParameterID>::ENCODING],
    );
}

#[cfg(feature = "AUComponent")]
unsafe impl RefEncode for AUDependentParameter {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The location and class name of one or more view factory objects an Audio Unit publishes
///
/// Contains the location of the bundle which the host app can then use to locate the bundle
///
/// Contains the names of the classes that implements the required protocol (AUCocoaUIBase). This class is a view factory that creates the NSView object that is the AudioUnit view.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitcocoaviewinfo?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitCocoaViewInfo {
    pub mCocoaAUViewBundleLocation: NonNull<CFURL>,
    pub mCocoaAUViewClass: [NonNull<CFString>; 1],
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AudioUnitCocoaViewInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitCocoaViewInfo",
        &[
            <NonNull<CFURL>>::ENCODING,
            <[NonNull<CFString>; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AudioUnitCocoaViewInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Used to describe the name and version of the audio unit's host
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auhostversionidentifier?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUHostVersionIdentifier {
    pub hostName: NonNull<CFString>,
    pub hostVersion: u32,
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AUHostVersionIdentifier {
    const ENCODING: Encoding = Encoding::Struct(
        "AUHostVersionIdentifier",
        &[<NonNull<CFString>>::ENCODING, <u32>::ENCODING],
    );
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AUHostVersionIdentifier {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/aumidioutputcallback?language=objc)
#[cfg(all(feature = "objc2-core-audio-types", feature = "objc2-core-midi"))]
pub type AUMIDIOutputCallback = Option<
    unsafe extern "C-unwind" fn(
        *mut c_void,
        NonNull<AudioTimeStamp>,
        u32,
        NonNull<MIDIPacketList>,
    ) -> OSStatus,
>;

/// Set by host application to provide the callback and user data for an audio
/// unit that provides MIDI output
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/aumidioutputcallbackstruct?language=objc)
#[cfg(all(feature = "objc2-core-audio-types", feature = "objc2-core-midi"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUMIDIOutputCallbackStruct {
    pub midiOutputCallback: AUMIDIOutputCallback,
    pub userData: *mut c_void,
}

#[cfg(all(feature = "objc2-core-audio-types", feature = "objc2-core-midi"))]
unsafe impl Encode for AUMIDIOutputCallbackStruct {
    const ENCODING: Encoding = Encoding::Struct(
        "AUMIDIOutputCallbackStruct",
        &[<AUMIDIOutputCallback>::ENCODING, <*mut c_void>::ENCODING],
    );
}

#[cfg(all(feature = "objc2-core-audio-types", feature = "objc2-core-midi"))]
unsafe impl RefEncode for AUMIDIOutputCallbackStruct {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Used by a host when registering a callback with an audio unit, to provide
/// input-to-output samples mapping
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auinputsamplesinoutputcallbackstruct?language=objc)
#[cfg(all(feature = "AUComponent", feature = "objc2-core-audio-types"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUInputSamplesInOutputCallbackStruct {
    pub inputToOutputCallback: AUInputSamplesInOutputCallback,
    pub userData: *mut c_void,
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-audio-types"))]
unsafe impl Encode for AUInputSamplesInOutputCallbackStruct {
    const ENCODING: Encoding = Encoding::Struct(
        "AUInputSamplesInOutputCallbackStruct",
        &[
            <AUInputSamplesInOutputCallback>::ENCODING,
            <*mut c_void>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-audio-types"))]
unsafe impl RefEncode for AUInputSamplesInOutputCallbackStruct {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// This structure contains the suggested update rate and history duration for parameters which have the kAudioUnitParameterFlag_PlotHistory flag set.
/// The structure is filled out by getting kAudioUnitProperty_ParameterHistoryInfo.
///
/// This is the number of times per second that it is suggested that the host get the value of this parameter.
///
/// This is the duration in seconds of history that should be plotted.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitparameterhistoryinfo?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitParameterHistoryInfo {
    pub updatesPerSecond: f32,
    pub historyDurationInSeconds: f32,
}

unsafe impl Encode for AudioUnitParameterHistoryInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitParameterHistoryInfo",
        &[<f32>::ENCODING, <f32>::ENCODING],
    );
}

unsafe impl RefEncode for AudioUnitParameterHistoryInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Expresses time as a sample count.
///
/// Sample times are normally positive, but hosts can propagate HAL sample times through audio
/// units, and HAL sample times can be small negative numbers.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/aueventsampletime?language=objc)
pub type AUEventSampleTime = i64;

/// untyped value generally between 0.0 and 1.0
///
/// takes an integer value (good for menu selections)
///
/// 0.0 means FALSE, non-zero means TRUE
///
/// usually from 0 -> 100, sometimes -50 -> +50
///
/// absolute or relative time
///
/// one sample frame equals (1.0/sampleRate) seconds
///
/// -180 to 180 degrees
///
/// rate multiplier, for playback speed, etc. (e.g. 2.0 == twice as fast)
///
/// absolute frequency/pitch in cycles/second
///
/// unit of relative pitch
///
/// useful for coarse detuning
///
/// absolute pitch as defined in the MIDI spec (exact freq may depend on tuning table)
///
/// a generic MIDI controller value from 0 -> 127
///
/// logarithmic relative gain
///
/// linear relative gain
///
/// -180 to 180 degrees, similar to phase but more general (good for 3D coord system)
///
/// 0 -> 100, crossfade mix two sources according to sqrt(x) and sqrt(1.0 - x)
///
/// 0.0 -> 1.0, pow(x, 3.0) -> linear gain to simulate a reasonable mixer channel fader response
///
/// standard left to right mixer pan
///
/// distance measured in meters
///
/// absolute frequency measurement :
/// if f is freq in hertz then absoluteCents = 1200 * log2(f / 440) + 6900
///
/// octaves in relative pitch where a value of 1 is equal to 1200 cents
///
/// beats per minute, ie tempo
///
/// time relative to tempo, i.e., 1.0 at 120 BPM would equal 1/2 a second
///
/// parameter is expressed in milliseconds
///
/// for compression, expansion ratio, etc.
///
/// this is the parameter unit type for parameters that present a custom unit name
///
/// a generic MIDI 2.0 controller value with 32-bit range
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitparameterunit?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioUnitParameterUnit(pub u32);
impl AudioUnitParameterUnit {
    #[doc(alias = "kAudioUnitParameterUnit_Generic")]
    pub const Generic: Self = Self(0);
    #[doc(alias = "kAudioUnitParameterUnit_Indexed")]
    pub const Indexed: Self = Self(1);
    #[doc(alias = "kAudioUnitParameterUnit_Boolean")]
    pub const Boolean: Self = Self(2);
    #[doc(alias = "kAudioUnitParameterUnit_Percent")]
    pub const Percent: Self = Self(3);
    #[doc(alias = "kAudioUnitParameterUnit_Seconds")]
    pub const Seconds: Self = Self(4);
    #[doc(alias = "kAudioUnitParameterUnit_SampleFrames")]
    pub const SampleFrames: Self = Self(5);
    #[doc(alias = "kAudioUnitParameterUnit_Phase")]
    pub const Phase: Self = Self(6);
    #[doc(alias = "kAudioUnitParameterUnit_Rate")]
    pub const Rate: Self = Self(7);
    #[doc(alias = "kAudioUnitParameterUnit_Hertz")]
    pub const Hertz: Self = Self(8);
    #[doc(alias = "kAudioUnitParameterUnit_Cents")]
    pub const Cents: Self = Self(9);
    #[doc(alias = "kAudioUnitParameterUnit_RelativeSemiTones")]
    pub const RelativeSemiTones: Self = Self(10);
    #[doc(alias = "kAudioUnitParameterUnit_MIDINoteNumber")]
    pub const MIDINoteNumber: Self = Self(11);
    #[doc(alias = "kAudioUnitParameterUnit_MIDIController")]
    pub const MIDIController: Self = Self(12);
    #[doc(alias = "kAudioUnitParameterUnit_Decibels")]
    pub const Decibels: Self = Self(13);
    #[doc(alias = "kAudioUnitParameterUnit_LinearGain")]
    pub const LinearGain: Self = Self(14);
    #[doc(alias = "kAudioUnitParameterUnit_Degrees")]
    pub const Degrees: Self = Self(15);
    #[doc(alias = "kAudioUnitParameterUnit_EqualPowerCrossfade")]
    pub const EqualPowerCrossfade: Self = Self(16);
    #[doc(alias = "kAudioUnitParameterUnit_MixerFaderCurve1")]
    pub const MixerFaderCurve1: Self = Self(17);
    #[doc(alias = "kAudioUnitParameterUnit_Pan")]
    pub const Pan: Self = Self(18);
    #[doc(alias = "kAudioUnitParameterUnit_Meters")]
    pub const Meters: Self = Self(19);
    #[doc(alias = "kAudioUnitParameterUnit_AbsoluteCents")]
    pub const AbsoluteCents: Self = Self(20);
    #[doc(alias = "kAudioUnitParameterUnit_Octaves")]
    pub const Octaves: Self = Self(21);
    #[doc(alias = "kAudioUnitParameterUnit_BPM")]
    pub const BPM: Self = Self(22);
    #[doc(alias = "kAudioUnitParameterUnit_Beats")]
    pub const Beats: Self = Self(23);
    #[doc(alias = "kAudioUnitParameterUnit_Milliseconds")]
    pub const Milliseconds: Self = Self(24);
    #[doc(alias = "kAudioUnitParameterUnit_Ratio")]
    pub const Ratio: Self = Self(25);
    #[doc(alias = "kAudioUnitParameterUnit_CustomUnit")]
    pub const CustomUnit: Self = Self(26);
    #[doc(alias = "kAudioUnitParameterUnit_MIDI2Controller")]
    pub const MIDI2Controller: Self = Self(27);
}

unsafe impl Encode for AudioUnitParameterUnit {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioUnitParameterUnit {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Bit positions 18, 17, and 16 are set aside for display scales. Bit 19 is reserved.
///
///
///
///
///
///
///
///
///
///
///
///
///
/// This flag provides a hint to a host that this parameter should be controlled through the
/// highest resolution if the host has limitations on the control resolution of parameter
/// values. Generally this means that controlling this parameter with a single MIDI Control
/// message (i.e. 128 values) is too course a grain for that parameter, and a finer control
/// resolution should be used if possible. If this flag is not set, then a host can assume that
/// a 7-bit control quantization is acceptable. Ideally, parameters should be controlled in the
/// fullest resolution that they are published with.
///
/// Changing the parameter in real-time will cause a glitch or otherwise undesirable effect.
///
/// If set, the parameter can be ramped.
///
/// If set, the parameter is obscure (hint to UI to only display in expert mode).
///
/// In the original ParameterInfo a C string only was specified. With MacOS 10.2 and later, the
/// last four bytes of this string are reserved for a CFStringRef, which gives the ability to
/// used Unicode encoding, necessary for providing a name in languages using non-ASCII
/// characters. If this flag bit is set, the CFStringRef is valid.
///
/// If set, changing this parameter may change any number of others in the AudioUnit.
///
/// If set, changing this parameter may change others in the same element as the current
/// parameter.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitparameteroptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioUnitParameterOptions(pub u32);
bitflags::bitflags! {
    impl AudioUnitParameterOptions: u32 {
        #[doc(alias = "kAudioUnitParameterFlag_CFNameRelease")]
        const Flag_CFNameRelease = 1<<4;
        #[doc(alias = "kAudioUnitParameterFlag_OmitFromPresets")]
        const Flag_OmitFromPresets = 1<<13;
        #[doc(alias = "kAudioUnitParameterFlag_PlotHistory")]
        const Flag_PlotHistory = 1<<14;
        #[doc(alias = "kAudioUnitParameterFlag_MeterReadOnly")]
        const Flag_MeterReadOnly = 1<<15;
        #[doc(alias = "kAudioUnitParameterFlag_DisplayMask")]
        const Flag_DisplayMask = (7<<16)|(1<<22);
        #[doc(alias = "kAudioUnitParameterFlag_DisplaySquareRoot")]
        const Flag_DisplaySquareRoot = 1<<16;
        #[doc(alias = "kAudioUnitParameterFlag_DisplaySquared")]
        const Flag_DisplaySquared = 2<<16;
        #[doc(alias = "kAudioUnitParameterFlag_DisplayCubed")]
        const Flag_DisplayCubed = 3<<16;
        #[doc(alias = "kAudioUnitParameterFlag_DisplayCubeRoot")]
        const Flag_DisplayCubeRoot = 4<<16;
        #[doc(alias = "kAudioUnitParameterFlag_DisplayExponential")]
        const Flag_DisplayExponential = 5<<16;
        #[doc(alias = "kAudioUnitParameterFlag_HasClump")]
        const Flag_HasClump = 1<<20;
        #[doc(alias = "kAudioUnitParameterFlag_ValuesHaveStrings")]
        const Flag_ValuesHaveStrings = 1<<21;
        #[doc(alias = "kAudioUnitParameterFlag_DisplayLogarithmic")]
        const Flag_DisplayLogarithmic = 1<<22;
        #[doc(alias = "kAudioUnitParameterFlag_IsHighResolution")]
        const Flag_IsHighResolution = 1<<23;
        #[doc(alias = "kAudioUnitParameterFlag_NonRealTime")]
        const Flag_NonRealTime = 1<<24;
        #[doc(alias = "kAudioUnitParameterFlag_CanRamp")]
        const Flag_CanRamp = 1<<25;
        #[doc(alias = "kAudioUnitParameterFlag_ExpertMode")]
        const Flag_ExpertMode = 1<<26;
        #[doc(alias = "kAudioUnitParameterFlag_HasCFNameString")]
        const Flag_HasCFNameString = 1<<27;
        #[doc(alias = "kAudioUnitParameterFlag_IsGlobalMeta")]
        const Flag_IsGlobalMeta = 1<<28;
        #[doc(alias = "kAudioUnitParameterFlag_IsElementMeta")]
        const Flag_IsElementMeta = 1<<29;
        #[doc(alias = "kAudioUnitParameterFlag_IsReadable")]
        const Flag_IsReadable = 1<<30;
        #[doc(alias = "kAudioUnitParameterFlag_IsWritable")]
        const Flag_IsWritable = 1<<31;
    }
}

unsafe impl Encode for AudioUnitParameterOptions {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioUnitParameterOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// UNUSED - set to zero - UTF8 encoded C string (originally).
///
/// Only valid if the unit field equals kAudioUnitParameterUnit_CustomUnit, in
/// which case, unitName must contain a valid CFStringRef. As with cfNameString,
/// if (flags
/// &
/// kAudioUnitParameterFlag_CFNameRelease) is non-zero, the
/// AudioUnit must return a +1 reference to this string, and the host must
/// release it.
///
/// Only valid if kAudioUnitParameterFlag_HasClump is set.
///
/// Only valid if kAudioUnitParameterFlag_HasCFNameString is set.
///
/// If the "unit" field contains a value not in the enum above, then assume
/// kAudioUnitParameterUnit_Generic
///
/// The parameter's minimum value.
///
/// The parameter's maximum value.
///
/// The parameter's default value.
///
/// Due to some vagaries about the ways in which Parameter's CFNames have been
/// described, it was necessary to add a flag:
/// kAudioUnitParameterFlag_CFNameRelease. In normal usage a parameter name is
/// essentially a static object, but sometimes an audio unit will generate
/// parameter names dynamically.. As these are expected to be CFStrings, in that
/// case the host should release those names when it is finished with them, but
/// there was no way to communicate this distinction in behavior. Thus, if an
/// audio unit will (or could) generate a name dynamically, it should set this
/// flag in the parameter's info. The host should check for this flag, and if
/// present, release the parameter name when it is finished with it.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitparameterinfo?language=objc)
#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitParameterInfo {
    pub name: [c_char; 52],
    pub unitName: *const CFString,
    pub clumpID: u32,
    pub cfNameString: *const CFString,
    pub unit: AudioUnitParameterUnit,
    pub minValue: AudioUnitParameterValue,
    pub maxValue: AudioUnitParameterValue,
    pub defaultValue: AudioUnitParameterValue,
    pub flags: AudioUnitParameterOptions,
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl Encode for AudioUnitParameterInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitParameterInfo",
        &[
            <[c_char; 52]>::ENCODING,
            <*const CFString>::ENCODING,
            <u32>::ENCODING,
            <*const CFString>::ENCODING,
            <AudioUnitParameterUnit>::ENCODING,
            <AudioUnitParameterValue>::ENCODING,
            <AudioUnitParameterValue>::ENCODING,
            <AudioUnitParameterValue>::ENCODING,
            <AudioUnitParameterOptions>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl RefEncode for AudioUnitParameterInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitclumpid_system?language=objc)
pub const kAudioUnitClumpID_System: c_uint = 0;

// TODO: pub fn GetAudioUnitParameterDisplayType(flags: AudioUnitParameterOptions,) -> AudioUnitParameterOptions;

// TODO: pub fn SetAudioUnitParameterDisplayType(flags: AudioUnitParameterOptions,display_type: AudioUnitParameterOptions,) -> AudioUnitParameterOptions;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitparametername_full?language=objc)
pub const kAudioUnitParameterName_Full: c_int = -1;

/// Used to provide shorter names for a specified parameter
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitparameternameinfo?language=objc)
#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitParameterNameInfo {
    pub inID: AudioUnitParameterID,
    pub inDesiredLength: i32,
    pub outName: *const CFString,
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl Encode for AudioUnitParameterNameInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitParameterNameInfo",
        &[
            <AudioUnitParameterID>::ENCODING,
            <i32>::ENCODING,
            <*const CFString>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl RefEncode for AudioUnitParameterNameInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitparameteridname?language=objc)
#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
pub type AudioUnitParameterIDName = AudioUnitParameterNameInfo;

/// Provide a string representation of a parameter's value
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitparameterstringfromvalue?language=objc)
#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitParameterStringFromValue {
    pub inParamID: AudioUnitParameterID,
    pub inValue: NonNull<AudioUnitParameterValue>,
    pub outString: *const CFString,
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl Encode for AudioUnitParameterStringFromValue {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitParameterStringFromValue",
        &[
            <AudioUnitParameterID>::ENCODING,
            <NonNull<AudioUnitParameterValue>>::ENCODING,
            <*const CFString>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl RefEncode for AudioUnitParameterStringFromValue {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Provide the parameter's value for a given string representation of it
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitparametervaluefromstring?language=objc)
#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitParameterValueFromString {
    pub inParamID: AudioUnitParameterID,
    pub inString: NonNull<CFString>,
    pub outValue: AudioUnitParameterValue,
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl Encode for AudioUnitParameterValueFromString {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitParameterValueFromString",
        &[
            <AudioUnitParameterID>::ENCODING,
            <NonNull<CFString>>::ENCODING,
            <AudioUnitParameterValue>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl RefEncode for AudioUnitParameterValueFromString {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// In inter-app audio, messages to control the host's transport state.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitremotecontrolevent?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioUnitRemoteControlEvent(pub u32);
impl AudioUnitRemoteControlEvent {
    #[doc(alias = "kAudioUnitRemoteControlEvent_TogglePlayPause")]
    pub const TogglePlayPause: Self = Self(1);
    #[doc(alias = "kAudioUnitRemoteControlEvent_ToggleRecord")]
    pub const ToggleRecord: Self = Self(2);
    #[doc(alias = "kAudioUnitRemoteControlEvent_Rewind")]
    pub const Rewind: Self = Self(3);
}

unsafe impl Encode for AudioUnitRemoteControlEvent {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioUnitRemoteControlEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Block called to receive a remote control event.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitremotecontroleventlistener?language=objc)
#[cfg(feature = "block2")]
pub type AudioUnitRemoteControlEventListener =
    *mut block2::DynBlock<dyn Fn(AudioUnitRemoteControlEvent)>;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_allparametermidimappings?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_AllParameterMIDIMappings: AudioUnitPropertyID = 41;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_addparametermidimapping?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_AddParameterMIDIMapping: AudioUnitPropertyID = 42;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_removeparametermidimapping?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_RemoveParameterMIDIMapping: AudioUnitPropertyID = 43;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_hotmapparametermidimapping?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_HotMapParameterMIDIMapping: AudioUnitPropertyID = 44;

/// General defined values to customize the behavior of parameter-to-MIDI mappings
///
///
///
/// If this flag is set and the value of the mStatus field is a MIDI channel message, then
/// the MIDI channel number in the status byte is ignored; the mapping is from the specified
/// MIDI message on any channel.
///
///
///
/// If this flag is set and the value of the mStatus field is a Note On, Note Off, or
/// Polyphonic Pressure message, the message's note number is ignored. The mapping is from
/// any note number.
///
///
///
/// Set this flag if the MIDI control should map only to a sub-range of the parameter's value.
/// Then specify that range in the mSubRangeMin and mSubRangeMax member fields.
///
///
///
/// Intended for Boolean typed parameters. When this property is set, it means that the
/// parameter's value should be toggled when the mapped MIDI message is received. For example,
/// if the parameter's value is currently TRUE, when the mapped MIDI message is received
/// the value changes to FALSE.
///
///
///
/// This property is useful when mapping a parameter to a MIDI Controller. When set, it
/// indicates that the parameter can assume only two values: on or off. For this reason, a
/// parameter associated with this property is typically Boolean. For example, if this
/// property is set for a parameter mapped to a sustain pedal MIDI controller, controller
/// values from 0 to 64 result in the parameter switched to its "off" state; controller
/// values from 65 to 127 result in the parameter switched to its "on" state.
///
/// This property works in connection with the kAUParameterMIDIMapping_Bipolar_On property.
/// The value of the kAUParameterMIDIMapping_Bipolar_On property
///
///
///
/// Determines whether the  "on" state of a parameter is mapped to the "on" or "off" state
/// of the associated MIDI controller. Only valid  if the  kAUParameterMIDIMapping_Bipolar
/// property is set.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auparametermidimappingflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUParameterMIDIMappingFlags(pub u32);
bitflags::bitflags! {
    impl AUParameterMIDIMappingFlags: u32 {
        #[doc(alias = "kAUParameterMIDIMapping_AnyChannelFlag")]
        const AnyChannelFlag = 1<<0;
        #[doc(alias = "kAUParameterMIDIMapping_AnyNoteFlag")]
        const AnyNoteFlag = 1<<1;
        #[doc(alias = "kAUParameterMIDIMapping_SubRange")]
        const SubRange = 1<<2;
        #[doc(alias = "kAUParameterMIDIMapping_Toggle")]
        const Toggle = 1<<3;
        #[doc(alias = "kAUParameterMIDIMapping_Bipolar")]
        const Bipolar = 1<<4;
        #[doc(alias = "kAUParameterMIDIMapping_Bipolar_On")]
        const Bipolar_On = 1<<5;
    }
}

unsafe impl Encode for AUParameterMIDIMappingFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUParameterMIDIMappingFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Represents a mapping between a MIDI message and an audio unit's parameter.
///
/// The reserved fields in this structure are for future use. In the current implementation,
/// they help align the structure to 64 bit size. Do not use the names of these fields in a
/// host application. They are subject to change.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auparametermidimapping?language=objc)
#[cfg(feature = "AUComponent")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUParameterMIDIMapping {
    pub mScope: AudioUnitScope,
    pub mElement: AudioUnitElement,
    pub mParameterID: AudioUnitParameterID,
    pub mFlags: AUParameterMIDIMappingFlags,
    pub mSubRangeMin: AudioUnitParameterValue,
    pub mSubRangeMax: AudioUnitParameterValue,
    pub mStatus: u8,
    pub mData1: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub reserved3: u32,
}

#[cfg(feature = "AUComponent")]
unsafe impl Encode for AUParameterMIDIMapping {
    const ENCODING: Encoding = Encoding::Struct(
        "AUParameterMIDIMapping",
        &[
            <AudioUnitScope>::ENCODING,
            <AudioUnitElement>::ENCODING,
            <AudioUnitParameterID>::ENCODING,
            <AUParameterMIDIMappingFlags>::ENCODING,
            <AudioUnitParameterValue>::ENCODING,
            <AudioUnitParameterValue>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "AUComponent")]
unsafe impl RefEncode for AUParameterMIDIMapping {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_midixmlnames?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_MIDIXMLNames: AudioUnitPropertyID = 1006;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_partgroup?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_PartGroup: AudioUnitPropertyID = 1010;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_dualschedulingmode?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_DualSchedulingMode: AudioUnitPropertyID = 1013;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_supportsstartstopnote?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_SupportsStartStopNote: AudioUnitPropertyID = 1014;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdevicesampleframemask_sampleoffset?language=objc)
pub const kMusicDeviceSampleFrameMask_SampleOffset: c_uint = 0xFFFFFF;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdevicesampleframemask_isscheduled?language=objc)
pub const kMusicDeviceSampleFrameMask_IsScheduled: c_uint = 0x01000000;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitofflineproperty_inputsize?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitOfflineProperty_InputSize: AudioUnitPropertyID = 3020;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitofflineproperty_outputsize?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitOfflineProperty_OutputSize: AudioUnitPropertyID = 3021;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitofflineproperty_startoffset?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitOfflineProperty_StartOffset: AudioUnitPropertyID = 3022;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitofflineproperty_preflightrequirements?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitOfflineProperty_PreflightRequirements: AudioUnitPropertyID = 3023;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitofflineproperty_preflightname?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitOfflineProperty_PreflightName: AudioUnitPropertyID = 3024;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kofflinepreflight_notrequired?language=objc)
pub const kOfflinePreflight_NotRequired: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kofflinepreflight_optional?language=objc)
pub const kOfflinePreflight_Optional: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kofflinepreflight_required?language=objc)
pub const kOfflinePreflight_Required: c_uint = 2;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_distanceattenuationdata?language=objc)
#[cfg(feature = "AUComponent")]
#[deprecated = "no longer supported"]
pub const kAudioUnitProperty_DistanceAttenuationData: AudioUnitPropertyID = 3600;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitmigrateproperty_fromplugin?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitMigrateProperty_FromPlugin: AudioUnitPropertyID = 4000;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitmigrateproperty_oldautomation?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitMigrateProperty_OldAutomation: AudioUnitPropertyID = 4001;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kotherpluginformat_undefined?language=objc)
pub const kOtherPluginFormat_Undefined: u32 = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kotherpluginformat_kmas?language=objc)
pub const kOtherPluginFormat_kMAS: u32 = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kotherpluginformat_kvst?language=objc)
pub const kOtherPluginFormat_kVST: u32 = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kotherpluginformat_au?language=objc)
pub const kOtherPluginFormat_AU: u32 = 3;

/// One of the OtherPluginFormat values
///
///
/// struct AudioClassDescription {
/// OSType mType;
/// OSType mSubType;
/// OSType mManufacturer;
/// };
/// is defined in
/// <CoreAudioTypes
/// /CoreAudioTypes.h>
///
/// mType specifies a generic, plug-in format defined descriptor
/// mSubType is usually left to the manufacturer to use at their discretion
/// mManufacturer is a registered code to identify all plugins from the same manufacturer
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitotherplugindesc?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitOtherPluginDesc {
    pub format: u32,
    pub plugin: AudioClassDescription,
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl Encode for AudioUnitOtherPluginDesc {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitOtherPluginDesc",
        &[<u32>::ENCODING, <AudioClassDescription>::ENCODING],
    );
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl RefEncode for AudioUnitOtherPluginDesc {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Used to translate another plug-in's parameter values to  audio unit parameter
/// values
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitparametervaluetranslation?language=objc)
#[cfg(all(feature = "AUComponent", feature = "objc2-core-audio-types"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitParameterValueTranslation {
    pub otherDesc: AudioUnitOtherPluginDesc,
    pub otherParamID: u32,
    pub otherValue: f32,
    pub auParamID: AudioUnitParameterID,
    pub auValue: AudioUnitParameterValue,
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-audio-types"))]
unsafe impl Encode for AudioUnitParameterValueTranslation {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitParameterValueTranslation",
        &[
            <AudioUnitOtherPluginDesc>::ENCODING,
            <u32>::ENCODING,
            <f32>::ENCODING,
            <AudioUnitParameterID>::ENCODING,
            <AudioUnitParameterValue>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-audio-types"))]
unsafe impl RefEncode for AudioUnitParameterValueTranslation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// AU-MAS specific structs for the data contained in the "masdata" key of an audio
/// unit preset dictionary
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitpresetmas_settingdata?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitPresetMAS_SettingData {
    pub isStockSetting: u32,
    pub settingID: u32,
    pub dataLen: u32,
    pub data: [u8; 1],
}

unsafe impl Encode for AudioUnitPresetMAS_SettingData {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitPresetMAS_SettingData",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <[u8; 1]>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for AudioUnitPresetMAS_SettingData {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// See MAS documentation
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitpresetmas_settings?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitPresetMAS_Settings {
    pub manufacturerID: u32,
    pub effectID: u32,
    pub variantID: u32,
    pub settingsVersion: u32,
    pub numberOfSettings: u32,
    pub settings: [AudioUnitPresetMAS_SettingData; 1],
}

unsafe impl Encode for AudioUnitPresetMAS_Settings {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitPresetMAS_Settings",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <[AudioUnitPresetMAS_SettingData; 1]>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for AudioUnitPresetMAS_Settings {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_samplerateconvertercomplexity?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SampleRateConverterComplexity: AudioUnitPropertyID = 3014;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitsamplerateconvertercomplexity_linear?language=objc)
pub const kAudioUnitSampleRateConverterComplexity_Linear: u32 = 0x6c696e65;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitsamplerateconvertercomplexity_normal?language=objc)
pub const kAudioUnitSampleRateConverterComplexity_Normal: u32 = 0x6e6f726d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitsamplerateconvertercomplexity_mastering?language=objc)
pub const kAudioUnitSampleRateConverterComplexity_Mastering: u32 = 0x62617473;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_currentdevice?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_CurrentDevice: AudioUnitPropertyID = 2000;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_isrunning?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_IsRunning: AudioUnitPropertyID = 2001;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_channelmap?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_ChannelMap: AudioUnitPropertyID = 2002;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_enableio?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_EnableIO: AudioUnitPropertyID = 2003;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_starttime?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_StartTime: AudioUnitPropertyID = 2004;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_setinputcallback?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_SetInputCallback: AudioUnitPropertyID = 2005;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_hasio?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_HasIO: AudioUnitPropertyID = 2006;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_starttimestampsatzero?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_StartTimestampsAtZero: AudioUnitPropertyID = 2007;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_osworkgroup?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_OSWorkgroup: AudioUnitPropertyID = 2015;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_midicallbacks?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_MIDICallbacks: AudioUnitPropertyID = 2010;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_hostreceivesremotecontrolevents?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_HostReceivesRemoteControlEvents: AudioUnitPropertyID = 2011;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_remotecontroltohost?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_RemoteControlToHost: AudioUnitPropertyID = 2012;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_hosttransportstate?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_HostTransportState: AudioUnitPropertyID = 2013;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiooutputunitproperty_nodecomponentdescription?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOutputUnitProperty_NodeComponentDescription: AudioUnitPropertyID = 2014;

/// For inter-app audio, callbacks for receiving MIDI messages.
///
/// The supplied callback functions are called from the realtime rendering thread, before each
/// render cycle, to provide any incoming MIDI messages.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiooutputunitmidicallbacks?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioOutputUnitMIDICallbacks {
    pub userData: *mut c_void,
    pub MIDIEventProc: unsafe extern "C-unwind" fn(*mut c_void, u32, u32, u32, u32),
    pub MIDISysExProc: unsafe extern "C-unwind" fn(*mut c_void, NonNull<u8>, u32),
}

unsafe impl Encode for AudioOutputUnitMIDICallbacks {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioOutputUnitMIDICallbacks",
        &[
            <*mut c_void>::ENCODING,
            <unsafe extern "C-unwind" fn(*mut c_void, u32, u32, u32, u32)>::ENCODING,
            <unsafe extern "C-unwind" fn(*mut c_void, NonNull<u8>, u32)>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for AudioOutputUnitMIDICallbacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiooutputunitstartattimeparams?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioOutputUnitStartAtTimeParams {
    pub mTimestamp: AudioTimeStamp,
    pub mFlags: u32,
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl Encode for AudioOutputUnitStartAtTimeParams {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioOutputUnitStartAtTimeParams",
        &[<AudioTimeStamp>::ENCODING, <u32>::ENCODING],
    );
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl RefEncode for AudioOutputUnitStartAtTimeParams {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kauvoiceioproperty_bypassvoiceprocessing?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUVoiceIOProperty_BypassVoiceProcessing: AudioUnitPropertyID = 2100;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kauvoiceioproperty_voiceprocessingenableagc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUVoiceIOProperty_VoiceProcessingEnableAGC: AudioUnitPropertyID = 2101;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kauvoiceioproperty_muteoutput?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUVoiceIOProperty_MuteOutput: AudioUnitPropertyID = 2104;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auvoiceiospeechactivityevent?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUVoiceIOSpeechActivityEvent(pub u32);
impl AUVoiceIOSpeechActivityEvent {
    #[doc(alias = "kAUVoiceIOSpeechActivityHasStarted")]
    pub const HasStarted: Self = Self(0);
    #[doc(alias = "kAUVoiceIOSpeechActivityHasEnded")]
    pub const HasEnded: Self = Self(1);
}

unsafe impl Encode for AUVoiceIOSpeechActivityEvent {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUVoiceIOSpeechActivityEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Block called to receive speech activity event while the client is muted.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auvoiceiomutedspeechactivityeventlistener?language=objc)
#[cfg(feature = "block2")]
pub type AUVoiceIOMutedSpeechActivityEventListener =
    *mut block2::DynBlock<dyn Fn(AUVoiceIOSpeechActivityEvent)>;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kauvoiceioproperty_mutedspeechactivityeventlistener?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUVoiceIOProperty_MutedSpeechActivityEventListener: AudioUnitPropertyID = 2106;

/// Ducking level applied to other (i.e. non-voice) audio by AUVoiceIO.
///
/// DuckingLevelDefault = Default ducking level to other audio for typical voice chat.
/// DuckingLevelMin = minimum ducking to other audio.
/// DuckingLevelMid = medium ducking to other audio.
/// DuckingLevelMax = maximum ducking to other audio.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auvoiceiootheraudioduckinglevel?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUVoiceIOOtherAudioDuckingLevel(pub u32);
impl AUVoiceIOOtherAudioDuckingLevel {
    #[doc(alias = "kAUVoiceIOOtherAudioDuckingLevelDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "kAUVoiceIOOtherAudioDuckingLevelMin")]
    pub const Min: Self = Self(10);
    #[doc(alias = "kAUVoiceIOOtherAudioDuckingLevelMid")]
    pub const Mid: Self = Self(20);
    #[doc(alias = "kAUVoiceIOOtherAudioDuckingLevelMax")]
    pub const Max: Self = Self(30);
}

unsafe impl Encode for AUVoiceIOOtherAudioDuckingLevel {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUVoiceIOOtherAudioDuckingLevel {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The configuration of ducking other (i.e. non-voice) audio
///
///
/// Enables advanced ducking which ducks other audio based on the presence of voice activity from local and/or remote chat participants.
///
/// Ducking level of other audio
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auvoiceiootheraudioduckingconfiguration?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUVoiceIOOtherAudioDuckingConfiguration {
    pub mEnableAdvancedDucking: Boolean,
    pub mDuckingLevel: AUVoiceIOOtherAudioDuckingLevel,
}

unsafe impl Encode for AUVoiceIOOtherAudioDuckingConfiguration {
    const ENCODING: Encoding = Encoding::Struct(
        "AUVoiceIOOtherAudioDuckingConfiguration",
        &[
            <Boolean>::ENCODING,
            <AUVoiceIOOtherAudioDuckingLevel>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for AUVoiceIOOtherAudioDuckingConfiguration {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kauvoiceioproperty_otheraudioduckingconfiguration?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUVoiceIOProperty_OtherAudioDuckingConfiguration: AudioUnitPropertyID = 2108;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kauvoiceioproperty_voiceprocessingquality?language=objc)
#[cfg(feature = "AUComponent")]
#[deprecated]
pub const kAUVoiceIOProperty_VoiceProcessingQuality: AudioUnitPropertyID = 2103;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunbandeqproperty_numberofbands?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNBandEQProperty_NumberOfBands: AudioUnitPropertyID = 2200;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunbandeqproperty_maxnumberofbands?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNBandEQProperty_MaxNumberOfBands: AudioUnitPropertyID = 2201;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunbandeqproperty_biquadcoefficients?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNBandEQProperty_BiquadCoefficients: AudioUnitPropertyID = 2203;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kauvoiceioerr_unexpectednumberofinputchannels?language=objc)
pub const kAUVoiceIOErr_UnexpectedNumberOfInputChannels: OSStatus = -66784;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_meteringmode?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MeteringMode: AudioUnitPropertyID = 3007;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_matrixlevels?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MatrixLevels: AudioUnitPropertyID = 3006;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_matrixdimensions?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MatrixDimensions: AudioUnitPropertyID = 3009;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_meterclipping?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MeterClipping: AudioUnitPropertyID = 3011;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_inputanchortimestamp?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_InputAnchorTimeStamp: AudioUnitPropertyID = 3016;

/// The maximum value seen on the channel since the last time the property was retrieved.
///
/// TRUE if there was an infinite value on this channel.
///
/// TRUE if there was a floating point Not-A-Number value on this channel.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitmeterclipping?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitMeterClipping {
    pub peakValueSinceLastCall: f32,
    pub sawInfinity: Boolean,
    pub sawNotANumber: Boolean,
}

unsafe impl Encode for AudioUnitMeterClipping {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitMeterClipping",
        &[<f32>::ENCODING, <Boolean>::ENCODING, <Boolean>::ENCODING],
    );
}

unsafe impl RefEncode for AudioUnitMeterClipping {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_reverbroomtype?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ReverbRoomType: AudioUnitPropertyID = 10;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_usesinternalreverb?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_UsesInternalReverb: AudioUnitPropertyID = 1005;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_spatializationalgorithm?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpatializationAlgorithm: AudioUnitPropertyID = 3000;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_spatialmixerrenderingflags?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpatialMixerRenderingFlags: AudioUnitPropertyID = 3003;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_spatialmixersourcemode?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpatialMixerSourceMode: AudioUnitPropertyID = 3005;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_spatialmixerdistanceparams?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpatialMixerDistanceParams: AudioUnitPropertyID = 3010;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_spatialmixerattenuationcurve?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpatialMixerAttenuationCurve: AudioUnitPropertyID = 3013;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_spatialmixeroutputtype?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpatialMixerOutputType: AudioUnitPropertyID = 3100;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_spatialmixerpointsourceinheadmode?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpatialMixerPointSourceInHeadMode: AudioUnitPropertyID = 3103;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_spatialmixerenableheadtracking?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpatialMixerEnableHeadTracking: AudioUnitPropertyID = 3111;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_spatialmixerpersonalizedhrtfmode?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpatialMixerPersonalizedHRTFMode: AudioUnitPropertyID = 3113;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_spatialmixeranyinputisusingpersonalizedhrtf?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpatialMixerAnyInputIsUsingPersonalizedHRTF: AudioUnitPropertyID =
    3116;

/// Use kSpatializationAlgorithm_UseOutputType with appropriate kAudioUnitProperty_SpatialMixerOutputType
/// for highest-quality spatial rendering across different hardware.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auspatializationalgorithm?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUSpatializationAlgorithm(pub u32);
impl AUSpatializationAlgorithm {
    #[doc(alias = "kSpatializationAlgorithm_EqualPowerPanning")]
    pub const SpatializationAlgorithm_EqualPowerPanning: Self = Self(0);
    #[doc(alias = "kSpatializationAlgorithm_SphericalHead")]
    pub const SpatializationAlgorithm_SphericalHead: Self = Self(1);
    #[doc(alias = "kSpatializationAlgorithm_HRTF")]
    pub const SpatializationAlgorithm_HRTF: Self = Self(2);
    #[doc(alias = "kSpatializationAlgorithm_SoundField")]
    pub const SpatializationAlgorithm_SoundField: Self = Self(3);
    #[doc(alias = "kSpatializationAlgorithm_VectorBasedPanning")]
    pub const SpatializationAlgorithm_VectorBasedPanning: Self = Self(4);
    #[doc(alias = "kSpatializationAlgorithm_StereoPassThrough")]
    pub const SpatializationAlgorithm_StereoPassThrough: Self = Self(5);
    #[doc(alias = "kSpatializationAlgorithm_HRTFHQ")]
    pub const SpatializationAlgorithm_HRTFHQ: Self = Self(6);
    #[doc(alias = "kSpatializationAlgorithm_UseOutputType")]
    pub const SpatializationAlgorithm_UseOutputType: Self = Self(7);
}

unsafe impl Encode for AUSpatializationAlgorithm {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUSpatializationAlgorithm {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Mono input is spatialized using kAudioUnitProperty_SpatializationAlgorithm.
/// Any input with more than one channel is passed through without spatialization. This is
/// the default mode and corresponds to legacy behavior. The rendering is equivalent to
/// kSpatialMixerSourceMode_PointSource for mono input and
/// kSpatialMixerSourceMode_Bypass for input with more than one channel.
///
///
///
/// No spatial rendering. If input and output AudioChannelLayouts are equivalent, all
/// input channels are copied to corresponding output channels. If the input and
/// output AudioChannelLayouts differ, mixing is done according to the
/// kAudioFormatProperty_MatrixMixMap property of the layouts. No occlusion, obstruction,
/// or reverb is applied in this mode.
///
///
///
/// All channels of the input signal are rendered as a single source except if rendering
/// in-head with kSpatialMixerPointSourceInHeadMode_Bypass.
///
///
///
/// The input channels are spatialized around the listener as far-field sources.
/// The relative directions of the individual channels are specified by the
/// AudioChannelLayout of the bus. The rotation of the whole bed in the global space is
/// controlled by azimuth and elevation parameters.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auspatialmixersourcemode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUSpatialMixerSourceMode(pub u32);
impl AUSpatialMixerSourceMode {
    #[doc(alias = "kSpatialMixerSourceMode_SpatializeIfMono")]
    pub const SpatialMixerSourceMode_SpatializeIfMono: Self = Self(0);
    #[doc(alias = "kSpatialMixerSourceMode_Bypass")]
    pub const SpatialMixerSourceMode_Bypass: Self = Self(1);
    #[doc(alias = "kSpatialMixerSourceMode_PointSource")]
    pub const SpatialMixerSourceMode_PointSource: Self = Self(2);
    #[doc(alias = "kSpatialMixerSourceMode_AmbienceBed")]
    pub const SpatialMixerSourceMode_AmbienceBed: Self = Self(3);
}

unsafe impl Encode for AUSpatialMixerSourceMode {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUSpatialMixerSourceMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Used to specify room type (as identified by a factory preset number) on Apple audio
/// units that use internal reverb.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/aureverbroomtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUReverbRoomType(pub u32);
impl AUReverbRoomType {
    #[doc(alias = "kReverbRoomType_SmallRoom")]
    pub const ReverbRoomType_SmallRoom: Self = Self(0);
    #[doc(alias = "kReverbRoomType_MediumRoom")]
    pub const ReverbRoomType_MediumRoom: Self = Self(1);
    #[doc(alias = "kReverbRoomType_LargeRoom")]
    pub const ReverbRoomType_LargeRoom: Self = Self(2);
    #[doc(alias = "kReverbRoomType_MediumHall")]
    pub const ReverbRoomType_MediumHall: Self = Self(3);
    #[doc(alias = "kReverbRoomType_LargeHall")]
    pub const ReverbRoomType_LargeHall: Self = Self(4);
    #[doc(alias = "kReverbRoomType_Plate")]
    pub const ReverbRoomType_Plate: Self = Self(5);
    #[doc(alias = "kReverbRoomType_MediumChamber")]
    pub const ReverbRoomType_MediumChamber: Self = Self(6);
    #[doc(alias = "kReverbRoomType_LargeChamber")]
    pub const ReverbRoomType_LargeChamber: Self = Self(7);
    #[doc(alias = "kReverbRoomType_Cathedral")]
    pub const ReverbRoomType_Cathedral: Self = Self(8);
    #[doc(alias = "kReverbRoomType_LargeRoom2")]
    pub const ReverbRoomType_LargeRoom2: Self = Self(9);
    #[doc(alias = "kReverbRoomType_MediumHall2")]
    pub const ReverbRoomType_MediumHall2: Self = Self(10);
    #[doc(alias = "kReverbRoomType_MediumHall3")]
    pub const ReverbRoomType_MediumHall3: Self = Self(11);
    #[doc(alias = "kReverbRoomType_LargeHall2")]
    pub const ReverbRoomType_LargeHall2: Self = Self(12);
}

unsafe impl Encode for AUReverbRoomType {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUReverbRoomType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auspatialmixerattenuationcurve?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUSpatialMixerAttenuationCurve(pub u32);
impl AUSpatialMixerAttenuationCurve {
    #[doc(alias = "kSpatialMixerAttenuationCurve_Power")]
    pub const SpatialMixerAttenuationCurve_Power: Self = Self(0);
    #[doc(alias = "kSpatialMixerAttenuationCurve_Exponential")]
    pub const SpatialMixerAttenuationCurve_Exponential: Self = Self(1);
    #[doc(alias = "kSpatialMixerAttenuationCurve_Inverse")]
    pub const SpatialMixerAttenuationCurve_Inverse: Self = Self(2);
    #[doc(alias = "kSpatialMixerAttenuationCurve_Linear")]
    pub const SpatialMixerAttenuationCurve_Linear: Self = Self(3);
}

unsafe impl Encode for AUSpatialMixerAttenuationCurve {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUSpatialMixerAttenuationCurve {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/mixerdistanceparams?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MixerDistanceParams {
    pub mReferenceDistance: f32,
    pub mMaxDistance: f32,
    pub mMaxAttenuation: f32,
}

unsafe impl Encode for MixerDistanceParams {
    const ENCODING: Encoding = Encoding::Struct(
        "MixerDistanceParams",
        &[<f32>::ENCODING, <f32>::ENCODING, <f32>::ENCODING],
    );
}

unsafe impl RefEncode for MixerDistanceParams {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auspatialmixerrenderingflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUSpatialMixerRenderingFlags(pub u32);
bitflags::bitflags! {
    impl AUSpatialMixerRenderingFlags: u32 {
        #[doc(alias = "kSpatialMixerRenderingFlags_InterAuralDelay")]
        const SpatialMixerRenderingFlags_InterAuralDelay = 1<<0;
        #[doc(alias = "kSpatialMixerRenderingFlags_DistanceAttenuation")]
        const SpatialMixerRenderingFlags_DistanceAttenuation = 1<<2;
    }
}

unsafe impl Encode for AUSpatialMixerRenderingFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUSpatialMixerRenderingFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Use generic head-related transfer function (HRTF).
///
///
///
/// Use personalized head-related transfer function (HRTF), if available.
///
///
///
/// Follow system preferences to choose between personalized vs generic
/// head-related transfer function (HRTF).
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auspatialmixerpersonalizedhrtfmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUSpatialMixerPersonalizedHRTFMode(pub u32);
impl AUSpatialMixerPersonalizedHRTFMode {
    #[doc(alias = "kSpatialMixerPersonalizedHRTFMode_Off")]
    pub const SpatialMixerPersonalizedHRTFMode_Off: Self = Self(0);
    #[doc(alias = "kSpatialMixerPersonalizedHRTFMode_On")]
    pub const SpatialMixerPersonalizedHRTFMode_On: Self = Self(1);
    #[doc(alias = "kSpatialMixerPersonalizedHRTFMode_Auto")]
    pub const SpatialMixerPersonalizedHRTFMode_Auto: Self = Self(2);
}

unsafe impl Encode for AUSpatialMixerPersonalizedHRTFMode {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUSpatialMixerPersonalizedHRTFMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Render for headphones.
///
///
///
/// Render for built-in speakers. The spatialization is optimized for current hardware and
/// will not be suitable for playback on other hardware. On iOS devices, the rendering may
/// be specific to device orientation. Non-realtime rendering may not provide intended results
/// if the orientation changes between rendering the audio and playing it back.
///
///
///
/// Render for external speakers based on the mixer's output channel layout.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auspatialmixeroutputtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUSpatialMixerOutputType(pub u32);
impl AUSpatialMixerOutputType {
    #[doc(alias = "kSpatialMixerOutputType_Headphones")]
    pub const SpatialMixerOutputType_Headphones: Self = Self(1);
    #[doc(alias = "kSpatialMixerOutputType_BuiltInSpeakers")]
    pub const SpatialMixerOutputType_BuiltInSpeakers: Self = Self(2);
    #[doc(alias = "kSpatialMixerOutputType_ExternalSpeakers")]
    pub const SpatialMixerOutputType_ExternalSpeakers: Self = Self(3);
}

unsafe impl Encode for AUSpatialMixerOutputType {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUSpatialMixerOutputType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// This setting only affects spatialization when using kSpatializationAlgorithm_UseOutputType
/// with kSpatialMixerSourceMode_PointSource.
///
///
///
/// A point source remains a single mono source inside the listener's head regardless
/// of the channels it consists of.
///
///
///
/// A point source splits into bypass inside the listener's head. This enables transitions
/// between traditional, non-spatialized rendering and spatialized sources outside the
/// listener's head.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auspatialmixerpointsourceinheadmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUSpatialMixerPointSourceInHeadMode(pub u32);
impl AUSpatialMixerPointSourceInHeadMode {
    #[doc(alias = "kSpatialMixerPointSourceInHeadMode_Mono")]
    pub const SpatialMixerPointSourceInHeadMode_Mono: Self = Self(0);
    #[doc(alias = "kSpatialMixerPointSourceInHeadMode_Bypass")]
    pub const SpatialMixerPointSourceInHeadMode_Bypass: Self = Self(1);
}

unsafe impl Encode for AUSpatialMixerPointSourceInHeadMode {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUSpatialMixerPointSourceInHeadMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_3dmixerdistanceparams?language=objc)
#[cfg(feature = "AUComponent")]
#[deprecated]
pub const kAudioUnitProperty_3DMixerDistanceParams: AudioUnitPropertyID = 3010;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_3dmixerattenuationcurve?language=objc)
#[cfg(feature = "AUComponent")]
#[deprecated]
pub const kAudioUnitProperty_3DMixerAttenuationCurve: AudioUnitPropertyID = 3013;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_dopplershift?language=objc)
#[cfg(feature = "AUComponent")]
#[deprecated]
pub const kAudioUnitProperty_DopplerShift: AudioUnitPropertyID = 3002;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_3dmixerrenderingflags?language=objc)
#[cfg(feature = "AUComponent")]
#[deprecated]
pub const kAudioUnitProperty_3DMixerRenderingFlags: AudioUnitPropertyID = 3003;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_3dmixerdistanceatten?language=objc)
#[cfg(feature = "AUComponent")]
#[deprecated]
pub const kAudioUnitProperty_3DMixerDistanceAtten: AudioUnitPropertyID = 3004;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_reverbpreset?language=objc)
#[cfg(feature = "AUComponent")]
#[deprecated]
pub const kAudioUnitProperty_ReverbPreset: AudioUnitPropertyID = 3012;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/au3dmixerrenderingflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AU3DMixerRenderingFlags(pub u32);
bitflags::bitflags! {
    impl AU3DMixerRenderingFlags: u32 {
        const k3DMixerRenderingFlags_InterAuralDelay = 1<<0;
        const k3DMixerRenderingFlags_DopplerShift = 1<<1;
        const k3DMixerRenderingFlags_DistanceAttenuation = 1<<2;
        const k3DMixerRenderingFlags_DistanceFilter = 1<<3;
        const k3DMixerRenderingFlags_DistanceDiffusion = 1<<4;
        const k3DMixerRenderingFlags_LinearDistanceAttenuation = 1<<5;
        const k3DMixerRenderingFlags_ConstantReverbBlend = 1<<6;
    }
}

unsafe impl Encode for AU3DMixerRenderingFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AU3DMixerRenderingFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/au3dmixerattenuationcurve?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AU3DMixerAttenuationCurve(pub u32);
impl AU3DMixerAttenuationCurve {
    pub const k3DMixerAttenuationCurve_Power: Self = Self(0);
    pub const k3DMixerAttenuationCurve_Exponential: Self = Self(1);
    pub const k3DMixerAttenuationCurve_Inverse: Self = Self(2);
    pub const k3DMixerAttenuationCurve_Linear: Self = Self(3);
}

unsafe impl Encode for AU3DMixerAttenuationCurve {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AU3DMixerAttenuationCurve {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_scheduleaudioslice?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ScheduleAudioSlice: AudioUnitPropertyID = 3300;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_schedulestarttimestamp?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ScheduleStartTimeStamp: AudioUnitPropertyID = 3301;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_currentplaytime?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_CurrentPlayTime: AudioUnitPropertyID = 3302;

/// bits in ScheduledAudioSlice.mFlags
///
///
/// Set if the unit is done with this slice
///
/// Set if any portion of the buffer has been played
///
/// Set if any portion of the buffer was not played because it was scheduled late
///
/// specifies that the buffer should loop indefinitely
///
/// specifies that the buffer should interrupt any previously scheduled buffer
/// (by default, buffers following a playing buffer are not played until the
/// playing buffer has completed).
///
/// specifies that the buffer should interrupt any previously scheduled buffer,
/// but only at a loop point in that buffer.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auscheduledaudiosliceflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AUScheduledAudioSliceFlags(pub u32);
bitflags::bitflags! {
    impl AUScheduledAudioSliceFlags: u32 {
        #[doc(alias = "kScheduledAudioSliceFlag_Complete")]
        const ScheduledAudioSliceFlag_Complete = 0x01;
        #[doc(alias = "kScheduledAudioSliceFlag_BeganToRender")]
        const ScheduledAudioSliceFlag_BeganToRender = 0x02;
        #[doc(alias = "kScheduledAudioSliceFlag_BeganToRenderLate")]
        const ScheduledAudioSliceFlag_BeganToRenderLate = 0x04;
        #[doc(alias = "kScheduledAudioSliceFlag_Loop")]
        const ScheduledAudioSliceFlag_Loop = 0x08;
        #[doc(alias = "kScheduledAudioSliceFlag_Interrupt")]
        const ScheduledAudioSliceFlag_Interrupt = 0x10;
        #[doc(alias = "kScheduledAudioSliceFlag_InterruptAtLoop")]
        const ScheduledAudioSliceFlag_InterruptAtLoop = 0x20;
    }
}

unsafe impl Encode for AUScheduledAudioSliceFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AUScheduledAudioSliceFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_scheduledfileids?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ScheduledFileIDs: AudioUnitPropertyID = 3310;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_scheduledfileregion?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ScheduledFileRegion: AudioUnitPropertyID = 3311;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_scheduledfileprime?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ScheduledFilePrime: AudioUnitPropertyID = 3312;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_scheduledfilebuffersizeframes?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ScheduledFileBufferSizeFrames: AudioUnitPropertyID = 3313;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_scheduledfilenumberbuffers?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ScheduledFileNumberBuffers: AudioUnitPropertyID = 3314;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_usesinternalreverb?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_UsesInternalReverb: AudioUnitPropertyID =
    kAudioUnitProperty_UsesInternalReverb;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_soundbankdata?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_SoundBankData: AudioUnitPropertyID = 1008;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_streamfromdisk?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_StreamFromDisk: AudioUnitPropertyID = 1011;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_soundbankfsref?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_SoundBankFSRef: AudioUnitPropertyID = 1012;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_instrumentname?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_InstrumentName: AudioUnitPropertyID = 1001;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_instrumentnumber?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_InstrumentNumber: AudioUnitPropertyID = 1004;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_instrumentcount?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_InstrumentCount: AudioUnitPropertyID = 1000;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_bankname?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_BankName: AudioUnitPropertyID = 1007;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_soundbankurl?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_SoundBankURL: AudioUnitPropertyID = 1100;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaumidisynthproperty_enablepreload?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUMIDISynthProperty_EnablePreload: AudioUnitPropertyID = 4119;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kausamplerproperty_loadinstrument?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUSamplerProperty_LoadInstrument: AudioUnitPropertyID = 4102;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kausamplerproperty_loadaudiofiles?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUSamplerProperty_LoadAudioFiles: AudioUnitPropertyID = 4101;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/ausamplerinstrumentdata?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUSamplerInstrumentData {
    pub fileURL: NonNull<CFURL>,
    pub instrumentType: u8,
    pub bankMSB: u8,
    pub bankLSB: u8,
    pub presetID: u8,
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AUSamplerInstrumentData {
    const ENCODING: Encoding = Encoding::Struct(
        "AUSamplerInstrumentData",
        &[
            <NonNull<CFURL>>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AUSamplerInstrumentData {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kinstrumenttype_dlspreset?language=objc)
pub const kInstrumentType_DLSPreset: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kinstrumenttype_sf2preset?language=objc)
pub const kInstrumentType_SF2Preset: c_uint = kInstrumentType_DLSPreset;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kinstrumenttype_aupreset?language=objc)
pub const kInstrumentType_AUPreset: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kinstrumenttype_audiofile?language=objc)
pub const kInstrumentType_Audiofile: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kinstrumenttype_exs24?language=objc)
pub const kInstrumentType_EXS24: c_uint = 4;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kausampler_defaultpercussionbankmsb?language=objc)
pub const kAUSampler_DefaultPercussionBankMSB: c_uint = 0x78;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kausampler_defaultmelodicbankmsb?language=objc)
pub const kAUSampler_DefaultMelodicBankMSB: c_uint = 0x79;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kausampler_defaultbanklsb?language=objc)
pub const kAUSampler_DefaultBankLSB: c_uint = 0x00;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_deferredrendererpullsize?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_DeferredRendererPullSize: AudioUnitPropertyID = 3320;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_deferredrendererextralatency?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_DeferredRendererExtraLatency: AudioUnitPropertyID = 3321;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_deferredrendererwaitframes?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_DeferredRendererWaitFrames: AudioUnitPropertyID = 3322;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetreceiveproperty_hostname?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetReceiveProperty_Hostname: AudioUnitPropertyID = 3511;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetreceiveproperty_password?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetReceiveProperty_Password: AudioUnitPropertyID = 3512;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendproperty_portnum?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendProperty_PortNum: AudioUnitPropertyID = 3513;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendproperty_transmissionformat?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendProperty_TransmissionFormat: AudioUnitPropertyID = 3514;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendproperty_transmissionformatindex?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendProperty_TransmissionFormatIndex: AudioUnitPropertyID = 3515;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendproperty_servicename?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendProperty_ServiceName: AudioUnitPropertyID = 3516;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendproperty_disconnect?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendProperty_Disconnect: AudioUnitPropertyID = 3517;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendproperty_password?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendProperty_Password: AudioUnitPropertyID = 3518;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_pcmfloat32?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_PCMFloat32: AudioUnitPropertyID = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_pcmint24?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_PCMInt24: AudioUnitPropertyID = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_pcmint16?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_PCMInt16: AudioUnitPropertyID = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_lossless24?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_Lossless24: AudioUnitPropertyID = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_lossless16?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_Lossless16: AudioUnitPropertyID = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_ulaw?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_ULaw: AudioUnitPropertyID = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_ima4?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_IMA4: AudioUnitPropertyID = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_128kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_128kbpspc: AudioUnitPropertyID = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_96kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_96kbpspc: AudioUnitPropertyID = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_80kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_80kbpspc: AudioUnitPropertyID = 9;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_64kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_64kbpspc: AudioUnitPropertyID = 10;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_48kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_48kbpspc: AudioUnitPropertyID = 11;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_40kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_40kbpspc: AudioUnitPropertyID = 12;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_32kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_32kbpspc: AudioUnitPropertyID = 13;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_ld_64kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_LD_64kbpspc: AudioUnitPropertyID = 14;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_ld_48kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_LD_48kbpspc: AudioUnitPropertyID = 15;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_ld_40kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_LD_40kbpspc: AudioUnitPropertyID = 16;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendpresetformat_aac_ld_32kbpspc?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendPresetFormat_AAC_LD_32kbpspc: AudioUnitPropertyID = 17;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaunetsendnumpresetformats?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUNetSendNumPresetFormats: AudioUnitPropertyID = 18;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/aunumversion?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUNumVersion {
    pub nonRelRev: u8,
    pub stage: u8,
    pub minorAndBugRev: u8,
    pub majorRev: u8,
}

unsafe impl Encode for AUNumVersion {
    const ENCODING: Encoding = Encoding::Struct(
        "AUNumVersion",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for AUNumVersion {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Used to describe the name and version of the audio unit's host
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/auhostidentifier?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUHostIdentifier {
    pub hostName: NonNull<CFString>,
    pub hostVersion: AUNumVersion,
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AUHostIdentifier {
    const ENCODING: Encoding = Encoding::Struct(
        "AUHostIdentifier",
        &[<NonNull<CFString>>::ENCODING, <AUNumVersion>::ENCODING],
    );
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AUHostIdentifier {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitparameterflag_global?language=objc)
pub const kAudioUnitParameterFlag_Global: c_uint = 1 << 0;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitparameterflag_input?language=objc)
pub const kAudioUnitParameterFlag_Input: c_uint = 1 << 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitparameterflag_output?language=objc)
pub const kAudioUnitParameterFlag_Output: c_uint = 1 << 2;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitparameterflag_group?language=objc)
pub const kAudioUnitParameterFlag_Group: c_uint = 1 << 3;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitparameterflag_hasname?language=objc)
pub const kAudioUnitParameterFlag_HasName: u32 =
    AudioUnitParameterOptions::Flag_ValuesHaveStrings.0;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_srcalgorithm?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SRCAlgorithm: AudioUnitPropertyID = 9;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_midicontrolmapping?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_MIDIControlMapping: AudioUnitPropertyID = 17;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_currentpreset?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_CurrentPreset: AudioUnitPropertyID = 28;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_parametervaluename?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_ParameterValueName: AudioUnitPropertyID =
    kAudioUnitProperty_ParameterStringFromValue;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_buscount?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_BusCount: AudioUnitPropertyID = kAudioUnitProperty_ElementCount;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioofflineunitproperty_inputsize?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOfflineUnitProperty_InputSize: AudioUnitPropertyID =
    kAudioUnitOfflineProperty_InputSize;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioofflineunitproperty_outputsize?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioOfflineUnitProperty_OutputSize: AudioUnitPropertyID =
    kAudioUnitOfflineProperty_OutputSize;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitsrcalgorithm_polyphase?language=objc)
pub const kAudioUnitSRCAlgorithm_Polyphase: u32 = 0x706f6c79;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitsrcalgorithm_mediumquality?language=objc)
pub const kAudioUnitSRCAlgorithm_MediumQuality: u32 = 0x63737263;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitmidicontrolmapping?language=objc)
#[cfg(feature = "AUComponent")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitMIDIControlMapping {
    pub midiNRPN: u16,
    pub midiControl: u8,
    pub scope: u8,
    pub element: AudioUnitElement,
    pub parameter: AudioUnitParameterID,
}

#[cfg(feature = "AUComponent")]
unsafe impl Encode for AudioUnitMIDIControlMapping {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitMIDIControlMapping",
        &[
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <AudioUnitElement>::ENCODING,
            <AudioUnitParameterID>::ENCODING,
        ],
    );
}

#[cfg(feature = "AUComponent")]
unsafe impl RefEncode for AudioUnitMIDIControlMapping {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiounitparametervaluename?language=objc)
#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioUnitParameterValueName {
    pub inParamID: AudioUnitParameterID,
    pub inValue: NonNull<f32>,
    pub outName: NonNull<CFString>,
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl Encode for AudioUnitParameterValueName {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioUnitParameterValueName",
        &[
            <AudioUnitParameterID>::ENCODING,
            <NonNull<f32>>::ENCODING,
            <NonNull<CFString>>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "AUComponent", feature = "objc2-core-foundation"))]
unsafe impl RefEncode for AudioUnitParameterValueName {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_groupoutputbus?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_GroupOutputBus: AudioUnitPropertyID = 1002;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kmusicdeviceproperty_soundbankfsspec?language=objc)
#[cfg(feature = "AUComponent")]
pub const kMusicDeviceProperty_SoundBankFSSpec: AudioUnitPropertyID = 1003;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_pannermode?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_PannerMode: AudioUnitPropertyID = 3008;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiounitproperty_speakerconfiguration?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAudioUnitProperty_SpeakerConfiguration: AudioUnitPropertyID = 3001;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kspeakerconfiguration_headphones?language=objc)
pub const kSpeakerConfiguration_HeadPhones: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kspeakerconfiguration_stereo?language=objc)
pub const kSpeakerConfiguration_Stereo: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kspeakerconfiguration_quad?language=objc)
pub const kSpeakerConfiguration_Quad: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kspeakerconfiguration_5_0?language=objc)
pub const kSpeakerConfiguration_5_0: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kspeakerconfiguration_5_1?language=objc)
pub const kSpeakerConfiguration_5_1: c_uint = kSpeakerConfiguration_5_0;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/ausamplerbankpresetdata?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUSamplerBankPresetData {
    pub bankURL: NonNull<CFURL>,
    pub bankMSB: u8,
    pub bankLSB: u8,
    pub presetID: u8,
    pub reserved: u8,
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AUSamplerBankPresetData {
    const ENCODING: Encoding = Encoding::Struct(
        "AUSamplerBankPresetData",
        &[
            <NonNull<CFURL>>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AUSamplerBankPresetData {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kausamplerproperty_loadpresetfrombank?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUSamplerProperty_LoadPresetFromBank: AudioUnitPropertyID = 4100;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kausamplerproperty_bankandpreset?language=objc)
#[cfg(feature = "AUComponent")]
pub const kAUSamplerProperty_BankAndPreset: AudioUnitPropertyID =
    kAUSamplerProperty_LoadPresetFromBank;
