// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The tool result content block. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Call a tool with the Converse API</a> in the Amazon Bedrock User Guide.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum ToolResultContentBlock {
    /// <p>A tool result that is a document.</p>
    Document(crate::types::DocumentBlock),
    /// <p>A tool result that is an image.</p><note>
    /// <p>This field is only supported by Amazon Nova and Anthropic Claude 3 and 4 models.</p>
    /// </note>
    Image(crate::types::ImageBlock),
    /// <p>A tool result that is JSON format data.</p>
    Json(::aws_smithy_types::Document),
    /// <p>A tool result that is text.</p>
    Text(::std::string::String),
    /// <p>A tool result that is video.</p>
    Video(crate::types::VideoBlock),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ToolResultContentBlock {
    /// Tries to convert the enum instance into [`Document`](crate::types::ToolResultContentBlock::Document), extracting the inner [`DocumentBlock`](crate::types::DocumentBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_document(&self) -> ::std::result::Result<&crate::types::DocumentBlock, &Self> {
        if let ToolResultContentBlock::Document(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Document`](crate::types::ToolResultContentBlock::Document).
    pub fn is_document(&self) -> bool {
        self.as_document().is_ok()
    }
    /// Tries to convert the enum instance into [`Image`](crate::types::ToolResultContentBlock::Image), extracting the inner [`ImageBlock`](crate::types::ImageBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_image(&self) -> ::std::result::Result<&crate::types::ImageBlock, &Self> {
        if let ToolResultContentBlock::Image(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Image`](crate::types::ToolResultContentBlock::Image).
    pub fn is_image(&self) -> bool {
        self.as_image().is_ok()
    }
    /// Tries to convert the enum instance into [`Json`](crate::types::ToolResultContentBlock::Json), extracting the inner [`Document`](::aws_smithy_types::Document).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_json(&self) -> ::std::result::Result<&::aws_smithy_types::Document, &Self> {
        if let ToolResultContentBlock::Json(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Json`](crate::types::ToolResultContentBlock::Json).
    pub fn is_json(&self) -> bool {
        self.as_json().is_ok()
    }
    /// Tries to convert the enum instance into [`Text`](crate::types::ToolResultContentBlock::Text), extracting the inner [`String`](::std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_text(&self) -> ::std::result::Result<&::std::string::String, &Self> {
        if let ToolResultContentBlock::Text(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Text`](crate::types::ToolResultContentBlock::Text).
    pub fn is_text(&self) -> bool {
        self.as_text().is_ok()
    }
    /// Tries to convert the enum instance into [`Video`](crate::types::ToolResultContentBlock::Video), extracting the inner [`VideoBlock`](crate::types::VideoBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_video(&self) -> ::std::result::Result<&crate::types::VideoBlock, &Self> {
        if let ToolResultContentBlock::Video(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Video`](crate::types::ToolResultContentBlock::Video).
    pub fn is_video(&self) -> bool {
        self.as_video().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
