//go:build purego || (!amd64 && !arm64)

// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package fp

import "math/bits"

// MulBy3 x *= 3 (mod q)
func MulBy3(x *Element) {
	_x := *x
	x.Double(x).Add(x, &_x)
}

// MulBy5 x *= 5 (mod q)
func MulBy5(x *Element) {
	_x := *x
	x.Double(x).Double(x).Add(x, &_x)
}

// MulBy13 x *= 13 (mod q)
func MulBy13(x *Element) {
	var y = Element{
		4345973640412121648,
		16340807117537158706,
		14673764841507373218,
		5587754667198343811,
		12846753860245084942,
		4041391838244625385,
		8324122986343791677,
		8773809490091176420,
		5465994123296109449,
		6649773564661156048,
		9147430723089113754,
		54281803719730243,
	}
	x.Mul(x, &y)
}

func fromMont(z *Element) {
	_fromMontGeneric(z)
}

func reduce(z *Element) {
	_reduceGeneric(z)
}

// Mul z = x * y (mod q)
//
// x and y must be less than q
func (z *Element) Mul(x, y *Element) *Element {

	// Algorithm 2 of "Faster Montgomery Multiplication and Multi-Scalar-Multiplication for SNARKS"
	// by Y. El Housni and G. Botrel https://doi.org/10.46586/tches.v2023.i3.504-521

	var t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11 uint64
	var u0, u1, u2, u3, u4, u5, u6, u7, u8, u9, u10, u11 uint64
	{
		var c0, c1, c2 uint64
		v := x[0]
		u0, t0 = bits.Mul64(v, y[0])
		u1, t1 = bits.Mul64(v, y[1])
		u2, t2 = bits.Mul64(v, y[2])
		u3, t3 = bits.Mul64(v, y[3])
		u4, t4 = bits.Mul64(v, y[4])
		u5, t5 = bits.Mul64(v, y[5])
		u6, t6 = bits.Mul64(v, y[6])
		u7, t7 = bits.Mul64(v, y[7])
		u8, t8 = bits.Mul64(v, y[8])
		u9, t9 = bits.Mul64(v, y[9])
		u10, t10 = bits.Mul64(v, y[10])
		u11, t11 = bits.Mul64(v, y[11])
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, 0, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[1]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[2]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[3]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[4]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[5]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[6]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[7]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[8]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[9]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[10]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[11]
		u0, c1 = bits.Mul64(v, y[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, y[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, y[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, y[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, y[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, y[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, y[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, y[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, y[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, y[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, y[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, y[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	z[0] = t0
	z[1] = t1
	z[2] = t2
	z[3] = t3
	z[4] = t4
	z[5] = t5
	z[6] = t6
	z[7] = t7
	z[8] = t8
	z[9] = t9
	z[10] = t10
	z[11] = t11

	// if z ⩾ q → z -= q
	if !z.smallerThanModulus() {
		var b uint64
		z[0], b = bits.Sub64(z[0], q0, 0)
		z[1], b = bits.Sub64(z[1], q1, b)
		z[2], b = bits.Sub64(z[2], q2, b)
		z[3], b = bits.Sub64(z[3], q3, b)
		z[4], b = bits.Sub64(z[4], q4, b)
		z[5], b = bits.Sub64(z[5], q5, b)
		z[6], b = bits.Sub64(z[6], q6, b)
		z[7], b = bits.Sub64(z[7], q7, b)
		z[8], b = bits.Sub64(z[8], q8, b)
		z[9], b = bits.Sub64(z[9], q9, b)
		z[10], b = bits.Sub64(z[10], q10, b)
		z[11], _ = bits.Sub64(z[11], q11, b)
	}
	return z
}

// Square z = x * x (mod q)
//
// x must be less than q
func (z *Element) Square(x *Element) *Element {
	// see Mul for algorithm documentation

	var t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11 uint64
	var u0, u1, u2, u3, u4, u5, u6, u7, u8, u9, u10, u11 uint64
	{
		var c0, c1, c2 uint64
		v := x[0]
		u0, t0 = bits.Mul64(v, x[0])
		u1, t1 = bits.Mul64(v, x[1])
		u2, t2 = bits.Mul64(v, x[2])
		u3, t3 = bits.Mul64(v, x[3])
		u4, t4 = bits.Mul64(v, x[4])
		u5, t5 = bits.Mul64(v, x[5])
		u6, t6 = bits.Mul64(v, x[6])
		u7, t7 = bits.Mul64(v, x[7])
		u8, t8 = bits.Mul64(v, x[8])
		u9, t9 = bits.Mul64(v, x[9])
		u10, t10 = bits.Mul64(v, x[10])
		u11, t11 = bits.Mul64(v, x[11])
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, 0, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[1]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[2]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[3]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[4]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[5]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[6]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[7]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[8]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[9]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[10]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	{
		var c0, c1, c2 uint64
		v := x[11]
		u0, c1 = bits.Mul64(v, x[0])
		t0, c0 = bits.Add64(c1, t0, 0)
		u1, c1 = bits.Mul64(v, x[1])
		t1, c0 = bits.Add64(c1, t1, c0)
		u2, c1 = bits.Mul64(v, x[2])
		t2, c0 = bits.Add64(c1, t2, c0)
		u3, c1 = bits.Mul64(v, x[3])
		t3, c0 = bits.Add64(c1, t3, c0)
		u4, c1 = bits.Mul64(v, x[4])
		t4, c0 = bits.Add64(c1, t4, c0)
		u5, c1 = bits.Mul64(v, x[5])
		t5, c0 = bits.Add64(c1, t5, c0)
		u6, c1 = bits.Mul64(v, x[6])
		t6, c0 = bits.Add64(c1, t6, c0)
		u7, c1 = bits.Mul64(v, x[7])
		t7, c0 = bits.Add64(c1, t7, c0)
		u8, c1 = bits.Mul64(v, x[8])
		t8, c0 = bits.Add64(c1, t8, c0)
		u9, c1 = bits.Mul64(v, x[9])
		t9, c0 = bits.Add64(c1, t9, c0)
		u10, c1 = bits.Mul64(v, x[10])
		t10, c0 = bits.Add64(c1, t10, c0)
		u11, c1 = bits.Mul64(v, x[11])
		t11, c0 = bits.Add64(c1, t11, c0)

		c2, _ = bits.Add64(0, 0, c0)
		t1, c0 = bits.Add64(u0, t1, 0)
		t2, c0 = bits.Add64(u1, t2, c0)
		t3, c0 = bits.Add64(u2, t3, c0)
		t4, c0 = bits.Add64(u3, t4, c0)
		t5, c0 = bits.Add64(u4, t5, c0)
		t6, c0 = bits.Add64(u5, t6, c0)
		t7, c0 = bits.Add64(u6, t7, c0)
		t8, c0 = bits.Add64(u7, t8, c0)
		t9, c0 = bits.Add64(u8, t9, c0)
		t10, c0 = bits.Add64(u9, t10, c0)
		t11, c0 = bits.Add64(u10, t11, c0)
		c2, _ = bits.Add64(u11, c2, c0)

		m := qInvNeg * t0

		u0, c1 = bits.Mul64(m, q0)
		_, c0 = bits.Add64(t0, c1, 0)
		u1, c1 = bits.Mul64(m, q1)
		t0, c0 = bits.Add64(t1, c1, c0)
		u2, c1 = bits.Mul64(m, q2)
		t1, c0 = bits.Add64(t2, c1, c0)
		u3, c1 = bits.Mul64(m, q3)
		t2, c0 = bits.Add64(t3, c1, c0)
		u4, c1 = bits.Mul64(m, q4)
		t3, c0 = bits.Add64(t4, c1, c0)
		u5, c1 = bits.Mul64(m, q5)
		t4, c0 = bits.Add64(t5, c1, c0)
		u6, c1 = bits.Mul64(m, q6)
		t5, c0 = bits.Add64(t6, c1, c0)
		u7, c1 = bits.Mul64(m, q7)
		t6, c0 = bits.Add64(t7, c1, c0)
		u8, c1 = bits.Mul64(m, q8)
		t7, c0 = bits.Add64(t8, c1, c0)
		u9, c1 = bits.Mul64(m, q9)
		t8, c0 = bits.Add64(t9, c1, c0)
		u10, c1 = bits.Mul64(m, q10)
		t9, c0 = bits.Add64(t10, c1, c0)
		u11, c1 = bits.Mul64(m, q11)

		t10, c0 = bits.Add64(0, c1, c0)
		u11, _ = bits.Add64(u11, 0, c0)
		t0, c0 = bits.Add64(u0, t0, 0)
		t1, c0 = bits.Add64(u1, t1, c0)
		t2, c0 = bits.Add64(u2, t2, c0)
		t3, c0 = bits.Add64(u3, t3, c0)
		t4, c0 = bits.Add64(u4, t4, c0)
		t5, c0 = bits.Add64(u5, t5, c0)
		t6, c0 = bits.Add64(u6, t6, c0)
		t7, c0 = bits.Add64(u7, t7, c0)
		t8, c0 = bits.Add64(u8, t8, c0)
		t9, c0 = bits.Add64(u9, t9, c0)
		t10, c0 = bits.Add64(u10, t10, c0)
		c2, _ = bits.Add64(c2, 0, c0)
		t10, c0 = bits.Add64(t11, t10, 0)
		t11, _ = bits.Add64(u11, c2, c0)

	}
	z[0] = t0
	z[1] = t1
	z[2] = t2
	z[3] = t3
	z[4] = t4
	z[5] = t5
	z[6] = t6
	z[7] = t7
	z[8] = t8
	z[9] = t9
	z[10] = t10
	z[11] = t11

	// if z ⩾ q → z -= q
	if !z.smallerThanModulus() {
		var b uint64
		z[0], b = bits.Sub64(z[0], q0, 0)
		z[1], b = bits.Sub64(z[1], q1, b)
		z[2], b = bits.Sub64(z[2], q2, b)
		z[3], b = bits.Sub64(z[3], q3, b)
		z[4], b = bits.Sub64(z[4], q4, b)
		z[5], b = bits.Sub64(z[5], q5, b)
		z[6], b = bits.Sub64(z[6], q6, b)
		z[7], b = bits.Sub64(z[7], q7, b)
		z[8], b = bits.Sub64(z[8], q8, b)
		z[9], b = bits.Sub64(z[9], q9, b)
		z[10], b = bits.Sub64(z[10], q10, b)
		z[11], _ = bits.Sub64(z[11], q11, b)
	}
	return z
}

// Butterfly sets
//
//	a = a + b (mod q)
//	b = a - b (mod q)
func Butterfly(a, b *Element) {
	_butterflyGeneric(a, b)
}
