#include "../../dxbc/dxbc_container.h"
#include "../../dxbc/dxbc_signature.h"

#include "../test_common.h"

#include <vector>

namespace dxbc_spv::tests::dxbc {

using namespace dxbc_spv::dxbc;

static const uint8_t gs40[] = {
  0x44, 0x58, 0x42, 0x43, 0xec, 0xda, 0x71, 0x92, 0x77, 0x24, 0xb6, 0xa2, 0x0d, 0x41, 0x84, 0xd9, 0xd0, 0x3a, 0x98, 0xb4, 0x01, 0x00, 0x00, 0x00, 0x38, 0x04, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x34, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x54, 0x01, 0x00, 0x00, 0x0c, 0x02, 0x00, 0x00, 0xbc, 0x03, 0x00, 0x00, 0x52, 0x44, 0x45, 0x46, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x04, 0x53, 0x47, 0x00, 0x81, 0x10, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x6f, 0x66,
  0x74, 0x20, 0x28, 0x52, 0x29, 0x20, 0x48, 0x4c, 0x53, 0x4c, 0x20, 0x53, 0x68, 0x61, 0x64, 0x65, 0x72, 0x20, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x20, 0x31, 0x30, 0x2e, 0x31, 0x00,
  0x49, 0x53, 0x47, 0x4e, 0xcc, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00,
  0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x01, 0x00, 0x00,
  0x53, 0x56, 0x5f, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4f, 0x4f, 0x52, 0x44, 0x00, 0x53, 0x49, 0x5a, 0x45, 0x00, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x00, 0x44, 0x52,
  0x41, 0x57, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x49, 0x64, 0x00, 0xab, 0xab, 0x4f, 0x53, 0x47, 0x4e, 0xb0, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x8c, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0x08, 0x00, 0x00, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x01, 0x0e, 0x00, 0x00, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x50,
  0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x00, 0x54, 0x45, 0x58, 0x43, 0x4f, 0x4f, 0x52, 0x44, 0x00, 0x44, 0x52, 0x41, 0x57, 0x00, 0x53, 0x56, 0x5f,
  0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x49, 0x44, 0x00, 0x53, 0x48, 0x44, 0x52, 0xa8, 0x01, 0x00, 0x00, 0x40, 0x00, 0x02, 0x00, 0x6a, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x05,
  0xf2, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x04, 0x32, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x5f, 0x00, 0x00, 0x04, 0x42, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x04, 0x72, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x5f, 0x00, 0x00, 0x04, 0x12, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x02, 0x00, 0xb0, 0x00, 0x00, 0x68, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00,
  0x5d, 0x30, 0x00, 0x01, 0x5c, 0x28, 0x00, 0x01, 0x67, 0x00, 0x00, 0x04, 0xf2, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x03, 0x72, 0x20, 0x10, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x03, 0x32, 0x20, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x03, 0x12, 0x20, 0x10, 0x00, 0x03, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x04,
  0x12, 0x20, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x5e, 0x00, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x05, 0x12, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x01, 0x50, 0x00, 0x00, 0x07, 0x22, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x40, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x04, 0x03, 0x1a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x07, 0xf2, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x46, 0x1e, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x07, 0x72, 0x20, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x46, 0x12, 0xa0, 0x00,
  0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x07, 0x32, 0x20, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x46, 0x10, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x07, 0x12, 0x20, 0x10, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0a, 0x10, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0xb0, 0x00, 0x00, 0x13, 0x00, 0x00, 0x01, 0x1e, 0x00, 0x00, 0x07, 0x12, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x01, 0x3e, 0x00, 0x00, 0x01, 0x53, 0x54, 0x41, 0x54,
  0x74, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const uint8_t gs50[] = {
  0x44, 0x58, 0x42, 0x43, 0xbc, 0x2f, 0x34, 0xfd, 0x69, 0xe8, 0xb5, 0x5c, 0x77, 0xa7, 0x9e, 0x51, 0xca, 0xf0, 0xe9, 0xcd, 0x01, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x34, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0x74, 0x01, 0x00, 0x00, 0x5c, 0x02, 0x00, 0x00, 0x68, 0x04, 0x00, 0x00, 0x52, 0x44, 0x45, 0x46, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x05, 0x53, 0x47, 0x00, 0x81, 0x10, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x52, 0x44, 0x31, 0x31, 0x3c, 0x00, 0x00, 0x00,
  0x18, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x6f, 0x66,
  0x74, 0x20, 0x28, 0x52, 0x29, 0x20, 0x48, 0x4c, 0x53, 0x4c, 0x20, 0x53, 0x68, 0x61, 0x64, 0x65, 0x72, 0x20, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x20, 0x31, 0x30, 0x2e, 0x31, 0x00,
  0x49, 0x53, 0x47, 0x4e, 0xcc, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00,
  0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x01, 0x00, 0x00,
  0x53, 0x56, 0x5f, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4f, 0x4f, 0x52, 0x44, 0x00, 0x53, 0x49, 0x5a, 0x45, 0x00, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x00, 0x44, 0x52,
  0x41, 0x57, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x49, 0x64, 0x00, 0xab, 0xab, 0x4f, 0x53, 0x47, 0x35, 0xe0, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x00, 0x54,
  0x45, 0x58, 0x43, 0x4f, 0x4f, 0x52, 0x44, 0x00, 0x44, 0x52, 0x41, 0x57, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x49, 0x44, 0x00, 0x53, 0x48, 0x45, 0x58,
  0x04, 0x02, 0x00, 0x00, 0x50, 0x00, 0x02, 0x00, 0x81, 0x00, 0x00, 0x00, 0x6a, 0x08, 0x00, 0x01, 0x61, 0x00, 0x00, 0x05, 0xf2, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x04, 0x32, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x04, 0x42, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x04, 0x72, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x04, 0x12, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x02, 0x00, 0xb0, 0x00, 0x00, 0x68, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x5d, 0x30, 0x00, 0x01, 0x8f, 0x00, 0x00, 0x03, 0x00, 0x00, 0x11, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x5c, 0x08, 0x00, 0x01, 0x67, 0x00, 0x00, 0x04, 0xf2, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x03, 0x72, 0x20, 0x10, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x03, 0x32, 0x20, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x03, 0x12, 0x20, 0x10, 0x00, 0x03, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x04,
  0x12, 0x20, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x8f, 0x00, 0x00, 0x03, 0x00, 0x00, 0x11, 0x00, 0x01, 0x00, 0x00, 0x00, 0x5c, 0x08, 0x00, 0x01, 0x65, 0x00, 0x00, 0x03,
  0x32, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x00, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x05, 0x12, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x01, 0x50, 0x00, 0x00, 0x07, 0x22, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x04, 0x03, 0x1a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x07, 0xf2, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x1e, 0xa0, 0x00,
  0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x07, 0x72, 0x20, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x46, 0x12, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x07, 0x32, 0x20, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x46, 0x10, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x07, 0x12, 0x20, 0x10, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0a, 0x10, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x36, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0xb0, 0x00, 0x00, 0x75, 0x00, 0x00, 0x03, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x07,
  0x32, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x10, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x75, 0x00, 0x00, 0x03, 0x00, 0x00, 0x11, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x07, 0x12, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x16, 0x00, 0x00, 0x01, 0x3e, 0x00, 0x00, 0x01, 0x53, 0x54, 0x41, 0x54, 0x94, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
};

static const uint8_t hs50[] = {
  0x44, 0x58, 0x42, 0x43, 0x56, 0xfa, 0x1e, 0x90, 0x9d, 0x65, 0xd1, 0x99, 0xe6, 0x2c, 0x49, 0x7f, 0x63, 0xf1, 0x53, 0xe5, 0x01, 0x00, 0x00, 0x00, 0x10, 0x05, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
  0x38, 0x00, 0x00, 0x00, 0xa4, 0x00, 0x00, 0x00, 0x18, 0x01, 0x00, 0x00, 0x6c, 0x01, 0x00, 0x00, 0x50, 0x02, 0x00, 0x00, 0x74, 0x04, 0x00, 0x00, 0x52, 0x44, 0x45, 0x46, 0x64, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x05, 0x53, 0x48, 0x00, 0x81, 0x10, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x52, 0x44, 0x31, 0x31,
  0x3c, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x69, 0x63, 0x72,
  0x6f, 0x73, 0x6f, 0x66, 0x74, 0x20, 0x28, 0x52, 0x29, 0x20, 0x48, 0x4c, 0x53, 0x4c, 0x20, 0x53, 0x68, 0x61, 0x64, 0x65, 0x72, 0x20, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x20, 0x31,
  0x30, 0x2e, 0x31, 0x00, 0x49, 0x53, 0x47, 0x4e, 0x6c, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x07, 0x07, 0x00, 0x00, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x50,
  0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4f, 0x4c, 0x4f, 0x52, 0x00, 0x44, 0x52, 0x41, 0x57, 0x49, 0x44, 0x00, 0xab, 0xab, 0xab, 0x4f, 0x53, 0x47, 0x4e, 0x4c, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0x08, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x4f, 0x53, 0x49, 0x54,
  0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4f, 0x4c, 0x4f, 0x52, 0x00, 0xab, 0xab, 0x50, 0x43, 0x53, 0x47, 0xdc, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0d, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x0e, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0xc5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0xc5, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x01, 0x0e, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x54, 0x65, 0x73, 0x73, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x00, 0x44, 0x52, 0x41, 0x57, 0x49, 0x44, 0x00, 0x53, 0x56, 0x5f, 0x49, 0x6e, 0x73, 0x69,
  0x64, 0x65, 0x54, 0x65, 0x73, 0x73, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x00, 0xab, 0xab, 0xab, 0x53, 0x48, 0x45, 0x58, 0x1c, 0x02, 0x00, 0x00, 0x50, 0x00, 0x03, 0x00, 0x87, 0x00, 0x00, 0x00,
  0x71, 0x00, 0x00, 0x01, 0x93, 0x20, 0x00, 0x01, 0x94, 0x20, 0x00, 0x01, 0x95, 0x18, 0x00, 0x01, 0x96, 0x08, 0x00, 0x01, 0x97, 0x18, 0x00, 0x01, 0x6a, 0x08, 0x00, 0x01, 0x72, 0x00, 0x00, 0x01,
  0x5f, 0x00, 0x00, 0x02, 0x00, 0x60, 0x01, 0x00, 0x5f, 0x00, 0x00, 0x04, 0xf2, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x04, 0x72, 0x10, 0x20, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x03, 0xf2, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x03, 0x72, 0x20, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x68, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x04, 0x12, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x60, 0x01, 0x00, 0x36, 0x00, 0x00, 0x07, 0xf2, 0x20, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x46, 0x1e, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x72, 0x20, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x46, 0x12, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x46, 0x12, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x3e, 0x00, 0x00, 0x01, 0x73, 0x00, 0x00, 0x01, 0x99, 0x00, 0x00, 0x02, 0x04, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x02, 0x00, 0x70, 0x01, 0x00, 0x67, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00,
  0x5b, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x04, 0x12, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x70, 0x01, 0x00,
  0x36, 0x00, 0x00, 0x06, 0x12, 0x20, 0x90, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x3e, 0x00, 0x00, 0x01, 0x73, 0x00, 0x00, 0x01,
  0x99, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x02, 0x00, 0x70, 0x01, 0x00, 0x67, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
  0x67, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x05, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x5b, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x04, 0x12, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x70, 0x01, 0x00, 0x36, 0x00, 0x00, 0x07, 0x12, 0x20, 0xd0, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x3e, 0x00, 0x00, 0x01, 0x73, 0x00, 0x00, 0x01, 0x5f, 0x00, 0x00, 0x04,
  0x12, 0x90, 0x21, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x03, 0x22, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x06, 0x22, 0x20, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0a, 0x90, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x01, 0x53, 0x54, 0x41, 0x54, 0x94, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static const uint8_t hs51[] = {
  0x44, 0x58, 0x42, 0x43, 0x7f, 0xa2, 0x59, 0x11, 0xe2, 0xf8, 0xd1, 0xc7, 0xf5, 0x9f, 0xdc, 0x27, 0xb9, 0x89, 0xd8, 0xbe, 0x01, 0x00, 0x00, 0x00, 0x28, 0x06, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x3c, 0x00, 0x00, 0x00, 0xa8, 0x00, 0x00, 0x00, 0x5c, 0x01, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0x04, 0x03, 0x00, 0x00, 0x7c, 0x05, 0x00, 0x00, 0x8c, 0x05, 0x00, 0x00, 0x52, 0x44, 0x45, 0x46,
  0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x01, 0x05, 0x53, 0x48, 0x00, 0x85, 0x10, 0x00, 0x3c, 0x00, 0x00, 0x00,
  0x13, 0x13, 0x44, 0x25, 0x3c, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x6f, 0x66, 0x74, 0x20, 0x28, 0x52, 0x29, 0x20, 0x48, 0x4c, 0x53, 0x4c, 0x20, 0x53, 0x68, 0x61, 0x64, 0x65, 0x72, 0x20, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
  0x65, 0x72, 0x20, 0x31, 0x30, 0x2e, 0x31, 0x00, 0x49, 0x53, 0x47, 0x31, 0xac, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x4f, 0x53, 0x49, 0x54,
  0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4f, 0x4c, 0x4f, 0x52, 0x00, 0x44, 0x52, 0x41, 0x57, 0x49, 0x44, 0x00, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x49, 0x44, 0x00, 0x4f, 0x53, 0x47, 0x31,
  0x5c, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x07, 0x08, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x00, 0x43, 0x4f, 0x4c, 0x4f, 0x52, 0x00, 0xab, 0xab,
  0x50, 0x53, 0x47, 0x31, 0x3c, 0x01, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x0d, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x01, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x56, 0x5f, 0x54, 0x65, 0x73, 0x73, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x00, 0x44, 0x52,
  0x41, 0x57, 0x49, 0x44, 0x00, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x49, 0x44, 0x00, 0x53, 0x56, 0x5f, 0x49, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x54, 0x65, 0x73, 0x73, 0x46, 0x61, 0x63,
  0x74, 0x6f, 0x72, 0x00, 0x53, 0x48, 0x45, 0x58, 0x70, 0x02, 0x00, 0x00, 0x51, 0x00, 0x03, 0x00, 0x9c, 0x00, 0x00, 0x00, 0x71, 0x00, 0x00, 0x01, 0x93, 0x20, 0x00, 0x01, 0x94, 0x20, 0x00, 0x01,
  0x95, 0x18, 0x00, 0x01, 0x96, 0x08, 0x00, 0x01, 0x97, 0x18, 0x00, 0x01, 0x6a, 0x08, 0x01, 0x01, 0x72, 0x00, 0x00, 0x01, 0x5f, 0x00, 0x00, 0x02, 0x00, 0x60, 0x01, 0x00, 0x5f, 0x00, 0x00, 0x04,
  0xf2, 0x10, 0x20, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x05, 0x72, 0x10, 0x20, 0x80, 0x01, 0x40, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x65, 0x00, 0x00, 0x03, 0xf2, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x04, 0x72, 0x20, 0x10, 0x80, 0x01, 0x40, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x02,
  0x01, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x04, 0x12, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x60, 0x01, 0x00, 0x36, 0x00, 0x00, 0x07, 0xf2, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x46, 0x1e, 0xa0, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x09, 0x72, 0x20, 0x10, 0x80, 0x01, 0x40, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x46, 0x12, 0xa0, 0x80, 0x01, 0x40, 0x00, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x01, 0x73, 0x00, 0x00, 0x01, 0x99, 0x00, 0x00, 0x02,
  0x04, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x02, 0x00, 0x70, 0x01, 0x00, 0x67, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x04,
  0x12, 0x20, 0x10, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x04,
  0x12, 0x20, 0x10, 0x00, 0x03, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x5b, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x04, 0x12, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x70, 0x01, 0x00, 0x36, 0x00, 0x00, 0x06, 0x12, 0x20, 0x90, 0x00, 0x0a, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x3e, 0x00, 0x00, 0x01, 0x73, 0x00, 0x00, 0x01, 0x99, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x5f, 0x00, 0x00, 0x02,
  0x00, 0x70, 0x01, 0x00, 0x67, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x05, 0x00, 0x00, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x5b, 0x00, 0x00, 0x04, 0x12, 0x20, 0x10, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x04,
  0x12, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x70, 0x01, 0x00, 0x36, 0x00, 0x00, 0x07, 0x12, 0x20, 0xd0, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x3e, 0x00, 0x00, 0x01, 0x73, 0x00, 0x00, 0x01, 0x5f, 0x00, 0x00, 0x04, 0x12, 0x90, 0x21, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x65, 0x00, 0x00, 0x04, 0x22, 0x20, 0x10, 0x80, 0x01, 0x40, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x07, 0x22, 0x20, 0x10, 0x80, 0x01, 0x40, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0a, 0x90, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x01, 0x73, 0x00, 0x00, 0x01, 0x5f, 0x00, 0x00, 0x05, 0x22, 0x90, 0x21, 0x80, 0x01, 0x00, 0x01, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x04, 0x22, 0x20, 0x10, 0x80, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x08, 0x22, 0x20, 0x10, 0x80,
  0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1a, 0x90, 0x21, 0x80, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x01, 0x53, 0x46, 0x49, 0x30,
  0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x54, 0x41, 0x54, 0x94, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

void testDxbcSignatureParseIsgn() {
  auto chunk = Container(util::ByteReader(gs40, sizeof(gs40))).getInputSignatureChunk();
  ok(chunk);

  Signature sig(chunk);
  ok(sig);
  ok(sig.getTag() == util::FourCC("ISGN"));

  std::array<SignatureEntry, 6u> entries = {{
    SignatureEntry("SV_POSITION",     0u,  0, 0u, 0xf0fu, SignatureSysval::ePosition, ir::ScalarType::eF32),
    SignatureEntry("COORD",           0u,  1, 0u, 0x303u, SignatureSysval::eNone, ir::ScalarType::eF32),
    SignatureEntry("SIZE",            0u,  1, 0u, 0x004u, SignatureSysval::eNone, ir::ScalarType::eF32),
    SignatureEntry("NORMAL",          0u,  2, 0u, 0x707u, SignatureSysval::eNone, ir::ScalarType::eF32),
    SignatureEntry("DRAW",            0u,  3, 0u, 0x101u, SignatureSysval::eNone, ir::ScalarType::eI32),
    SignatureEntry("SV_PrimitiveId",  0u, -1, 0u, 0x101u, SignatureSysval::ePrimitiveId, ir::ScalarType::eU32),
  }};

  auto a = entries.begin();
  auto b = sig.begin();

  while (a != entries.end() && b != sig.end()) {
    ok(!std::strcmp(a->getSemanticName(), b->getSemanticName()));
    ok(a->getSemanticIndex() == b->getSemanticIndex());
    ok(a->getRegisterIndex() == b->getRegisterIndex());
    ok(a->getStreamIndex() == b->getStreamIndex());
    ok(a->getComponentMask() == b->getComponentMask());
    ok(a->getUsedComponentMask() == b->getUsedComponentMask());
    ok(a->getSystemValue() == b->getSystemValue());
    ok(a->getRawScalarType() == b->getRawScalarType());

    a++;
    b++;
  }

  ok(a == entries.end());
  ok(b == sig.end());
}


void testDxbcSignatureParseOsgn() {
  auto chunk = Container(util::ByteReader(gs40, sizeof(gs40))).getOutputSignatureChunk();
  ok(chunk);

  Signature sig(chunk);
  ok(sig);
  ok(sig.getTag() == util::FourCC("OSGN"));

  std::array<SignatureEntry, 5u> entries = {{
    SignatureEntry("SV_POSITION",     0u,  0, 0u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eF32),
    SignatureEntry("NORMAL",          0u,  1, 0u, 0x807u, SignatureSysval::eNone, ir::ScalarType::eF32),
    SignatureEntry("TEXCOORD",        0u,  2, 0u, 0xc03u, SignatureSysval::eNone, ir::ScalarType::eF32),
    SignatureEntry("DRAW",            0u,  3, 0u, 0xe01u, SignatureSysval::eNone, ir::ScalarType::eI32),
    SignatureEntry("SV_PRIMITIVEID",  0u,  4, 0u, 0xe01u, SignatureSysval::ePrimitiveId, ir::ScalarType::eU32),
  }};

  auto a = entries.begin();
  auto b = sig.begin();

  while (a != entries.end() && b != sig.end()) {
    ok(!std::strcmp(a->getSemanticName(), b->getSemanticName()));
    ok(a->getSemanticIndex() == b->getSemanticIndex());
    ok(a->getRegisterIndex() == b->getRegisterIndex());
    ok(a->getStreamIndex() == b->getStreamIndex());
    ok(a->getComponentMask() == b->getComponentMask());
    ok(a->getUsedComponentMask() == b->getUsedComponentMask());
    ok(a->getSystemValue() == b->getSystemValue());
    ok(a->getRawScalarType() == b->getRawScalarType());

    a++;
    b++;
  }

  ok(a == entries.end());
  ok(b == sig.end());
}


void testDxbcSignatureParsePcsg() {

}


void testDxbcSignatureParseOsg5() {
  auto chunk = Container(util::ByteReader(gs50, sizeof(gs50))).getOutputSignatureChunk();
  ok(chunk);

  Signature sig(chunk);
  ok(sig);
  ok(sig.getTag() == util::FourCC("OSG5"));

  std::array<SignatureEntry, 6u> entries = {{
    SignatureEntry("SV_POSITION",     0u,  0, 0u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eF32),
    SignatureEntry("NORMAL",          0u,  1, 0u, 0x807u, SignatureSysval::eNone, ir::ScalarType::eF32),
    SignatureEntry("TEXCOORD",        0u,  2, 0u, 0xc03u, SignatureSysval::eNone, ir::ScalarType::eF32),
    SignatureEntry("DRAW",            0u,  3, 0u, 0xe01u, SignatureSysval::eNone, ir::ScalarType::eI32),
    SignatureEntry("SV_PRIMITIVEID",  0u,  4, 0u, 0xe01u, SignatureSysval::ePrimitiveId, ir::ScalarType::eU32),
    SignatureEntry("TEXCOORD",        0u,  0, 1u, 0xc03u, SignatureSysval::eNone, ir::ScalarType::eF32),
  }};

  auto a = entries.begin();
  auto b = sig.begin();

  while (a != entries.end() && b != sig.end()) {
    ok(!std::strcmp(a->getSemanticName(), b->getSemanticName()));
    ok(a->getSemanticIndex() == b->getSemanticIndex());
    ok(a->getRegisterIndex() == b->getRegisterIndex());
    ok(a->getStreamIndex() == b->getStreamIndex());
    ok(a->getComponentMask() == b->getComponentMask());
    ok(a->getUsedComponentMask() == b->getUsedComponentMask());
    ok(a->getSystemValue() == b->getSystemValue());
    ok(a->getRawScalarType() == b->getRawScalarType());

    a++;
    b++;
  }

  ok(a == entries.end());
  ok(b == sig.end());
}


void testDxbcSignatureParseIsg1() {
  auto chunk = Container(util::ByteReader(hs51, sizeof(hs51))).getInputSignatureChunk();
  ok(chunk);

  Signature sig(chunk);
  ok(sig);
  ok(sig.getTag() == util::FourCC("ISG1"));

  std::array<SignatureEntry, 4u> entries = {{
    SignatureEntry("SV_POSITION",     0u,  0, 0u, 0xf0fu, SignatureSysval::ePosition, ir::ScalarType::eF32),
    SignatureEntry("COLOR",           0u,  1, 0u, 0x707u, SignatureSysval::eNone, ir::ScalarType::eMinF16),
    SignatureEntry("DRAWID",          0u,  2, 0u, 0x101u, SignatureSysval::eNone, ir::ScalarType::eU32),
    SignatureEntry("INSTANCEID",      0u,  2, 0u, 0x202u, SignatureSysval::eNone, ir::ScalarType::eMinI16),
  }};

  auto a = entries.begin();
  auto b = sig.begin();

  while (a != entries.end() && b != sig.end()) {
    ok(!std::strcmp(a->getSemanticName(), b->getSemanticName()));
    ok(a->getSemanticIndex() == b->getSemanticIndex());
    ok(a->getRegisterIndex() == b->getRegisterIndex());
    ok(a->getStreamIndex() == b->getStreamIndex());
    ok(a->getComponentMask() == b->getComponentMask());
    ok(a->getUsedComponentMask() == b->getUsedComponentMask());
    ok(a->getSystemValue() == b->getSystemValue());
    ok(a->getRawScalarType() == b->getRawScalarType());

    a++;
    b++;
  }

  ok(a == entries.end());
  ok(b == sig.end());
}


void testDxbcSignatureParseOsg1() {
  auto chunk = Container(util::ByteReader(hs51, sizeof(hs51))).getOutputSignatureChunk();
  ok(chunk);

  Signature sig(chunk);
  ok(sig);
  ok(sig.getTag() == util::FourCC("OSG1"));

  std::array<SignatureEntry, 2u> entries = {{
    SignatureEntry("SV_POSITION",     0u,  0, 0u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eF32),
    SignatureEntry("COLOR",           0u,  1, 0u, 0x807u, SignatureSysval::eNone, ir::ScalarType::eMinF16),
  }};

  auto a = entries.begin();
  auto b = sig.begin();

  while (a != entries.end() && b != sig.end()) {
    ok(!std::strcmp(a->getSemanticName(), b->getSemanticName()));
    ok(a->getSemanticIndex() == b->getSemanticIndex());
    ok(a->getRegisterIndex() == b->getRegisterIndex());
    ok(a->getStreamIndex() == b->getStreamIndex());
    ok(a->getComponentMask() == b->getComponentMask());
    ok(a->getUsedComponentMask() == b->getUsedComponentMask());
    ok(a->getSystemValue() == b->getSystemValue());
    ok(a->getRawScalarType() == b->getRawScalarType());

    a++;
    b++;
  }

  ok(a == entries.end());
  ok(b == sig.end());
}


void testDxbcSignatureParsePsg1() {
  auto chunk = Container(util::ByteReader(hs51, sizeof(hs51))).getPatchConstantSignatureChunk();
  ok(chunk);

  Signature sig(chunk);
  ok(sig);
  ok(sig.getTag() == util::FourCC("PSG1"));

  std::array<SignatureEntry, 8u> entries = {{
    SignatureEntry("SV_TessFactor",       0u,  0, 0u, 0xe01u, SignatureSysval::eQuadEdgeTessFactor, ir::ScalarType::eF32),
    SignatureEntry("DRAWID",              0u,  0, 0u, 0xd02u, SignatureSysval::eNone, ir::ScalarType::eMinU16),
    SignatureEntry("SV_TessFactor",       1u,  1, 0u, 0xe01u, SignatureSysval::eQuadEdgeTessFactor, ir::ScalarType::eF32),
    SignatureEntry("INSTANCEID",          0u,  1, 0u, 0xd02u, SignatureSysval::eNone, ir::ScalarType::eMinI16),
    SignatureEntry("SV_TessFactor",       2u,  2, 0u, 0xe01u, SignatureSysval::eQuadEdgeTessFactor, ir::ScalarType::eF32),
    SignatureEntry("SV_TessFactor",       3u,  3, 0u, 0xe01u, SignatureSysval::eQuadEdgeTessFactor, ir::ScalarType::eF32),
    SignatureEntry("SV_InsideTessFactor", 0u,  4, 0u, 0xe01u, SignatureSysval::eQuadInsideTessFactor, ir::ScalarType::eF32),
    SignatureEntry("SV_InsideTessFactor", 1u,  5, 0u, 0xe01u, SignatureSysval::eQuadInsideTessFactor, ir::ScalarType::eF32),
  }};

  auto a = entries.begin();
  auto b = sig.begin();

  while (a != entries.end() && b != sig.end()) {
    ok(!std::strcmp(a->getSemanticName(), b->getSemanticName()));
    ok(a->getSemanticIndex() == b->getSemanticIndex());
    ok(a->getRegisterIndex() == b->getRegisterIndex());
    ok(a->getStreamIndex() == b->getStreamIndex());
    ok(a->getComponentMask() == b->getComponentMask());
    ok(a->getUsedComponentMask() == b->getUsedComponentMask());
    ok(a->getSystemValue() == b->getSystemValue());
    ok(a->getRawScalarType() == b->getRawScalarType());

    a++;
    b++;
  }

  ok(a == entries.end());
  ok(b == sig.end());
}


void testDxbcSignatureSearch() {
  Signature sig(util::FourCC("OSG1"));
  sig.add(SignatureEntry("SV_POSITION",     0u, 0, 0u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eMinF16));
  sig.add(SignatureEntry("SV_CLIPDISTANCE", 0u, 1, 0u, 0x00fu, SignatureSysval::eClipDistance, ir::ScalarType::eMinF10));
  sig.add(SignatureEntry("TEXCOORD",        0u, 2, 0u, 0xc03u, SignatureSysval::eNone, ir::ScalarType::eMinU16));
  sig.add(SignatureEntry("DATA",            0u, 2, 0u, 0x30cu, SignatureSysval::eNone, ir::ScalarType::eMinI16));
  sig.add(SignatureEntry("DATA",            1u, 3, 0u, 0x30cu, SignatureSysval::eNone, ir::ScalarType::eMinI16));
  sig.add(SignatureEntry("SV_CLIPDISTANCE", 0u, 0, 1u, 0xc03u, SignatureSysval::eClipDistance, ir::ScalarType::eF32));
  sig.add(SignatureEntry("SV_POSITION",     0u, 1, 1u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eF32));

  auto a = sig.findSemantic(0u, "sv_position", 0u);
  auto b = sig.findSemantic(0u, "SV_POSITION", 0u);
  auto c = sig.findSemantic(1u, "Sv_Position", 0u);

  ok(a != sig.end());
  ok(b != sig.end());
  ok(c != sig.end());
  ok(a == b);
  ok(a != c);
  ok(a->getSystemValue() == SignatureSysval::ePosition && a->getStreamIndex() == 0u);
  ok(c->getSystemValue() == SignatureSysval::ePosition && c->getStreamIndex() == 1u);

  auto d = sig.findSemantic(0u, "DATA", 0u);
  auto e = sig.findSemantic(0u, "DATA", 1u);
  auto f = sig.findSemantic(0u, "DATA", 2u);
  auto g = sig.findSemantic(1u, "DATA", 0u);

  ok(d != sig.end());
  ok(e != sig.end());
  ok(f == sig.end());
  ok(g == sig.end());
  ok(d != e);
  ok(d->matches("data"));
  ok(e->matches("data"));
  ok(d->getSemanticIndex() == 0u);
  ok(e->getSemanticIndex() == 1u);
}


void testDxbcSignatureFilter() {
  Signature sig(util::FourCC("OSG1"));
  sig.add(SignatureEntry("SV_POSITION",     0u, 0, 0u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eMinF16));
  sig.add(SignatureEntry("SV_CLIPDISTANCE", 0u, 1, 0u, 0x00fu, SignatureSysval::eClipDistance, ir::ScalarType::eMinF10));
  sig.add(SignatureEntry("TEXCOORD",        0u, 2, 0u, 0xc03u, SignatureSysval::eNone, ir::ScalarType::eMinU16));
  sig.add(SignatureEntry("DATA",            0u, 2, 0u, 0x30cu, SignatureSysval::eNone, ir::ScalarType::eMinI16));
  sig.add(SignatureEntry("SV_CLIPDISTANCE", 0u, 0, 1u, 0xc03u, SignatureSysval::eClipDistance, ir::ScalarType::eF32));
  sig.add(SignatureEntry("SV_POSITION",     0u, 1, 1u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eF32));

  { auto f = sig.filter([] (const SignatureEntry& e) {
      return e.matches("Sv_Position");
    });

    uint32_t count = 0u;

    for (auto i = f; i != sig.end(); i++) {
      ok(!std::strcmp(i->getSemanticName(), "SV_POSITION"));
      ok(i->getRegisterIndex() == int32_t(count));
      ok(i->getStreamIndex() == count);

      count++;
    }

    ok(count == 2u);
  }

  { auto f = sig.filter([] (const SignatureEntry& e) {
      return e.getStreamIndex() == 0u;
    }).filter([] (const SignatureEntry& e) {
      return e.getVectorType().isIntType();
    });

    ok(f != sig.end() && f->matches("TexCoord"));
    f++;
    ok(f != sig.end() && f->matches("data"));
    f++;
    ok(f == sig.end());
  }
}


void testDxbcSignatureEncodeOsgn() {
  Signature sig(util::FourCC("OSGN"));
  sig.add(SignatureEntry("SV_POSITION",     0u, 0, 0u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eF32));
  sig.add(SignatureEntry("SV_CLIPDISTANCE", 0u, 1, 0u, 0x00fu, SignatureSysval::eClipDistance, ir::ScalarType::eF32));
  sig.add(SignatureEntry("SV_CLIPDISTANCE", 1u, 2, 0u, 0xc03u, SignatureSysval::eClipDistance, ir::ScalarType::eF32));
  sig.add(SignatureEntry("TEXCOORD",        0u, 3, 0u, 0xc03u, SignatureSysval::eNone, ir::ScalarType::eF32));
  sig.add(SignatureEntry("DATA",            0u, 3, 0u, 0x30cu, SignatureSysval::eNone, ir::ScalarType::eI32));

  util::ByteWriter wr;
  ok(sig.write(wr));

  auto data = std::move(wr).extract();
  Signature rb(util::ByteReader(data.data(), data.size()));

  auto a = sig.begin();
  auto b = rb.begin();

  while (a != sig.end() && b != rb.end()) {
    ok(!std::strcmp(a->getSemanticName(), b->getSemanticName()));
    ok(a->getSemanticIndex() == b->getSemanticIndex());
    ok(a->getRegisterIndex() == b->getRegisterIndex());
    ok(a->getStreamIndex() == b->getStreamIndex());
    ok(a->getComponentMask() == b->getComponentMask());
    ok(a->getUsedComponentMask() == b->getUsedComponentMask());
    ok(a->getSystemValue() == b->getSystemValue());
    ok(a->getRawScalarType() == b->getRawScalarType());

    a++;
    b++;
  }

  ok(a == sig.end());
  ok(b == rb.end());
}


void testDxbcSignatureEncodeOsg5() {
  Signature sig(util::FourCC("OSG5"));
  sig.add(SignatureEntry("SV_POSITION",     0u, 0, 0u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eF32));
  sig.add(SignatureEntry("SV_CLIPDISTANCE", 0u, 1, 0u, 0x00fu, SignatureSysval::eClipDistance, ir::ScalarType::eF32));
  sig.add(SignatureEntry("TEXCOORD",        0u, 2, 0u, 0xc03u, SignatureSysval::eNone, ir::ScalarType::eF32));
  sig.add(SignatureEntry("DATA",            0u, 2, 0u, 0x30cu, SignatureSysval::eNone, ir::ScalarType::eI32));
  sig.add(SignatureEntry("SV_CLIPDISTANCE", 0u, 0, 1u, 0xc03u, SignatureSysval::eClipDistance, ir::ScalarType::eF32));
  sig.add(SignatureEntry("SV_POSITION",     0u, 1, 1u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eF32));

  util::ByteWriter wr;
  ok(sig.write(wr));

  auto data = std::move(wr).extract();
  Signature rb(util::ByteReader(data.data(), data.size()));

  auto a = sig.begin();
  auto b = rb.begin();

  while (a != sig.end() && b != rb.end()) {
    ok(!std::strcmp(a->getSemanticName(), b->getSemanticName()));
    ok(a->getSemanticIndex() == b->getSemanticIndex());
    ok(a->getRegisterIndex() == b->getRegisterIndex());
    ok(a->getStreamIndex() == b->getStreamIndex());
    ok(a->getComponentMask() == b->getComponentMask());
    ok(a->getUsedComponentMask() == b->getUsedComponentMask());
    ok(a->getSystemValue() == b->getSystemValue());
    ok(a->getRawScalarType() == b->getRawScalarType());

    a++;
    b++;
  }

  ok(a == sig.end());
  ok(b == rb.end());
}


void testDxbcSignatureEncodeOsg1() {
  Signature sig(util::FourCC("OSG1"));
  sig.add(SignatureEntry("SV_POSITION",     0u, 0, 0u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eMinF16));
  sig.add(SignatureEntry("SV_CLIPDISTANCE", 0u, 1, 0u, 0x00fu, SignatureSysval::eClipDistance, ir::ScalarType::eMinF10));
  sig.add(SignatureEntry("TEXCOORD",        0u, 2, 0u, 0xc03u, SignatureSysval::eNone, ir::ScalarType::eMinU16));
  sig.add(SignatureEntry("DATA",            0u, 2, 0u, 0x30cu, SignatureSysval::eNone, ir::ScalarType::eMinI16));
  sig.add(SignatureEntry("SV_CLIPDISTANCE", 0u, 0, 1u, 0xc03u, SignatureSysval::eClipDistance, ir::ScalarType::eF32));
  sig.add(SignatureEntry("SV_POSITION",     0u, 1, 1u, 0x00fu, SignatureSysval::ePosition, ir::ScalarType::eF32));

  util::ByteWriter wr;
  ok(sig.write(wr));

  auto data = std::move(wr).extract();
  Signature rb(util::ByteReader(data.data(), data.size()));

  auto a = sig.begin();
  auto b = rb.begin();

  while (a != sig.end() && b != rb.end()) {
    ok(!std::strcmp(a->getSemanticName(), b->getSemanticName()));
    ok(a->getSemanticIndex() == b->getSemanticIndex());
    ok(a->getRegisterIndex() == b->getRegisterIndex());
    ok(a->getStreamIndex() == b->getStreamIndex());
    ok(a->getComponentMask() == b->getComponentMask());
    ok(a->getUsedComponentMask() == b->getUsedComponentMask());
      ok(a->getSystemValue() == b->getSystemValue());
    ok(a->getRawScalarType() == b->getRawScalarType());

    a++;
    b++;
  }

  ok(a == sig.end());
  ok(b == rb.end());
}


void testDxbcHash() {
  ok(Container(util::ByteReader(gs40, sizeof(gs40))).validateHash());
  ok(Container(util::ByteReader(gs50, sizeof(gs50))).validateHash());
  ok(Container(util::ByteReader(hs50, sizeof(hs50))).validateHash());
  ok(Container(util::ByteReader(hs51, sizeof(hs51))).validateHash());
}

}
